# 画面設計書 188-コード編集

## 概要

本ドキュメントは、QuickerSite CMSにおける「コード編集」画面の画面設計書です。サイト内のJavaScript、CSS、HTMLファイルを直接編集するためのコードエディタ画面です。

### 本画面の処理概要

この画面は、QuickerSite CMSのユーザーファイル領域にあるJavaScript（.js）、HTML/テキスト（.html, .htm, .txt）、CSS（.css）ファイルを直接編集するためのコードエディタ画面です。CodeMirrorライブラリを使用した本格的なコードエディタを提供し、シンタックスハイライト、行番号表示、フルスクリーンモード等の機能を備えています。

**業務上の目的・背景**：サイトのカスタマイズにおいて、JavaScriptやCSSの微調整が必要になることがあります。この画面により、FTPクライアントを使わずにブラウザ上で直接コードを編集できます。テンプレートのカスタマイズ、JavaScriptの修正、CSSスタイルの調整など、技術的なカスタマイズ作業を効率化します。

**画面へのアクセス方法**：
- アセットマネージャー（bs_assetmanager.asp）から対象ファイルを選択してアクセス
- URL: asp/bs_editcode.asp?path={ファイルパス}
- セカンドアドミン（制限付き管理者）はアクセス不可

**主要な操作・処理内容**：
1. ファイルの読み込みと表示
2. CodeMirrorエディタでのコード編集
3. 保存ボタンでファイル上書き保存
4. ファイルコピー機能
5. テキスト折り返し（ワードラップ）のON/OFF
6. フルスクリーンモード（F11キー）

**画面遷移**：
- 遷移元：アセットマネージャー（bs_assetmanager.asp）
- 遷移先：なし（同一画面で保存、クローズボタンでウィンドウを閉じる）

**権限による表示制御**：
- セカンドアドミンの場合はアクセス不可（response.end）
- ユーザーファイル領域外のファイルはアクセス不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 96 | スクリプト管理 | 主機能 | コード直接編集 |
| 37 | アセットマネージャー | 補助機能 | ファイル選択・アクセス |

## 画面種別

編集画面（コードエディタ）

## URL/ルーティング

```
asp/bs_editcode.asp?path={ファイルパス}
オプション: copy=1（ファイルコピー）、copied=1（コピー完了通知）
```

## 入出力項目

### 入力パラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| path | String | 必須 | 編集対象ファイルのパス |
| copy | Integer | - | 1の場合、ファイルをコピー |
| lineWrapping | Boolean | - | テキスト折り返し設定 |

### フォーム入力

| 項目名 | フィールド名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| コード | code | String | - | 編集したコード内容 |
| アクション | btnAction | String | - | "Save"で保存 |
| 折り返し | lineWrapping | Boolean | - | テキスト折り返しフラグ |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| コードエディタ | HTML | CodeMirrorエディタ |
| フィードバックメッセージ | HTML | 保存完了/コピー完了メッセージ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ファイルパス | テキスト | グレー背景のヘッダーに表示 |
| コードエディタ | CodeMirror | シンタックスハイライト付きエディタ |
| Saveボタン | ボタン | ファイル保存 |
| Closeボタン | ボタン | ウィンドウを閉じる |
| wrap textチェックボックス | チェックボックス | テキスト折り返し切り替え |
| copy fileリンク | リンク | ファイルコピー |
| フィードバック | メッセージ | 保存/コピー完了通知 |

## イベント仕様

### 1-Saveボタン押下（btnAction=Save）

**処理フロー**:
1. フォームからコード内容を取得（request.form("code")）
2. FileSystemObjectでファイルを開く（書き込みモード）
3. ファイル内容を上書き
4. ファイルを閉じる
5. "file is saved"メッセージを表示

### 2-copy fileリンククリック（copy=1）

**処理フロー**:
1. 元ファイル名を取得
2. コピー先ファイル名を生成（"ファイル名 - copy.拡張子"）
3. 同名ファイルが存在する場合、連番を付与（"- copy1", "- copy2"...）
4. FileSystemObjectで新規ファイル作成
5. 元ファイルの内容をコピー
6. bs_editcode.asp?copied=1&path=...にリダイレクト

### 3-wrap textチェックボックス変更

**処理フロー**:
1. チェック状態に応じてlineWrapping値を設定
2. フォームをサブミット
3. CodeMirrorのlineWrappingオプションを更新

### 4-フルスクリーン（F11キー）

**処理フロー**:
1. CodeMirrorのfullScreenオプションをトグル
2. Escキーでフルスクリーン解除

## データベース更新仕様

この画面ではデータベースへの更新は行いません。ファイルシステムへの直接書き込みのみです。

### ファイルシステム操作

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Save | 指定ファイル | WRITE | ファイル内容の上書き保存 |
| copy | 新規ファイル | CREATE | ファイルのコピー作成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| file is saved | 成功 | "file is saved"（黄色背景・緑文字） | 保存成功時 |
| file is copied | 成功 | "file is copied"（黄色背景・緑文字） | コピー成功時 |
| file not found | エラー | "file not found" | ファイルが存在しない場合 |
| file not allowed | エラー | "file not allowed" | 許可されていないパスの場合 |
| Are you sure to copy this file? | 確認 | コピー確認ダイアログ | コピーリンククリック時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| セカンドアドミンの場合 | response.endで処理終了 |
| 許可されていない拡張子 | response.endで処理終了 |
| ファイルが存在しない | "file not found"表示後、response.end |
| ユーザーファイル領域外 | "file not allowed"表示後、response.end |

## 備考

- 編集可能な拡張子はjs、html、htm、txt、cssのみ
- ユーザーファイル領域（C_VIRT_DIR & Application("QS_CMS_userfiles")）内のファイルのみ編集可能
- CodeMirrorライブラリを使用（バージョン確認が必要）
- フルスクリーンモード対応（F11キー、Escで解除）
- セッション変数bHasSetUFはfalseに設定される
- エディタの高さは520pxに固定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ファイル操作とセキュリティチェックの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_editcode.asp | `asp/bs_editcode.asp` | 許可拡張子リスト（12-23行目） |
| 1-2 | bs_editcode.asp | `asp/bs_editcode.asp` | セキュリティチェック（25-46行目） |

**読解のコツ**: GetFileExtension関数で拡張子を取得し、許可リストと照合する仕組み。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editcode.asp | `asp/bs_editcode.asp` | メインファイル全体（179行） |

**主要処理フロー**:
1. **1-2行目**: begin.asp、bs_security.aspインクルード
2. **3行目**: セカンドアドミンチェック（アクセス不可）
3. **9-23行目**: 拡張子に応じたモード設定（text/javascript, text/html, text/css）
4. **25-46行目**: セキュリティチェック（ファイル存在、パス検証）
5. **61-66行目**: ファイル読み込み
6. **70-95行目**: ファイルコピー処理
7. **99-106行目**: ファイル保存処理
8. **126-175行目**: CodeMirrorエディタ初期化

#### Step 3: CodeMirrorの設定を理解する

エディタの設定を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editcode.asp | `asp/bs_editcode.asp` | CodeMirror設定（155-173行目） |

**主要設定**:
- **155行目**: lineNumbers: true（行番号表示）
- **157行目**: theme: "default"（テーマ設定）
- **158行目**: mode: 拡張子に応じたモード
- **159-161行目**: lineWrapping: オプション
- **164-170行目**: extraKeys: F11でフルスクリーン、Escで解除
- **173行目**: setSize("100%", "520px")（エディタサイズ）

### プログラム呼び出し階層図

```
bs_editcode.asp
    │
    ├─ begin.asp (初期化)
    │
    ├─ bs_security.asp (認証確認)
    │
    ├─ セカンドアドミンチェック
    │      └─ true: response.end
    │
    ├─ GetFileExtension() (拡張子取得)
    │      └─ モード判定 (js/html/css)
    │             └─ 不許可: response.end
    │
    ├─ FileSystemObject
    │      ├─ FileExists() (ファイル存在確認)
    │      │      └─ false: "file not found"
    │      │
    │      └─ パス検証 (ユーザーファイル領域)
    │             └─ 範囲外: "file not allowed"
    │
    ├─ [copy=1]
    │      ├─ コピー先ファイル名生成
    │      ├─ createTextFile()
    │      └─ リダイレクト (copied=1)
    │
    ├─ [btnAction=Save]
    │      ├─ openTextFile() (書き込みモード)
    │      └─ write() (内容書き込み)
    │
    └─ HTML出力
           └─ CodeMirror初期化
```

### データフロー図

```
[入力]                    [処理]                    [出力]

path ────────────▶ GetFileExtension() ───────▶ モード判定
                         │
                    [許可拡張子]
                         │
                    FileExists() ───────────▶ [不存在: エラー]
                         │
                    パス検証 ──────────────▶ [範囲外: エラー]
                         │
                    openTextFile() ──────────▶ filecontent
                         │
[表示]                   │
                    CodeMirror ◀────────────── filecontent
                         │
[編集]                   │
                    request.form("code") ───▶ 新コード
                         │
[Save]                   │
                    openTextFile(2) ─────────▶ ファイル上書き
                         │
                    "file is saved" ─────────▶ メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editcode.asp | `asp/bs_editcode.asp` | ソース | メイン画面（本ファイル） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード |
| codemirror.js | `asp/codemirror/lib/codemirror.js` | ライブラリ | CodeMirrorコアライブラリ |
| codemirror.css | `asp/codemirror/lib/codemirror.css` | スタイル | CodeMirrorスタイル |
| fullscreen.js | `asp/codemirror/addon/display/fullscreen.js` | ライブラリ | フルスクリーンアドオン |
| fullscreen.css | `asp/codemirror/addon/display/fullscreen.css` | スタイル | フルスクリーンスタイル |
| xml.js | `asp/codemirror/mode/xml/xml.js` | ライブラリ | XMLモード |
| javascript.js | `asp/codemirror/mode/javascript/javascript.js` | ライブラリ | JavaScriptモード |
| css.js | `asp/codemirror/mode/css/css.js` | ライブラリ | CSSモード |
