# 画面設計書 189-アコーディオンセットアップ

## 概要

本ドキュメントは、QuickerSite CMSにおける「アコーディオンセットアップ」画面の画面設計書です。リストページで使用するjQueryアコーディオンプラグインの外観をカスタマイズするための設定画面です。

### 本画面の処理概要

この画面は、QuickerSite CMSのリストページで使用されるjQueryアコーディオン（折りたたみ式コンテンツ表示）の外観をカスタマイズするための設定画面です。メインCSS、ヘッダーCSS、コンテンツCSSをそれぞれ独立して設定でき、プリセット（デフォルト/ダーク）の読み込みや、カラーピッカーによる自動CSS生成機能を提供します。

**業務上の目的・背景**：リストページでアコーディオン形式のコンテンツ表示を使用する際、サイトのデザインに合わせた外観カスタマイズが必要になります。この画面により、CSSの知識がなくてもカラーピッカーで色を選択するだけで統一感のあるアコーディオンスタイルを設定できます。また、CSSに詳しいユーザーは直接CSSコードを編集することも可能です。

**画面へのアクセス方法**：
- バックサイトメニューから「Setup」→「Page Elements」→アコーディオン設定
- URL: asp/bs_AccordionSetup.asp

**主要な操作・処理内容**：
1. Main CSS（メイン部分のスタイル）の編集
2. Header CSS（ヘッダー部分のスタイル）の編集
3. Content CSS（コンテンツ部分のスタイル）の編集
4. 「Load default CSS」でデフォルトスタイルを読み込み
5. 「Load dark CSS」でダークテーマスタイルを読み込み
6. カラーピッカーで色を選択し「Suggest CSS」で自動CSS生成
7. プレビュー表示で設定結果を確認
8. 「Save」ボタンで設定を保存

**画面遷移**：
- 遷移元：ページ要素設定画面（bs_pageelements.asp）
- 遷移先：なし（同一画面にリダイレクト）

**権限による表示制御**：
- 認証が必要（bs_security.asp）
- 特定の権限制限なし（管理者全般がアクセス可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | アコーディオン設定 | 主機能 | アコーディオンCSSカスタマイズ |
| 6 | サイトデザイン設定 | 補助機能 | サイト全体のデザイン設定 |

## 画面種別

設定画面（CSSエディタ）

## URL/ルーティング

```
asp/bs_AccordionSetup.asp
オプションパラメータ:
- loaddefault=1（デフォルトCSS読み込み）
- loaddark=1（ダークCSS読み込み）
- selectedColor=#{色コード}（選択色保持）
- fbMessage=fb_saveOK（保存完了メッセージ）
```

## 入出力項目

### 入力パラメータ（GET）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| loaddefault | Integer | - | 1でデフォルトCSS読み込み |
| loaddark | Integer | - | 1でダークCSS読み込み |
| selectedColor | String | - | 選択した色コード |
| fbMessage | String | - | フィードバックメッセージID |

### フォーム入力（POST）

| 項目名 | フィールド名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| Main CSS | sQSAccordionMain | String | - | メイン部分のCSS |
| Header CSS | sQSAccordionHeader | String | - | ヘッダー部分のCSS |
| Content CSS | sQSAccordionContent | String | - | コンテンツ部分のCSS |
| 色選択 | sCWLinkColor | String | - | カラーピッカーで選択した色 |
| CSS提案 | suggestcss | String | - | "Suggest CSS"で自動生成 |
| 保存 | btnaction | String | - | 保存アクション |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CSS編集フォーム | HTML | 3つのテキストエリア |
| プレビュー | HTML | アコーディオンのライブプレビュー |
| カラーピッカー | HTML | jQueryカラーピッカー |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 説明テキスト | テキスト | アコーディオンカスタマイズの説明 |
| Main CSSテキストエリア | textarea | 80列×7行 |
| Header CSSテキストエリア | textarea | 80列×7行 |
| Content CSSテキストエリア | textarea | 80列×7行 |
| Load default CSSボタン | リンクボタン | デフォルトスタイル読み込み |
| Load dark CSSボタン | リンクボタン | ダークスタイル読み込み |
| カラーピッカー | 入力+ピッカー | 色選択UI |
| Suggest CSSボタン | submitボタン | 自動CSS生成 |
| プレビュー | アコーディオン | 3つのサンプルアイテム |
| Saveボタン | submitボタン | 保存実行 |

## イベント仕様

### 1-Load default CSSリンククリック（loaddefault=1）

**処理フロー**:
1. 確認ダイアログ表示（"Are you sure to load the default CSS?"）
2. customer.sQSAccordionMain = ""（空文字）
3. customer.sQSAccordionHeader = ""（空文字）
4. customer.sQSAccordionContent = ""（空文字）
5. customer.save()で保存
6. bs_AccordionSetup.asp?fbMessage=fb_saveOKにリダイレクト

### 2-Load dark CSSリンククリック（loaddark=1）

**処理フロー**:
1. 確認ダイアログ表示（"Are you sure to load the dark CSS?"）
2. customer.sQSAccordionMain = "font-family: inherit; font-size: 1em;"
3. customer.sQSAccordionHeader = "border:1px solid #111111; background-color: #222222; color: #FFFFFF; font-weight: 700;"
4. customer.sQSAccordionContent = "border:1px solid #111111; background-color: #666666; color: #FFFFFF;"
5. customer.save()で保存
6. bs_AccordionSetup.asp?fbMessage=fb_saveOKにリダイレクト

### 3-Suggest CSSボタン押下（suggestcss="Suggest CSS"）

**処理フロー**:
1. 選択色（sCWLinkColor）を取得
2. HEXCOL2RGB関数で色をRGB値に変換
3. トライアド配色を計算（16777216/3で3分割）
4. color1: 選択色
5. color2: トライアド色1
6. color3: トライアド色2
7. ヘッダーCSS生成（border、background、color、font-weight）
8. コンテンツCSS生成（border、background、color）
9. customer.save()で保存
10. bs_AccordionSetup.asp?selectedColor=...&fbMessage=fb_saveOKにリダイレクト

### 4-Saveボタン押下（btnaction）

**処理フロー**:
1. フォームから各CSS値を取得（trim処理）
2. customer.sQSAccordionMain = sQSAccordionMain
3. customer.sQSAccordionHeader = sQSAccordionHeader
4. customer.sQSAccordionContent = sQSAccordionContent
5. customer.save()で保存
6. bs_AccordionSetup.asp?fbMessage=fb_saveOKにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Load default CSS | tblCustomer | UPDATE | アコーディオンCSSをクリア |
| Load dark CSS | tblCustomer | UPDATE | ダークテーマCSSを設定 |
| Suggest CSS | tblCustomer | UPDATE | 自動生成CSSを設定 |
| Save | tblCustomer | UPDATE | 入力したCSSを保存 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sQSAccordionMain | フォーム入力値 | メインCSS |
| UPDATE | sQSAccordionHeader | フォーム入力値 | ヘッダーCSS |
| UPDATE | sQSAccordionContent | フォーム入力値 | コンテンツCSS |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存完了メッセージ | 保存成功時 |
| Are you sure to load the default CSS? | 確認 | デフォルト読み込み確認 | Load default CSSクリック時 |
| Are you sure to load the dark CSS? | 確認 | ダーク読み込み確認 | Load dark CSSクリック時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 未認証 | bs_login.aspにリダイレクト |
| 色コード未指定 | デフォルト色（#000000）を使用 |

## 備考

- jQueryアコーディオンプラグインを使用（jQuery UI）
- カラーピッカーはJQColorPicker関数で生成
- HEXCOL2RGB関数で16進数カラーコードをRGB値に変換
- トライアド配色（色相環で120度間隔の3色）を自動計算
- プレビューはリアルタイムではなく、保存後にリダイレクトで反映
- CSSクラス名: .QSAccordion, .QSAccordionHeader, .QSAccordionContent

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、customerオブジェクトのアコーディオン関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sQSAccordionMain, sQSAccordionHeader, sQSAccordionContentプロパティ |

**読解のコツ**: customerオブジェクトはサイト全体の設定を管理。アコーディオンCSSはこのオブジェクトの3つのプロパティに格納される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_AccordionSetup.asp | `asp/bs_AccordionSetup.asp` | メインファイル全体（57行） |

**主要処理フロー**:
1. **1-4行目**: インクルードファイル（begin.asp, bs_security.asp, header.asp, bs_initBack.asp, bs_header.asp）
2. **5-11行目**: selectedColorの取得（POST→GET→デフォルト#000000）
3. **12-18行目**: loaddark=1の処理（ダークCSSプリセット）
4. **19-25行目**: loaddefault=1の処理（デフォルトCSSクリア）
5. **26-48行目**: suggestcss="Suggest CSS"の処理（トライアド配色計算）
6. **49-55行目**: btnactionの処理（通常保存）
7. **55-56行目**: HTMLフォーム出力とプレビュー

#### Step 3: 色計算ロジックを理解する

Suggest CSS機能の色計算を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_AccordionSetup.asp | `asp/bs_AccordionSetup.asp` | 26-48行目（トライアド配色計算） |

**主要処理フロー**:
- **28行目**: 選択色から#を除去
- **29行目**: HEXCOL2RGB()で数値変換
- **30行目**: triad = 16777216/3（RGB色空間の1/3）
- **31-37行目**: color2計算（選択色+triad、オーバーフロー処理）
- **38-43行目**: color3計算（color2+triad、オーバーフロー処理）
- **44-46行目**: CSS文字列生成

### プログラム呼び出し階層図

```
bs_AccordionSetup.asp
    │
    ├─ begin.asp (初期化)
    │
    ├─ bs_security.asp (認証確認)
    │
    ├─ includes/header.asp (HTMLヘッダー)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ bs_header.asp (バックサイトヘッダー)
    │
    ├─ [loaddark=1]
    │      ├─ ダークCSSプリセット設定
    │      ├─ customer.save()
    │      └─ リダイレクト
    │
    ├─ [loaddefault=1]
    │      ├─ CSS空文字設定
    │      ├─ customer.save()
    │      └─ リダイレクト
    │
    ├─ [suggestcss="Suggest CSS"]
    │      ├─ HEXCOL2RGB() (色変換)
    │      ├─ トライアド配色計算
    │      ├─ CSS文字列生成
    │      ├─ customer.save()
    │      └─ リダイレクト
    │
    ├─ [btnaction]
    │      ├─ フォーム値取得
    │      ├─ customer.save()
    │      └─ リダイレクト
    │
    └─ HTML出力
           ├─ CSSテキストエリア×3
           ├─ JQColorPicker() (カラーピッカー)
           └─ アコーディオンプレビュー
```

### データフロー図

```
[入力]                    [処理]                    [出力]

loaddark=1 ────────────▶ ダークプリセット ─────────▶ customer.save()
                              │
loaddefault=1 ─────────▶ 空文字設定 ───────────────▶ customer.save()
                              │
sCWLinkColor ──────────▶ HEXCOL2RGB() ────────────▶ 数値変換
                              │
                         トライアド計算
                              │
                         CSS文字列生成 ────────────▶ customer.save()
                              │
sQSAccordionMain ──────▶ trim() ───────────────────▶ customer.save()
sQSAccordionHeader ────▶ trim()
sQSAccordionContent ───▶ trim()
                              │
[表示]                        │
                         customer.sQSAccordion* ───▶ テキストエリア表示
                              │
                         jQuery accordion() ───────▶ プレビュー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_AccordionSetup.asp | `asp/bs_AccordionSetup.asp` | ソース | メイン画面（本ファイル） |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客オブジェクト定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト終了処理 |
