# 画面設計書 19-ページ検証

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「ページ検証」画面の設計仕様を定義するものである。

### 本画面の処理概要

ページ検証画面は、ユーザー（コンタクト）がフロントサイトから編集したページコンテンツを管理者が検証・承認するための画面である。フロントサイト編集機能で変更されたタイトルや本文を確認し、承認または却下することができる。

**業務上の目的・背景**：
CMSでは、権限のある会員（コンタクト）がフロントサイトから直接ページを編集できる機能がある。しかし、公開前に管理者のチェックを必要とするワークフローを実装することで、コンテンツの品質を確保できる。本画面は、ユーザーが編集した内容を管理者が検証し、承認または却下するためのインターフェースを提供する。

**画面へのアクセス方法**：
1. バックサイトにログイン後、複数ページ検証画面（bs_validatepages.asp）から対象ページを選択
2. URLパラメータとして暗号化されたページID（iId）が渡される

**主要な操作・処理内容**：
1. 変更されたタイトルの確認（現在のタイトルと新しいタイトルを比較）
2. 変更された本文の確認（現在の本文と新しい本文を比較）
3. 新しいタイトルの承認または却下
4. 新しい本文の承認または却下
5. 承認時は更新者に通知メールを送信

**画面遷移**：
- 遷移元: 複数ページ検証画面（bs_validatepages.asp）
- 遷移先: 複数ページ検証画面（bs_validatepages.asp）

**権限による表示制御**：
本画面は管理者専用であり、bs_security.aspによる認証チェックが行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 98 | ページ検証 | 主機能 | ページのHTML検証処理 |

## 画面種別

検証・承認画面

## URL/ルーティング

```
asp/bs_validatepage.asp?iId={暗号化されたページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| sTitleToBeValidated | 入力（text） | String | No | 検証対象の新タイトル |
| sValueToBeValidated | 入力（WYSIWYG） | String | No | 検証対象の新本文 |
| btnValidate | 入力（submit） | String | Yes | 検証アクション |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | テキスト | 現在のページタイトル |
| 更新者名 | テキスト | 更新したユーザーのニックネーム |
| 更新日時 | テキスト | 更新日時（ヨーロッパ形式） |
| 現在のタイトル | テキスト | 現在のsTitle値 |
| 新しいタイトル | 入力フィールド | sTitleToBeValidated値（編集可能） |
| 現在のテキスト | スクロール表示 | 現在のsValue値 |
| 新しいテキスト | WYSIWYG | sValueToBeValidated値（編集可能） |
| 承認・却下ボタン | ボタン | 各項目に対する操作ボタン |

## イベント仕様

### 1-タイトル承認ボタン押下（Save and Validate New Title）

1. JavaScript confirm()で確認ダイアログ表示
2. OKでフォームをPOST送信
3. 現在のsTitleを新しい値で上書き
4. sTitleToBeValidatedをnullにクリア
5. 更新者に承認通知メールを送信
6. page.save()で保存
7. 成功時、message.Add("fb_saveOK")でメッセージ設定

### 2-タイトル却下ボタン押下（Remove New Title）

1. JavaScript confirm()で確認ダイアログ表示（変更がキャンセルされる旨を警告）
2. OKでフォームをPOST送信
3. sTitleToBeValidatedをnullにクリア（現在のタイトルは維持）
4. page.save()で保存
5. 成功時、message.Add("fb_saveOK")でメッセージ設定

### 3-本文承認ボタン押下（Save and Validate New Text）

1. JavaScript confirm()で確認ダイアログ表示
2. OKでフォームをPOST送信
3. 現在のsValueを新しい値で上書き
4. sValueToBeValidatedをnullにクリア
5. 更新者に承認通知メールを送信
6. page.save()で保存
7. 成功時、message.Add("fb_saveOK")でメッセージ設定

### 4-本文却下ボタン押下（Remove New Text）

1. JavaScript confirm()で確認ダイアログ表示（変更がキャンセルされる旨を警告）
2. OKでフォームをPOST送信
3. sValueToBeValidatedをnullにクリア（現在の本文は維持）
4. page.save()で保存
5. 成功時、message.Add("fb_saveOK")でメッセージ設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タイトル承認 | tblPage | UPDATE | タイトルを更新、検証待ちをクリア |
| タイトル却下 | tblPage | UPDATE | 検証待ちタイトルをクリア |
| 本文承認 | tblPage | UPDATE | 本文を更新、検証待ちをクリア |
| 本文却下 | tblPage | UPDATE | 検証待ち本文をクリア |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（タイトル承認） | sTitle | sTitleToBeValidatedの値 | 新タイトルで上書き |
| UPDATE（タイトル承認） | sTitleToBeValidated | null | 検証待ちをクリア |
| UPDATE（タイトル却下） | sTitleToBeValidated | null | 検証待ちをクリアのみ |
| UPDATE（本文承認） | sValue | sValueToBeValidatedの値 | 新本文で上書き |
| UPDATE（本文承認） | sValueToBeValidated | null | 検証待ちをクリア |
| UPDATE（本文却下） | sValueToBeValidated | null | 検証待ちをクリアのみ |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存が完了しました |
| - | 確認 | 承認ボタン押下時 | Are you sure? |
| - | 確認 | 却下ボタン押下時 | Are you sure? This will cancel the changes by the user! |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| 不正なページID | page.pick()で該当なしの場合、空のオブジェクトとなる |

## 備考

- 承認時にsendMailToContact()関数で更新者に通知メールを送信
- 通知メールには、承認されたページへのリンクが含まれる
- cls_mail_messageクラスでメール送信を実行
- sTitleToBeValidatedとsValueToBeValidatedは、それぞれ独立して検証・承認可能
- 現在のテキストはスクロール可能なdiv（660x200px）で表示
- 新しいテキストはWYSIWYGエディタ（siteBuilderMail設定）で編集可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構成を理解する

ページ検証画面の表示内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_validatepage.asp | `asp/bs_validatepage.asp` | 画面構成、タイトル/本文の2フォーム |

**読解のコツ**: sTitleToBeValidatedとsValueToBeValidatedの空判定による表示切り替えに注目。

#### Step 2: 検証処理を理解する

承認・却下処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_validatepage.asp | `asp/bs_validatepage.asp` | select caseによる処理分岐（行7-32） |

**主要処理フロー**:
1. **行7-14**: Save and Validate New Title - タイトル承認
2. **行15-19**: Remove New Title - タイトル却下
3. **行20-27**: Save and Validate New Text - 本文承認
4. **行28-32**: Remove New Text - 本文却下

#### Step 3: 通知メール処理を理解する

承認時の通知メール送信を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_validatepage.asp | `asp/bs_validatepage.asp` | sendMailToContact()関数（行33-44） |

**主要処理フロー**:
1. **行34-36**: 更新者のコンタクト情報取得
2. **行37-42**: メールオブジェクト作成、件名・本文設定
3. **行42**: メール送信

### プログラム呼び出し階層図

```
bs_validatepage.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ cls_page.pick()（ページデータ取得）
    │
    └─ [検証アクション]
           │
           ├─ [Save and Validate New Title]
           │      ├─ sTitle = sTitleToBeValidated
           │      ├─ sTitleToBeValidated = null
           │      ├─ sendMailToContact()
           │      │      ├─ cls_contact.pick()
           │      │      └─ cls_mail_message.send()
           │      └─ page.save()
           │
           ├─ [Remove New Title]
           │      ├─ sTitleToBeValidated = null
           │      └─ page.save()
           │
           ├─ [Save and Validate New Text]
           │      ├─ sValue = sValueToBeValidated
           │      ├─ sValueToBeValidated = null
           │      ├─ sendMailToContact()
           │      └─ page.save()
           │
           └─ [Remove New Text]
                  ├─ sValueToBeValidated = null
                  └─ page.save()
```

### データフロー図

```
[入力]                        [処理]                      [出力]

URLパラメータ(iId) ───────────▶ decrypt() ─────────────▶ ページID取得
                                    │
                                    ▼
                              cls_page.pick() ──────────▶ 現在値・検証待ち値取得
                                    │
                                    ▼
                              条件判定
                                    │
                        ┌───────────┴───────────┐
                        │                       │
              [sTitleToBeValidated      [sValueToBeValidated
                    あり]                     あり]
                        │                       │
                        ▼                       ▼
                  タイトル検証フォーム    本文検証フォーム
                        │                       │
                        ▼                       ▼
                  [承認/却下]             [承認/却下]
                        │                       │
                  ┌─────┴─────┐           ┌─────┴─────┐
                [承認]     [却下]       [承認]     [却下]
                  │           │           │           │
                  ▼           ▼           ▼           ▼
              sTitle更新  クリアのみ  sValue更新  クリアのみ
                  │                       │
                  ▼                       ▼
              sendMailToContact() ───────▶ 通知メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_validatepage.asp | `asp/bs_validatepage.asp` | ソース | メイン画面処理 |
| bs_validatepages.asp | `asp/bs_validatepages.asp` | ソース | 一覧画面（遷移元） |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| contact.asp | `asp/includes/contact.asp` | インクルード | cls_contactクラス（推定） |
| mail_message.asp | `asp/includes/mail_message.asp` | インクルード | cls_mail_messageクラス（推定） |
