# 画面設計書 190-ページ要素

## 概要

本ドキュメントは、QuickerSite CMSにおける「ページ要素」画面の画面設計書です。サイトのページ要素（バナー、デフォルトブロック、フッター、ファビコン）の設定画面へのナビゲーションハブとなる画面です。

### 本画面の処理概要

この画面は、QuickerSite CMSのページ要素設定に関するナビゲーションハブです。サイト全体で共通して使用されるページ要素（バナーメニュー、デフォルトブロック、フッター、ファビコン）の各設定画面へのリンクをアイコン形式で提供します。各アイコンをクリックすると、該当する設定画面に遷移します。

**業務上の目的・背景**：サイト運営において、共通のページ要素（ヘッダーバナー、フッター、ファビコンなど）を一元管理する必要があります。この画面により、管理者は関連する設定画面に素早くアクセスでき、サイト全体の外観を効率的に管理できます。

**画面へのアクセス方法**：
- バックサイトメニューから「Setup」→「Page Elements」
- URL: asp/bs_pageelements.asp
- セカンドアドミンのbSetupPageElements権限が必要

**主要な操作・処理内容**：
1. 「Banners」アイコンクリック→バナーメニュー設定画面へ遷移
2. 「Default Blocks」アイコンクリック→デフォルトブロック設定画面へ遷移
3. 「Footer」アイコンクリック→フッター設定画面へ遷移
4. 「Favicon」アイコンクリック→ファビコン設定画面へ遷移

**画面遷移**：
- 遷移元：バックサイトメニュー（Setup）
- 遷移先：
  - bs_editbannermenu.asp（バナーメニュー）
  - bs_editProps.asp（デフォルトブロック）
  - bs_editfooter.asp（フッター）
  - bs_favicon.asp（ファビコン）

**権限による表示制御**：
- セカンドアドミンのbSetupPageElements権限でアクセス制御
- 権限がない場合はアクセス不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | サイトデザイン設定 | 主機能 | ページ要素設定ハブ |
| 45 | バナー管理 | 補助機能 | バナーメニュー設定 |
| 46 | フッター管理 | 補助機能 | フッター設定 |
| 47 | ファビコン管理 | 補助機能 | ファビコン設定 |

## 画面種別

ナビゲーション画面（ハブ画面）

## URL/ルーティング

```
asp/bs_pageelements.asp
```

## 入出力項目

### 入力パラメータ

なし（パラメータ不要）

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ナビゲーションリンク | HTML | 4つの設定画面へのリンク |
| 説明テキスト | HTML | ページ要素の説明 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 説明テキスト | テキスト | l("explpageelements") |
| Bannersアイコン | リンク+アイコン | view_column_2アイコン、bs_editbannermenu.aspへ |
| Default Blocksアイコン | リンク+アイコン | flex_wrapアイコン、bs_editProps.aspへ |
| Footerアイコン | リンク+アイコン | splitscreen_bottomアイコン、bs_editfooter.aspへ |
| Faviconアイコン | リンク+アイコン | wb_sunnyアイコン、bs_favicon.aspへ |

## イベント仕様

### 1-Bannersアイコンクリック

**処理フロー**:
1. bs_editbannermenu.aspに遷移

### 2-Default Blocksアイコンクリック

**処理フロー**:
1. bs_editProps.aspに遷移

### 3-Footerアイコンクリック

**処理フロー**:
1. bs_editfooter.aspに遷移

### 4-Faviconアイコンクリック

**処理フロー**:
1. bs_favicon.aspに遷移

## データベース更新仕様

この画面ではデータベースへの更新は行いません。ナビゲーション機能のみです。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| explpageelements | 情報 | ページ要素の説明テキスト | 常時表示 |
| banners | ラベル | "Banners" | アイコン下のラベル |
| footer | ラベル | "Footer" | アイコン下のラベル |
| favicon | ラベル | "Favicon" | アイコン下のラベル |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 未認証 | bs_login.aspにリダイレクト |
| bSetupPageElements権限なし | アクセス拒否 |

## 備考

- Material Symbolsアイコン（Google Fonts）を使用
- アイコンサイズは40px
- テーブルレイアウト（4列、幅450px、cellpadding=15）
- 各アイコンは中央揃え
- "Default Blocks"のみ多言語化されていない（ハードコード）
- getBOHeader(btn_Setup)とgetBOSetupMenu(btn_pageelements)でメニュー表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構造を理解する

まず、画面のHTML構造とナビゲーションリンクを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_pageelements.asp | `asp/bs_pageelements.asp` | 4つのナビゲーションリンクの構造 |

**読解のコツ**: シンプルなナビゲーション画面。tableタグで4つのアイコンリンクを配置。

#### Step 2: 権限制御を理解する

アクセス権限の制御方法を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_pageelements.asp | `asp/bs_pageelements.asp` | 4行目のlogon.hasaccess |
| 2-2 | bs_security.asp | `asp/bs_security.asp` | logon.hasaccessメソッド |

**主要処理フロー**:
- **4行目**: `logon.hasaccess secondAdmin.bSetupPageElements`でアクセス権限チェック
- 権限がない場合はアクセス拒否

#### Step 3: 遷移先画面を理解する

各リンク先の画面を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editbannermenu.asp | `asp/bs_editbannermenu.asp` | バナーメニュー設定 |
| 3-2 | bs_editProps.asp | `asp/bs_editProps.asp` | デフォルトブロック設定 |
| 3-3 | bs_editfooter.asp | `asp/bs_editfooter.asp` | フッター設定 |
| 3-4 | bs_favicon.asp | `asp/bs_favicon.asp` | ファビコン設定 |

### プログラム呼び出し階層図

```
bs_pageelements.asp
    │
    ├─ begin.asp (初期化)
    │
    ├─ bs_security.asp (認証確認)
    │      └─ logon.hasaccess secondAdmin.bSetupPageElements
    │             └─ 権限なし：アクセス拒否
    │
    ├─ includes/header.asp (HTMLヘッダー)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ bs_header.asp (バックサイトヘッダー)
    │      ├─ getBOHeader(btn_Setup)
    │      └─ getBOSetupMenu(btn_pageelements)
    │
    ├─ HTML出力（ナビゲーションテーブル）
    │      ├─ [Banners] → bs_editbannermenu.asp
    │      ├─ [Default Blocks] → bs_editProps.asp
    │      ├─ [Footer] → bs_editfooter.asp
    │      └─ [Favicon] → bs_favicon.asp
    │
    ├─ bs_endBack.asp (バックサイト終了)
    │
    └─ includes/footer.asp (HTMLフッター)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

(なし) ─────────────────▶ 権限チェック ────────────▶ [権限なし: 拒否]
                              │
                         [権限あり]
                              │
                         HTML出力 ─────────────────▶ ナビゲーション画面
                              │
[クリック]                    │
                              │
Bannersクリック ──────────▶ リダイレクト ──────────▶ bs_editbannermenu.asp
                              │
Default Blocksクリック ───▶ リダイレクト ──────────▶ bs_editProps.asp
                              │
Footerクリック ───────────▶ リダイレクト ──────────▶ bs_editfooter.asp
                              │
Faviconクリック ──────────▶ リダイレクト ──────────▶ bs_favicon.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_pageelements.asp | `asp/bs_pageelements.asp` | ソース | メイン画面（本ファイル） |
| bs_editbannermenu.asp | `asp/bs_editbannermenu.asp` | ソース | バナーメニュー設定（遷移先） |
| bs_editProps.asp | `asp/bs_editProps.asp` | ソース | デフォルトブロック設定（遷移先） |
| bs_editfooter.asp | `asp/bs_editfooter.asp` | ソース | フッター設定（遷移先） |
| bs_favicon.asp | `asp/bs_favicon.asp` | ソース | ファビコン設定（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト終了処理 |
