# 画面設計書 191-オンライン設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「オンライン設定」画面の設計仕様を定義するものである。この画面は、個別ページの公開/非公開状態を制御するためのUI部品として、他の画面（ページ編集画面など）に埋め込まれて使用される。

### 本画面の処理概要

この画面は、CMSで管理するページのオンライン/オフライン（公開/非公開）状態を設定するための機能を提供する。

**業務上の目的・背景**：Webサイト運営において、コンテンツを作成しても即座に公開せず、下書き状態として保持したり、一時的に非公開にしたりする必要がある。本画面は、この公開状態の制御を簡潔なチェックボックスUIで実現し、サイト管理者が直感的にページの可視性を管理できるようにする。また、親ページがオフラインの場合やホームページ（トップページ）の場合など、特定の条件下では公開状態の変更を制限することで、サイト構造の整合性を保護する。

**画面へのアクセス方法**：この画面単体での直接アクセスはなく、ページ編集画面（bs_editItem.asp、bs_listPage.asp等）に埋め込まれる形で表示される。バックサイトメニューから「ページ一覧」→対象ページの編集画面を開くことでアクセスできる。

**主要な操作・処理内容**：
1. オンライン状態のチェックボックスにチェックを入れる/外すことで、ページの公開/非公開を切り替える
2. 子ページを持つページをオフラインにしようとした場合、警告メッセージを表示する
3. 親ページがオフラインの場合は、オンライン設定を変更できない（非公開固定）

**画面遷移**：本画面は他画面への埋め込み部品であり、単独での画面遷移はない。親画面のフォーム送信時に設定値が送信される。

**権限による表示制御**：secondAdmin.bPagePublish権限がtrueの場合のみ、この設定項目が表示される。権限がない場合は設定項目自体が非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ページ一覧 | 主機能 | ページ公開設定の管理 |
| 9 | ページ作成・編集 | 補助機能 | 編集画面への埋め込み |

## 画面種別

設定（編集画面への埋め込み部品）

## URL/ルーティング

本画面は他画面への埋め込み用ASPインクルードファイルであり、単独のURLは持たない。
- 埋め込み元ファイル: `asp/bs_onlineOrNot.asp`
- インクルード方式: SSI（Server Side Include）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| オンライン状態 | bOnline | checkbox | - | 入力 | ページの公開/非公開状態（1=公開、0=非公開） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| オンラインチェックボックス | secondAdmin.bPagePublish=true かつ 親ページがオンラインかつホームページでない | チェック済み=公開状態 |
| 「cannotgooffline」メッセージ | 親ページがオフラインの場合 | 公開できない旨のメッセージ表示 |
| 「cannotgoofflinehp」メッセージ | ホームページ（トップページ）の場合 | ホームページは非公開にできない旨のメッセージ |

## イベント仕様

### 1-チェックボックスクリック（onclick）

子ページを持つページの場合、チェックを外そうとすると確認アラートが表示される。

**処理フロー**：
1. チェックボックスがクリックされる
2. チェックが外れた状態（this.checked=false）の場合
3. page.subPages(true).count > 0（子ページが存在する）の場合
4. JavaScript alertで警告メッセージを表示: 「warningoffline」ラベルの内容

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親画面のフォーム送信 | tblPage | UPDATE | bOnlineカラムの更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bOnline | フォームから送信された値（1 or 0） | 親画面で更新処理実行 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| cannotgooffline | 情報 | 親ページがオフラインのため公開設定を変更できない | 親ページ.bOnline = false |
| cannotgoofflinehp | 情報 | ホームページは非公開にできない | page.canGoOffline = false |
| warningoffline | 警告 | 子ページが存在する状態でオフラインにする旨の警告 | 子ページあり かつ チェックオフ時 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足（bPagePublish = false） | 設定項目自体が非表示 |
| 親ページオフライン | チェックボックス非表示、hiddenフィールドで0固定、メッセージ表示 |
| ホームページ（トップページ） | チェックボックス非表示、hiddenフィールドで1固定、メッセージ表示 |

## 備考

- この画面はページ編集系の各画面に埋め込まれるインクルードファイルとして実装されている
- ページのオンライン/オフライン状態は、フロントサイトでのページ表示可否に直結する
- 親ページがオフラインの場合、子ページは自動的にフロントサイトからアクセス不可となる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページの公開状態を管理するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのbOnlineプロパティ、canGoOfflineメソッド、subPagesメソッドの定義を確認 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdminクラスのbPagePublish権限の定義を確認 |

**読解のコツ**: ASP/VBScriptのクラス定義では、Property Let/Getでプロパティを定義している。bOnlineはブール型プロパティ。

#### Step 2: エントリーポイントを理解する

本ファイルはインクルード用であり、呼び出し元の画面から読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | 本ファイル。条件分岐とHTML出力ロジックを確認 |
| 2-2 | bs_editItem.asp | `asp/bs_editItem.asp` | 呼び出し元の例。SSIでbs_onlineOrNot.aspをインクルード |

**主要処理フロー**:
1. **2行目**: secondAdmin.bPagePublish権限のチェック
2. **3行目**: page.parentPage.bOnline（親ページのオンライン状態）チェック
3. **3行目**: page.canGoOfflineメソッドでホームページ判定
4. **3-8行目**: 条件に応じたHTML出力（チェックボックスまたはメッセージ）

#### Step 3: 権限制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | secondAdminオブジェクトの初期化とデフォルト権限設定 |

**主要処理フロー**:
- **56行目**: secondAdmin.bPagePublish = trueのデフォルト設定

### プログラム呼び出し階層図

```
bs_editItem.asp（または他のページ編集画面）
    │
    └─ bs_onlineOrNot.asp（SSIインクルード）
           │
           ├─ secondAdmin.bPagePublish（権限チェック）
           │
           ├─ page.parentPage.bOnline（親ページ状態チェック）
           │
           ├─ page.canGoOffline（ホームページ判定）
           │
           └─ page.subPages(true).count（子ページ数取得）
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.bOnline ───▶ 条件判定ロジック ───▶ チェックボックスHTML
                      │                        or
secondAdmin     ───▶ 権限チェック    ───▶ 非表示/メッセージ
.bPagePublish         │
                      │
page.parentPage ───▶ 親ページ状態   ───▶ hidden input (value=0)
.bOnline              チェック              + メッセージ
                      │
page.canGoOffline ─▶ ホームページ   ───▶ hidden input (value=1)
                      判定                  + メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | ソース | オンライン設定UI部品 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限初期化 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 呼び出し元画面例 |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | 呼び出し元画面例 |
