# 画面設計書 192-URL設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「URL設定」画面の設計仕様を定義するものである。この画面は、ページのURL関連設定（内部URL、フルURL、ユーザーフレンドリーURL、検索除外設定、キャッシュ設定）を管理するためのUI部品として、他の画面に埋め込まれて使用される。

### 本画面の処理概要

この画面は、CMSで管理するページのURL関連設定を行うための機能を提供する。SEO対策やアクセス管理に必要なURL設定を集約している。

**業務上の目的・背景**：Webサイト運営において、SEOフレンドリーなURL（ユーザーフレンドリーURL）の設定、検索エンジンからの除外設定、ページキャッシュ制御など、URL・アクセスに関する様々な設定が必要となる。本画面は、これらの設定を一箇所で管理できるようにし、サイト管理者がページごとのURL戦略を効率的に実施できるようにする。

**画面へのアクセス方法**：この画面単体での直接アクセスはなく、ページ編集画面（bs_editItem.asp、bs_listPage.asp等）に埋め込まれる形で表示される。バックサイトメニューから「ページ一覧」→対象ページの編集画面を開くことでアクセスできる。

**主要な操作・処理内容**：
1. 内部URL（default.asp?iID=xxx形式）の確認
2. フルURL（サイトドメイン付き）の確認とプレビューリンク
3. 検索除外設定（bHideFromSearch）のオン/オフ切り替え
4. ユーザーフレンドリーURL（SEOフレンドリーURL）の設定
5. ページキャッシュ無効化設定（bNocache）のオン/オフ切り替え

**画面遷移**：本画面は他画面への埋め込み部品であり、単独での画面遷移はない。プレビューリンクから新規ウィンドウでページプレビューが開く。

**権限による表示制御**：ユーザーフレンドリーURL設定は、customer.bUserFriendlyURL（サイト設定）とsecondAdmin.bPageUFL（権限）の両方がtrueの場合のみ表示される。キャッシュ設定は、customer.bUseCachingForPagesがtrueの場合のみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | ユーザーフレンドリーURL設定 | 主機能 | URL設定・SEOフレンドリーURL管理 |
| 6 | SEO設定 | 補助機能 | 検索除外設定 |

## 画面種別

設定（編集画面への埋め込み部品）

## URL/ルーティング

本画面は他画面への埋め込み用ASPインクルードファイルであり、単独のURLは持たない。
- 埋め込み元ファイル: `asp/bs_url.asp`
- インクルード方式: SSI（Server Side Include）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| 検索から除外 | bHideFromSearch | checkbox | - | - | 入力 | 公開検索から除外するかどうか |
| ユーザーフレンドリーURL | sUserFriendlyURL | text | - | 49文字 | 入力 | SEOフレンドリーなURL文字列 |
| キャッシュ無効化 | bNocache | checkbox | - | - | 入力 | ページのキャッシュを無効化するかどうか |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 内部URL | page.iIDが数値の場合 | default.asp?iID=xxx形式のURL |
| フルURL | page.iIDが数値の場合 | サイトドメイン付きの完全URL |
| iId表示 | page.iIDが数値の場合 | ページの内部ID（イタリック表示） |
| プレビューリンク | page.iIDが数値の場合 | フルURLへのリンク（新規ウィンドウ） |
| 検索除外チェックボックス | 常時 | bHideFromSearchの現在値 |
| ユーザーフレンドリーURL入力欄 | customer.bUserFriendlyURL=true かつ secondAdmin.bPageUFL=true | sUserFriendlyURLの現在値 |
| キャッシュ無効化チェックボックス | customer.bUseCachingForPages=true | bNocacheの現在値 |

## イベント仕様

### 1-プレビューリンククリック

フルURLをクリックすると、新規ウィンドウでページプレビューが表示される。

**処理フロー**：
1. プレビューリンク（`<a target="...">`）をクリック
2. 新規ウィンドウが開く
3. customer.sQSUrl + "/default.asp?iID=" + 暗号化されたpage.iID のURLでページが表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親画面のフォーム送信 | tblPage | UPDATE | URL関連カラムの更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bHideFromSearch | フォームから送信された値（1 or 0） | 検索除外設定 |
| UPDATE | sUserFriendlyURL | フォームから送信された文字列（最大49文字） | SEOフレンドリーURL |
| UPDATE | bNocache | フォームから送信された値（1 or 0） | キャッシュ無効化 |

## メッセージ仕様

本画面固有のメッセージはない。親画面のフォーム送信時のメッセージに従う。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| page.iIDが数値でない | 内部URL・フルURL表示部分を非表示 |
| ユーザーフレンドリーURL権限なし | ユーザーフレンドリーURL入力欄を非表示 |
| ページキャッシュ機能が無効 | キャッシュ無効化チェックボックスを非表示 |

## 備考

- この画面はページ編集系の各画面に埋め込まれるインクルードファイルとして実装されている
- encrypt()関数でpage.iIDを暗号化してURLパラメータとして使用（セキュリティ対策）
- generatePassWord()関数で一意なウィンドウ名を生成（同一ページの重複プレビュー防止）
- ユーザーフレンドリーURLはcustomer.sVDUrl（仮想ディレクトリURL）と組み合わせて表示
- quotrep()関数でHTML特殊文字のエスケープ処理を実施
- sanitize()関数で入力値のサニタイズ処理を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページのURL関連プロパティを管理するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのiID、bHideFromSearch、sUserFriendlyURL、bNocacheプロパティの定義 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | customerクラスのsQSUrl、sVDUrl、bUserFriendlyURL、bUseCachingForPagesプロパティ |
| 1-3 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdminクラスのbPageUFL権限の定義 |

**読解のコツ**: ASP/VBScriptでは、Property Get/Letでプロパティを定義。customerオブジェクトはサイト全体設定を保持。

#### Step 2: エントリーポイントを理解する

本ファイルはインクルード用であり、直接の実行はされない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_url.asp | `asp/bs_url.asp` | 本ファイル。条件分岐とHTML出力ロジックを確認 |

**主要処理フロー**:
1. **2行目**: isNumeriek(page.iID)で内部URL表示の条件判定
2. **2行目**: encrypt(page.iID)で暗号化されたURL生成
3. **2行目**: customer.sQSUrl、customer.sVDUrlでURLプレフィックス取得
4. **2行目**: bHideFromSearchチェックボックス出力
5. **2行目**: customer.bUserFriendlyURL と secondAdmin.bPageUFLで条件判定
6. **3行目**: customer.bUseCachingForPagesでキャッシュ設定表示判定

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | encryption.asp | `asp/includes/encryption.asp` | encrypt()関数の実装 |
| 3-2 | functions.asp | `asp/includes/functions.asp` | isNumeriek()、quotrep()、sanitize()、convertBool()関数の実装 |

**主要処理フロー**:
- encrypt(): 数値を暗号化文字列に変換
- isNumeriek(): 値が数値かどうか判定
- quotrep(): HTMLの引用符エスケープ
- sanitize(): XSS対策のサニタイズ
- convertBool(): 値をブール型に変換

### プログラム呼び出し階層図

```
bs_editItem.asp（または他のページ編集画面）
    │
    └─ bs_url.asp（SSIインクルード）
           │
           ├─ isNumeriek(page.iID)（数値判定）
           │
           ├─ encrypt(page.iID)（URL暗号化）
           │
           ├─ customer.sQSUrl（サイトURL取得）
           │
           ├─ customer.sVDUrl（仮想ディレクトリURL取得）
           │
           ├─ generatePassWord()（ウィンドウ名生成）
           │
           ├─ quotrep()（HTMLエスケープ）
           │
           ├─ sanitize()（サニタイズ）
           │
           ├─ convertBool()（ブール変換）
           │
           ├─ customer.bUserFriendlyURL（設定チェック）
           │
           ├─ secondAdmin.bPageUFL（権限チェック）
           │
           └─ customer.bUseCachingForPages（キャッシュ設定チェック）
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.iID ─────────▶ isNumeriek() ────▶ 内部URL表示
                         │
                    encrypt() ────────▶ 暗号化URL
                         │
customer.sQSUrl ───▶ URL結合 ─────────▶ フルURL+プレビューリンク

page.bHideFromSearch ──▶ convertBool() ──▶ チェックボックス状態

page.sUserFriendlyURL ─▶ quotrep() ───────▶ 入力欄value
                              │
customer.bUserFriendlyURL ──▶ 条件判定 ────▶ 表示/非表示
secondAdmin.bPageUFL ────────┘

page.bNocache ─────▶ convertBool() ──▶ チェックボックス状態
                          │
customer.bUseCachingForPages ─▶ 条件判定 ─▶ 表示/非表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_url.asp | `asp/bs_url.asp` | ソース | URL設定UI部品 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客/サイト設定クラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 呼び出し元画面例 |
