# 画面設計書 193-プロパティ編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「プロパティ編集」画面の設計仕様を定義するものである。この画面は、サイト全体で使用する8つのデフォルトブロック（PAGE_BLOCK01〜PAGE_BLOCK08）のコンテンツを編集するための画面である。

### 本画面の処理概要

この画面は、テンプレート内で使用できる8つのデフォルトブロックの内容を設定する機能を提供する。各ページはこれらのブロックを継承するか、個別に上書きするかを選択できる。

**業務上の目的・背景**：Webサイトのテンプレートでは、複数のページで共通して表示するコンテンツ領域（サイドバー、フッターバナー、共通メッセージ等）が必要となることが多い。本画面は、サイト全体のデフォルトコンテンツブロックを一元管理し、各ページがそれを継承または上書きできる仕組みを提供する。これにより、サイト全体の一貫性を保ちながら、個別ページのカスタマイズも可能となる。

**画面へのアクセス方法**：バックサイトメニューから「Setup」→「Page elements」→「Default Blocks」を選択することでアクセスできる。直接URL（bs_editProps.asp）でもアクセス可能。

**主要な操作・処理内容**：
1. PAGE_BLOCK01〜PAGE_BLOCK08の8つのブロックのコンテンツを編集
2. 奇数番号ブロック（01, 03, 05, 07）はプレーンテキストエリアで編集
3. 偶数番号ブロック（02, 04, 06, 08）はWYSIWYGエディタ（CKEditor等）で編集
4. 「Save」ボタンで設定を保存

**画面遷移**：
- 遷移元：バックサイトホーム → Setup → Page elements → Default Blocks
- 遷移先：保存後は同画面に留まる（自画面へのリダイレクト）

**権限による表示制御**：secondAdmin.bSetupPageElements権限がtrueの場合のみアクセス可能。権限がない場合はアクセス拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | デフォルトブロック編集 | 主機能 | ページプロパティの編集 |
| 5 | サイト基本設定 | 補助機能 | サイト全体設定の一部 |

## 画面種別

編集

## URL/ルーティング

- URL: `asp/bs_editProps.asp`
- メソッド: GET（表示）/ POST（保存）
- アクセス制限: secondAdmin.bSetupPageElements権限が必要

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| [PAGE_BLOCK01] | sProp01 | textarea | - | 入力 | ブロック01のHTML/テキスト |
| [PAGE_BLOCK02] | sProp02 | WYSIWYGエディタ | - | 入力 | ブロック02のリッチテキスト |
| [PAGE_BLOCK03] | sProp03 | textarea | - | 入力 | ブロック03のHTML/テキスト |
| [PAGE_BLOCK04] | sProp04 | WYSIWYGエディタ | - | 入力 | ブロック04のリッチテキスト |
| [PAGE_BLOCK05] | sProp05 | textarea | - | 入力 | ブロック05のHTML/テキスト |
| [PAGE_BLOCK06] | sProp06 | WYSIWYGエディタ | - | 入力 | ブロック06のリッチテキスト |
| [PAGE_BLOCK07] | sProp07 | textarea | - | 入力 | ブロック07のHTML/テキスト |
| [PAGE_BLOCK08] | sProp08 | WYSIWYGエディタ | - | 入力 | ブロック08のリッチテキスト |
| CSRFトークン | QS_secCodeHidden | hidden | 必須 | 入力 | CSRF対策用セキュリティコード |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 説明テキスト | 画面上部 | 8つのデフォルトブロックの使用方法の説明 |
| [PAGE_BLOCK01]〜[PAGE_BLOCK08] | フォーム内 | 各ブロックのラベルと入力欄 |
| 保存ボタン | フォーム下部 | 設定保存ボタン |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. フォームが送信される（POST）
2. CSRF検証（checkCSRF()）が実行される
3. 各フィールドの値をRequest.Formから取得
4. removeEmptyP()関数で空の段落タグを除去
5. convertStr()関数で文字列変換
6. customerオブジェクトの各プロパティに値をセット
7. customer.save()でデータベースに保存
8. 保存成功時、message.Add("fb_saveOK")でメッセージ追加

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | sProp01〜sProp08カラムの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sProp01 | removeEmptyP(convertStr(Request.Form("sProp01"))) | プレーンテキストブロック |
| UPDATE | sProp02 | removeEmptyP(convertStr(Request.Form("sProp02"))) | リッチテキストブロック |
| UPDATE | sProp03 | removeEmptyP(convertStr(Request.Form("sProp03"))) | プレーンテキストブロック |
| UPDATE | sProp04 | removeEmptyP(convertStr(Request.Form("sProp04"))) | リッチテキストブロック |
| UPDATE | sProp05 | removeEmptyP(convertStr(Request.Form("sProp05"))) | プレーンテキストブロック |
| UPDATE | sProp06 | removeEmptyP(convertStr(Request.Form("sProp06"))) | リッチテキストブロック |
| UPDATE | sProp07 | removeEmptyP(convertStr(Request.Form("sProp07"))) | プレーンテキストブロック |
| UPDATE | sProp08 | removeEmptyP(convertStr(Request.Form("sProp08"))) | リッチテキストブロック |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存成功メッセージ | customer.save()がtrueを返した場合 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足 | noaccess.htmにリダイレクト |
| CSRF検証失敗 | エラーメッセージ表示（checkCSRF()内で処理） |
| 保存失敗 | customer.save()がfalseを返す（メッセージ非表示） |

## 備考

- テンプレート内で[PAGE_BLOCK01]〜[PAGE_BLOCK08]のプレースホルダーを使用することで、これらのブロックコンテンツを挿入できる
- 各ページはデフォルト値を「継承」するか「上書き」するかを選択可能
- 奇数番号ブロックはプレーンテキスト入力、偶数番号ブロックはWYSIWYGエディタを使用
- createFCKInstance()関数でWYSIWYGエディタを生成（CKEditor等）
- quotrep()関数でHTML特殊文字のエスケープ処理を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

顧客（サイト）のプロパティデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのsProp01〜sProp08プロパティの定義、save()メソッド |

**読解のコツ**: ASP/VBScriptのクラス定義では、Property Let/Getでプロパティを定義。customerオブジェクトはサイト全体設定を保持し、データベースのtblCustomerテーブルと対応。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editProps.asp | `asp/bs_editProps.asp` | 本ファイル。フォーム表示と保存処理のロジック |

**主要処理フロー**:
1. **1行目**: begin.aspのインクルード（共通初期化）
2. **4行目**: bs_security.aspでセキュリティチェック
3. **4行目**: logon.hasaccess secondAdmin.bSetupPageElementsで権限チェック
4. **4-14行目**: POSTデータがあれば保存処理実行
5. **5行目**: checkCSRF()でCSRF検証
6. **6-13行目**: 各sProp値をcustomerオブジェクトにセット
7. **14行目**: customer.save()でデータベース保存
8. **15行目以降**: フォームHTML出力

#### Step 3: セキュリティ制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | secondAdminオブジェクトの初期化と権限チェック |

**主要処理フロー**:
- **4行目**: logon.hasaccess secondAdmin.bSetupPageElements でアクセス制御

#### Step 4: WYSIWYGエディタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ckeditor.asp | `asp/includes/ckeditor.asp` | createFCKInstance()関数の実装 |

**主要処理フロー**:
- createFCKInstance()関数でWYSIWYGエディタ（CKEditor）を生成
- 第1引数: 初期値、第2引数: ツールバー設定、第3引数: フィールド名

### プログラム呼び出し階層図

```
bs_editProps.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ 各種インクルードファイル
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bSetupPageElements
    │
    ├─ includes/header.asp（ヘッダー出力）
    │
    ├─ bs_initBack.asp（バックサイト初期化）
    │
    ├─ bs_header.asp（バックサイトヘッダー）
    │
    ├─ getBOHeader() / getBOSetupMenu()（メニュー出力）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ removeEmptyP() / convertStr()（入力値処理）
    │
    ├─ customer.save()（データベース保存）
    │
    ├─ quotrep()（HTMLエスケープ）
    │
    ├─ createFCKInstance()（WYSIWYGエディタ生成）
    │
    ├─ bs_endBack.asp（バックサイト終了）
    │
    └─ includes/footer.asp（フッター出力）
```

### データフロー図

```
[入力]                    [処理]                    [出力]

Request.Form ────────▶ checkCSRF() ─────────▶ CSRF検証
("sProp01"〜"sProp08")       │
         │                   │
         └───────────▶ convertStr() ────────▶ 文字列変換
                             │
                        removeEmptyP() ─────▶ 空段落除去
                             │
                        customer.sPropXX ───▶ プロパティ設定
                             │
                        customer.save() ────▶ DB保存
                             │
                        message.Add() ──────▶ 成功メッセージ

customer.sPropXX ────▶ quotrep() ──────────▶ textarea value
                             │
                      createFCKInstance() ──▶ WYSIWYGエディタ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editProps.asp | `asp/bs_editProps.asp` | ソース | プロパティ編集画面本体 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客/サイト設定クラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限初期化 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー/メニュー |
