# 画面設計書 194-ソート順設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「ソート順設定」画面の設計仕様を定義するものである。この画面は、ページのメニュー内での表示順序（並び順）を設定するためのUI部品として、他の画面に埋め込まれて使用される。

### 本画面の処理概要

この画面は、CMSで管理するページのメニュー内での表示順序を設定する機能を提供する。同一階層内でのページの並び順をドロップダウンリストから選択できる。

**業務上の目的・背景**：Webサイトのナビゲーションメニューでは、ページの表示順序がユーザビリティに大きく影響する。本画面は、サイト管理者がページの並び順を直感的に設定できるようにし、メニュー構造を柔軟にコントロールできるようにする。重要なページを上位に配置したり、関連ページをグループ化して並べるなどの調整が可能となる。

**画面へのアクセス方法**：この画面単体での直接アクセスはなく、ページ編集画面（bs_editItem.asp、bs_listPage.asp等）に埋め込まれる形で表示される。バックサイトメニューから「ページ一覧」→対象ページの編集画面を開くことでアクセスできる。

**主要な操作・処理内容**：
1. ドロップダウンリストから並び順（1〜n）を選択
2. 選択した順序は親画面のフォーム送信時にデータベースに反映される

**画面遷移**：本画面は他画面への埋め込み部品であり、単独での画面遷移はない。親画面のフォーム送信時に設定値が送信される。

**権限による表示制御**：secondAdmin.bPagesMoveとsecondAdmin.bPageOrderの両方がtrueの場合のみ、この設定項目が表示される。権限がない場合は設定項目自体が非表示となる。また、ルートページ（bLossePagina=true）の場合も非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ページ移動・並び替え | 主機能 | ページの並び順設定 |

## 画面種別

設定（編集画面への埋め込み部品）

## URL/ルーティング

本画面は他画面への埋め込み用ASPインクルードファイルであり、単独のURLは持たない。
- 埋め込み元ファイル: `asp/bs_sortorder.asp`
- インクルード方式: SSI（Server Side Include）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| メニュー内順序 | iRang | select | - | 入力 | ページの並び順（1〜兄弟ページ数） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| ラベル「Place in menu」 | 表示条件を満たす場合 | l("placeinmenu")ラベル |
| 並び順ドロップダウン | bLossePagina=false かつ bPagesMove=true かつ bPageOrder=true | 1〜nの選択肢 |
| 必須マーク「*」 | 表示条件を満たす場合 | 項目が必須であることを示す |

## イベント仕様

### 1-並び順選択

ドロップダウンリストから並び順を選択する。

**処理フロー**：
1. ドロップダウンリストから順序番号を選択
2. 選択値はフォームのhidden/select値として保持
3. 親画面のフォーム送信時にiRang値が送信される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親画面のフォーム送信 | tblPage | UPDATE | iRangカラムの更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iRang | フォームから送信された順序番号（1〜n） | 親画面で更新処理実行 |

## メッセージ仕様

本画面固有のメッセージはない。親画面のフォーム送信時のメッセージに従う。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| ルートページ（bLossePagina=true） | 設定項目自体を非表示 |
| 権限不足（bPagesMove=false または bPageOrder=false） | 設定項目自体を非表示 |
| 新規ページ（page.iId=0） | 兄弟ページ数+1を最大値として表示 |

## 備考

- この画面はページ編集系の各画面に埋め込まれるインクルードファイルとして実装されている
- iRang値は同一階層内でのページの表示順序を決定する
- 新規ページ作成時は、現在の兄弟ページ数+1がデフォルト値（最後尾）
- 既存ページ編集時は、現在のiRang値がデフォルト値
- numberList()関数で選択肢を生成（1からallRangまでの連番）
- convertGetal()関数で数値変換を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページの並び順データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのiRang、bLossePagina、siblingsプロパティの定義 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdminクラスのbPagesMove、bPageOrder権限の定義 |

**読解のコツ**: iRangプロパティはページの表示順序を表す整数値。siblingsプロパティは同一階層の兄弟ページ数を返す。bLossePaginaはルートページかどうかを判定。

#### Step 2: エントリーポイントを理解する

本ファイルはインクルード用であり、呼び出し元の画面から読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_sortorder.asp | `asp/bs_sortorder.asp` | 本ファイル。条件分岐とHTML出力ロジックを確認 |

**主要処理フロー**:
1. **2行目**: page.bLossePaginaでルートページ判定（trueなら非表示）
2. **3行目**: secondAdmin.bPagesMoveとsecondAdmin.bPageOrderで権限チェック
3. **4-8行目**: pageRangとallRangの計算
   - 新規ページ（iId=0）: pageRang = siblings+1, allRang = siblings+1
   - 既存ページ: pageRang = iRang, allRang = siblings
4. **11行目**: numberList()関数でドロップダウンオプション生成

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | functions.asp | `asp/includes/functions.asp` | numberList()、convertGetal()関数の実装 |

**主要処理フロー**:
- numberList(start, end, step, selected): start〜endまでの連番オプションを生成
- convertGetal(): 値を数値に変換

### プログラム呼び出し階層図

```
bs_editItem.asp（または他のページ編集画面）
    │
    └─ bs_sortorder.asp（SSIインクルード）
           │
           ├─ page.bLossePagina（ルートページ判定）
           │
           ├─ secondAdmin.bPagesMove（権限チェック）
           │
           ├─ secondAdmin.bPageOrder（権限チェック）
           │
           ├─ convertGetal(page.iId)（数値変換）
           │
           ├─ page.siblings（兄弟ページ数取得）
           │
           ├─ page.iRang（現在の順序取得）
           │
           ├─ l("placeinmenu")（ラベル取得）
           │
           └─ numberList(1, allRang, 1, pageRang)（選択肢生成）
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.bLossePagina ──▶ ルートページ判定 ────▶ 表示/非表示決定

secondAdmin.bPagesMove ─┐
                        ├──▶ 権限判定 ────────▶ 表示/非表示決定
secondAdmin.bPageOrder ─┘

page.iId ────────────▶ convertGetal() ───────▶ 新規/既存判定
                             │
page.siblings ───────────────┼──▶ allRang計算
                             │
page.iRang ──────────────────┼──▶ pageRang計算
                             │
                        numberList() ────────▶ <option>タグ生成
                             │
                             └───────────────▶ <select name="iRang">
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_sortorder.asp | `asp/bs_sortorder.asp` | ソース | ソート順設定UI部品 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 呼び出し元画面例 |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | 呼び出し元画面例 |
