# 画面設計書 195-リダイレクト先設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「リダイレクト先設定」画面の設計仕様を定義するものである。この画面は、ページの自動リダイレクト（メタリフレッシュ）機能を設定するためのUI部品として、他の画面に埋め込まれて使用される。

### 本画面の処理概要

この画面は、ページ表示後に自動的に別のURLへリダイレクトする機能を設定する。リダイレクトまでの待機秒数と遷移先URLを指定できる。

**業務上の目的・背景**：Webサイト運営において、一時的な告知ページからの自動遷移、ページ統合後の旧URLからの転送、スプラッシュページ（ウェルカムページ）から本コンテンツへの自動遷移などが必要となる場合がある。本画面は、HTML metaリフレッシュを利用した自動リダイレクトを簡単に設定できるようにし、サイト管理者が柔軟にページ遷移を制御できるようにする。

**画面へのアクセス方法**：この画面単体での直接アクセスはなく、ページ編集画面（bs_editItem.asp等）に埋め込まれる形で表示される。バックサイトメニューから「ページ一覧」→対象ページの編集画面を開くことでアクセスできる。

**主要な操作・処理内容**：
1. リダイレクトまでの待機秒数を選択（0〜600秒）
2. リダイレクト先URLを入力

**画面遷移**：本画面は他画面への埋め込み部品であり、単独での画面遷移はない。親画面のフォーム送信時に設定値が送信される。

**権限による表示制御**：secondAdmin.bPageRefresh権限がtrueの場合のみ、この設定項目が表示される。権限がない場合は設定項目自体が非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | 外部URL設定 | 主機能 | リダイレクト先URLの設定 |
| 9 | ページ作成・編集 | 補助機能 | ページ編集機能の一部 |

## 画面種別

設定（編集画面への埋め込み部品）

## URL/ルーティング

本画面は他画面への埋め込み用ASPインクルードファイルであり、単独のURLは持たない。
- 埋め込み元ファイル: `asp/bs_redirectTO.asp`
- インクルード方式: SSI（Server Side Include）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| リフレッシュ秒数 | iReload | select | - | - | 入力 | リダイレクトまでの待機秒数（0〜600秒） |
| リダイレクト先URL | sRedirectTo | text | - | 255文字 | 入力 | 自動遷移先のURL |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| ラベル「Refresh after」 | secondAdmin.bPageRefresh=true | l("refresh")とl("after")ラベル |
| 秒数選択ドロップダウン | secondAdmin.bPageRefresh=true | 0〜600秒の選択肢 |
| 単位「seconds」 | secondAdmin.bPageRefresh=true | l("seconds")ラベル（イタリック表示） |
| ラベル「Redirect to」 | secondAdmin.bPageRefresh=true | l("redirectto")ラベル |
| リダイレクト先URL入力欄 | secondAdmin.bPageRefresh=true | sRedirectToの現在値 |

## イベント仕様

### 1-リダイレクト秒数選択

ドロップダウンリストからリダイレクトまでの待機秒数を選択する。

**処理フロー**：
1. ドロップダウンリストから秒数を選択（0=リダイレクトなし、1〜600秒）
2. 選択値はフォームのselect値として保持
3. 親画面のフォーム送信時にiReload値が送信される

### 2-リダイレクト先URL入力

リダイレクト先のURLを入力する。

**処理フロー**：
1. テキストボックスにURLを入力
2. 入力値はフォームのtext値として保持
3. 親画面のフォーム送信時にsRedirectTo値が送信される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親画面のフォーム送信 | tblPage | UPDATE | iReload、sRedirectToカラムの更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iReload | フォームから送信された秒数（0〜600） | 0=リダイレクトなし |
| UPDATE | sRedirectTo | フォームから送信されたURL（最大255文字） | リダイレクト先URL |

## メッセージ仕様

本画面固有のメッセージはない。親画面のフォーム送信時のメッセージに従う。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足（bPageRefresh=false） | 設定項目自体を非表示 |
| 無効なURL形式 | バリデーションなし（入力値をそのまま保存） |

## 備考

- この画面はページ編集系の各画面に埋め込まれるインクルードファイルとして実装されている
- iReload=0の場合、リダイレクトは実行されない
- リダイレクトはHTML metaタグの`<meta http-equiv="refresh" content="n;url=...">`で実現
- 秒数は0〜600（10分）の範囲で設定可能
- numberList()関数で選択肢を生成
- quotRep()関数でHTML特殊文字のエスケープ処理を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページのリダイレクト設定データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのiReload、sRedirectToプロパティの定義 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdminクラスのbPageRefresh権限の定義 |

**読解のコツ**: iReloadは整数型プロパティで、リダイレクトまでの秒数を保持。sRedirectToは文字列型で遷移先URLを保持。

#### Step 2: エントリーポイントを理解する

本ファイルはインクルード用であり、呼び出し元の画面から読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_redirectTO.asp | `asp/bs_redirectTO.asp` | 本ファイル。条件分岐とHTML出力ロジックを確認 |

**主要処理フロー**:
1. **2行目**: secondAdmin.bPageRefreshで権限チェック
2. **2行目**: l("refresh")、l("after")でラベル取得
3. **2行目**: numberList(0,600,1,page.iReload)で秒数選択肢を生成
4. **2行目**: l("seconds")で単位ラベル取得
5. **2行目**: l("redirectto")でラベル取得
6. **2行目**: quotRep(page.sRedirectTo)でエスケープされたURL値を出力

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | functions.asp | `asp/includes/functions.asp` | numberList()、quotRep()関数の実装 |

**主要処理フロー**:
- numberList(start, end, step, selected): start〜endまでの連番オプションを生成
- quotRep(): HTML引用符のエスケープ処理

### プログラム呼び出し階層図

```
bs_editItem.asp（または他のページ編集画面）
    │
    └─ bs_redirectTO.asp（SSIインクルード）
           │
           ├─ secondAdmin.bPageRefresh（権限チェック）
           │
           ├─ l("refresh")（ラベル取得）
           │
           ├─ l("after")（ラベル取得）
           │
           ├─ numberList(0, 600, 1, page.iReload)（選択肢生成）
           │
           ├─ l("seconds")（単位ラベル取得）
           │
           ├─ l("redirectto")（ラベル取得）
           │
           └─ quotRep(page.sRedirectTo)（URLエスケープ）
```

### データフロー図

```
[入力]               [処理]                    [出力]

secondAdmin ─────▶ 権限判定 ─────────────▶ 表示/非表示決定
.bPageRefresh

page.iReload ────▶ numberList() ──────────▶ <select name="iReload">
                                                (0〜600のオプション)

page.sRedirectTo ▶ quotRep() ────────────▶ <input name="sRedirectTo">
                                                (エスケープされた値)

l("refresh") ────▶ ラベル処理 ───────────▶ 表示ラベル
l("after")
l("seconds")
l("redirectto")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_redirectTO.asp | `asp/bs_redirectTO.asp` | ソース | リダイレクト設定UI部品 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| language.asp | `asp/includes/language.asp` | ソース | 多言語ラベル関数 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 呼び出し元画面例 |
