# 画面設計書 196-メタタグ設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「メタタグ設定」画面の設計仕様を定義するものである。この画面は、ページのSEO関連設定（TITLEタグ、META keywords、META description、追加ヘッダー）を編集するためのUI部品として、他の画面に埋め込まれて使用される。

### 本画面の処理概要

この画面は、CMSで管理するページのSEO関連メタ情報を設定する機能を提供する。検索エンジン最適化に必要な主要なHTML head要素を編集できる。

**業務上の目的・背景**：SEO（検索エンジン最適化）はWebサイトの集客において重要な要素である。本画面は、各ページのTITLEタグ、META keywords、META description、追加ヘッダー情報をページ単位で設定できるようにし、サイト管理者が効果的なSEO戦略を実施できるようにする。適切なメタ情報設定により、検索結果での表示内容を最適化し、クリック率向上に貢献する。

**画面へのアクセス方法**：この画面単体での直接アクセスはなく、ページ編集画面（bs_editItem.asp、bs_listPage.asp等）に埋め込まれる形で表示される。バックサイトメニューから「ページ一覧」→対象ページの編集画面を開くことでアクセスできる。

**主要な操作・処理内容**：
1. TITLEタグの内容を入力（最大200文字）
2. META keywords（キーワード）を入力（最大2048文字）
3. META description（説明文）を入力
4. 追加ヘッダー情報を入力（カスタムHTMLヘッダー）

**画面遷移**：本画面は他画面への埋め込み部品であり、単独での画面遷移はない。親画面のフォーム送信時に設定値が送信される。

**権限による表示制御**：各項目は個別の権限で制御される。bPageTitleTag（TITLEタグ）、bPageKeywords（keywords）、bPageDescription（description）、bPageAdditionalHeader（追加ヘッダー）がそれぞれtrueの場合のみ該当項目が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | SEO設定 | 主機能 | META keywords・description等のSEO設定 |
| 9 | ページ作成・編集 | 補助機能 | ページ編集機能の一部 |

## 画面種別

設定（編集画面への埋め込み部品）

## URL/ルーティング

本画面は他画面への埋め込み用ASPインクルードファイルであり、単独のURLは持たない。
- 埋め込み元ファイル: `asp/bs_metatags.asp`
- インクルード方式: SSI（Server Side Include）

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| TITLEタグ | sSEOtitle | text | - | 200文字 | 入力 | ページのTITLEタグ内容 |
| キーワード | sKeywords | text | - | 2048文字 | 入力 | META keywords内容 |
| 説明文 | sDescription | textarea | - | - | 入力 | META description内容 |
| 追加ヘッダー | sHeader | textarea | - | - | 入力 | カスタムHTMLヘッダー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| TITLEタグ入力欄 | secondAdmin.bPageTitleTag=true | sSEOtitleの現在値 |
| キーワード入力欄 | secondAdmin.bPageKeywords=true | sKeywordsの現在値、補足説明付き |
| 説明文入力欄 | secondAdmin.bPageDescription=true | sDescriptionの現在値、補足説明付き |
| 追加ヘッダー入力欄 | secondAdmin.bPageAdditionalHeader=true | sHeaderの現在値 |

## イベント仕様

本画面は入力UI部品であり、独自のイベントは持たない。親画面のフォーム送信時に各入力値が送信される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 親画面のフォーム送信 | tblPage | UPDATE | SEO関連カラムの更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sSEOtitle | フォームから送信された値（最大200文字） | TITLEタグ |
| UPDATE | sKeywords | フォームから送信された値（最大2048文字） | META keywords |
| UPDATE | sDescription | フォームから送信された値 | META description |
| UPDATE | sHeader | フォームから送信された値 | 追加ヘッダー |

## メッセージ仕様

本画面固有のメッセージはない。親画面のフォーム送信時のメッセージに従う。

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| TITLEタグ権限なし（bPageTitleTag=false） | TITLEタグ入力欄を非表示 |
| keywords権限なし（bPageKeywords=false） | キーワード入力欄を非表示 |
| description権限なし（bPageDescription=false） | 説明文入力欄を非表示 |
| 追加ヘッダー権限なし（bPageAdditionalHeader=false） | 追加ヘッダー入力欄を非表示 |

## 備考

- この画面はページ編集系の各画面に埋め込まれるインクルードファイルとして実装されている
- TITLEタグは検索結果のタイトルやブラウザタブに表示される
- META keywordsは現代のSEOでは効果が低いとされるが、一部の検索エンジン向けに残されている
- META descriptionは検索結果のスニペット（説明文）に使用される可能性がある
- 追加ヘッダーにはカスタムJavaScript、CSS、その他のmetaタグなどを記述可能
- sanitize()関数でXSS対策のサニタイズ処理を実施
- quotRep()関数でHTML特殊文字のエスケープ処理を実施
- l("keywords")、l("description")、l("header")で多言語ラベルを取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページのSEO関連データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsSEOtitle、sKeywords、sDescription、sHeaderプロパティの定義 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdminクラスのbPageTitleTag、bPageKeywords、bPageDescription、bPageAdditionalHeader権限の定義 |

**読解のコツ**: 各プロパティはHTML headセクションに出力される内容を保持。権限は各項目ごとに細かく制御される。

#### Step 2: エントリーポイントを理解する

本ファイルはインクルード用であり、呼び出し元の画面から読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_metatags.asp | `asp/bs_metatags.asp` | 本ファイル。条件分岐とHTML出力ロジックを確認 |

**主要処理フロー**:
1. **2行目**: secondAdmin.bPageTitleTagでTITLEタグ表示判定
2. **2行目**: sanitize(page.sSEOtitle)でサニタイズされた値を出力
3. **3行目**: secondAdmin.bPageKeywordsでキーワード表示判定
4. **3行目**: sanitize(page.sKeywords)でサニタイズされた値を出力
5. **4行目**: secondAdmin.bPageDescriptionで説明文表示判定
6. **4行目**: sanitize(page.sDescription)でサニタイズされた値を出力
7. **5行目**: secondAdmin.bPageAdditionalHeaderで追加ヘッダー表示判定
8. **5行目**: quotRep(page.sHeader)でエスケープされた値を出力

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | functions.asp | `asp/includes/functions.asp` | sanitize()、quotRep()関数の実装 |

**主要処理フロー**:
- sanitize(): XSS対策のHTMLエスケープ処理
- quotRep(): HTML引用符のエスケープ処理

### プログラム呼び出し階層図

```
bs_editItem.asp（または他のページ編集画面）
    │
    └─ bs_metatags.asp（SSIインクルード）
           │
           ├─ secondAdmin.bPageTitleTag（権限チェック）
           │      └─ sanitize(page.sSEOtitle)
           │
           ├─ secondAdmin.bPageKeywords（権限チェック）
           │      └─ sanitize(page.sKeywords)
           │
           ├─ secondAdmin.bPageDescription（権限チェック）
           │      └─ sanitize(page.sDescription)
           │
           └─ secondAdmin.bPageAdditionalHeader（権限チェック）
                  └─ quotRep(page.sHeader)
```

### データフロー図

```
[入力]               [処理]                    [出力]

secondAdmin ─────▶ 権限判定 ─────────────▶ 表示/非表示決定
.bPageTitleTag
.bPageKeywords
.bPageDescription
.bPageAdditionalHeader

page.sSEOtitle ──▶ sanitize() ───────────▶ <input name="sSEOtitle">
                                              (サニタイズ済み値)

page.sKeywords ──▶ sanitize() ───────────▶ <input name="sKeywords">
                                              (サニタイズ済み値)

page.sDescription▶ sanitize() ───────────▶ <textarea name="sDescription">
                                              (サニタイズ済み値)

page.sHeader ────▶ quotRep() ────────────▶ <textarea name="sHeader">
                                              (エスケープ済み値)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_metatags.asp | `asp/bs_metatags.asp` | ソース | メタタグ設定UI部品 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| language.asp | `asp/includes/language.asp` | ソース | 多言語ラベル関数 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 呼び出し元画面例 |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | 呼び出し元画面例 |
