# 画面設計書 197-バックサイトエントリー

## 概要

本ドキュメントは、QuickerSite CMSの「バックサイトエントリー」画面の設計仕様を定義するものである。この画面は、バックサイト（管理画面）へのエントリーポイントとして機能し、自動的にログイン画面へリダイレクトする。

### 本画面の処理概要

この画面は、バックサイト管理画面へのアクセス起点となる。ユーザーがbacksite/default.aspにアクセスすると、即座にログイン画面（asp/bs_login.asp）へリダイレクトされる。

**業務上の目的・背景**：QuickerSite CMSでは、管理画面（バックサイト）は/backsiteディレクトリ配下に配置される想定となっている。サイト管理者が直感的に/backsiteへアクセスした場合に、適切なログイン画面へ誘導するためのリダイレクト処理を提供する。これにより、ユーザビリティの向上とアクセスパスの一貫性を確保する。

**画面へのアクセス方法**：ブラウザでサイトの/backsite/または/backsite/default.aspにアクセスする。

**主要な操作・処理内容**：
1. ページにアクセスすると即座にResponse.Redirectが実行される
2. ../asp/bs_login.aspへリダイレクトされる
3. ユーザー操作は不要（自動処理）

**画面遷移**：
- 遷移元：直接URL入力
- 遷移先：バックサイトログイン画面（asp/bs_login.asp）

**権限による表示制御**：権限制御なし。誰でもアクセス可能だが、即座にログイン画面へリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 管理者ログイン | 主機能 | バックサイト管理画面のエントリーポイント |

## 画面種別

リダイレクト（エントリーポイント）

## URL/ルーティング

- URL: `backsite/default.asp`
- メソッド: GET
- リダイレクト先: `../asp/bs_login.asp`
- アクセス制限: なし（ただしリダイレクト先で認証が必要）

## 入出力項目

なし（リダイレクト処理のみ）

## 表示項目

なし（画面表示前にリダイレクトされる）

## イベント仕様

### 1-ページロード（自動実行）

**処理フロー**：
1. ページにアクセスする
2. ASPコードが実行される
3. Response.Redirect("../asp/bs_login.asp")が呼び出される
4. HTTPレスポンスとして302リダイレクトが返される
5. ブラウザがbs_login.aspにリダイレクトされる

## データベース更新仕様

なし（リダイレクト処理のみでデータベースアクセスなし）

## メッセージ仕様

なし

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| リダイレクト先が存在しない | 404エラー（bs_login.aspが存在しない場合） |

## 備考

- このファイルは非常にシンプルで、3行のみで構成されている
- Response.Redirectは即座にリダイレクト応答を返し、以降のコードは実行されない
- 相対パス（../asp/）を使用してログイン画面を参照
- IISのデフォルトドキュメント設定により、/backsite/へのアクセスでもこのファイルが実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本ファイルはデータ構造を持たない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | - | データ構造なし |

**読解のコツ**: このファイルは単純なリダイレクト処理のみであり、データ構造は存在しない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | default.asp | `backsite/default.asp` | 本ファイル。リダイレクト処理を確認 |

**主要処理フロー**:
1. **1行目**: `<%` - ASPコードブロック開始
2. **2行目**: `Response.Redirect ("../asp/bs_login.asp")` - リダイレクト実行
3. **3行目**: `%>` - ASPコードブロック終了

#### Step 3: リダイレクト先を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_login.asp | `asp/bs_login.asp` | リダイレクト先のログイン画面 |

**主要処理フロー**:
- bs_login.aspはバックサイトログイン画面を表示
- CAPTCHA認証とパスワード認証を提供

### プログラム呼び出し階層図

```
backsite/default.asp
    │
    └─ Response.Redirect("../asp/bs_login.asp")
           │
           └─ bs_login.asp（ログイン画面）
                  │
                  ├─ 認証成功 → bs_default.asp（ホーム画面）
                  │
                  └─ 認証失敗 → bs_login.asp（再表示）
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ─────▶ Response.Redirect ───▶ HTTP 302リダイレクト
(/backsite/)              │                      │
                          │                      │
                          └───────────────────▶ Location: ../asp/bs_login.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default.asp | `backsite/default.asp` | ソース | バックサイトエントリーポイント |
| bs_login.asp | `asp/bs_login.asp` | ソース | リダイレクト先ログイン画面 |
| bs_default.asp | `asp/bs_default.asp` | ソース | ログイン成功後のホーム画面 |
