# 画面設計書 198-ウェブ設定

## 概要

本ドキュメントは、QuickerSite CMSの「ウェブ設定」ファイルの設計仕様を定義するものである。このファイルは画面ではなく、システム全体の設定を定義する設定ファイルである。データベース接続、メール設定、パス設定など、QuickerSite CMSの基本動作に必要なパラメータを一元管理する。

### 本画面の処理概要

このファイルはQuickerSite CMSの中核となる設定ファイルであり、すべてのASPページで読み込まれる。画面としてのUIは持たず、定数・変数の定義のみを行う。

**業務上の目的・背景**：CMSシステムの運用には、データベース接続情報、メールサーバー設定、ファイルパス設定など多岐にわたる設定が必要となる。本ファイルは、これらの設定を一箇所に集約し、システム管理者がサーバー環境に応じた設定を容易に行えるようにする。また、設定の変更が必要な場合も、このファイルのみを編集すればよい構成となっている。

**画面へのアクセス方法**：UIを持たないため、画面アクセスはない。設定変更はサーバー上でファイルを直接編集する。

**主要な操作・処理内容**：
1. 仮想ディレクトリ設定（C_VIRT_DIR、C_DIRECTORY_QUICKERSITE）
2. ユーザーファイルフォルダ設定（QS_CMS_userfiles）
3. メールコンポーネント・SMTPサーバー設定
4. データベースパス設定（Access/SQL Server対応）
5. 顧客ID設定（QS_CMS_iCustomerID）
6. 管理者メールアドレス・パスワード設定
7. カスタムASPページパス設定
8. その他動作設定

**画面遷移**：該当なし（設定ファイル）

**権限による表示制御**：該当なし（サーバー上でのファイル編集権限が必要）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | ウェブ設定ファイルの管理 |

## 画面種別

設定ファイル（UIなし）

## URL/ルーティング

- ファイルパス: `asp/config/web_config.asp`
- 直接アクセス: 不可（インクルード専用）
- インクルード元: `asp/begin.asp`

## 入出力項目

### 定数・変数一覧

| カテゴリ | 定数/変数名 | 型 | デフォルト値 | 説明 |
|----------|-------------|-----|-------------|------|
| 仮想ディレクトリ | C_VIRT_DIR | const | "" | IIS仮想ディレクトリパス |
| 仮想ディレクトリ | C_DIRECTORY_QUICKERSITE | const | "" | QuickerSiteディレクトリパス |
| ファイルパス | QS_CMS_userfiles | Application | "/userfiles/" | アップロードファイル保存先 |
| メール | C_MAILCOMPONENT | const | "cdo.message" | メールコンポーネント種別 |
| メール | C_SMTPSERVER | const | "localhost" | SMTPサーバーアドレス |
| メール | C_SMTPPORT | const | 25 | SMTPポート番号 |
| メール | C_SMTPUSERNAME | const | "" | SMTP認証ユーザー名 |
| メール | C_SMTPUSERPW | const | "" | SMTP認証パスワード |
| メール | QSCDO_smtpusessl | 変数 | false | SMTP SSL使用フラグ |
| メール | C_SENDUSING | const | 1 | CDO送信方式（1:ローカル、2:外部、3:Exchange） |
| DB | QS_DBS | 変数 | 1 | データベース種別（1:Access、2:SQL Server） |
| DB | C_DATABASE | 変数 | server.MapPath(...)+"QuickerSite.mdb" | メインDBパス |
| DB | C_DATABASE_LABELS | 変数 | server.MapPath(...)+"QuickerLabels.mdb" | ラベルDBパス |
| 顧客 | QS_CMS_iCustomerID | Application | 73 | 顧客ID |
| 管理者 | C_ADMINEMAIL | const | "" | 管理者メールアドレス |
| 管理者 | C_ADMINPASSWORD | const | "" | 管理者パスワード |
| 管理者 | QS_admin_login_page | const | "ad_login.asp" | 管理者ログインページ |
| カスタム | execBeforePageLoad | 変数 | "" | ページロード前実行ASP |
| カスタム | execAfterPageLoad | 変数 | "" | ページロード後実行ASP |
| その他 | QS_backsite_login_page | const | "bs_login.asp" | バックサイトログインページ |
| その他 | QS_number_of_allowed_attempts_to_login | const | 5 | ログイン試行許可回数 |
| その他 | manyContacts | 変数 | 250 | 「多い」とみなす連絡先数 |
| その他 | C_DEV | const | false | 開発モードフラグ |
| テンプレート | sNewTemplatesPath | 変数 | server.MapPath(...)+"/templates" | テンプレート保存パス |
| テンプレート | sNewTemplatesURL | 変数 | C_VIRT_DIR+"/templates" | テンプレートURL |
| テンプレート | bBrowseOnlineTemplates | 変数 | true | オンラインテンプレート参照許可 |

## 表示項目

該当なし（設定ファイル）

## イベント仕様

該当なし（設定ファイル）

## データベース更新仕様

該当なし（設定ファイル。ただし、このファイルの設定に基づいてDBアクセスが行われる）

## メッセージ仕様

| 状況 | 動作 |
|------|------|
| C_DEV=true | l("QuickerSiteoffline")メッセージを表示してサイト停止 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| データベースパスが不正 | データベース接続エラー |
| メール設定が不正 | メール送信エラー |

## 備考

- このファイルはbegin.aspからインクルードされ、すべてのASPページで読み込まれる
- 設定変更後はIISのアプリケーションプールをリサイクルする必要がある場合がある
- SQL Server使用時は、QS_DBS=2に設定し、SQL2005_*定数をアンコメントして設定する
- C_MAILCOMPONENTは複数のメールコンポーネントに対応：persits.mailsender, cdo.message, jmail.message, cdonts.newmail, smtpsvg.mailer
- セキュリティ上、C_ADMINPASSWORDは必ず設定すること

---

## コードリーディングガイド

本ファイルを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定ファイルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | web_config.asp | `asp/config/web_config.asp` | 本ファイル。各設定項目の意味と用途 |

**読解のコツ**: constは定数（変更不可）、変数は実行時に変更可能。Application変数はアプリケーション全体で共有される。

#### Step 2: インクルード元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | begin.asp | `asp/begin.asp` | web_config.aspをインクルードする箇所（57行目） |

**主要処理フロー**:
1. **57行目**: `<!-- #include file="config/web_config.asp"-->`でインクルード

#### Step 3: 設定値の使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | database.asp | `asp/includes/database.asp` | C_DATABASE、QS_DBSの使用箇所 |
| 3-2 | mail_message.asp | `asp/includes/mail_message.asp` | C_MAILCOMPONENT、C_SMTPSERVERの使用箇所 |

### プログラム呼び出し階層図

```
任意のASPページ
    │
    └─ begin.asp（共通初期化）
           │
           ├─ config/rebrand.asp（ブランド設定）
           │
           └─ config/web_config.asp（ウェブ設定）★本ファイル
                  │
                  ├─ C_DATABASE → database.asp → DB接続
                  │
                  ├─ C_MAILCOMPONENT → mail_message.asp → メール送信
                  │
                  └─ QS_CMS_iCustomerID → customer.asp → 顧客データ取得
```

### データフロー図

```
[設定ファイル]           [利用箇所]                    [機能]

C_DATABASE ───────▶ database.asp ────────────▶ DB接続確立
C_DATABASE_LABELS ──┘

C_MAILCOMPONENT ──▶ mail_message.asp ────────▶ メール送信
C_SMTPSERVER ─────┘

QS_CMS_iCustomerID▶ customer.asp ─────────────▶ 顧客データ取得

C_VIRT_DIR ───────▶ 各種パス生成 ─────────────▶ URL/パス構築
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| web_config.asp | `asp/config/web_config.asp` | 設定 | メイン設定ファイル |
| rebrand.asp | `asp/config/rebrand.asp` | 設定 | ブランド設定ファイル |
| begin.asp | `asp/begin.asp` | ソース | 設定ファイルのインクルード元 |
| database.asp | `asp/includes/database.asp` | ソース | DB接続処理 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信処理 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データ管理 |
