# 画面設計書 199-リブランド設定

## 概要

本ドキュメントは、QuickerSite CMSの「リブランド設定」ファイルの設計仕様を定義するものである。このファイルは画面ではなく、CMSのブランディング（名称、ロゴ、スローガン、フッター等）とバックサイトテンプレートのHTMLを定義する設定ファイルである。ホワイトラベル対応でCMSを再ブランド化する際に使用する。

### 本画面の処理概要

このファイルはQuickerSite CMSのブランディング要素を定義し、バックサイト（管理画面）のHTML構造を出力する関数群を提供する。画面としてのUIは持たず、定数定義と関数定義を行う。

**業務上の目的・背景**：QuickerSite CMSはホワイトラベル対応のCMSであり、リセラーやシステム開発会社が自社ブランドとして顧客に提供できる。本ファイルは、CMSの名称（MYQS_name）、スローガン（MYQS_slogan）、サポートURL、フッター等を一箇所で設定し、簡単にリブランドできるようにする。また、バックサイトのHTMLテンプレート（ヘッダー、メニュー、フッター）も定義し、管理画面のデザインを統一する。

**画面へのアクセス方法**：UIを持たないため、画面アクセスはない。設定変更はサーバー上でファイルを直接編集する。

**主要な操作・処理内容**：
1. CMS名称・スローガン設定（MYQS_name、MYQS_slogan）
2. サポートURL設定（MYQS_url、MYQS_urlSupport等）
3. フッターHTML設定（MYQS_FOOTER）
4. アイコンカラー設定（MYQS_IconColor、MYQS_IconHoverColor）
5. バックサイトHTMLテンプレート関数（artHeaderPart、artTopBannerAndMenu等）

**画面遷移**：該当なし（設定ファイル）

**権限による表示制御**：該当なし（サーバー上でのファイル編集権限が必要）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | リブランディング設定 |

## 画面種別

設定ファイル（UIなし）

## URL/ルーティング

- ファイルパス: `asp/config/rebrand.asp`
- 直接アクセス: 不可（インクルード専用）
- インクルード元: `asp/begin.asp`

## 入出力項目

### 定数一覧

| 定数名 | デフォルト値 | 説明 |
|--------|-------------|------|
| MYQS_name | "QuickerSite" | CMS名称 |
| MYQS_slogan | "CMS the fun way!" | スローガン |
| MYQS_url | "http://www.quickersite.com/" | CMSのURL |
| MYQS_GENERATOR | "QuickerSite CMS - visit www.quickersite.com" | META Generatorタグ値 |
| MYQS_urlSupport | "http://www.quickersite.com/r/?sCode=SUPPORT" | サポートページURL |
| MYQS_urlTemplates | "http://www.quickersite.com/r/?sCode=TEMPLATES" | テンプレートページURL |
| MYQS_urlUFLs | "http://www.quickersite.com/r/ufl" | ユーザーフレンドリーURL解説ページ |
| MYQS_FOOTER | HTMLフッター | フッターHTML |
| MYQS_IconColor | "#3A383E" | アイコン通常色 |
| MYQS_IconHoverColor | "#70919A" | アイコンホバー色 |

### 関数一覧

| 関数名 | 説明 |
|--------|------|
| artHeaderPart | バックサイトHTMLヘッダー部分を出力 |
| artTopBannerAndMenu | バックサイトトップバナー・メニュー部分を出力 |
| artFooterPart | バックサイトフッター部分を出力 |
| artTopBannerAndMenuLOGIN | ログイン画面用トップバナー・メニュー部分を出力 |
| artFooterPartLOGIN | ログイン画面用フッター部分を出力 |
| artHeaderPartLOGIN | ログイン画面用ヘッダー部分を出力 |

## 表示項目

該当なし（設定ファイル。ただし、定義された関数がバックサイト画面の表示に使用される）

## イベント仕様

該当なし（設定ファイル）

## データベース更新仕様

該当なし（設定ファイル）

## メッセージ仕様

該当なし

## 例外処理

該当なし

## 備考

- このファイルはbegin.aspからインクルードされ、すべてのASPページで読み込まれる
- 設定変更後はIISアプリケーションをリセット（Application.Contents.RemoveAll()）する必要がある
- artXXX関数群はバックサイトテンプレート（backsiteTemplate31）を使用
- MYQS_FOOTERにはHTMLを直接記述可能（Copyright表示等）
- getBSArtMenu関数が動的メニューを生成し、artTopBannerAndMenuから呼び出される
- ログイン画面は別テンプレート（backsiteTemplateLOGIN31）を使用

---

## コードリーディングガイド

本ファイルを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定定数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rebrand.asp | `asp/config/rebrand.asp` | 本ファイル。各定数の意味と用途（15-39行目） |

**読解のコツ**: MYQS_で始まる定数がリブランド対象。これらを変更することでCMSの表示名やURLを変更できる。

#### Step 2: HTML出力関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rebrand.asp | `asp/config/rebrand.asp` | artHeaderPart関数（42-57行目） |
| 2-2 | rebrand.asp | `asp/config/rebrand.asp` | artTopBannerAndMenu関数（59-110行目） |
| 2-3 | rebrand.asp | `asp/config/rebrand.asp` | artFooterPart関数（112-152行目） |

**主要処理フロー**:
1. **artHeaderPart**: CSSとJSのlink/scriptタグを出力
2. **artTopBannerAndMenu**: ロゴ、スローガン、メニューを含むヘッダーHTMLを出力
3. **artFooterPart**: フッターHTMLを出力

#### Step 3: 関数の使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | header.asp | `asp/includes/header.asp` | artHeaderPart()の呼び出し箇所 |
| 3-2 | artisteer.asp | `asp/includes/artisteer.asp` | artTopBannerAndMenu()の呼び出し箇所 |

### プログラム呼び出し階層図

```
任意のバックサイトASPページ
    │
    ├─ includes/header.asp
    │      └─ artHeaderPart()（または artHeaderPartLOGIN()）
    │             └─ CSS/JSリンク出力
    │
    ├─ includes/artisteer.asp
    │      └─ artTopBannerAndMenu()（または artTopBannerAndMenuLOGIN()）
    │             ├─ ロゴ表示（MYQS_name、MYQS_slogan）
    │             └─ getBSArtMenu()（動的メニュー生成）
    │
    └─ includes/footer.asp
           └─ artFooterPart()（または artFooterPartLOGIN()）
                  └─ フッター表示（MYQS_FOOTER）
```

### データフロー図

```
[設定定数]             [関数]                    [出力先]

MYQS_name ──────────▶ artTopBannerAndMenu() ───▶ ロゴ表示
MYQS_slogan ─────────┘

C_DIRECTORY_QUICKERSITE▶ artHeaderPart() ────────▶ CSS/JSパス

MYQS_FOOTER ─────────▶ artFooterPart() ─────────▶ フッターHTML

getBSArtMenu() ──────▶ artTopBannerAndMenu() ───▶ ナビゲーションメニュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rebrand.asp | `asp/config/rebrand.asp` | 設定 | リブランド設定ファイル |
| web_config.asp | `asp/config/web_config.asp` | 設定 | ウェブ設定ファイル |
| begin.asp | `asp/begin.asp` | ソース | 設定ファイルのインクルード元 |
| header.asp | `asp/includes/header.asp` | ソース | HTMLヘッダー出力 |
| artisteer.asp | `asp/includes/artisteer.asp` | ソース | Artisteerテンプレート関数 |
| footer.asp | `asp/includes/footer.asp` | ソース | HTMLフッター出力 |
| bs_header.asp | `asp/bs_header.asp` | ソース | メニュー生成（getBSArtMenu） |
| style.css | `backsiteTemplate31/style.css` | CSS | バックサイトスタイル |
| jquery.js | `backsiteTemplate31/jquery.js` | JS | jQuery |
| script.js | `backsiteTemplate31/script.js` | JS | バックサイトスクリプト |
