# 画面設計書 2-管理者ログイン画面

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者（Admin）向けログイン画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、QuickerSiteのシステム全体を管理するAdmin権限でのログインを行うための認証画面である。バックサイト管理者よりも上位の権限を持つシステム管理者専用の認証ゲートウェイとして機能し、複数顧客サイトの一元管理が可能となる。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSとして複数のサイトをホスティングできる構造を持つ。Admin権限を持つユーザーは、全顧客サイトの管理、IIS設定の変更、システムアップグレードなどの高度な操作を行う必要があるため、バックサイト管理者とは別の認証レイヤーが設けられている。

**画面へのアクセス方法**：`/asp/ad_login.asp` へ直接アクセスする。Admin認証が必要なページにアクセスした際、認証されていない状態では自動的にこのログイン画面にリダイレクトされる。

**主要な操作・処理内容**：
1. パスワード入力フィールドにAdmin パスワードを入力する
2. CAPTCHAに表示された文字列を入力する
3. ログインボタンを押下して認証を実行する
4. 認証成功時は管理者ダッシュボード（ad_default.asp）へリダイレクトされる
5. 認証失敗時はエラーメッセージとともにログイン画面が再表示される

**画面遷移**：
- 遷移元：直接URLアクセス、Admin認証が必要なページからのリダイレクト
- 遷移先：ad_default.asp（管理者ダッシュボード）

**権限による表示制御**：この画面自体は未認証ユーザー向けの画面であり、権限による表示制御はない。Admin認証は単一のシステム管理者パスワードで行われ、web_config.aspに設定されたC_ADMINPASSWORDと照合される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 管理者ログイン | 主機能 | システム管理者（Admin）向けログイン認証処理 |
| 118 | CAPTCHA認証 | 補助機能 | スパム防止用の画像認証表示・検証 |

## 画面種別

認証画面（ログインフォーム）

## URL/ルーティング

- `/asp/ad_login.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| パスワード | password | 入力 | 文字列 | - | 必須 | システム管理者パスワード |
| CAPTCHA | captcha | 入力 | 文字列 | 4 | 必須 | 画像認証の入力値 |
| ボタンアクション | btnaction | Hidden | 文字列 | - | - | 固定値「loginAdmin」 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ADMINログインタイトル | 上部中央 | 「ADMIN Login」固定テキスト |
| セキュリティ警告 | 上部中央 | IPブロック等の警告メッセージ |
| パスワードラベル | フォーム内 | 多言語対応ラベル |
| CAPTCHAラベル | フォーム内 | 多言語対応ラベル |
| CAPTCHA画像 | フォーム内 | includes/captcha.asp で生成 |
| ログインボタン | フォーム内 | 多言語対応ラベル |
| 試行回数表示 | 下部中央 | 現在のログイン試行回数と上限警告 |

## イベント仕様

### 1-ログインボタン押下

**処理フロー**：
1. フォームをPOST送信（btnaction="loginAdmin"）
2. Session("captcha")と入力されたcaptcha値を比較（先頭4文字、大文字小文字無視）
3. CAPTCHAが一致しない場合：err_captchaエラーを追加
4. CAPTCHAが一致する場合：logon.logonAdmin関数を呼び出し、入力パスワードを暗号化して検証
5. 認証成功時：ad_default.aspにリダイレクト
6. 認証失敗時：err_loginエラーを追加
7. ログイン試行回数をApplication変数でカウント

### 2-IPブロック処理

**処理フロー**：
1. application("adminLoginCount"&UserIP)の値がQS_number_of_allowed_attempts_to_loginを超過した場合
2. lockAdmin関数でエラーを発生させ、アクセスを遮断
3. 管理者にメール通知（初回のみ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン成功時 | なし | - | データベース更新なし（Session変数のみ更新） |

### テーブル別更新項目詳細

本画面ではデータベースへの直接的な更新は行わない。認証状態はSessionおよびApplication変数で管理される。

**Application変数**：
- `adminLoginCount{UserIP}`: ログイン試行回数（IPアドレス別）

**Session変数**：
- `{cId}isAUTHENTICATEDasADMIN`: Admin認証フラグ

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| err_captcha | エラー | CAPTCHA認証エラー | CAPTCHA入力が画像と一致しない |
| err_login | エラー | ログインエラー | パスワードが正しくない |
| lastchance | 警告 | 最後のチャンス警告 | 試行回数が上限に達した |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| IPブロック状態 | エラーページへリダイレクト、管理者にメール通知 |
| Admin無効化状態 | C_ADMINPASSWORDが空の場合、メッセージ表示後にアクセス遮断 |
| デフォルトパスワード使用 | devVersion以外ではnoaccess.htmへリダイレクト |

## 備考

- Admin認証はweb_config.aspに設定されたC_ADMINPASSWORDと照合される
- パスワードはEncrypt関数またはSHA256でハッシュ化して検証される
- バックサイト認証とは別のセッション変数（isAUTHENTICATEDasADMIN）で管理される
- C_ADMINPASSWORDが空の場合、Admin機能は無効化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Admin認証に関わるデータ構造と設定を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | web_config.asp | `asp/config/web_config.asp` | C_ADMINPASSWORD定数の定義場所 |
| 1-2 | logonEdit.asp | `asp/includes/logonEdit.asp` | cls_LogonEditクラスのlogonAdmin関数 |

**読解のコツ**: Admin認証はバックサイト認証と異なり、設定ファイルに定義されたパスワードと照合する。データベースは参照しない。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_login.asp | `asp/ad_login.asp` | Admin認証画面のメインファイル |

**主要処理フロー**:
1. **行7**: request("btnaction")="loginAdmin"でPOST送信を検知
2. **行8**: セッションのCAPTCHAと入力値を比較
3. **行11**: logon.logonAdmin関数でパスワード検証（Encrypt関数使用）
4. **行12**: 認証成功時はad_default.aspへリダイレクト
5. **行16**: ログイン試行回数のインクリメント
6. **行18**: lockAdmin関数でブロック判定

#### Step 3: 認証処理を理解する

Admin認証のコアロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logonAdmin関数（行55-66）の認証ロジック |

**主要処理フロー**:
- **行57**: Encrypt(C_ADMINPASSWORD)またはsha256(C_ADMINPASSWORD)と比較
- **行58**: Session(cId & "isAUTHENTICATEDasADMIN")をTrueに設定
- **行59**: 成功時にログイン試行回数をリセット

#### Step 4: セキュリティ処理を理解する

ブルートフォース対策を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | lockAdmin関数（行68-85）のブロック処理 |

**主要処理フロー**:
- **行69-73**: C_ADMINPASSWORDが空の場合の処理
- **行74-84**: 試行回数超過時のブロック処理とメール通知

### プログラム呼び出し階層図

```
ad_login.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化)
    │      ├─ config/web_config.asp (C_ADMINPASSWORD)
    │      ├─ database.asp (DB接続)
    │      └─ logonEdit.asp (認証クラス)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ logon.logonAdmin() (Admin認証処理)
    │      ├─ Encrypt() (パスワード暗号化)
    │      └─ sha256() (パスワードハッシュ)
    │
    ├─ logon.lockAdmin() (ブロック判定)
    │      └─ dumpError() (エラー通知)
    │
    └─ includes/footer.asp (共通フッター)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パスワード ────────▶ Encrypt/SHA256 ────────▶ C_ADMINPASSWORDと比較
                           │
                           ▼
CAPTCHA入力 ────────▶ セッション値と比較 ────────▶ 認証結果
                           │
                           ▼
IPアドレス ─────────▶ Application変数で
                     試行回数カウント ────────▶ ブロック判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_login.asp | `asp/ad_login.asp` | ソース | Admin認証画面メイン |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理・クラスロード |
| web_config.asp | `asp/config/web_config.asp` | 設定 | C_ADMINPASSWORD定義 |
| logonEdit.asp | `asp/includes/logonEdit.asp` | インクルード | 認証処理クラス |
| encryption.asp | `asp/includes/encryption.asp` | インクルード | 暗号化関数 |
| captcha.asp | `asp/includes/captcha.asp` | インクルード | CAPTCHA画像生成 |
| sha256.asp | `asp/includes/sha256.asp` | インクルード | SHA256ハッシュ関数 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックサイト初期化 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダーHTML |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッターHTML |
