# 画面設計書 20-複数ページ検証

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「複数ページ検証」画面の設計仕様を定義するものである。

### 本画面の処理概要

複数ページ検証画面は、フロントサイトからユーザーが編集した検証待ちページの一覧を表示する画面である。管理者は、この一覧から個別のページ検証画面に遷移して承認・却下作業を行う。

**業務上の目的・背景**：
複数のユーザーがフロントサイトから編集を行った場合、どのページが検証待ち状態にあるかを一覧で把握する必要がある。本画面は、検証が必要なページをリストアップし、管理者のワークフローを効率化する。更新者名と更新日時も表示されるため、優先度を判断しやすい。

**画面へのアクセス方法**：
1. バックサイトにログイン後、ホーム画面からアクセス
2. バックサイトヘッダーのホームメニューから遷移

**主要な操作・処理内容**：
1. 検証待ちページの一覧表示
2. 各ページの更新者名と更新日時の確認
3. 個別ページの検証画面への遷移

**画面遷移**：
- 遷移元: バックサイトホーム（bs_default.asp）
- 遷移先: ページ検証画面（bs_validatepage.asp）、バックサイトホーム（bs_default.asp）

**権限による表示制御**：
本画面は管理者専用であり、bs_security.aspによる認証チェックが行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 98 | ページ検証 | 主機能 | 複数ページの一括HTML検証 |

## 画面種別

一覧画面

## URL/ルーティング

```
asp/bs_validatepages.asp
```

## 入出力項目

本画面は一覧表示のみで、入力項目はない。

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| - | - | - | - | 入力項目なし |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | リンク | 検証待ちページのタイトル（クリックで検証画面へ） |
| 更新者名 | テキスト | 更新したユーザーのニックネーム |
| 更新日時 | テキスト | 更新日時（ヨーロッパ形式） |
| 検証待ちなしメッセージ | テキスト | 検証待ちページがない場合のメッセージ |
| 戻るリンク | リンク | バックサイトホームへ戻るリンク |

## イベント仕様

### 1-ページタイトルリンククリック

1. 検証待ちページの暗号化されたIDをURLパラメータとして付与
2. bs_validatepage.aspに遷移
3. 個別ページの検証処理が可能

### 2-戻るリンククリック

1. バックサイトホーム（bs_default.asp）に遷移

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみで、データベースの更新は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblPage | SELECT | 検証待ちページの取得 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sTitle, iUpdatedBy, dUpdatedOn | sTitleToBeValidatedまたはsValueToBeValidatedがNULLでない | 検証待ちページの一覧取得 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| - | 情報 | 検証待ちなし | No pages to validate. |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| 検証待ちページなし | 「No pages to validate.」メッセージを表示 |

## 備考

- customer.pagesTobeValidatedプロパティで検証待ちページのリストを取得
- 各ページの情報はcls_pageオブジェクトから取得
- 更新者情報はpobj.updater.sNickNameで取得（updaterプロパティ経由）
- 日時表示はconvertEuroDateTime()関数でヨーロッパ形式に変換
- ul/liタグでシンプルなリスト形式で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構成を理解する

複数ページ検証画面の表示内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_validatepages.asp | `asp/bs_validatepages.asp` | 画面構成、ループ処理、条件分岐 |

**読解のコツ**: customer.pagesTobeValidatedで検証待ちリストを取得し、For Eachでループ表示している点に注目。

#### Step 2: 検証待ちリスト取得を理解する

検証待ちページの取得ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_validatepages.asp | `asp/bs_validatepages.asp` | customer.pagesTobeValidated呼び出し（行4-5） |

**主要処理フロー**:
1. **行4-5**: customer.pagesTobeValidatedでリスト取得
2. **行5-8**: For Eachでページごとにcls_pageオブジェクト生成
3. **行5-7**: リンク生成と更新者・更新日時表示

#### Step 3: ページオブジェクトを理解する

cls_pageの関連プロパティを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page.asp | `asp/includes/page.asp` | updater、iUpdatedBy、dUpdatedOnプロパティ |

### プログラム呼び出し階層図

```
bs_validatepages.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ customer.pagesTobeValidated（検証待ちリスト取得）
    │      └─ tblPage SELECT
    │             (WHERE sTitleToBeValidated IS NOT NULL
    │              OR sValueToBeValidated IS NOT NULL)
    │
    └─ [ループ処理]
           │
           ├─ cls_page.pick()（各ページ情報取得）
           │
           └─ 表示
                  ├─ ページタイトル（リンク）
                  ├─ pobj.updater.sNickName（更新者名）
                  └─ convertEuroDateTime(pobj.dUpdatedOn)（更新日時）
```

### データフロー図

```
[入力]                      [処理]                      [出力]

                      customer.pagesTobeValidated
                              │
                              ▼
                      tblPage SELECT ─────────────────▶ ページIDリスト
                              │
                              ▼
                      For Each ページID
                              │
                              ▼
                      cls_page.pick(ページID)
                              │
                              ▼
                      ┌───────┴───────┐
                      │               │
                  sTitle         updater.sNickName
                      │               │
                      ▼               ▼
                リンク表示        更新者表示
                      │
                      ▼
                dUpdatedOn
                      │
                      ▼
              convertEuroDateTime()
                      │
                      ▼
                日時表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_validatepages.asp | `asp/bs_validatepages.asp` | ソース | メイン画面処理 |
| bs_validatepage.asp | `asp/bs_validatepage.asp` | ソース | 個別検証画面（遷移先） |
| bs_default.asp | `asp/bs_default.asp` | ソース | バックサイトホーム（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| customer.asp | `asp/includes/customer.asp` | インクルード | pagesTobeValidatedプロパティ（推定） |
