# 画面設計書 200-404エラー

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト管理画面における「404エラー」画面の設計仕様を定義するものである。この画面は、カスタム404エラーページの設定を行うための画面である。ファイルが見つからない場合に表示するエラーページのタイトル、本文、テンプレートを設定できる。

### 本画面の処理概要

この画面は、サイト訪問者が存在しないページにアクセスした際に表示する404エラーページのコンテンツとデザインを設定する機能を提供する。

**業務上の目的・背景**：Webサイト運営において、ユーザーが存在しないURLにアクセスすることは避けられない。デフォルトの404エラーページはユーザー体験を損なう可能性があるため、本画面でカスタム404ページを設定し、サイトのデザインに合った、ユーザーフレンドリーなエラーページを提供できるようにする。また、[404FILENAME]プレースホルダーを使用して、要求されたファイル名を動的に表示することも可能。

**画面へのアクセス方法**：バックサイトメニューから「Setup」→「Custom 404 page」を選択することでアクセスできる。直接URL（bs_404.asp）でもアクセス可能。ただし、customer.bUserFriendlyURL（ユーザーフレンドリーURL機能）が有効かつsecondAdmin.bCustom404権限がtrueの場合のみ表示される。

**主要な操作・処理内容**：
1. カスタム404ページの有効/無効切り替え（bCustom404）
2. 404ページタイトル（sCustom404Title）の設定
3. 404ページ本文（sCustom404Body）の設定（WYSIWYGエディタ使用）
4. 404ページに適用するテンプレート（i404TemplateID）の選択
5. 「Save」ボタンで設定を保存

**画面遷移**：
- 遷移元：バックサイトホーム → Setup → Custom 404 page
- 遷移先：保存成功後、同画面にリダイレクト（クエリパラメータでメッセージ表示）

**権限による表示制御**：customer.bUserFriendlyURLがtrueかつsecondAdmin.bCustom404権限がtrueの場合のみ、メニューに表示され、アクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | カスタム404ページ設定 | 主機能 | 404エラーページの表示・設定 |

## 画面種別

編集

## URL/ルーティング

- URL: `asp/bs_404.asp`
- メソッド: GET（表示）/ POST（保存）
- アクセス制限: secondAdmin.bCustom404権限が必要

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|-----|------|--------|-----------|------|
| カスタム404有効 | bCustom404 | checkbox | - | - | 入力 | カスタム404ページを有効にするかどうか |
| ページタイトル | sCustom404Title | text | - | 255文字 | 入力 | 404ページのタイトル（[PAGETITLE]に展開） |
| メッセージ本文 | sCustom404Body | WYSIWYGエディタ | - | - | 入力 | 404ページの本文（[PAGEBODY]に展開） |
| テンプレート | i404TemplateID | select | - | - | 入力 | 404ページに適用するテンプレートID |
| ポストバックフラグ | postback | hidden | - | - | 入力 | フォーム送信判定用 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| Enable custom 404 page? | フォーム1行目 | bCustom404チェックボックス |
| [PAGETITLE] | フォーム2行目 | タイトル入力欄 |
| Message / [PAGEBODY] | フォーム3行目 | 本文入力欄（WYSIWYGエディタ） |
| [404FILENAME]ヒント | フォーム3行目 | 不明ファイル名を参照するためのプレースホルダー説明 |
| Template | フォーム4行目 | テンプレート選択ドロップダウン |
| Saveボタン | フォーム1行目右 / 5行目 | 保存ボタン（2箇所） |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. フォームが送信される（POST）
2. postbackフラグ（hidden field）がtrueかどうか判定
3. 各フィールドの値をRequest.Formから取得
4. sCustom404Titleはleft()で最大250文字に切り詰め
5. i404TemplateIDはdecrypt()で復号化
6. customerオブジェクトの各プロパティに値をセット
7. customer.save()でデータベースに保存
8. 保存成功時、bs_404.asp?fbMessage=fb_saveOKにリダイレクト

### 2-デフォルト値設定

**処理フロー**：
1. sCustom404BodyとsCustom404Titleが両方とも空の場合
2. デフォルト値を設定：
   - sCustom404Title = "File Not Found"
   - sCustom404Body = 'The file "[404FILENAME]" you searched for cannot be found.'

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | 404関連カラムの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bCustom404 | convertBool(request.form("bCustom404")) | カスタム404有効フラグ |
| UPDATE | sCustom404Title | left(request.form("sCustom404Title"),250) | ページタイトル（最大250文字） |
| UPDATE | sCustom404Body | request.form("sCustom404Body") | ページ本文 |
| UPDATE | i404TemplateID | convertGetal(decrypt(request.form("i404TemplateID"))) | テンプレートID |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存成功メッセージ | リダイレクトURLのクエリパラメータで指定 |

## 例外処理

| 例外ケース | 処理内容 |
|-----------|----------|
| 権限不足（bCustom404=false） | noaccess.htmにリダイレクト |
| ユーザーフレンドリーURL無効 | メニューに表示されない（直接アクセスは可能） |
| 保存失敗 | customer.save()がfalseを返す（リダイレクトなし） |

## 備考

- ユーザーフレンドリーURL機能（customer.bUserFriendlyURL）が有効な場合にのみ意味を持つ機能
- [404FILENAME]プレースホルダーは、要求されたファイル名を動的に挿入する
- [PAGETITLE]と[PAGEBODY]はテンプレート内のプレースホルダーで、設定したタイトルと本文に置換される
- dumpFCKInstance()関数でWYSIWYGエディタを生成
- sanitize()関数でXSS対策のサニタイズ処理を実施
- customer.showSelectedtemplate()でテンプレート選択肢を生成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

顧客（サイト）の404設定データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのbCustom404、sCustom404Title、sCustom404Body、i404TemplateIDプロパティの定義 |

**読解のコツ**: customerオブジェクトはサイト全体設定を保持し、データベースのtblCustomerテーブルと対応。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_404.asp | `asp/bs_404.asp` | 本ファイル。フォーム表示と保存処理のロジック |

**主要処理フロー**:
1. **1行目**: begin.aspのインクルード（共通初期化）
2. **2行目**: bs_security.aspでセキュリティチェック、logon.hasaccess secondAdmin.bCustom404で権限チェック
3. **4-17行目**: POSTデータ処理と保存
4. **19-22行目**: デフォルト値の設定（タイトル・本文が空の場合）
5. **28-40行目**: フォームHTML出力

#### Step 3: セキュリティ制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | secondAdmin.bCustom404の設定（72行目） |
| 3-2 | bs_header.asp | `asp/bs_header.asp` | メニュー表示条件（414-421行目） |

**主要処理フロー**:
- **bs_security.asp 72行目**: secondAdmin.bCustom404=true のデフォルト設定
- **bs_header.asp 414-421行目**: customer.bUserFriendlyURL AND secondAdmin.bCustom404 でメニュー表示

#### Step 4: WYSIWYGエディタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ckeditor.asp | `asp/includes/ckeditor.asp` | dumpFCKInstance()関数の実装 |

### プログラム呼び出し階層図

```
bs_404.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bCustom404
    │
    ├─ includes/header.asp（ヘッダー出力）
    │
    ├─ bs_initBack.asp（バックサイト初期化）
    │
    ├─ bs_header.asp（バックサイトヘッダー）
    │
    ├─ convertBool()（ブール変換）
    │
    ├─ left()（文字列切り詰め）
    │
    ├─ decrypt()（テンプレートID復号）
    │
    ├─ convertGetal()（数値変換）
    │
    ├─ customer.save()（データベース保存）
    │
    ├─ response.redirect()（保存後リダイレクト）
    │
    ├─ sanitize()（XSS対策）
    │
    ├─ dumpFCKInstance()（WYSIWYGエディタ生成）
    │
    ├─ customer.showSelectedtemplate()（テンプレート選択肢生成）
    │
    └─ l()（多言語ラベル取得）
```

### データフロー図

```
[入力]                    [処理]                    [出力]

Request.Form ─────────▶ convertBool() ────────▶ bCustom404
("bCustom404")

Request.Form ─────────▶ left(...,250) ────────▶ sCustom404Title
("sCustom404Title")

Request.Form ─────────▶ そのまま ─────────────▶ sCustom404Body
("sCustom404Body")

Request.Form ─────────▶ decrypt() ────────────▶ i404TemplateID
("i404TemplateID")    └─ convertGetal()

customer.* ───────────▶ customer.save() ──────▶ DB更新

customer.sCustom404* ──▶ sanitize() ──────────▶ フォーム表示
                             │
                       dumpFCKInstance() ─────▶ WYSIWYGエディタ

customer.showSelectedtemplate() ───────────────▶ <option>タグ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_404.asp | `asp/bs_404.asp` | ソース | 404エラー設定画面本体 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客/サイト設定クラス定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限初期化 |
| bs_header.asp | `asp/bs_header.asp` | ソース | メニュー定義 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | ユーティリティ関数群 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化/復号化関数 |
| template.asp | `asp/includes/template.asp` | ソース | テンプレート管理クラス |
