# 画面設計書 21-検索画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における検索画面（bs_search.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がバックサイト内のコンテンツを横断的に検索するための機能を提供する。ページ、定数、フォーム、テンプレート、フィード、投票、ギャラリー、テーマなど、CMSで管理されているあらゆるコンテンツを対象とした全文検索を実行し、該当するコンテンツへの直接リンクを表示する。

**業務上の目的・背景**：サイト運営において、コンテンツが増加すると特定のページやフォーム、定数を探すことが困難になる。本画面は、管理者が効率的にコンテンツを探索し、編集作業の起点とするための機能を提供することで、運用効率を向上させる。

**画面へのアクセス方法**：バックサイトホーム（bs_default.asp）のヘッダーメニューから「検索」リンクをクリックしてアクセスする。セカンドアドミン権限を持つユーザーはアクセスが制限される。

**主要な操作・処理内容**：
1. 検索キーワードの入力
2. 検索ボタンの押下による全文検索の実行
3. 検索結果一覧の確認
4. 該当コンテンツへの直接遷移

**画面遷移**：バックサイトホーム（bs_default.asp）から遷移し、検索結果の各リンクから該当する編集画面（bs_formEdit.asp、bs_templateEdit.asp、bs_constantEdit.asp等）へ遷移可能。

**権限による表示制御**：セカンドアドミン（secondAdmin）ユーザーは本画面へのアクセスが制限され、アクセス時にはbs_default.aspへリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 97 | バックオフィス検索 | 主機能 | 管理画面内でのページ・コンテンツ検索 |

## 画面種別

検索

## URL/ルーティング

`asp/bs_search.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| 検索キーワード | svalue | テキスト | 必須 | - | 空白チェック | 検索対象のキーワード |
| ポストバックフラグ | postback | hidden | - | - | - | フォーム送信判定用 |
| CSRFトークン | QS_secCodeHidden | hidden | - | - | CSRF検証 | セキュリティトークン |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| セットアップ | 検索ヒット時 | 顧客設定（サイト名、URL、タイトル等）の検索結果 |
| ページ一覧 | 検索ヒット時 | ページの検索結果リンク一覧 |
| 定数 | 検索ヒット時 | 定数の検索結果リンク一覧 |
| フォーム | 検索ヒット時 | フォームの検索結果リンク一覧 |
| フォームフィールド | 検索ヒット時 | フォームフィールドの検索結果リンク一覧 |
| テンプレート | 検索ヒット時 | テンプレートの検索結果リンク一覧 |
| フィード | 検索ヒット時 | RSSフィードの検索結果リンク一覧 |
| 投票 | 検索ヒット時 | 投票の検索結果リンク一覧 |
| ギャラリー | 検索ヒット時 | ギャラリーの検索結果リンク一覧 |
| テーマ | 検索ヒット時 | テーマの検索結果リンク一覧 |
| カタログフィールド | 検索ヒット時 | カタログフィールドの検索結果リンク一覧 |
| 検索結果なしメッセージ | 結果が0件時 | 「0件の検索結果」メッセージ |

## イベント仕様

### 1-検索ボタン押下

**トリガー**: 検索ボタン（btnaction）クリック

**処理フロー**:
1. フォームがPOST送信される
2. CSRFトークンの検証（checkCSRF関数）
3. cls_fullSearchクラスのインスタンス化
4. 検索パターンを正規表現として設定
5. 以下の順序でコンテンツを検索:
   - 顧客フィールド（tblCustomer）
   - ページ（tblPage）
   - 定数（tblConstant）
   - フォーム（tblForm）
   - フォームフィールド（tblFormField）
   - テンプレート（tblTemplate）
   - フィード（tblFeed）
   - 投票（tblPoll）
   - ギャラリー（tblGallery）
   - テーマ（tblTheme）
   - カタログフィールド（tblCatalogField）
   - イントラネットメッセージ（tblCustomerIntranetMessage）
6. 検索結果をHTML形式で構築し出力
7. 結果が0件の場合はメッセージを表示

**遷移先**: 同画面（検索結果表示）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索実行 | tblCustomer | SELECT | 顧客設定の検索 |
| 検索実行 | tblPage | SELECT | ページコンテンツの検索 |
| 検索実行 | tblConstant | SELECT | 定数の検索 |
| 検索実行 | tblForm | SELECT | フォームの検索 |
| 検索実行 | tblFormField | SELECT | フォームフィールドの検索 |
| 検索実行 | tblTemplate | SELECT | テンプレートの検索 |
| 検索実行 | tblFeed | SELECT | フィードの検索 |
| 検索実行 | tblPoll | SELECT | 投票の検索 |
| 検索実行 | tblGallery | SELECT | ギャラリーの検索 |
| 検索実行 | tblTheme | SELECT | テーマの検索 |
| 検索実行 | tblCatalogField | SELECT | カタログフィールドの検索 |
| 検索実行 | tblCustomerIntranetMessage | SELECT | イントラネットメッセージの検索 |

### テーブル別更新項目詳細

本画面はデータの参照のみを行い、データの更新は行わない。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| sitesearchexpl | サイト検索の説明文 | 初期表示時 | 情報 |
| thereAre | 「検索結果は」 | 検索結果0件時 | 情報 |
| resultsForSearch | 「件です」 | 検索結果0件時 | 情報 |
| search | 「検索」 | ボタンラベル | - |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| セカンドアドミンでアクセス | bs_default.aspへリダイレクト |
| 検索キーワード未入力 | 検索処理をスキップ |
| CSRFトークン不正 | エラー処理（checkCSRF関数による） |

## 備考

- 検索は正規表現ベースで実行される
- 検索キーワードに含まれる括弧は特殊処理される（treatParentheses関数）
- 検索結果は各コンテンツタイプごとにカテゴリ分けされて表示される
- 検索結果のリンクは新しいウィンドウ/タブで開く（target='_blank'）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

全文検索機能で使用される検索クラスとパターンマッチングの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fullsearch.asp | `asp/includes/fullsearch.asp` | cls_fullSearchクラスの構造、正規表現パターンマッチングの実装 |

**読解のコツ**: cls_fullSearchクラスは複数のpublic関数（pages, constants, forms等）を持ち、それぞれが対応するテーブルを検索する。scanForPattern関数とtestPattern関数が正規表現マッチングの中核。

#### Step 2: エントリーポイントを理解する

検索画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_search.asp | `asp/bs_search.asp` | 検索フォームの処理、cls_fullSearchの利用方法 |

**主要処理フロー**:
1. **行5-6**: postbackフラグの取得とフォーム入力値の確認
2. **行7-8**: CSRF検証とフォーム入力チェック
3. **行9-11**: cls_fullSearchインスタンス化とパターン設定
4. **行12-13**: search関数の実行と結果取得
5. **行14-18**: 結果の出力またはメッセージ表示

#### Step 3: セキュリティ処理を理解する

アクセス制御とCSRF対策の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | ログイン状態確認、セカンドアドミンチェック |

**主要処理フロー**:
- **行4**: logon.currentPWとcustomer.secondAdmin.sPasswordの比較でセカンドアドミンを判定

### プログラム呼び出し階層図

```
bs_search.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess (権限チェック)
    │
    ├─ cls_fullSearch (検索処理)
    │      ├─ pages() → tblPage検索
    │      ├─ constants() → tblConstant検索
    │      ├─ forms() → tblForm検索
    │      ├─ formFields() → tblFormField検索
    │      ├─ templates() → tblTemplate検索
    │      ├─ feeds() → tblFeed検索
    │      ├─ polls() → tblPoll検索
    │      ├─ galleries() → tblGallery検索
    │      ├─ themes() → tblTheme検索
    │      ├─ catFields() → tblCatalogField検索
    │      └─ customerfields() → tblCustomer検索
    │
    └─ bs_header.asp (ヘッダー表示)
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索キーワード ───▶ treatParentheses() ───▶ 正規表現パターン
                         │
                         ▼
               cls_fullSearch.search()
                         │
    ┌────────────────────┼────────────────────┐
    │                    │                    │
    ▼                    ▼                    ▼
tblPage             tblForm            tblTemplate
    │                    │                    │
    └────────────────────┼────────────────────┘
                         │
                         ▼
                  HTML検索結果 ───▶ ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_search.asp | `asp/bs_search.asp` | ソース | 検索画面メインファイル |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | 全文検索クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダー表示処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
