# 画面設計書 22-プレビュー画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるプレビュー画面（bs_preview.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がページコンテンツを公開前にプレビュー表示するための機能を提供する。現在編集中のページの表示状態を確認するためのプレビューリンクを生成し、新しいウィンドウでフロントエンド表示を確認できる。リストページアイテムとそれ以外のページで異なるリンク構造を生成する。

**業務上の目的・背景**：コンテンツ作成時に公開前の状態を確認することは、品質管理上重要である。本画面はWYSIWYG編集後の実際の表示を確認し、デザインやレイアウトの問題を事前に発見するための機能を提供する。誤った状態でのコンテンツ公開を防止し、ユーザー体験を向上させる。

**画面へのアクセス方法**：ページ編集画面（bs_editItem.asp）、リストページ編集画面（bs_listPage.asp）、リストアイテム編集画面（bs_editListItem.asp）等のコンテンツ編集画面から「プレビュー」リンク/ボタンをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 現在のページIDに基づくプレビューURLの生成
2. リストページアイテムの場合はアンカー付きURLの生成
3. メディア管理画面へのリンク表示
4. 新しいウィンドウでのプレビュー表示

**画面遷移**：各種ページ編集画面から呼び出され、プレビューリンククリック時にフロントエンド（default.asp）が新しいウィンドウで開く。

**権限による表示制御**：secondAdmin.bSetupPageElements権限によりページブロック編集リンクの表示/非表示が制御される（現在はコメントアウト状態）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | ページプレビュー | 主機能 | 公開前のページプレビュー表示 |

## 画面種別

プレビュー（補助画面）

## URL/ルーティング

`asp/bs_preview.asp`

## 入出力項目

本画面は入力項目を持たず、ページ編集画面からのコンテキスト情報（page.iID, page.iListPageID）を使用する。

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| Mediaリンク | page.iIDが設定されている場合 | アイテムメディア管理画面へのポップアップリンク |
| プレビューリンク | page.iIDが設定されている場合 | フロントエンドプレビューへのリンク |

## イベント仕様

### 1-Mediaリンククリック

**トリガー**: Mediaリンク（bPopupFullWidthNoReloadNoOverlayClose）クリック

**処理フロー**:
1. bs_itemmedia.aspがポップアップで開く
2. ページIDがencrypt関数で暗号化されてパラメータとして渡される

**遷移先**: bs_itemmedia.asp（ポップアップ）

### 2-プレビューリンククリック

**トリガー**: プレビューリンククリック

**処理フロー**:
1. リストページアイテムの場合（page.iListPageID > 0）:
   - default.asp?iID={暗号化されたリストページID}&item={暗号化されたアイテムID}#{暗号化されたアイテムID}のURLを生成
2. 通常ページの場合:
   - default.asp?iID={暗号化されたページID}のURLを生成
3. 新しいウィンドウ/タブでフロントエンドが開く

**遷移先**: default.asp（新規ウィンドウ）

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースの更新を行わない。表示処理のみ。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースアクセスなし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| preview | プレビュー | リンクラベル | - |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| page.iIDが0または未設定 | プレビューリンクを表示しない |

## 備考

- 本画面はインクルードファイルとして他の画面から呼び出される形式
- ページIDはencrypt関数で暗号化されてURLに含まれる
- プレビューは新しいウィンドウ/タブで開く（target="_blank"）
- ページブロック編集リンクは現在コメントアウトされている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プレビュー画面で使用されるページオブジェクトの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page クラス | 関連インクルードファイル | page.iID, page.iListPageIDプロパティの理解 |

**読解のコツ**: pageオブジェクトは既にコンテキストとして存在しており、bs_preview.aspはそのプロパティを参照するのみ。

#### Step 2: エントリーポイントを理解する

プレビュー画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_preview.asp | `asp/bs_preview.asp` | 条件分岐によるリンク生成ロジック |

**主要処理フロー**:
1. **行3**: page.iIDが0以外かを確認
2. **行5**: qsmedialinkにメディア管理リンクを設定
3. **行7-8**: page.iListPageIDが0以外の場合、リストページアイテム用URLを生成
4. **行9-14**: 通常ページの場合、標準的なプレビューURLを生成
5. **行11-13**: secondAdmin.bSetupPageElements権限チェック（コメントアウト状態）

#### Step 3: ヘルパー関数を理解する

リンク生成に使用されるヘルパー関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 共通関数 | 関連インクルードファイル | getArtLink関数、encrypt関数の実装 |

**主要処理フロー**:
- getArtLink: アートスタイルのリンクHTMLを生成
- encrypt: ページIDの暗号化

### プログラム呼び出し階層図

```
呼び出し元画面（bs_editItem.asp等）
    │
    └─ bs_preview.asp (インクルード)
           │
           ├─ page オブジェクト参照
           │      ├─ page.iID
           │      └─ page.iListPageID
           │
           ├─ encrypt() 関数
           │
           ├─ getArtLink() 関数
           │
           └─ secondAdmin オブジェクト参照
                  └─ secondAdmin.bSetupPageElements
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.iID ─────────▶ 条件分岐
                         │
                         ├─ iListPageID > 0 ──▶ リストページプレビューURL
                         │                      ?iID={listPageID}&item={iID}#{iID}
                         │
                         └─ iListPageID = 0 ──▶ 通常ページプレビューURL
                                               ?iID={iID}
                         │
                         ▼
                  HTMLリンク出力 ───▶ ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_preview.asp | `asp/bs_preview.asp` | ソース | プレビューリンク生成 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | コンテンツ編集画面（呼び出し元） |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集画面（呼び出し元） |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | リストページ編集画面（呼び出し元） |
| bs_itemmedia.asp | `asp/bs_itemmedia.asp` | ソース | アイテムメディア管理画面 |
| default.asp | `default.asp` | ソース | フロントエンドエントリーポイント |
