# 画面設計書 23-フォーム一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォーム一覧画面（bs_formList.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がCMSに登録されているフォームを一覧表示し、各フォームに対する操作（編集、フィールド設定、プレビュー、データ表示、Excel出力、複製）を行うための画面である。フォーム管理の中核となる画面であり、フォームの追加、編集、データ管理へのエントリーポイントとして機能する。

**業務上の目的・背景**：Webサイトにおけるお問い合わせフォーム、アンケートフォーム等の管理は重要な業務である。本画面は、複数のフォームを効率的に管理し、フォームからの送信データを閲覧・エクスポートするための起点を提供することで、サイト運営者の業務効率を向上させる。

**画面へのアクセス方法**：バックサイトホーム（bs_default.asp）のヘッダーメニューから「フォーム」リンクをクリックしてアクセスする。フォーム管理権限（secondAdmin.bForms）が必要。

**主要な操作・処理内容**：
1. 登録済みフォームの一覧表示
2. 新規フォーム作成画面への遷移
3. フォーム編集画面への遷移
4. フォームフィールド設定画面への遷移
5. フォームプレビュー表示
6. フォーム送信データの表示・エクスポート
7. フォームの複製

**画面遷移**：バックサイトホームから遷移し、各種フォーム関連画面（bs_formEdit.asp、bs_formFields.asp、bs_formPreview.asp、bs_formExport.asp）へ遷移可能。

**権限による表示制御**：secondAdmin.bForms権限がないユーザーはアクセス不可。secondAdmin.bFormExport権限により、データ表示・Excel出力アイコンの表示/非表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | フォーム一覧 | 主機能 | 登録済みフォームの一覧表示 |
| 40 | フォーム作成・編集 | 遷移先機能 | 新規フォーム作成画面への遷移 |
| 42 | フォーム送信データ表示 | 遷移先機能 | フォーム送信データ閲覧画面への遷移 |
| 44 | フォームプレビュー | 遷移先機能 | フォームプレビュー画面への遷移 |
| 43 | フォームデータExcel出力 | 補助機能 | Excel形式でのデータエクスポート |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_formList.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | hidden/URL | - | 複製時に使用するフォームID |
| CSRFトークン | QS_secCodeURL | URL | - | 複製処理時のセキュリティトークン |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 新規フォーム作成リンク | 常時 | bs_formEdit.aspへのリンク |
| フォーム名 | フォームが存在する場合 | フォーム編集へのリンク付き |
| フィールド設定アイコン | フォームが存在する場合 | bs_formFields.aspへのアイコンリンク |
| プレビューアイコン | フォームが存在する場合 | bs_formPreview.aspへのポップアップアイコン |
| データアイコン | bFormExport権限あり | bs_formExport.aspへのポップアップアイコン |
| Excelアイコン | bFormExport権限あり | bs_formExcel.aspへのアイコン（新規ウィンドウ） |
| 複製アイコン | フォームが存在する場合 | フォーム複製処理へのアイコン |
| iID | フォームが存在する場合 | フォームの内部ID（イタリック表示） |
| フォームなしメッセージ | フォームが0件の場合 | 「フォームがありません」メッセージ |

## イベント仕様

### 1-新規フォーム作成リンククリック

**トリガー**: 「新規フォーム」リンククリック

**処理フロー**:
1. bs_formEdit.aspへ遷移（パラメータなし）
2. 新規フォーム作成モードで画面が開く

**遷移先**: bs_formEdit.asp

### 2-フォーム名クリック

**トリガー**: フォーム名リンククリック

**処理フロー**:
1. 選択したフォームのiFormIDをencrypt関数で暗号化
2. bs_formEdit.asp?iFormID={暗号化ID}へ遷移

**遷移先**: bs_formEdit.asp

### 3-フィールド設定アイコンクリック

**トリガー**: コンテナアイコンクリック

**処理フロー**:
1. 選択したフォームのiFormIDをencrypt関数で暗号化
2. bs_formFields.asp?iFormID={暗号化ID}へ遷移

**遷移先**: bs_formFields.asp

### 4-プレビューアイコンクリック

**トリガー**: 検索アイコンクリック（class="QSPP"）

**処理フロー**:
1. 選択したフォームのiFormIDをencrypt関数で暗号化
2. bs_formPreview.asp?iFormID={暗号化ID}をポップアップで開く

**遷移先**: bs_formPreview.asp（ポップアップ）

### 5-データアイコンクリック

**トリガー**: テーブルアイコンクリック（class="bPopupFullWidthNoReload"）

**処理フロー**:
1. 選択したフォームのiFormIDをencrypt関数で暗号化
2. bs_formExport.asp?iFormID={暗号化ID}をポップアップで開く

**遷移先**: bs_formExport.asp（ポップアップ）

### 6-Excelアイコンクリック

**トリガー**: Excelアイコンクリック

**処理フロー**:
1. 選択したフォームのiFormIDをencrypt関数で暗号化
2. window.openでbs_formExcel.asp?iFormID={暗号化ID}を新規ウィンドウで開く
3. Excel形式でデータがダウンロードされる

**遷移先**: bs_formExcel.asp（新規ウィンドウ）

### 7-複製アイコンクリック

**トリガー**: コピーアイコンクリック

**処理フロー**:
1. JavaScript確認ダイアログ表示（「コピーしますか？」）
2. 確認後、同画面にCSRFトークンとiFormIDを付加してアクセス
3. cls_formクラスのcopy関数が実行される
4. フォームとそのフィールドが複製される
5. 画面がリロードされ、複製されたフォームが一覧に追加される

**遷移先**: bs_formList.asp（リロード）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | 顧客のフォーム一覧取得 |
| フォーム複製 | tblForm | INSERT | 新規フォームレコード作成 |
| フォーム複製 | tblFormField | INSERT | フォームフィールドの複製 |

### テーブル別更新項目詳細

#### tblForm（フォーム複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sName | "コピー " + 元のフォーム名 | 複製元の名前にプレフィックス付加 |
| INSERT | その他全カラム | 複製元の値をコピー | iCustomerIDは現在の顧客ID |
| INSERT | dCreatedTS | now() | 作成日時 |
| INSERT | dUpdatedTS | now() | 更新日時 |

#### tblFormField（フォーム複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iFormID | 新規作成されたフォームID | 複製先フォームとの紐付け |
| INSERT | その他全カラム | 複製元の値をコピー | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| newform | 新規フォーム | 常時 | リンクラベル |
| specifyfields | フィールド設定 | アイコンalt | ツールチップ |
| preview | プレビュー | アイコンalt | ツールチップ |
| copyItem | コピー | アイコンalt | ツールチップ |
| areyousuretocopy | コピーしますか？ | 複製時 | 確認 |
| noforms | フォームがありません | フォーム0件時 | 情報 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bForms権限なし | アクセス拒否（logon.hasaccess） |
| フォームが存在しない | 「フォームがありません」メッセージ表示 |

## 備考

- フォーム一覧はcustomer.formsディクショナリから取得される
- 複製機能はcls_formクラスのcopy()メソッドで実装
- フォームIDはencrypt関数で暗号化されてURLに含まれる
- データエクスポート機能はsecondAdmin.bFormExport権限で制御される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォーム管理で使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスの構造、copy()メソッドの実装 |

**読解のコツ**: cls_formクラスはフォームのCRUD操作を担当。copy()メソッド（行839-851）がフォーム複製のコア処理。

#### Step 2: エントリーポイントを理解する

フォーム一覧画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formList.asp | `asp/bs_formList.asp` | フォーム一覧の取得と表示ロジック |

**主要処理フロー**:
1. **行4**: secondAdmin.bForms権限チェック
2. **行5-6**: cls_formインスタンス化とcopy()呼び出し（複製処理）
3. **行7-8**: customer.formsからフォーム一覧取得
4. **行8-9**: formsディクショナリをループして表示

#### Step 3: ヘルパー関数を理解する

アイコン生成に使用されるヘルパー関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 共通関数 | 関連インクルードファイル | getIcon関数、getIconPP関数、encrypt関数 |

**主要処理フロー**:
- getIcon: 通常アイコンリンクの生成
- getIconPP: ポップアップ付きアイコンリンクの生成
- encrypt: フォームIDの暗号化

### プログラム呼び出し階層図

```
bs_formList.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bForms)
    │
    ├─ cls_form (フォーム処理)
    │      └─ copy() (複製処理)
    │             ├─ fields() - フィールド取得
    │             ├─ save() - フォーム保存
    │             └─ cls_formField.copy() - フィールド複製
    │
    ├─ customer.forms (フォーム一覧取得)
    │
    ├─ getIcon() / getIconPP() (アイコン生成)
    │
    └─ encrypt() (ID暗号化)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ 複製処理判定
(iFormID)              │
                       ├─ 複製要求あり ───▶ cls_form.copy()
                       │                        │
                       │                        ▼
                       │                  tblForm INSERT
                       │                  tblFormField INSERT
                       │
                       └─ 一覧表示 ───▶ customer.forms取得
                                              │
                                              ▼
                                        HTMLテーブル出力 ───▶ ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス定義 |
| bs_formEdit.asp | `asp/bs_formEdit.asp` | ソース | フォーム編集画面（遷移先） |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド一覧画面（遷移先） |
| bs_formPreview.asp | `asp/bs_formPreview.asp` | ソース | フォームプレビュー画面（遷移先） |
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | フォームデータエクスポート画面（遷移先） |
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | Excel出力処理（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
