# 画面設計書 24-フォーム編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォーム編集画面（bs_formEdit.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がフォームの新規作成および既存フォームの編集を行うための画面である。フォームの基本情報（名前、イントロダクション、ボタンラベル）、レイアウト設定、送信後の動作（フィードバックメッセージ、リダイレクト）、メール送信設定、自動応答メール設定など、フォームに関する全ての設定を管理する。

**業務上の目的・背景**：お問い合わせフォームやアンケートなどのWebフォームを柔軟にカスタマイズできることは、サイト運営において重要である。本画面は、フォームの外観、動作、メール通知などを一元的に設定できる機能を提供し、コーディング不要でフォームを構築・管理することを可能にする。

**画面へのアクセス方法**：フォーム一覧画面（bs_formList.asp）から「新規フォーム」リンクまたは既存フォーム名をクリックしてアクセスする。フォーム管理権限（secondAdmin.bForms）が必要。

**主要な操作・処理内容**：
1. フォームの基本情報入力（名前、イントロ、ボタンラベル等）
2. 質問と回答のレイアウト設定（左右配置、上下配置）
3. Cookie保存オプションの設定
4. CAPTCHA認証の有効化設定
5. フィードバックメッセージまたはリダイレクトURLの設定
6. 自動応答メール設定（件名、本文、差出人等）
7. メール送信設定（宛先、件名、添付ファイル含む設定）
8. フォームの保存・削除

**画面遷移**：フォーム一覧画面から遷移し、新規フォーム保存後はフォームフィールド一覧画面（bs_formFields.asp）へ、編集後はフォーム一覧画面へリダイレクトする。

**権限による表示制御**：secondAdmin.bForms権限がないユーザーはアクセス不可。customer.bApplication権限がある場合のみ「送信時スクリプト」設定項目が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | フォーム作成・編集 | 主機能 | フォームの作成・設定・自動応答設定 |
| 117 | CSRF対策 | 補助機能 | フォーム送信時のCSRF対策 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_formEdit.asp`

## 入出力項目

### 基本設定

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| フォームID | iFormID | hidden | - | - | - | 編集対象フォームの暗号化ID |
| フォーム名 | sName | テキスト | 必須 | 250 | 空白不可 | フォームの識別名 |
| イントロダクション | sIntro | テキストエリア | - | - | - | フォーム上部に表示するHTML |
| 送信ボタンラベル | sButton | テキスト | 必須 | 255 | 空白不可 | 送信ボタンの表示テキスト |
| リセットボタンラベル | sReset | テキスト | - | 255 | - | リセットボタンの表示テキスト（空白でボタン非表示） |
| Q&A配置 | sQAalign | ラジオ | 必須 | - | - | 質問と回答の配置（左右/上下/右左） |
| Cookie保存 | bCookie | チェック | - | - | - | 入力値をCookieに保存するか |
| CAPTCHA | bCaptcha | チェック | - | - | - | CAPTCHA認証を使用するか |

### 送信後動作設定

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| フィードバックメッセージ | sFeedback | テキストエリア | 条件付 | - | リダイレクトと排他 | 送信後に表示するメッセージHTML |
| リダイレクトプレフィックス | sRedirectPrefix | セレクト | - | - | - | http://またはhttps:// |
| リダイレクトURL | sRedirect | テキスト | 条件付 | 255 | フィードバックと排他 | 送信後のリダイレクト先URL |

### 自動応答設定

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| 自動応答有効 | bAutoResponder | チェック | - | - | - | 自動応答メールを送信するか |
| 件名 | sAutoResponseSubject | テキスト | 条件付 | 255 | 自動応答有効時必須 | 自動応答メールの件名 |
| 差出人名 | sAutoResponseFromName | テキスト | 条件付 | 255 | 自動応答有効時必須 | 差出人表示名 |
| 差出人メール | sAutoResponseFromEmail | テキスト | 条件付 | 255 | メール形式 | 差出人メールアドレス |
| 本文 | sAutoResponse | テキストエリア | 条件付 | - | 自動応答有効時必須 | 自動応答メール本文 |

### メール送信設定

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| メール送信有効 | bSendEmail | チェック | - | - | - | 管理者へメール送信するか |
| 件名 | sSubject | テキスト | 条件付 | 255 | メール送信有効時必須 | メールの件名 |
| 本文（管理者向け） | sAutoResponseWebmaster | テキストエリア | - | - | - | メール本文のヘッダー部分 |
| 宛先 | sTo | テキストエリア | 条件付 | - | メール形式（複数行） | 送信先メールアドレス（改行区切り） |
| 添付ファイル含む | bAttachFiles | チェック | - | - | - | 添付ファイルをメールに含むか |

### 高度な設定

| 項目名 | 項目ID | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|--------|-----|------|--------|----------------|------|
| 送信時スクリプト | sScriptUponSubmission | テキストエリア | - | - | - | 送信時に実行するASP/VBScript |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 基本設定セクション | 常時 | フォーム名、ボタンラベル等 |
| 自動応答設定セクション | bAutoResponder=true | 自動応答メール設定項目群 |
| メール送信設定セクション | bSendEmail=true | メール送信設定項目群 |
| 送信時スクリプト | customer.bApplication=true | カスタムスクリプト入力欄 |
| 削除ボタン | iIDが数値の場合 | 既存フォームの削除用 |
| [QS_COPYSUBMISSION]ヒント | 常時 | 送信内容コピー用プレースホルダーの説明 |

## イベント仕様

### 1-保存ボタン押下

**トリガー**: 保存ボタン（btnaction=l("save")）クリック

**処理フロー**:
1. CSRFトークン検証（checkCSRF）
2. フォーム入力値の取得（form.getRequestValues）
3. 新規フォームか判定（isLeeg(form.iId)）
4. バリデーション実行（form.check）
   - フォーム名必須チェック
   - ボタンラベル必須チェック
   - Q&A配置必須チェック
   - フィードバックとリダイレクトの排他チェック
   - 自動応答有効時の必須項目チェック
   - メール送信有効時の必須項目チェック
   - メールアドレス形式チェック
5. フォーム保存（form.save）
6. 新規の場合: bs_formfields.asp?iFormID={暗号化ID}へリダイレクト
7. 編集の場合: bs_formList.aspへリダイレクト

**遷移先**: bs_formfields.asp（新規）/ bs_formList.asp（編集）

### 2-削除ボタン押下

**トリガー**: 削除ボタン（btnaction=l("delete")）クリック

**処理フロー**:
1. JavaScript確認ダイアログ表示
2. 確認後、CSRFトークン検証（checkCSRF）
3. フォーム削除処理（form.remove）
   - 関連するsubmissionsの削除
   - 関連するfieldsの削除
   - tblPageのiFormIDをnullに更新
   - tblCatalogのiFormIDをnullに更新
   - tblFormからレコード削除
4. bs_formList.aspへリダイレクト

**遷移先**: bs_formList.asp

### 3-自動応答チェックボックス変更

**トリガー**: bAutoResponderチェックボックスのonclick

**処理フロー**:
1. document.mainform.submit()でフォーム自動送信
2. 画面がリロードされ、自動応答設定項目が表示/非表示切替

**遷移先**: 同画面（リロード）

### 4-メール送信チェックボックス変更

**トリガー**: bSendEmailチェックボックスのonclick

**処理フロー**:
1. document.mainform.submit()でフォーム自動送信
2. 画面がリロードされ、メール送信設定項目が表示/非表示切替

**遷移先**: 同画面（リロード）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblForm | INSERT | 新規フォームレコード作成 |
| 編集保存 | tblForm | UPDATE | 既存フォームレコード更新 |
| 削除 | tblFormFieldValue | DELETE | 送信値の削除 |
| 削除 | tblFormSubmission | DELETE | 送信レコードの削除 |
| 削除 | tblFormField | DELETE | フィールドの削除 |
| 削除 | tblPage | UPDATE | ページのフォーム参照解除 |
| 削除 | tblCatalog | UPDATE | カタログのフォーム参照解除 |
| 削除 | tblForm | DELETE | フォームレコード削除 |

### テーブル別更新項目詳細

#### tblForm（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | 最大255文字 |
| INSERT/UPDATE | sComment | フォーム入力値 | |
| INSERT/UPDATE | sCode | フォーム入力値 | |
| INSERT/UPDATE | sIntro | フォーム入力値 | |
| INSERT/UPDATE | sFeedback | フォーム入力値 | |
| INSERT/UPDATE | sTo | フォーム入力値 | |
| INSERT/UPDATE | sSubject | フォーム入力値 | |
| INSERT/UPDATE | sRedirect | フォーム入力値 | http://,https://除去 |
| INSERT/UPDATE | sRedirectPrefix | フォーム入力値 | |
| INSERT/UPDATE | sButton | フォーム入力値 | |
| INSERT/UPDATE | sReset | フォーム入力値 | |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| INSERT | dCreatedTS | now() | 作成日時（新規のみ） |
| INSERT/UPDATE | bSendEmail | フォーム入力値 | |
| INSERT/UPDATE | bCookie | フォーム入力値 | |
| INSERT/UPDATE | bAttachFiles | フォーム入力値 | |
| INSERT/UPDATE | bCaptcha | フォーム入力値 | |
| INSERT/UPDATE | sQAalign | フォーム入力値 | |
| INSERT/UPDATE | sAutoResponse | フォーム入力値 | |
| INSERT/UPDATE | bAutoResponder | フォーム入力値 | |
| INSERT/UPDATE | sAutoResponseSubject | フォーム入力値 | |
| INSERT/UPDATE | sAutoResponseFromName | フォーム入力値 | |
| INSERT/UPDATE | sAutoResponseFromEmail | フォーム入力値 | |
| INSERT/UPDATE | sScriptUponSubmission | フォーム入力値 | |
| INSERT/UPDATE | sAutoResponseWebmaster | フォーム入力値 | |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| general | 一般 | セクションヘッダー | - |
| name | 名前 | ラベル | - |
| introform | イントロ | ラベル | - |
| buttonsend | 送信ボタン | ラベル | - |
| buttonreset | リセットボタン | ラベル | - |
| formqaalign | Q&A配置 | ラベル | - |
| qleftaright | 質問左・回答右 | ラジオ選択肢 | - |
| QtopAbottom | 質問上・回答下 | ラジオ選択肢 | - |
| qrightaleft | 質問右・回答左 | ラジオ選択肢 | - |
| setcookie | Cookie保存 | ラベル | - |
| verifyhumanity | CAPTCHA認証 | ラベル | - |
| feedbackform | フィードバック | ラベル | - |
| redirecttourl | リダイレクトURL | ラベル | - |
| useautoresponse | 自動応答使用 | ラベル | - |
| settingsautoresponse | 自動応答設定 | セクションヘッダー | 自動応答有効時 |
| sendemail | メール送信 | ラベル | - |
| emailsettings | メール設定 | セクションヘッダー | メール送信有効時 |
| subject | 件名 | ラベル | - |
| fromname | 差出人名 | ラベル | - |
| fromemail | 差出人メール | ラベル | - |
| autoresponse | 自動応答本文 | ラベル | - |
| receiver | 宛先 | ラベル | - |
| enterseplist | 改行区切りで入力 | ヒント | - |
| includeattachments | 添付ファイル含む | ラベル | - |
| mandatory | 必須 | ラベル/エラー | - |
| save | 保存 | ボタン | - |
| delete | 削除 | ボタン | - |
| areyousure | 本当に削除しますか？ | 確認 | - |
| leaveblankifnotneeded | 不要な場合は空白 | ヒント | - |
| scriptuponsubmission | 送信時スクリプト | ラベル | customer.bApplication時 |
| err_mandatory | 必須項目が入力されていません | バリデーションエラー | エラー |
| err_reg_or_fb | フィードバックまたはリダイレクトのどちらかを指定 | バリデーションエラー | エラー |
| err_email | メールアドレスの形式が正しくありません | バリデーションエラー | エラー |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bForms権限なし | アクセス拒否（logon.hasaccess） |
| 他顧客のフォーム編集試行 | Response.End（アクセス拒否） |
| バリデーションエラー | エラーメッセージ表示、画面再表示 |
| CSRFトークン不正 | エラー処理（checkCSRF関数） |

## 備考

- フィードバックメッセージとリダイレクトURLは排他的（どちらか一方のみ設定可能）
- 自動応答メールに[QS_COPYSUBMISSION]プレースホルダーを使用すると送信内容のコピーを含められる
- メール送信設定の宛先は改行区切りで複数指定可能
- リダイレクトURLからhttp://、https://は自動除去される
- customer.bApplication権限がある場合のみ送信時スクリプト実行機能が使用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォーム編集で使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスのプロパティ、save()、check()、remove()メソッド |

**読解のコツ**: cls_formクラスは全てのフォームプロパティを保持し、CRUD操作を担当。check()メソッド（行64-130）がバリデーションロジックの中核。

#### Step 2: エントリーポイントを理解する

フォーム編集画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formEdit.asp | `asp/bs_formEdit.asp` | フォーム取得、保存、削除の処理フロー |

**主要処理フロー**:
1. **行4-10**: cls_formインスタンス化とpostback判定
2. **行11-13**: 他顧客フォームへのアクセス防止
3. **行14-31**: btnactionによる処理分岐（保存/削除）
4. **行32-45**: フォーム入力フィールドのHTML生成

#### Step 3: バリデーションを理解する

フォーム入力値の検証ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp check関数 | `asp/includes/form.asp` | バリデーションルール（行64-130） |

**主要処理フロー**:
- **行66-77**: 必須項目チェック（sName, sButton, sQAalign）
- **行78-81**: フィードバックとリダイレクトの排他チェック
- **行82-108**: 自動応答設定の条件付き必須チェック
- **行109-129**: メール送信設定の条件付き必須チェック

### プログラム呼び出し階層図

```
bs_formEdit.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bForms)
    │
    ├─ cls_form (フォーム処理)
    │      ├─ pick() - フォーム取得
    │      ├─ getRequestValues() - 入力値取得
    │      ├─ check() - バリデーション
    │      │      ├─ isLeeg() - 空白チェック
    │      │      └─ CheckEmailSyntax() - メール形式チェック
    │      ├─ save() - 保存処理
    │      │      └─ db.GetDynamicRS - DB操作
    │      └─ remove() - 削除処理
    │             ├─ submissions削除
    │             ├─ fields削除
    │             └─ tblForm削除
    │
    └─ cls_urlTypeShortList (URLプレフィックス)
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ getRequestValues()
                         │
                         ▼
                     check()
                         │
              ┌──────────┼──────────┐
              │          │          │
              ▼          ▼          ▼
         エラーあり   保存処理   削除処理
              │          │          │
              │          ▼          ▼
              │      save()    remove()
              │          │          │
              │          ▼          ▼
              │     tblForm     tblForm
              │     INSERT/     DELETE
              │     UPDATE
              │          │          │
              ▼          ▼          ▼
         画面再表示   リダイレクト   リダイレクト
                   bs_formfields   bs_formList
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formEdit.asp | `asp/bs_formEdit.asp` | ソース | フォーム編集画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス定義 |
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧画面（遷移元/先） |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド一覧画面（遷移先） |
| bs_backForm.asp | `asp/bs_backForm.asp` | ソース | 戻るリンク表示 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
