# 画面設計書 25-フォームフィールド一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォームフィールド一覧画面（bs_formFields.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がフォームに含まれる入力フィールド（質問項目）を一覧表示し、フィールドの追加、編集、並び順変更を行うための画面である。フォーム構築における中核的な画面であり、フォームの入力項目定義を管理する。

**業務上の目的・背景**：フォームの入力項目（名前、メールアドレス、お問い合わせ内容等）を柔軟に追加・編集できることは、多様なフォーム要件に対応する上で重要である。本画面は、フィールドの種類、必須設定、表示順序などを一元的に管理し、コーディング不要でフォーム項目を構築できる機能を提供する。

**画面へのアクセス方法**：フォーム一覧画面（bs_formList.asp）のフィールド設定アイコンをクリック、または新規フォーム作成後にリダイレクトされてアクセスする。フォーム管理権限（secondAdmin.bForms）が必要。

**主要な操作・処理内容**：
1. フォームフィールドの一覧表示（名前、種類、必須、順序）
2. 新規フィールド追加画面への遷移
3. フィールド編集画面への遷移
4. フィールドの並び順変更（上へ/下へ移動）
5. フォームプレビュー表示

**画面遷移**：フォーム一覧画面から遷移し、フォームフィールド編集画面（bs_FormFieldEdit.asp）、フォームプレビュー画面（bs_formPreview.asp）へ遷移可能。

**権限による表示制御**：secondAdmin.bForms権限がないユーザーはアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | フォームフィールド管理 | 主機能 | フォーム入力項目の一覧表示・並び替え |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_formFields.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | URL/hidden | 必須 | 対象フォームの暗号化ID |
| フォームフィールドID | iFormFieldID | URL | - | 並び替え対象フィールドの暗号化ID |
| アクション | btnaction | URL | - | MoveUP/MoveDOWN |
| CSRFトークン | QS_secCodeURL | URL | - | セキュリティトークン |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| フォーム名 | 常時 | 対象フォームの名前（太字） |
| 新規フィールドリンク | 常時 | bs_FormFieldEdit.aspへのリンク |
| プレビューアイコン | 常時 | bs_formPreview.aspへのポップアップアイコン |
| フィールド一覧テーブル | フィールドが存在する場合 | 以下の列を含むテーブル |
| - 名前 | フィールドが存在する場合 | フィールド編集へのリンク付き |
| - 種類 | フィールドが存在する場合 | フィールドタイプの表示名 |
| - 必須 | フィールドが存在する場合 | 必須マーク（*等） |
| - 順序 | フィールドが存在する場合 | 表示順序番号 |
| - iId | フィールドが存在する場合 | フィールドの内部ID |
| - 上下移動アイコン | フィールドが存在する場合 | 並び順変更用アイコン |

## イベント仕様

### 1-新規フィールドリンククリック

**トリガー**: 「新規フィールド」リンククリック

**処理フロー**:
1. bs_formFieldEdit.asp?iFormID={暗号化ID}へ遷移
2. 新規フィールド作成モードで画面が開く

**遷移先**: bs_FormFieldEdit.asp

### 2-フィールド名クリック

**トリガー**: フィールド名リンククリック

**処理フロー**:
1. 選択したフィールドのiFormFieldIDをencrypt関数で暗号化
2. bs_formFieldEdit.asp?iFormFieldID={暗号化ID}へ遷移

**遷移先**: bs_FormFieldEdit.asp

### 3-上へ移動アイコンクリック

**トリガー**: 上矢印アイコン（MoveUP）クリック

**処理フロー**:
1. CSRFトークン検証（checkCSRF）
2. cls_FormFieldクラスのmoveUp()メソッド実行
3. フィールドの順序を1つ上に移動
4. 画面がリロードされ、更新された順序で表示

**遷移先**: bs_formFields.asp（リロード）

### 4-下へ移動アイコンクリック

**トリガー**: 下矢印アイコン（MoveDOWN）クリック

**処理フロー**:
1. CSRFトークン検証（checkCSRF）
2. cls_FormFieldクラスのmoveDown()メソッド実行
3. フィールドの順序を1つ下に移動
4. 画面がリロードされ、更新された順序で表示

**遷移先**: bs_formFields.asp（リロード）

### 5-プレビューアイコンクリック

**トリガー**: 検索アイコン（class="QSPP"）クリック

**処理フロー**:
1. bs_formPreview.asp?iFormID={暗号化ID}をポップアップで開く

**遷移先**: bs_formPreview.asp（ポップアップ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | フォーム情報取得 |
| 画面表示 | tblFormField | SELECT | フィールド一覧取得 |
| 上へ移動 | tblFormField | UPDATE | 対象フィールドのiRangを減少、入れ替え先のiRangを増加 |
| 下へ移動 | tblFormField | UPDATE | 対象フィールドのiRangを増加、入れ替え先のiRangを減少 |

### テーブル別更新項目詳細

#### tblFormField（並び順変更時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iRang | 現在値 - 1（MoveUP）/ 現在値 + 1（MoveDOWN） | 対象フィールド |
| UPDATE | iRang | 現在値 + 1（MoveUP）/ 現在値 - 1（MoveDOWN） | 入れ替え先フィールド |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| newfield | 新規フィールド | 常時 | リンクラベル |
| preview | プレビュー | アイコンalt | ツールチップ |
| name | 名前 | テーブルヘッダー | - |
| type | 種類 | テーブルヘッダー | - |
| mandatory | 必須 | テーブルヘッダー | - |
| order | 順序 | テーブルヘッダー | - |
| up | 上へ | アイコンalt | ツールチップ |
| down | 下へ | アイコンalt | ツールチップ |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bForms権限なし | アクセス拒否（logon.hasaccess） |
| フィールドが存在しない | テーブルを表示しない |
| CSRFトークン不正 | エラー処理（checkCSRF関数） |

## 備考

- フィールド一覧はform.fieldsディクショナリから取得される（iRang昇順でソート済み）
- フィールド種類の表示名はcls_formFieldTypeListクラスで定義される
- テーブルにはclass="sortable"が設定されており、JavaScriptによるソートが可能
- フィールドIDはencrypt関数で暗号化されてURLに含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームフィールド管理で使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | フィールドタイプ定数と表示名の対応 |
| 1-2 | form.asp fields関数 | `asp/includes/form.asp` | form.fields()の実装（行233-249） |

**読解のコツ**: formFieldTypeList.aspでsb_ff_*定数が定義されており、各フィールドタイプの内部コードを理解することが重要。

#### Step 2: エントリーポイントを理解する

フォームフィールド一覧画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formFields.asp | `asp/bs_formFields.asp` | フィールド一覧の取得と表示、並び順変更処理 |

**主要処理フロー**:
1. **行4-5**: cls_FormFieldインスタンス化
2. **行6-13**: btnactionによる処理分岐（MoveUP/MoveDOWN）
3. **行14-17**: cls_form、fieldsの取得
4. **行18-19**: フィールド一覧のループ表示

#### Step 3: 並び順変更処理を理解する

moveUp/moveDownメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cls_FormField | 関連インクルードファイル | moveUp(), moveDown()の実装 |

**主要処理フロー**:
- moveUp: 現在のiRangより1小さいフィールドとiRangを入れ替え
- moveDown: 現在のiRangより1大きいフィールドとiRangを入れ替え

### プログラム呼び出し階層図

```
bs_formFields.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bForms)
    │
    ├─ cls_FormField (フィールド処理)
    │      ├─ pick() - フィールド取得
    │      ├─ moveUp() - 上へ移動
    │      └─ moveDown() - 下へ移動
    │
    ├─ cls_form (フォーム処理)
    │      └─ fields() - フィールド一覧取得
    │             └─ cls_formField.pick() - 各フィールド取得
    │
    ├─ cls_formFieldTypeList (フィールドタイプ)
    │      └─ showSelected() - タイプ表示名取得
    │
    └─ getIcon() / getIconPP() (アイコン生成)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ btnaction判定
(btnaction)            │
                       ├─ MoveUP ───▶ ff.moveUp()
                       │                   │
                       │                   ▼
                       │             tblFormField UPDATE
                       │
                       ├─ MoveDOWN ───▶ ff.moveDown()
                       │                   │
                       │                   ▼
                       │             tblFormField UPDATE
                       │
                       └─ 一覧表示 ───▶ form.fields()
                                              │
                                              ▼
                                        HTMLテーブル出力 ───▶ ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド一覧画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス定義、fields()メソッド |
| formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | ソース | フィールドタイプ定数・表示名定義 |
| bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | ソース | フォームフィールド編集画面（遷移先） |
| bs_formPreview.asp | `asp/bs_formPreview.asp` | ソース | フォームプレビュー画面（遷移先） |
| bs_backForm.asp | `asp/bs_backForm.asp` | ソース | 戻るリンク表示 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
