# 画面設計書 26-フォームフィールド編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォームフィールド編集画面（bs_FormFieldEdit.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がフォームの入力フィールド（質問項目）を新規作成および編集するための画面である。フィールドの種類（テキスト、テキストエリア、チェックボックス、セレクト等）に応じて動的に設定項目が変化し、各フィールドタイプに固有のオプション（サイズ、最大長、選択肢等）を設定できる。

**業務上の目的・背景**：フォームの入力項目は、項目ごとに異なる設定（テキストならサイズと最大長、セレクトなら選択肢、ファイルなら許可拡張子等）が必要である。本画面は、フィールドタイプに応じた適切な設定項目を動的に表示し、ノーコードで多様なフォーム項目を構築できる機能を提供する。

**画面へのアクセス方法**：フォームフィールド一覧画面（bs_formFields.asp）から「新規フィールド」リンクまたは既存フィールド名をクリックしてアクセスする。フォーム管理権限（secondAdmin.bForms）が必要。

**主要な操作・処理内容**：
1. フィールドの基本情報入力（名前、プレースホルダー、順序）
2. フィールドタイプの選択と変更
3. タイプ固有設定の入力（サイズ、行数、選択肢、ファイル設定等）
4. 必須設定の指定
5. メール関連設定（自動応答送信先、送信者メールとして使用）
6. フィールドの保存・削除

**画面遷移**：フォームフィールド一覧画面から遷移し、保存後はフォームフィールド一覧画面へリダイレクトする。

**権限による表示制御**：secondAdmin.bForms権限がないユーザーはアクセス不可。customer.bApplication権限がある場合のみ「隠しフィールド」タイプが選択可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | フォームフィールド管理 | 主機能 | フォームフィールドの詳細設定 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_FormFieldEdit.asp`

## 入出力項目

### 基本設定（全フィールドタイプ共通）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 表示条件 | 説明 |
|--------|--------|-----|------|--------|----------|------|
| フォームフィールドID | iFormFieldID | hidden | - | - | 常時 | 編集対象フィールドの暗号化ID |
| フォームID | iFormID | hidden | 必須 | - | 常時 | 所属フォームの暗号化ID |
| フォーム名 | - | 表示のみ | - | - | 常時 | 所属フォーム名（編集不可） |
| フィールド名 | sName | テキスト | 必須 | 255 | 常時 | フィールドのラベル名 |
| プレースホルダー | sPlaceholder | テキスト | - | - | text/url/email/textarea | 入力欄のヒントテキスト |
| 表示順序 | iRang | セレクト | 必須 | - | 常時 | フォーム内での表示順 |
| フィールドタイプ | sType | セレクト | 必須 | - | 常時 | フィールドの種類 |

### タイプ別設定

#### テキスト/URL/メール（sb_ff_text, sb_ff_url, sb_ff_email）

| 項目名 | 項目ID | 型 | 必須 | 範囲 | 説明 |
|--------|--------|-----|------|------|------|
| サイズ | iSize | セレクト | - | 2-100 | 入力欄の表示幅 |
| 最大長 | iMaxlength | セレクト | - | 1-1024 | 入力可能文字数 |

#### テキストエリア（sb_ff_textarea）

| 項目名 | 項目ID | 型 | 必須 | 範囲 | 説明 |
|--------|--------|-----|------|------|------|
| 列数 | iCols | セレクト | - | 10-100 | 表示列数 |
| 行数 | iRows | セレクト | - | 2-50 | 表示行数 |
| 最大長 | iMaxlength | セレクト | - | 0-2500（50刻み） | 入力可能文字数（0=無制限） |

#### セレクト/ラジオ（sb_ff_select, sb_ff_radio）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 選択肢 | sValues | テキストエリア | 必須 | 改行区切りの選択肢リスト |
| 複数選択許可 | bAllowMS | チェック | - | ラジオのみ、複数選択を許可 |
| 配置 | sRadioPlacement | セレクト | - | ラジオのみ、縦/横配置 |

#### ファイル/画像（sb_ff_file, sb_ff_image）

| 項目名 | 項目ID | 型 | 必須 | 範囲 | 説明 |
|--------|--------|-----|------|------|------|
| 保存フォルダ | sFileLocation | テキスト | - | 255 | カスタム保存先パス |
| 許可拡張子 | sAllowedExtensions | テキスト | - | 255 | ファイルのみ、許可する拡張子 |
| 最大サイズ | iMaxFileSize | セレクト | - | 16-4096 | アップロード上限（kB） |

#### コメント（sb_ff_comment）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| コメント内容 | sValues | リッチテキスト | 必須 | フォームに表示する説明文（HTML） |

#### 隠しフィールド（sb_ff_hidden）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| デフォルト値 | sValues | テキスト | - | 隠しフィールドの値 |

### メール関連設定（メールタイプ専用）

| 項目名 | 項目ID | 型 | 必須 | 表示条件 | 説明 |
|--------|--------|-----|------|----------|------|
| 自動応答有効 | bAutoResponder | チェック | - | form.bAutoResponder | この項目を自動応答の送信先に使用 |
| 送信者メール使用 | bUseForSending | チェック | - | form.bSendEmail | この項目を管理者メールの送信者に使用 |

### 必須設定

| 項目名 | 項目ID | 型 | 必須 | 表示条件 | 説明 |
|--------|--------|-----|------|----------|------|
| 必須 | bMandatory | チェック | - | comment/hidden以外 | 入力必須とするか |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 基本設定セクション | 常時 | 名前、順序、タイプ |
| プレースホルダー | text/url/email/textarea | ヒントテキスト入力欄 |
| サイズ/最大長 | text/url/email | 入力欄サイズ設定 |
| 列数/行数/最大長 | textarea | テキストエリアサイズ設定 |
| 選択肢 | select/radio | 選択肢入力欄 |
| 複数選択許可 | radio | 複数選択オプション |
| 配置 | radio | 縦横配置オプション |
| 保存フォルダ/許可拡張子/最大サイズ | file/image | ファイルアップロード設定 |
| コメント内容 | comment | リッチテキストエディタ |
| デフォルト値 | hidden | 隠しフィールド値 |
| 自動応答有効 | email & form.bAutoResponder | 自動応答設定 |
| 送信者メール使用 | email & form.bSendEmail | 送信者設定 |
| 必須 | comment/hidden以外 | 必須チェック |
| 削除ボタン | iIDが数値の場合 | 既存フィールドの削除用 |

## イベント仕様

### 1-保存ボタン押下

**トリガー**: 保存ボタン（btnaction=l("save")）クリック

**処理フロー**:
1. CSRFトークン検証（checkCSRF）
2. フォーム入力値の取得（FormField.getRequestValues）
3. バリデーション実行（FormField.check）
4. フィールド保存（FormField.save）
5. bs_formFields.asp?iFormID={暗号化ID}へリダイレクト

**遷移先**: bs_formFields.asp

### 2-削除ボタン押下

**トリガー**: 削除ボタン（btnaction=l("delete")）クリック

**処理フロー**:
1. JavaScript確認ダイアログ表示
2. 確認後、CSRFトークン検証（checkCSRF）
3. フィールド削除処理（FormField.remove）
   - tblFormFieldValueから関連値を削除
   - tblFormFieldからレコード削除
4. bs_formFields.asp?iFormID={暗号化ID}へリダイレクト

**遷移先**: bs_formFields.asp

### 3-フィールドタイプ変更

**トリガー**: sTypeセレクトボックスのonchange

**処理フロー**:
1. document.mainform.submit()でフォーム自動送信
2. 画面がリロードされ、選択されたタイプに応じた設定項目が表示

**遷移先**: 同画面（リロード）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblFormField | INSERT | 新規フィールドレコード作成 |
| 編集保存 | tblFormField | UPDATE | 既存フィールドレコード更新 |
| 削除 | tblFormFieldValue | DELETE | 関連する送信値の削除 |
| 削除 | tblFormField | DELETE | フィールドレコード削除 |

### テーブル別更新項目詳細

#### tblFormField（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | iFormID | フォームID | 所属フォーム |
| INSERT/UPDATE | sName | フォーム入力値 | フィールド名 |
| INSERT/UPDATE | sPlaceholder | フォーム入力値 | ヒントテキスト |
| INSERT/UPDATE | iRang | フォーム入力値 | 表示順序 |
| INSERT/UPDATE | sType | フォーム入力値 | フィールドタイプコード |
| INSERT/UPDATE | iSize | フォーム入力値 | 表示サイズ |
| INSERT/UPDATE | iCols | フォーム入力値 | テキストエリア列数 |
| INSERT/UPDATE | iRows | フォーム入力値 | テキストエリア行数 |
| INSERT/UPDATE | iMaxlength | フォーム入力値 | 最大文字数 |
| INSERT/UPDATE | sValues | フォーム入力値 | 選択肢/コメント/デフォルト値 |
| INSERT/UPDATE | bAllowMS | フォーム入力値 | 複数選択許可 |
| INSERT/UPDATE | sRadioPlacement | フォーム入力値 | ラジオ配置 |
| INSERT/UPDATE | sFileLocation | フォーム入力値 | ファイル保存先 |
| INSERT/UPDATE | sAllowedExtensions | フォーム入力値 | 許可拡張子 |
| INSERT/UPDATE | iMaxFileSize | フォーム入力値 | 最大ファイルサイズ |
| INSERT/UPDATE | bMandatory | フォーム入力値 | 必須フラグ |
| INSERT/UPDATE | bAutoResponder | フォーム入力値 | 自動応答使用 |
| INSERT/UPDATE | bUseForSending | フォーム入力値 | 送信者メール使用 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| general | 一般 | セクションヘッダー | - |
| form | フォーム | ラベル | - |
| name | 名前 | ラベル | - |
| sortorder | 表示順序 | ラベル | - |
| type | タイプ | ラベル | - |
| defaultvalue | デフォルト値 | ラベル | hidden時 |
| columns | 列数 | ラベル | textarea時 |
| rows | 行数 | ラベル | textarea時 |
| maxlength | 最大長 | ラベル | text/textarea時 |
| size | サイズ | ラベル | text時 |
| values | 選択肢 | ラベル | select/radio時 |
| enterseplist | 改行区切りで入力 | ヒント | select/radio時 |
| comment | コメント | ラベル | comment時 |
| placement | 配置 | ラベル | radio時 |
| storeinfolder | 保存フォルダ | ラベル | file/image時 |
| allowedfiletypes | 許可拡張子 | ラベル | file時 |
| maxfilesize | 最大サイズ | ラベル | file/image時 |
| cs_fileextx | カンマ区切りで拡張子 | ヒント | file時 |
| nolimit | 制限なし | ヒント | - |
| characters | 文字 | ラベル | - |
| enableautoresponse | 自動応答有効 | ラベル | email時 |
| useasenderemail | 送信者メール使用 | ラベル | email時 |
| mandatory | 必須 | ラベル/チェック | - |
| save | 保存 | ボタン | - |
| delete | 削除 | ボタン | - |
| areyousure | 本当に削除しますか？ | 確認 | - |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bForms権限なし | アクセス拒否（logon.hasaccess） |
| バリデーションエラー | エラーメッセージ表示、画面再表示 |
| CSRFトークン不正 | エラー処理（checkCSRF関数） |

## 備考

- フィールドタイプ変更時は自動でフォームが送信され、画面がリロードされる
- 新規作成時、表示順序は既存フィールド数+1がデフォルト
- 隠しフィールド（sb_ff_hidden）はcustomer.bApplication権限がある場合のみ選択可能
- コメントフィールドはFCKEditorによるリッチテキスト編集が可能
- ファイル保存先未指定の場合はデフォルトのuserfilesフォルダに保存

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームフィールドで使用されるタイプ定数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | sb_ff_*定数の定義（行2-14） |

**読解のコツ**: 各フィールドタイプは文字列コード（"10", "20"等）で識別される。これを理解することで条件分岐の意味が明確になる。

#### Step 2: エントリーポイントを理解する

フォームフィールド編集画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | フィールド取得、タイプ別表示切替、保存処理 |

**主要処理フロー**:
1. **行2-8**: cls_FormFieldインスタンス化とpostback処理
2. **行9-18**: btnactionによる処理分岐（保存/削除）
3. **行22-39**: フォーム基本項目と条件別表示項目のHTML生成

#### Step 3: タイプ別表示切替を理解する

sTypeの値による条件分岐を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | select case FormField.sTypeによる分岐（行25-39） |

**主要処理フロー**:
- **行24-30**: text/url/emailのプレースホルダー表示
- **行32-34**: textareaの列数/行数/最大長
- **行35-38**: select/radioの選択肢
- **行38**: radioの複数選択許可
- **行39**: file/imageのファイル設定

### プログラム呼び出し階層図

```
bs_FormFieldEdit.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bForms)
    │
    ├─ cls_FormField (フィールド処理)
    │      ├─ pick() - フィールド取得
    │      ├─ getRequestValues() - 入力値取得
    │      ├─ save() - 保存処理
    │      └─ remove() - 削除処理
    │
    ├─ cls_formFieldTypeList (フィールドタイプ)
    │      └─ showSelected() - タイプ選択肢生成
    │
    ├─ cls_placementList (配置リスト)
    │      └─ showSelected() - 配置選択肢生成
    │
    └─ createFCKInstance() (リッチテキスト)
           └─ FCKEditorの初期化
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ getRequestValues()
                         │
                         ▼
              ┌──────────┼──────────┐
              │          │          │
              ▼          ▼          ▼
         エラーあり   保存処理   削除処理
              │          │          │
              │          ▼          ▼
              │      save()    remove()
              │          │          │
              │          ▼          ▼
              │   tblFormField  tblFormField
              │     INSERT/     DELETE
              │     UPDATE
              │          │          │
              ▼          ▼          ▼
         画面再表示   リダイレクト   リダイレクト
                   bs_formFields   bs_formFields
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_FormFieldEdit.asp | `asp/bs_FormFieldEdit.asp` | ソース | フォームフィールド編集画面メインファイル |
| formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | ソース | フィールドタイプ定数・選択肢定義 |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド一覧画面（遷移元/先） |
| bs_backFormField.asp | `asp/bs_backFormField.asp` | ソース | 戻るリンク表示 |
| bs_FormExpl.asp | `asp/bs_formExpl.asp` | ソース | フォーム説明表示 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
