# 画面設計書 27-フォームプレビュー

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォームプレビュー画面（bs_formPreview.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がフォームの表示状態を公開前にプレビューするための画面である。cls_formクラスのbuild()メソッドを使用してフォームのHTMLを動的に生成し、実際にユーザーに表示される状態を確認できる。プレビュー専用画面であり、実際のフォーム送信は行わない。

**業務上の目的・背景**：フォームを公開する前に、設定したフィールドが正しく表示されるか、レイアウトが意図通りか、必須マークが正しく付与されているか等を確認することは重要である。本画面は、フォーム設定の確認と品質保証のための機能を提供する。

**画面へのアクセス方法**：フォーム一覧画面（bs_formList.asp）またはフォームフィールド一覧画面（bs_formFields.asp）のプレビューアイコンをクリックしてポップアップで表示する。フォーム管理権限（secondAdmin.bForms）が必要。

**主要な操作・処理内容**：
1. フォームHTMLの動的生成
2. フォームの表示プレビュー
3. 各フィールドの表示確認

**画面遷移**：フォーム一覧画面またはフォームフィールド一覧画面からポップアップで表示される。送信ボタンは機能するが、同画面内で完結する。

**権限による表示制御**：secondAdmin.bForms権限がないユーザーはアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | フォームプレビュー | 主機能 | フォームの表示プレビュー |

## 画面種別

プレビュー（ポップアップ）

## URL/ルーティング

`asp/bs_formPreview.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | URL | 必須 | プレビュー対象フォームの暗号化ID |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| フォームHTML | 常時 | form.build()で生成されたフォーム全体 |
| - イントロダクション | form.sIntroが設定されている場合 | フォーム上部の説明文 |
| - 入力フィールド群 | 常時 | 各フィールドのHTML |
| - 必須マーク | bMandatory=trueのフィールド | 「*」マーク |
| - CAPTCHAフィールド | form.bCaptcha=true | 画像認証入力欄 |
| - 送信ボタン | 常時 | form.sButtonの値 |
| - リセットボタン | form.sResetが設定されている場合 | form.sResetの値 |

## イベント仕様

### 1-送信ボタン押下

**トリガー**: 送信ボタン（button）クリック

**処理フロー**:
1. フォームが同画面（bs_formPreview.asp）にPOST送信される
2. プレビュー画面では実際の送信処理は行われない
3. 画面がリロードされ、同じプレビューが再表示される

**遷移先**: bs_formPreview.asp（同画面）

### 2-リセットボタン押下

**トリガー**: リセットボタン（button）クリック

**処理フロー**:
1. JavaScript関数resetForm()が実行される
2. 各入力フィールドの値がクリアされる

**遷移先**: 同画面（リセット処理のみ）

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースの更新を行わない。表示処理のみ。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | フォーム情報取得 |
| 画面表示 | tblFormField | SELECT | フィールド一覧取得 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| mandatory | 必須 | 必須フィールド存在時 | 注記 |
| charactersleft | 文字残り | maxlength設定時 | カウンター |
| captcha | CAPTCHA | bCaptcha=true | ラベル |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bForms権限なし | アクセス拒否（logon.hasaccess） |
| フォームが存在しない | 空の画面が表示される |

## 備考

- 本画面はポップアップウィンドウとして表示される（class="QSPP"）
- form.build()メソッドで動的にフォームHTMLが生成される
- action属性は"bs_formPreview.asp"に設定され、実際の送信処理は行われない
- 表示幅は680pxに固定されている
- 独立したHTMLドキュメントとして出力される（DOCTYPE宣言付き）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームビルド機能で使用されるcls_formクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp build関数 | `asp/includes/form.asp` | build()メソッドの実装（行250-805） |

**読解のコツ**: build()メソッドは非常に長い関数だが、フィールドタイプごとの分岐（行624-737）を中心に理解することが重要。

#### Step 2: エントリーポイントを理解する

フォームプレビュー画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formPreview.asp | `asp/bs_formPreview.asp` | シンプルな構造、form.build()の呼び出し |

**主要処理フロー**:
1. **行4**: cls_formインスタンス化（URLパラメータからフォームID取得）
2. **行5**: form.build()でフォームHTML生成
3. **行6**: cleanUPASPでリソース解放

#### Step 3: フォームビルドのオプションを理解する

build()メソッドのパラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp build関数 | `asp/includes/form.asp` | build(action, align, buttonType, itemID)の引数 |

**主要処理フロー**:
- action: フォームの送信先URL
- align: フォームの配置（"center"等）
- buttonType: ボタンの種類（"button"/"submit"）
- itemID: カタログアイテムとの紐付け（プレビューではnull）

### プログラム呼び出し階層図

```
bs_formPreview.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bForms)
    │
    └─ cls_form (フォーム処理)
           └─ build() - フォームHTML生成
                  │
                  ├─ fields() - フィールド一覧取得
                  │
                  ├─ フィールドタイプ別HTML生成
                  │      ├─ sb_ff_text → input[type=text]
                  │      ├─ sb_ff_textarea → textarea
                  │      ├─ sb_ff_checkbox → input[type=checkbox]
                  │      ├─ sb_ff_select → select
                  │      ├─ sb_ff_radio → input[type=radio]
                  │      └─ ...その他タイプ
                  │
                  └─ resetJS生成 - リセットスクリプト
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ cls_form.pick()
(iFormID)               │
                        ▼
                  form.fields()
                        │
                        ▼
                  form.build()
                        │
                        ▼
              フィールドタイプ別
              HTML生成ループ
                        │
                        ▼
              フォームHTML ───▶ ブラウザ表示
              （action="bs_formPreview.asp"）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formPreview.asp | `asp/bs_formPreview.asp` | ソース | フォームプレビュー画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス、build()メソッド |
| formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | ソース | フィールドタイプ定数定義 |
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧画面（呼び出し元） |
| bs_formFields.asp | `asp/bs_formFields.asp` | ソース | フォームフィールド一覧画面（呼び出し元） |
