# 画面設計書 28-フォームデータエクスポート

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォームデータエクスポート画面（bs_formExport.asp）の画面設計書である。

### 本画面の処理概要

本画面は、サイト管理者がフォームから送信されたデータを一覧表示し、個別の編集、削除、およびExcel形式でのエクスポートを行うための画面である。送信データの閲覧と管理の中核となる機能を提供し、お問い合わせ対応やデータ分析の起点として機能する。

**業務上の目的・背景**：Webフォームから送信されたデータを効率的に管理・活用することは、顧客対応やマーケティング活動において重要である。本画面は、送信データの一覧表示、個別データの編集・削除、Excel形式でのエクスポート機能を提供し、データ活用を支援する。

**画面へのアクセス方法**：フォーム一覧画面（bs_formList.asp）のデータアイコンをクリックしてポップアップで表示する。フォームエクスポート権限（secondAdmin.bFormExport）が必要。

**主要な操作・処理内容**：
1. フォーム送信データの一覧表示
2. 送信データの詳細確認（各フィールド値、送信日時）
3. 送信データの編集画面への遷移
4. 送信データの個別削除
5. 送信データの一括削除
6. Excel形式でのデータエクスポート

**画面遷移**：フォーム一覧画面からポップアップで表示され、送信編集画面（bs_formSubmissionEdit.asp）へ遷移可能。

**権限による表示制御**：secondAdmin.bFormExport権限がないユーザーはアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | フォーム送信データ表示 | 主機能 | フォーム送信データの閲覧 |

## 画面種別

一覧（ポップアップ）

## URL/ルーティング

`asp/bs_formExport.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | URL | 必須 | 対象フォームの暗号化ID |
| 送信ID | iSubmissionID | URL | - | 削除対象の送信データID |
| ページアクション | pageAction | URL | - | "removeAll"で全件削除 |
| CSRFトークン | QS_secCodeURL | URL | - | 削除処理時のセキュリティトークン |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 件数表示 | データが存在する場合 | 「X件の送信」 |
| Excelアイコン | データが存在する場合 | bs_formExcel.aspへのリンク |
| 送信データテーブル | データが存在する場合 | 以下の列を含むテーブル |
| - 編集リンク | 常時 | bs_formSubmissionEdit.aspへのリンク |
| - 日時 | 常時 | 送信日時（formatTimeStamp形式） |
| - カタログ名 | カタログ連携時 | 関連カタログ名 |
| - アイテム名 | カタログ連携時 | 関連アイテム名 |
| - 各フィールド値 | 常時 | 送信された各フィールドの値 |
| - 削除アイコン | 常時 | 個別削除用ゴミ箱アイコン |
| 全件削除リンク | データが存在する場合 | 全送信データ削除リンク |
| データなしメッセージ | データが0件の場合 | 「データがありません」メッセージ |

## イベント仕様

### 1-編集リンククリック

**トリガー**: 「修正」リンククリック

**処理フロー**:
1. bs_formSubmissionEdit.asp?iFormID={暗号化ID}&iSubmissionID={暗号化ID}へ遷移

**遷移先**: bs_formSubmissionEdit.asp

### 2-削除アイコンクリック

**トリガー**: ゴミ箱アイコンクリック

**処理フロー**:
1. JavaScript確認ダイアログ表示
2. 確認後、CSRFトークン検証（checkCSRF）
3. cls_submissionクラスのremove()メソッド実行
   - 関連ファイルの削除（ファイル/画像フィールドの場合）
   - tblFormFieldValueから関連値削除
   - tblFormSubmissionからレコード削除
4. 同画面がリロードされる（アンカー付き）

**遷移先**: bs_formExport.asp（リロード）

### 3-全件削除リンククリック

**トリガー**: 「全て削除」リンククリック

**処理フロー**:
1. JavaScript確認ダイアログ表示
2. 確認後、CSRFトークン検証（checkCSRF）
3. form.removeAllSubmissions()メソッド実行
   - 全送信データと関連値を削除
4. 同画面がリロードされる

**遷移先**: bs_formExport.asp（リロード）

### 4-Excelアイコンクリック

**トリガー**: Excelアイコンクリック

**処理フロー**:
1. window.openでbs_formExcel.asp?iFormID={暗号化ID}を新規ウィンドウで開く
2. Excelファイルがダウンロードされる

**遷移先**: bs_formExcel.asp（新規ウィンドウ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | フォーム情報取得 |
| 画面表示 | tblFormField | SELECT | フィールド一覧取得 |
| 画面表示 | tblFormSubmission | SELECT | 送信データ一覧取得 |
| 画面表示 | tblFormFieldValue | SELECT | 送信値取得 |
| 個別削除 | tblFormFieldValue | DELETE | 対象送信の値削除 |
| 個別削除 | tblFormSubmission | DELETE | 送信レコード削除 |
| 全件削除 | tblFormFieldValue | DELETE | 全送信の値削除 |
| 全件削除 | tblFormSubmission | DELETE | 全送信レコード削除 |

### テーブル別更新項目詳細

#### tblFormFieldValue（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iSubmissionID = 対象ID | 送信に紐づく全値を削除 |

#### tblFormSubmission（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iId = 対象ID | 送信レコードを削除 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| submissions | 件の送信 | データ存在時 | 情報 |
| date | 日付 | テーブルヘッダー | - |
| hour | 時刻 | テーブルヘッダー | - |
| catalog | カタログ | テーブルヘッダー | カタログ連携時 |
| item | アイテム | テーブルヘッダー | カタログ連携時 |
| modify | 修正 | リンクラベル | - |
| delete | 削除 | アイコンalt | - |
| removeall | 全て削除 | リンクラベル | - |
| areyousure | 本当に削除しますか？ | 確認 | - |
| nodata | データがありません | データ0件時 | 情報 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bFormExport権限なし | アクセス拒否（logon.hasaccess） |
| 送信データが存在しない | 「データがありません」メッセージ表示 |
| CSRFトークン不正 | エラー処理（checkCSRF関数） |

## 備考

- テーブルにはclass="sortable"が設定されており、JavaScriptによるソートが可能
- 送信データは作成日時の降順（新しい順）で表示される
- ファイル/画像フィールドはリンクとして表示され、クリックでダウンロード可能
- カタログアイテムと連携している場合、カタログ名とアイテム名が表示される
- 削除時にはアップロードされたファイルも物理削除される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

送信データ管理で使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | submission.asp | `asp/includes/submission.asp` | cls_submissionクラスの構造、remove()メソッド |
| 1-2 | form.asp submissions関数 | `asp/includes/form.asp` | submissions()メソッド（行824-838） |

**読解のコツ**: cls_submissionクラスはフォーム送信データを表し、values()メソッドで各フィールドの値を取得できる。

#### Step 2: エントリーポイントを理解する

フォームデータエクスポート画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formExport.asp | `asp/bs_formExport.asp` | 送信データ一覧表示、削除処理 |

**主要処理フロー**:
1. **行4-8**: cls_form、cls_submissionインスタンス化
2. **行9-12**: 個別削除処理（iSubmissionID指定時）
3. **行13-16**: 全件削除処理（pageAction=removeAll）
4. **行17-49**: 送信データ一覧のループ表示

#### Step 3: フィールドタイプ別表示を理解する

各フィールドタイプの値表示ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_formExport.asp | `asp/bs_formExport.asp` | select case fields(cField).sTypeによる分岐（行29-46） |

**主要処理フロー**:
- checkbox: Yes/Noに変換表示
- file/image: リンクとして表示
- その他: sanitize()で安全に表示

### プログラム呼び出し階層図

```
bs_formExport.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bFormExport)
    │
    ├─ cls_form (フォーム処理)
    │      ├─ fields() - フィールド一覧取得
    │      ├─ submissions() - 送信データ一覧取得
    │      │      └─ cls_submission.pick() - 各送信データ取得
    │      └─ removeAllSubmissions() - 全件削除
    │
    ├─ cls_submission (送信データ処理)
    │      ├─ pick() - 送信データ取得
    │      ├─ values() - フィールド値取得
    │      ├─ item() - カタログアイテム取得
    │      └─ remove() - 個別削除
    │             ├─ ファイル削除
    │             └─ DB削除
    │
    └─ formatTimeStamp() (日時整形)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ 削除処理判定
                         │
           ┌─────────────┼─────────────┐
           │             │             │
           ▼             ▼             ▼
    iSubmissionID   pageAction     一覧表示
    指定時          =removeAll
           │             │             │
           ▼             ▼             ▼
    submission.    form.remove     form.
    remove()       AllSubmissions  submissions()
           │             │             │
           ▼             ▼             ▼
    tblFormField   tblFormField   tblFormField
    Value DELETE   Value DELETE   Value SELECT
           │             │             │
           ▼             ▼             ▼
    tblForm       tblForm         HTMLテーブル出力
    Submission    Submission           │
    DELETE        DELETE               ▼
                                 ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | フォームデータエクスポート画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス、submissions()メソッド |
| submission.asp | `asp/includes/submission.asp` | ソース | cls_submissionクラス定義 |
| bs_formList.asp | `asp/bs_formList.asp` | ソース | フォーム一覧画面（呼び出し元） |
| bs_formSubmissionEdit.asp | `asp/bs_formSubmissionEdit.asp` | ソース | 送信データ編集画面（遷移先） |
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | Excel出力処理（遷移先） |
