# 画面設計書 29-フォームExcel出力

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォームExcel出力画面（bs_formExcel.asp）の画面設計書である。

### 本画面の処理概要

本画面は、フォーム送信データをExcel形式でエクスポートするための処理画面である。画面表示は行わず、即座にExcelファイルを生成してブラウザにダウンロードさせる。cls_excelFileクラスを使用してHTMLテーブルをExcel形式に変換し、一時ファイルとして保存後、リダイレクトによりダウンロードを開始する。

**業務上の目的・背景**：フォームから収集したデータを分析・報告・保管するためにExcel形式でエクスポートする機能は、業務運用上不可欠である。本画面は、全送信データを一括でExcelファイルとしてダウンロードする機能を提供する。

**画面へのアクセス方法**：フォームデータエクスポート画面（bs_formExport.asp）のExcelアイコンをクリックして新規ウィンドウで開く。フォームエクスポート権限（secondAdmin.bFormExport）が必要。

**主要な操作・処理内容**：
1. フォーム送信データの全件取得
2. HTMLテーブル形式でデータ生成
3. Excel形式ファイル（.xls）への変換・保存
4. ブラウザへのファイルダウンロードリダイレクト

**画面遷移**：フォームデータエクスポート画面から新規ウィンドウで呼び出され、Excelファイルがダウンロードされる。

**権限による表示制御**：secondAdmin.bFormExport権限がないユーザーはアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 43 | フォームデータExcelエクスポート | 主機能 | Excel形式でのデータ出力 |

## 画面種別

ダウンロード（新規ウィンドウ）

## URL/ルーティング

`asp/bs_formExcel.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | URL | 必須 | 対象フォームの暗号化ID |

## 表示項目

本画面は表示画面ではなく、ファイルダウンロード処理を行う。画面表示は行われない。

### エクスポートされるデータ項目

| 項目名 | 出力条件 | 説明 |
|--------|----------|------|
| ID | 常時 | 送信データのID |
| 日付&時刻 | 常時 | 送信日時（formatTimeStamp形式） |
| カタログ | カタログ連携時 | 関連カタログ名 |
| アイテム | カタログ連携時 | 関連アイテム名 |
| 各フィールド値 | 常時 | フィールドタイプがcomment以外の全フィールド |

## イベント仕様

### 1-画面アクセス

**トリガー**: URLアクセス（フォームデータエクスポート画面からのリンク）

**処理フロー**:
1. 権限チェック（secondAdmin.bFormExport）
2. cls_formインスタンス作成、フィールド一覧取得
3. 送信データ一覧取得（form.submissions）
4. カタログ連携有無の判定
5. HTMLテーブル形式でデータ生成
   - ヘッダー行：ID、日時、（カタログ、アイテム）、各フィールド名
   - データ行：各送信データをループで出力
6. cls_excelFileインスタンス作成
7. export()メソッドでExcelファイル生成
8. redirectLink()でファイルダウンロードにリダイレクト

**遷移先**: Excelファイルダウンロード

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースの更新を行わない。読み取り専用。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | フォーム情報取得 |
| 画面表示 | tblFormField | SELECT | フィールド一覧取得 |
| 画面表示 | tblFormSubmission | SELECT | 送信データ一覧取得 |
| 画面表示 | tblFormFieldValue | SELECT | 送信値取得 |
| 画面表示 | tblCatalog | SELECT | カタログ情報取得（連携時） |
| 画面表示 | tblItem | SELECT | アイテム情報取得（連携時） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| date | 日付 | テーブルヘッダー | - |
| hour | 時刻 | テーブルヘッダー | - |
| catalog | カタログ | テーブルヘッダー（カタログ連携時） | - |
| item | アイテム | テーブルヘッダー（カタログ連携時） | - |
| downloadexcel | Excelダウンロード | ダウンロードリンク | - |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bFormExport権限なし | アクセス拒否（logon.hasaccess） |
| ファイル作成失敗 | on error resume nextでエラー抑制 |

## 備考

- Excelファイルは実際にはHTMLテーブルを.xls拡張子で保存したもの
- ファイル名は「IEExport_{ランダムパスワード}.xls」形式
- 生成時に古いエクスポートファイル（IEExport_で始まるファイル）は削除される
- 文字コードはQS_CHARSET（設定による）で出力
- checkboxフィールドはYes/Noに変換して出力
- file/imageフィールドはURLリンクとして出力
- commentフィールドはエクスポート対象外

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Excelエクスポートで使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスの構造、export()メソッド |
| 1-2 | form.asp submissions関数 | `asp/includes/form.asp` | submissions()メソッド（行824-838） |

**読解のコツ**: cls_excelFileクラスはHTMLテーブルを受け取り、.xlsファイルとして保存する。Excelで開けるHTML形式で出力している。

#### Step 2: エントリーポイントを理解する

フォームExcel出力画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formExcel.asp | `asp/bs_formExcel.asp` | データ取得、テーブル生成、エクスポート実行 |

**主要処理フロー**:
1. **行4-7**: cls_form、フィールド一覧、送信データ一覧取得
2. **行9-14**: カタログ連携有無の判定ループ
3. **行15-26**: テーブルヘッダー生成（ID、日時、カタログ、フィールド名）
4. **行28-60**: データ行生成ループ
5. **行62-66**: cls_excelFile生成、エクスポート実行、リダイレクト

#### Step 3: フィールドタイプ別処理を理解する

各フィールドタイプの出力ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_formExcel.asp | `asp/bs_formExcel.asp` | select case fields(cField).sTypeによる分岐（行41-52） |

**主要処理フロー**:
- checkbox: convertCheckedYesNo()でYes/Noに変換
- file/image: linkUrls()でURLリンクとして出力
- その他: sanitize()でサニタイズして出力
- comment: 出力対象外（条件分岐で除外）

### プログラム呼び出し階層図

```
bs_formExcel.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bFormExport)
    │
    ├─ cls_form (フォーム処理)
    │      ├─ fields() - フィールド一覧取得
    │      └─ submissions() - 送信データ一覧取得
    │             └─ cls_submission - 各送信データ
    │                    ├─ values() - フィールド値取得
    │                    └─ item() - カタログアイテム取得
    │                           └─ catalog - カタログ情報
    │
    ├─ formatTimeStamp() (日時整形)
    │
    ├─ convertCheckedYesNo() (チェックボックス変換)
    │
    ├─ linkUrls() (URL生成)
    │
    └─ cls_excelFile (Excelエクスポート)
           ├─ export() - HTMLテーブルをExcel形式で保存
           │      ├─ convertTo_iso_8859_1() - 文字コード変換
           │      ├─ prepareForExport() - エクスポート準備
           │      ├─ deleteOthers() - 古いファイル削除
           │      └─ CreateTextFile() - ファイル書き込み
           └─ redirectLink() - ファイルダウンロードリダイレクト
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ cls_form.pick()
(iFormID)               │
                        ▼
                  form.fields()
                        │
                        ▼
                  form.submissions()
                        │
          ┌─────────────┴─────────────┐
          │                           │
          ▼                           ▼
   カタログ連携              送信データ
   有無判定                  ループ処理
          │                           │
          ▼                           ▼
   showCatalog          submission.values()
   フラグ設定                    │
          │                      ▼
          │              フィールドタイプ
          │              別処理
          │                      │
          └─────────┬────────────┘
                    ▼
             HTMLテーブル生成
                    │
                    ▼
             cls_excelFile.export()
                    │
                    ▼
             .xlsファイル生成
                    │
                    ▼
             redirectLink()
                    │
                    ▼
             ブラウザダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | フォームExcel出力メインファイル |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | cls_excelFileクラス定義 |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス、submissions()メソッド |
| submission.asp | `asp/includes/submission.asp` | ソース | cls_submissionクラス定義 |
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | フォームデータエクスポート画面（呼び出し元） |
