# 画面設計書 3-ログオフ画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）からのログオフ処理を行う画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、バックサイト（CMS管理画面）からセッションを終了してログオフするための処理画面である。セッションの破棄、認証Cookieのクリア、メニューキャッシュのクリアなど、完全なログアウト処理を実行し、セキュリティを確保する。

**業務上の目的・背景**：共有端末や公共の場所からCMSにアクセスした場合、作業終了後に適切にログオフすることで、第三者による不正なセッション利用を防止する。また、セッションタイムアウト前にログオフすることで、意図しないセッション継続を防ぐことができる。

**画面へのアクセス方法**：バックサイトのヘッダーメニューまたはナビゲーションからログオフリンクをクリックする。直接 `/asp/bs_logoff.asp` にアクセスすることも可能。

**主要な操作・処理内容**：
1. ログオフ処理（logon.logoffBO）が自動実行される
2. 認証Cookie（hfsdsiiqqssdfjf）がクリアされる
3. セカンド管理者認証フラグがクリアされる
4. 通常認証フラグがクリアされる
5. ログイン画面（bs_login.asp）にリダイレクトされる
6. リダイレクト後、「ログオフしました」メッセージと再ログインリンクが表示される

**画面遷移**：
- 遷移元：バックサイト各画面のログオフリンク
- 遷移先：bs_login.asp（バックサイトログイン画面）

**権限による表示制御**：認証済みユーザーのみがログオフ処理を実行できる（bs_security.aspによる認証チェック）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 管理者ログアウト | 主機能 | バックサイトからのセッション終了・ログアウト処理 |

## 画面種別

処理画面（自動リダイレクト付きログオフ処理）

## URL/ルーティング

- `/asp/bs_logoff.asp`
- `/asp/bs_logoff.asp?loggedoff=1`（ログオフ完了状態）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| ログオフ完了フラグ | loggedoff | QueryString | 文字列 | - | - | 空でない場合はメッセージ表示モード |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ログオフ完了メッセージ | 中央 | 多言語対応メッセージ「youareloggedoff」 |
| 再ログインリンク | 中央 | ログイン画面へのリンク「loginagain」 |

## イベント仕様

### 1-ログオフ処理（自動実行）

**処理フロー**：
1. request.querystring("loggedoff")が空かどうかを確認
2. 空の場合（初回アクセス）：
   - logon.logoffBO関数を呼び出してセッションを破棄
   - 認証Cookie（cId&"hfsdsiiqqssdfjf"）をクリア
   - Session(cId & "isAUTHENTICATEDSecondAdmin")をfalseに設定
   - Session(cId & "isAUTHENTICATED")をfalseに設定
   - bs_login.aspにリダイレクト
3. 空でない場合（リダイレクト後）：
   - ログオフ完了メッセージを表示
   - 再ログインリンクを表示

### 2-再ログインリンクのクリック

**処理フロー**：
1. bs_login.aspへ遷移
2. ログイン画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログオフ処理 | なし | - | データベース更新なし |

### テーブル別更新項目詳細

本画面ではデータベースへの更新は行わない。

**Application変数の更新**：
- `QS_CMS_FCK_allowedIP`: 空文字列に設定
- `QS_CMS_cacheBOMenu{password}`: 空文字列に設定（メニューキャッシュクリア）

**Session変数の更新**：
- `{cId}isAUTHENTICATED`: falseに設定
- `{cId}isAUTHENTICATEDSecondAdmin`: falseに設定
- Session.Abandonによる全セッション破棄

**Cookie更新**：
- `{cId}hfsdsiiqqssdfjf`: 空文字列に設定

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| youareloggedoff | 情報 | ログオフ完了メッセージ | ログオフ処理完了後 |
| loginagain | リンク | 再ログインリンクテキスト | ログオフ完了後に表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態でのアクセス | bs_security.aspにより認証画面へリダイレクト |

## 備考

- ログオフ処理は自動実行され、ユーザー操作は不要
- セッション全体がSession.Abandonにより破棄される
- メニューキャッシュもクリアされるため、次回ログイン時に再構築される
- QS_CMS_FCK_allowedIPがクリアされることで、FCKエディタのセキュリティも確保される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログオフで破棄されるセッション・Cookie・Application変数を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logoffBO関数でクリアされる変数一覧 |

**読解のコツ**: ログオフ処理はログイン処理の逆操作である。ログイン時に設定された変数がすべてクリアされることを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_logoff.asp | `asp/bs_logoff.asp` | ログオフ画面のメインファイル |

**主要処理フロー**:
1. **行4**: request.querystring("loggedoff")の確認
2. **行5**: logon.logoffBO関数を呼び出し
3. **行6**: Cookie（cId&"hfsdsiiqqssdfjf"）をクリア
4. **行7**: Session(cId & "isAUTHENTICATEDSecondAdmin")をfalseに設定
5. **行8**: Session(cId & "isAUTHENTICATED")をfalseに設定
6. **行9**: bs_login.aspへリダイレクト

#### Step 3: ログオフ関数を理解する

logoffBO関数の内部処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logoffBO関数（行183-188） |

**主要処理フロー**:
- **行184**: QS_CMS_FCK_allowedIPをクリア
- **行185-186**: メニューキャッシュをクリア
- **行187**: Session.Abandonで全セッションを破棄

### プログラム呼び出し階層図

```
bs_logoff.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ logon.logoffBO() (ログオフ処理)
    │      ├─ Application変数クリア
    │      └─ Session.Abandon()
    │
    ├─ Cookieクリア処理
    │
    ├─ Session変数クリア処理
    │
    └─ Response.Redirect (bs_login.asp)
```

### データフロー図

```
[処理]                              [影響範囲]

logoffBO() ─────────────▶ Application変数クリア
       │                         ├─ QS_CMS_FCK_allowedIP
       │                         └─ QS_CMS_cacheBOMenu
       │
       └─────────────────▶ Session.Abandon()

Cookieクリア ────────────▶ hfsdsiiqqssdfjf = ""

Session変数設定 ─────────▶ isAUTHENTICATED = false
                         isAUTHENTICATEDSecondAdmin = false
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_logoff.asp | `asp/bs_logoff.asp` | ソース | ログオフ画面メイン |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理・クラスロード |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| logonEdit.asp | `asp/includes/logonEdit.asp` | インクルード | logoffBO関数定義 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダーHTML |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッターHTML |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
