# 画面設計書 30-フォーム送信編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフォーム送信編集画面（bs_formSubmissionEdit.asp）の画面設計書である。

### 本画面の処理概要

本画面は、フォームから送信されたデータを編集するための画面である。送信済みのフィールド値を修正し、データベースに保存することができる。ファイル/画像フィールド以外の全フィールドが編集可能であり、テキストエリアでの入力に対応している。

**業務上の目的・背景**：フォームから送信されたデータに誤りがあった場合や、追加情報を記録する必要がある場合に、管理者がデータを修正できる機能は運用上重要である。本画面は、送信データの事後修正機能を提供する。

**画面へのアクセス方法**：フォームデータエクスポート画面（bs_formExport.asp）の「修正」リンクをクリックして遷移する。フォームエクスポート権限（secondAdmin.bFormExport）が必要。

**主要な操作・処理内容**：
1. 送信データの現在値表示
2. フィールド値の編集（テキストエリア）
3. 編集内容の保存

**画面遷移**：フォームデータエクスポート画面から遷移し、保存後はフォームデータエクスポート画面に戻る。

**権限による表示制御**：secondAdmin.bFormExport権限がないユーザーはアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | フォーム送信データ表示 | 主機能 | 送信データの編集・保存 |

## 画面種別

編集

## URL/ルーティング

`asp/bs_formSubmissionEdit.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フォームID | iFormID | URL/POST | 必須 | 対象フォームの暗号化ID |
| 送信ID | iSubmissionID | URL/POST | 必須 | 編集対象送信データの暗号化ID |
| ポストバック | postback | POST | - | 保存処理フラグ |
| フィールド値 | {暗号化フィールドID} | POST | - | 各フィールドの編集値 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 戻るリンク | 常時 | bs_formExport.aspへのリンク |
| 編集フォーム | 常時 | フィールド編集用フォーム |
| - フィールドラベル | file/image以外 | フィールド名 |
| - テキストエリア | file/image以外 | 80列×3行のテキストエリア |
| 保存ボタン | 常時 | 確認ダイアログ付き保存ボタン |

## イベント仕様

### 1-画面表示

**トリガー**: URLアクセス（フォームデータエクスポート画面からのリンク）

**処理フロー**:
1. 権限チェック（secondAdmin.bFormExport）
2. cls_formインスタンス作成、フィールド一覧取得
3. cls_submissionインスタンス作成
4. フォームIDの整合性チェック（submission.iFormID = form.iId）
5. 各フィールドの現在値をテキストエリアに表示

**遷移先**: 同画面（表示）

### 2-保存ボタン押下

**トリガー**: 「保存」ボタンクリック

**処理フロー**:
1. JavaScript確認ダイアログ表示
2. 確認後、postback=trueでフォーム送信
3. 各フィールドをループ処理
   - file/imageフィールドはスキップ
   - tblFormFieldValueテーブルを検索
   - レコードが存在しない場合は新規作成（addNew）
   - sValueを更新
4. bs_formExport.aspへリダイレクト（アンカー付き）

**遷移先**: bs_formExport.asp

### 3-戻るリンククリック

**トリガー**: 「Back」リンククリック

**処理フロー**:
1. bs_formExport.asp?iFormID={暗号化ID}へ遷移

**遷移先**: bs_formExport.asp

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblForm | SELECT | フォーム情報取得 |
| 画面表示 | tblFormField | SELECT | フィールド一覧取得 |
| 画面表示 | tblFormSubmission | SELECT | 送信データ取得 |
| 画面表示 | tblFormFieldValue | SELECT | 送信値取得 |
| 保存 | tblFormFieldValue | SELECT | 既存値確認 |
| 保存 | tblFormFieldValue | INSERT | 新規値追加（該当なし時） |
| 保存 | tblFormFieldValue | UPDATE | 値更新 |

### テーブル別更新項目詳細

#### tblFormFieldValue（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | WHERE iSubmissionID = 対象ID AND iFormFieldId = フィールドID | 既存レコード確認 |
| INSERT | iFormFieldId | フィールドID | 新規レコード時 |
| INSERT | iSubmissionID | 送信ID | 新規レコード時 |
| UPDATE | sValue | request.form(encrypt(フィールドID)) | 入力値 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| save | 保存 | ボタンラベル | - |
| areyousure | 本当に保存しますか？ | 確認ダイアログ | 確認 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| secondAdmin.bFormExport権限なし | アクセス拒否（logon.hasaccess） |
| フォームIDと送信データのフォームIDが不一致 | response.endで処理終了 |
| データベース更新エラー | on error resume nextでエラー抑制 |

## 備考

- file/imageフィールドは編集対象外（スキップされる）
- テキストエリアは80列×3行で固定
- 保存時に確認ダイアログが表示される
- 保存後のリダイレクトにはアンカー（#送信ID）が付与され、一覧画面で該当行にスクロールする
- フィールドIDは暗号化されてフォームに含まれる
- 既存値がない場合（後から追加されたフィールド等）は新規レコードを作成する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

送信データ編集で使用されるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | submission.asp | `asp/includes/submission.asp` | cls_submissionクラスの構造、values()メソッド |
| 1-2 | form.asp | `asp/includes/form.asp` | cls_formクラス、fields()メソッド |

**読解のコツ**: cls_submissionクラスはフォーム送信データを表し、iFormIDプロパティでフォームとの関連を持つ。values()メソッドで各フィールドの値をDictionary形式で取得できる。

#### Step 2: エントリーポイントを理解する

フォーム送信編集画面のメインロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formSubmissionEdit.asp | `asp/bs_formSubmissionEdit.asp` | 表示処理、保存処理の分岐 |

**主要処理フロー**:
1. **行4-8**: cls_form、cls_submissionインスタンス化、整合性チェック
2. **行9-31**: 保存処理（postback=true時）
   - フィールドループ
   - file/image以外のフィールドを更新
   - リダイレクト
3. **行32-44**: 表示処理
   - 戻るリンク表示
   - フィールドループでテキストエリア表示

#### Step 3: 更新処理を理解する

データベース更新処理の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_formSubmissionEdit.asp | `asp/bs_formSubmissionEdit.asp` | select case、getDynamicRS、addNew/update（行12-29） |

**主要処理フロー**:
- getDynamicRS: 動的レコードセット取得
- rs.open: SELECT文でレコード確認
- rs.eof: レコード存在確認
- rs.addNew(): 新規レコード追加
- rs.update: レコード更新

### プログラム呼び出し階層図

```
bs_formSubmissionEdit.asp (エントリーポイント)
    │
    ├─ begin.asp (初期化処理)
    │
    ├─ bs_security.asp (認証・認可)
    │      └─ logon.hasaccess(secondAdmin.bFormExport)
    │
    ├─ header.asp (ヘッダー)
    │
    ├─ bs_initBack.asp (バックサイト初期化)
    │
    ├─ bs_header.asp (管理画面ヘッダー)
    │
    ├─ cls_form (フォーム処理)
    │      └─ fields() - フィールド一覧取得
    │
    ├─ cls_submission (送信データ処理)
    │      ├─ iFormID - フォームID確認
    │      └─ values() - フィールド値取得
    │
    ├─ 保存処理（postback=true）
    │      ├─ db.getDynamicRS() - 動的レコードセット
    │      ├─ SELECT tblFormFieldValue
    │      ├─ addNew() / update() - レコード更新
    │      └─ response.redirect() - リダイレクト
    │
    └─ 表示処理
           ├─ cleanUpStr() - フィールド名サニタイズ
           ├─ encrypt() - フィールドID暗号化
           └─ quotrep() - 値エスケープ
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ cls_form.pick()
(iFormID,              │
iSubmissionID)         ▼
                 cls_submission.pick()
                       │
                       ▼
                 フォームID整合性
                 チェック
                       │
       ┌───────────────┴───────────────┐
       │                               │
       ▼                               ▼
postback=false                  postback=true
(表示処理)                      (保存処理)
       │                               │
       ▼                               ▼
submission.values()           フィールドループ
       │                               │
       ▼                               ▼
フィールドループ              tblFormFieldValue
       │                      SELECT/INSERT/UPDATE
       ▼                               │
テキストエリア表示                     ▼
       │                      response.redirect
       ▼                      (bs_formExport.asp)
ブラウザ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formSubmissionEdit.asp | `asp/bs_formSubmissionEdit.asp` | ソース | フォーム送信編集画面メインファイル |
| form.asp | `asp/includes/form.asp` | ソース | cls_formクラス、fields()メソッド |
| submission.asp | `asp/includes/submission.asp` | ソース | cls_submissionクラス定義 |
| formFieldTypeList.asp | `asp/includes/formFieldTypeList.asp` | ソース | フィールドタイプ定数定義 |
| bs_formExport.asp | `asp/bs_formExport.asp` | ソース | フォームデータエクスポート画面（呼び出し元・遷移先） |
