# 画面設計書 31-ギャラリー一覧

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるギャラリー一覧画面（bs_galleryList.asp）の設計仕様を定義する。

### 本画面の処理概要

ギャラリー一覧画面は、サイト管理者が登録済みの画像ギャラリーを一覧表示・管理するための画面である。

**業務上の目的・背景**：Webサイトにおいて画像ギャラリー機能は、製品紹介やポートフォリオ、イベント写真などを効果的に表示するために不可欠な機能である。本画面は、複数のギャラリーを一元管理し、新規作成・編集・コピー・プレビューなどの操作を可能にすることで、コンテンツ管理者の作業効率を向上させる。

**画面へのアクセス方法**：バックサイトにログイン後、メインメニューから「Gallery」ボタンをクリックするか、直接URLでbs_galleryList.aspにアクセスする。secondAdmin権限でギャラリー管理権限（bGallery）が必要。

**主要な操作・処理内容**：
1. 登録済みギャラリーの一覧表示（ギャラリー名、プレビューアイコン、コピーアイコン、埋め込みコード、内部ID）
2. 新規ギャラリー作成画面への遷移
3. 既存ギャラリーの編集画面への遷移
4. ギャラリーのプレビュー表示
5. ギャラリーのコピー（複製）機能
6. ギャラリー埋め込みコード（[QS_GALLERY:コード]形式）の表示

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、バックサイトヘッダーメニュー
- 遷移先：ギャラリー編集画面（bs_galleryEdit.asp）、ギャラリープレビュー画面（bs_galleryPreview.asp）

**権限による表示制御**：secondAdmin.bGalleryがtrueの場合のみアクセス可能。権限がない場合はログイン画面にリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | ギャラリー一覧 | 主機能 | 登録済みギャラリーの一覧表示 |
| 57 | ギャラリー作成・編集 | 遷移先機能 | 新規ギャラリー作成画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`/asp/bs_galleryList.asp`

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iGalleryID | 入力（クエリ） | 暗号化数値 | - | コピー対象ギャラリーID |
| QS_secCode | 入力（クエリ） | 文字列 | - | CSRF対策トークン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ギャラリー名 | 文字列 | ギャラリーの名称（リンク） |
| プレビューアイコン | アイコン | プレビュー画面へのリンク |
| コピーアイコン | アイコン | ギャラリー複製機能 |
| 埋め込みコード | 文字列 | [QS_GALLERY:コード]形式の埋め込み用テキスト |
| 内部ID | 数値 | システム内部のギャラリーID |

## イベント仕様

### 1-新規ギャラリー作成リンククリック

ギャラリー編集画面（bs_galleryEdit.asp）に遷移し、新規ギャラリー作成モードで表示する。

### 2-ギャラリー名リンククリック

選択したギャラリーの編集画面（bs_galleryEdit.asp?iGalleryID=暗号化ID）に遷移する。

### 3-プレビューアイコンクリック

選択したギャラリーのプレビュー画面（bs_galleryPreview.asp?iGalleryID=暗号化ID）をポップアップまたは新規ウィンドウで表示する。

### 4-コピーアイコンクリック

確認ダイアログ表示後、選択したギャラリーを複製する。複製後は新しいギャラリーの編集画面にリダイレクトされる。
- cls_gallery.copy()メソッドが呼び出される
- 新しいギャラリー名は「コピー元名 のコピー」となる
- コードは自動生成されたパスワードが設定される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblGallery | SELECT | 顧客のギャラリー一覧を取得 |
| コピーアイコンクリック | tblGallery | INSERT | ギャラリーレコードを複製 |

### テーブル別更新項目詳細

#### tblGallery

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID=現在の顧客ID | 一覧表示用 |
| INSERT | sName | 「コピー元名 のコピー」 | コピー時 |
| INSERT | sCode | 自動生成パスワード | コピー時、一意性確保 |
| INSERT | dCreatedTS | now() | コピー時 |
| INSERT | その他項目 | コピー元の値 | コピー時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| newgallery | リンクテキスト | 多言語ラベル | 新規作成リンク |
| preview | ツールチップ | 多言語ラベル | プレビューアイコン |
| copyItem | ツールチップ | 多言語ラベル | コピーアイコン |
| areyousuretocopy | 確認 | 多言語ラベル | コピー実行前確認 |
| nogallery | 情報 | 多言語ラベル | ギャラリーが0件の場合 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | bs_security.aspでlogon.hasaccessにより認証チェック、権限なしの場合はログイン画面へリダイレクト |
| ギャラリーが存在しない | 「nogallery」メッセージを表示 |

## 備考

- ギャラリーの埋め込みコードは、テンプレートやページコンテンツ内で使用することで、該当ギャラリーを表示できる
- コピー機能はCSRF対策トークン（QS_secCodeURL）による保護が実装されている
- 顧客ごとにギャラリーが分離されており、他顧客のギャラリーにはアクセスできない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ギャラリーデータを管理するクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスの定義、プロパティ（iId, sName, sCode, sPath等）と主要メソッド（Pick, Save, copy）を確認 |

**読解のコツ**: ASP/VBScriptのクラス定義はClass_Initializeがコンストラクタに相当。decrypt(request("iGalleryID"))でURLパラメータからIDを取得している。

#### Step 2: エントリーポイントを理解する

一覧画面のメイン処理ファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryList.asp | `asp/bs_galleryList.asp` | 一覧画面のメイン処理。セキュリティチェック、コピー処理、一覧表示ループ |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込み、セキュリティチェック（logon.hasaccess）
2. **行5-7**: コピー処理のインスタンス生成と実行、コピー成功時は編集画面へリダイレクト
3. **行8-9**: customer.galleriesで顧客のギャラリー一覧を取得
4. **行9-10**: for eachループでギャラリー一覧を表示

#### Step 3: セキュリティ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | logonオブジェクトのhasaccessメソッドによる権限チェック |
| 3-2 | begin.asp | `asp/begin.asp` | セッション初期化、データベース接続、共通オブジェクト生成 |

#### Step 4: 共通ヘッダー・フッターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_header.asp | `asp/bs_header.asp` | バックサイト共通ヘッダー、メニュー表示 |
| 4-2 | bs_initBack.asp | `asp/bs_initBack.asp` | バックサイト初期化処理 |

### プログラム呼び出し階層図

```
bs_galleryList.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │      └─ 各種共通インクルード
    │
    ├─ bs_security.asp（権限チェック）
    │      └─ logon.hasaccess(secondAdmin.bGallery)
    │
    ├─ cls_gallery.copy()（コピー処理）
    │      └─ gallery.save()
    │
    ├─ customer.galleries（一覧取得）
    │      └─ tblGalleryからSELECT
    │
    └─ bs_endBack.asp / footer.asp（共通フッター）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iGalleryID ───▶ cls_gallery.copy() ───▶ 編集画面へリダイレクト
(コピー時)            │
                     ▼
               tblGallery INSERT

なし ─────────▶ customer.galleries ───▶ 一覧HTML表示
(通常表示)            │
                     ▼
               tblGallery SELECT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | ギャラリー一覧画面メイン |
| gallery.asp | `asp/includes/gallery.asp` | ソース | cls_galleryクラス定義 |
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | ギャラリー編集画面（遷移先） |
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | ギャラリープレビュー画面（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | バックサイトフッター |
