# 画面設計書 32-ギャラリー編集

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるギャラリー編集画面（bs_galleryEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

ギャラリー編集画面は、サイト管理者が画像ギャラリーを新規作成・編集するための画面である。多様なギャラリータイプ（標準、スライドショー、サイクル、Nivoスライダー等）に対応し、各タイプに応じた詳細設定を行える。

**業務上の目的・背景**：Webサイトのビジュアルコンテンツを魅力的に表示するため、様々なギャラリー形式（サムネイル一覧、スライドショー、カルーセル等）をノーコードで設定できる機能が必要である。本画面は、画像の表示方法、サイズ、エフェクト、自動再生などの詳細設定を一元的に管理し、コンテンツ管理者がビジュアル表現を自由にカスタマイズできるようにする。

**画面へのアクセス方法**：
- ギャラリー一覧画面から「新規ギャラリー」リンクをクリック（新規作成）
- ギャラリー一覧画面から既存ギャラリー名をクリック（編集）
- 直接URL：bs_galleryEdit.asp?iGalleryID=暗号化ID

**主要な操作・処理内容**：
1. ギャラリー基本情報の入力（名前、コード、画像パス）
2. ギャラリータイプの選択（標準/スライドショー/サイクル/Nivoスライダー）
3. タイプ別詳細設定（サムネイルサイズ、行あたり画像数、エフェクト等）
4. スペシャルエフェクトの設定（白黒、グレースケール、セピア等）
5. Nivoスライダー使用時のキャプション・URL設定
6. ギャラリーの保存・削除・プレビュー
7. ギャラリー使用箇所の検索・表示

**画面遷移**：
- 遷移元：ギャラリー一覧画面（bs_galleryList.asp）
- 遷移先：ギャラリー一覧画面（保存/削除後）、ギャラリープレビュー画面（bs_galleryPreview.asp）

**権限による表示制御**：secondAdmin.bGalleryがtrueの場合のみアクセス可能。削除ボタンは既存ギャラリー編集時のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | ギャラリー作成・編集 | 主機能 | ギャラリーの作成・画像アップロード・設定 |
| 37 | アセットマネージャー | 補助機能 | 画像ファイルのアップロード管理 |

## 画面種別

登録 / 編集

## URL/ルーティング

`/asp/bs_galleryEdit.asp`

クエリパラメータ：
- `iGalleryID`（暗号化）：編集対象ギャラリーID（新規作成時は省略）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| sName | 入力 | 文字列 | ○ | 50 | ギャラリー名 |
| sCode | 入力 | 文字列 | ○ | 45 | 埋め込み用コード（大文字変換） |
| sPath | 入力（選択） | 文字列 | ○ | - | 画像フォルダパス |
| sType | 入力（選択） | 文字列 | - | - | ギャラリータイプ |
| iSpecialEffect | 入力（選択） | 数値 | - | - | スペシャルエフェクト |
| iThumbSize | 入力（選択） | 数値 | - | - | サムネイルサイズ（10-1920px） |
| iPicsInRow | 入力（選択） | 数値 | - | - | 1行あたりの画像数 |
| iBrowseBy | 入力（選択） | 数値 | - | - | ページあたりの表示数 |
| iFullImageSize | 入力（選択） | 数値 | - | - | フルサイズ画像の最大サイズ |
| bShowFileName | 入力（チェック） | 真偽値 | - | - | ファイル名表示 |
| bFSR | 入力（チェック） | 真偽値 | - | - | 固定サイズリサイズ |
| bAutoStartSS | 入力（チェック） | 真偽値 | - | - | スライドショー自動開始 |
| iSlideShowTimerQS | 入力（選択） | 数値 | - | - | スライドショー間隔（秒） |
| sStyleTable | 入力 | 文字列 | - | 255 | テーブルスタイル |
| sStyleTableCell | 入力 | 文字列 | - | 255 | セルスタイル |
| sStyleImage | 入力 | 文字列 | - | 255 | 画像スタイル |
| sCustomLink | 入力 | 文字列 | - | 255 | カスタムリンク設定 |
| sNextLink | 入力 | 文字列 | - | 200 | 次へリンクテキスト |
| sPreviousLink | 入力 | 文字列 | - | 200 | 前へリンクテキスト |
| sFullImage | 入力 | 文字列 | - | 200 | フルイメージラベル |
| sBorder | 入力（選択） | 数値 | - | - | 画像ボーダー幅 |
| sBorderColor | 入力 | 文字列 | - | - | ボーダー色（カラーピッカー） |
| sWidth | 入力（選択） | 数値 | - | - | スライドショー幅 |
| sHeight | 入力（選択） | 数値 | - | - | スライドショー高さ |
| sCycleEffect | 入力（選択） | 文字列 | - | - | サイクルエフェクト |
| sNSCss | 入力（選択） | 文字列 | - | - | Nivoスライダースタイル |
| bNSControlNav | 入力（チェック） | 真偽値 | - | - | Nivoコントロールナビ表示 |
| bNSdirectionNav | 入力（チェック） | 真偽値 | - | - | Nivo方向ナビ表示 |
| iSortImagesBy | 入力（選択） | 数値 | - | - | 画像ソート順 |
| bOpenInNewWindow | 入力（チェック） | 真偽値 | - | - | 新規ウィンドウで開く |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 使用箇所一覧 | HTML | ギャラリーが使用されているページ一覧（既存ギャラリーのみ） |
| 画像一覧（Nivo） | HTML | Nivoスライダー時の画像・キャプション・URL設定 |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークンチェック（checkCSRF()）
2. フォーム値をgallery.getRequestValues()で取得
3. gallery.check()でバリデーション
4. gallery.save()でデータベース保存
5. ギャラリー一覧画面へリダイレクト

### 2-プレビューボタン押下

1. CSRFトークンチェック
2. フォーム値取得・バリデーション
3. 保存処理
4. プレビュー画面（bs_galleryPreview.asp?iGalleryID=暗号化ID）へリダイレクト

### 3-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. CSRFトークンチェック
3. gallery.remove()でデータベースから削除
4. ギャラリー一覧画面へリダイレクト

### 4-画像パス選択変更

フォームを自動送信し、選択したパスに基づく画面再描画を行う。

### 5-ギャラリータイプ選択変更

フォームを自動送信し、選択したタイプに応じた設定項目を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示（編集） | tblGallery | SELECT | 既存ギャラリー情報を取得 |
| 保存（新規） | tblGallery | INSERT | 新規ギャラリーレコード作成 |
| 保存（更新） | tblGallery | UPDATE | 既存ギャラリーレコード更新 |
| 削除 | tblGallery | DELETE | ギャラリーレコード削除 |
| コード重複チェック | tblGallery | SELECT | 同一コードの存在確認 |

### テーブル別更新項目詳細

#### tblGallery

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値（最大50文字） | 必須 |
| INSERT/UPDATE | sCode | フォーム入力値（大文字変換） | 必須、一意性チェック |
| INSERT/UPDATE | sPath | フォーム選択値 | 必須 |
| INSERT/UPDATE | sType | フォーム選択値 | ギャラリータイプ |
| INSERT/UPDATE | iThumbSize | フォーム選択値 | サムネイルサイズ |
| INSERT/UPDATE | iFullImageSize | フォーム選択値 | フルサイズ |
| INSERT/UPDATE | iPicsInRow | フォーム選択値 | 行あたり画像数 |
| INSERT/UPDATE | iBrowseBy | フォーム選択値 | ページあたり表示数 |
| INSERT/UPDATE | bShowFileName | フォームチェック値 | ファイル名表示 |
| INSERT/UPDATE | bFSR | フォームチェック値 | 固定サイズリサイズ |
| INSERT/UPDATE | bAutoStartSS | フォームチェック値 | 自動開始 |
| INSERT/UPDATE | iSlideShowTimerQS | フォーム選択値 | 間隔秒数 |
| INSERT/UPDATE | iSpecialEffect | フォーム選択値 | エフェクト |
| INSERT/UPDATE | sCycleEffect | フォーム選択値 | サイクルエフェクト |
| INSERT/UPDATE | sWidth | フォーム選択値 | 幅 |
| INSERT/UPDATE | sHeight | フォーム選択値 | 高さ |
| INSERT/UPDATE | sBorder | フォーム選択値 | ボーダー幅 |
| INSERT/UPDATE | sBorderColor | フォーム入力値 | ボーダー色 |
| INSERT/UPDATE | sStyleTable | フォーム入力値 | テーブルスタイル |
| INSERT/UPDATE | sStyleImage | フォーム入力値 | 画像スタイル |
| INSERT/UPDATE | sStyleTableCell | フォーム入力値 | セルスタイル |
| INSERT/UPDATE | sCustomLink | フォーム入力値 | カスタムリンク |
| INSERT/UPDATE | sNextLink | フォーム入力値 | 次へリンク |
| INSERT/UPDATE | sPreviousLink | フォーム入力値 | 前へリンク |
| INSERT/UPDATE | sFullImage | フォーム入力値 | フルイメージラベル |
| INSERT/UPDATE | bOpenInNewWindow | フォームチェック値 | 新規ウィンドウ |
| INSERT/UPDATE | iSortImagesBy | フォーム選択値 | ソート順 |
| INSERT/UPDATE | sNSCss | フォーム選択値 | Nivoスタイル |
| INSERT/UPDATE | bNSControlNav | フォームチェック値 | Nivoコントロール |
| INSERT/UPDATE | bNSdirectionNav | フォームチェック値 | Nivo方向 |
| INSERT/UPDATE | sNSImgLinks | 動的生成 | Nivo画像リンク情報 |
| INSERT/UPDATE | iCustomerID | セッション値（cId） | 顧客ID |
| INSERT | dCreatedTS | now() | 作成日時 |
| DELETE | - | iId=対象ID | レコード削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 必須項目が未入力 | バリデーションエラー |
| err_doublefeed | エラー | コードが重複 | 同一コードが存在 |
| areyousure | 確認 | 削除確認 | 削除ボタン押下時 |
| general | ラベル | 一般設定セクション | 画面表示 |
| advanced | ラベル | 詳細設定セクション | 画面表示 |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| wheregalleryused | 情報 | 使用箇所見出し | 既存ギャラリー編集時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| 必須項目未入力 | err_mandatoryメッセージ表示、保存処理中断 |
| コード重複 | err_doublefeedメッセージ表示、保存処理中断 |
| 画像フォルダ不存在 | 画像パス選択後にアセットマネージャーリンク非表示 |

## 備考

- ギャラリータイプにより表示される設定項目が動的に変化する
- Nivoスライダー（QS_gallery_NS）選択時は、各画像にキャプションとURLを設定可能
- カスタムリンクで使用可能な変数：[FILENAME], [COUNTER], [PAGEID]
- 画像ソート順オプション：名前、作成日（新しい順/古い順）、更新日（新しい順/古い順）、ランダム
- 保存後、Application変数にキャッシュされたギャラリー情報がクリアされる（customer.cacheGalleries()）
- ギャラリー使用箇所検索はcls_fullSearchクラスによる正規表現検索

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスの全プロパティ（約40個）、Save/Check/getRequestValuesメソッド |
| 1-2 | galleryTypeList.asp | `asp/includes/galleryTypeList.asp` | ギャラリータイプの選択肢定義 |
| 1-3 | gallerySEList.asp | `asp/includes/gallerySEList.asp` | スペシャルエフェクトの選択肢定義 |

**読解のコツ**: getRequestValues()メソッドでフォーム値の取得処理、check()メソッドでバリデーション、save()メソッドで保存処理を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | メイン処理フロー、ギャラリータイプ別の表示分岐 |

**主要処理フロー**:
1. **行4-12**: セッション初期化、ギャラリーインスタンス生成、postBack判定
2. **行15-30**: btnactionによる処理分岐（save/delete/preview）
3. **行31-38**: 補助オブジェクト生成（fileexplorer, typeList等）
4. **行40-107**: フォームHTML生成（タイプ別条件分岐）
5. **行109-177**: Nivoスライダー用の画像一覧・キャプション設定
6. **行183-194**: ギャラリー使用箇所検索・表示

#### Step 3: タイプ別表示ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_galleryEdit.asp 行50-106 | `asp/bs_galleryEdit.asp` | select case sTypeによるタイプ別設定項目の出し分け |

**タイプ別分岐**:
- QS_gallery_SS（スライドショー）：最大画像サイズ、ボーダー設定
- QS_gallery_SC（サイクル）：サイクルエフェクト設定
- QS_gallery_NS（Nivoスライダー）：スタイル、ナビ設定、画像別キャプション
- それ以外（標準）：サムネイル、ブラウズ設定、スタイル設定

#### Step 4: 使用箇所検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_galleryEdit.asp 行183-194 | `asp/bs_galleryEdit.asp` | cls_fullSearchによる正規表現検索 |

### プログラム呼び出し階層図

```
bs_galleryEdit.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bGallery)
    │
    ├─ cls_gallery（インスタンス生成）
    │      ├─ pick()（既存データ読込）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存）
    │      │      └─ customer.cacheGalleries()（キャッシュ更新）
    │      └─ remove()（削除）
    │
    ├─ cls_fileexplorer（フォルダ選択）
    │      └─ SelectBoxFolders()
    │
    ├─ cls_galleryTypeList（タイプ選択肢）
    ├─ cls_gallerySEList（エフェクト選択肢）
    ├─ cls_galleryCycleList（サイクル選択肢）
    │
    └─ cls_fullSearch（使用箇所検索）
           └─ search()
```

### データフロー図

```
[入力]               [処理]                    [出力]

iGalleryID ───▶ cls_gallery.pick() ───▶ フォーム表示
(クエリ)              │
                     ▼
               tblGallery SELECT

フォーム値 ───▶ getRequestValues() ───▶ プロパティ設定
                     │
                     ▼
               check()（バリデーション）
                     │
                     ▼
               save()
                     │
                     ▼
               tblGallery INSERT/UPDATE
                     │
                     ▼
               一覧画面/プレビューへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | ギャラリー編集画面メイン |
| gallery.asp | `asp/includes/gallery.asp` | ソース | cls_galleryクラス定義 |
| galleryTypeList.asp | `asp/includes/galleryTypeList.asp` | ソース | タイプ選択肢 |
| gallerySEList.asp | `asp/includes/gallerySEList.asp` | ソース | エフェクト選択肢 |
| bs_galleryBack.asp | `asp/bs_galleryBack.asp` | ソース | 一覧へ戻るリンク |
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | 一覧画面（遷移先） |
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | プレビュー画面（遷移先） |
