# 画面設計書 33-ギャラリープレビュー

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるギャラリープレビュー画面（bs_galleryPreview.asp）の設計仕様を定義する。

### 本画面の処理概要

ギャラリープレビュー画面は、サイト管理者が設定したギャラリーの表示結果を、公開前に確認するためのプレビュー画面である。

**業務上の目的・背景**：ギャラリーの設定変更後、実際にサイト上でどのように表示されるかを事前に確認することは、品質管理上重要である。本画面は、設定変更の結果をリアルタイムで確認できる環境を提供し、公開前の品質確認を可能にする。

**画面へのアクセス方法**：
- ギャラリー一覧画面からプレビューアイコンをクリック
- ギャラリー編集画面からプレビューボタンをクリック
- 直接URL：bs_galleryPreview.asp?iGalleryID=暗号化ID

**主要な操作・処理内容**：
1. 指定されたギャラリーのプレビュー表示（ギャラリー設定に基づくHTML生成）
2. 戻るリンクによる一覧画面への遷移
3. 編集ボタンによる編集画面への遷移

**画面遷移**：
- 遷移元：ギャラリー一覧画面（bs_galleryList.asp）、ギャラリー編集画面（bs_galleryEdit.asp）
- 遷移先：ギャラリー一覧画面、ギャラリー編集画面

**権限による表示制御**：secondAdmin.bGalleryがtrueの場合のみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | ギャラリープレビュー | 主機能 | ギャラリー表示のプレビュー |

## 画面種別

詳細（プレビュー表示）

## URL/ルーティング

`/asp/bs_galleryPreview.asp`

クエリパラメータ：
- `iGalleryID`（暗号化）：プレビュー対象ギャラリーID（必須）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iGalleryID | 入力（クエリ） | 暗号化数値 | ○ | プレビュー対象ギャラリーID |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 戻るリンク | HTML | ギャラリー一覧画面へのリンク |
| ギャラリープレビュー | HTML | gallery.build()で生成されたギャラリー表示 |
| 編集ボタン | ボタン | ギャラリー編集画面へのリンクボタン |

## イベント仕様

### 1-戻るリンククリック

ギャラリー一覧画面（bs_galleryList.asp）へ遷移する。

### 2-編集ボタンクリック

ギャラリー編集画面（bs_galleryEdit.asp?iGalleryID=暗号化ID）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblGallery | SELECT | ギャラリー情報を取得 |

### テーブル別更新項目詳細

#### tblGallery

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=対象ギャラリーID | プレビュー表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| back | リンクテキスト | 多言語ラベル | 戻るリンク |
| modify | ボタンテキスト | 多言語ラベル | 編集ボタン |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| ギャラリーID不正 | ギャラリーが存在しない場合、空のプレビューが表示される |
| 画像フォルダ不存在 | gallery.build()内でエラーメッセージを表示 |

## 備考

- プレビューモードでは、gallery.backsitePV=trueが設定され、一部の動作がプレビュー用に調整される
- ナビゲーションリンク（次へ/前へ）はプレビューモードでは非表示
- gallery.build()メソッドがギャラリータイプに応じたHTML出力を生成
- treatconstants()関数でテンプレート変数が展開される
- Nivoスライダー使用時はincludeNS=trueが設定され、必要なJavaScript/CSSがインクルードされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gallery.asp | `asp/includes/gallery.asp` | cls_galleryクラスのbuild()メソッド（行289-677）を重点的に確認 |

**読解のコツ**: build()メソッドは約400行あり、ギャラリータイプ（標準/スライドショー/サイクル/Nivo）ごとに異なるHTML生成ロジックを持つ。sType変数で分岐している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | 非常にシンプルな構造（7行程度）、gallery.backsitePV設定とbuild()呼び出し |

**主要処理フロー**:
1. **行2**: includeNS=trueでNivoスライダー用ライブラリを有効化
2. **行4-6**: ギャラリーインスタンス生成、backsitePV=true設定
3. **行7**: treatconstants(gallery.build(),true)でHTML生成・変数展開

#### Step 3: build()メソッドの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gallery.asp 行289-400 | `asp/includes/gallery.asp` | ファイルシステム操作、画像ループ処理 |
| 3-2 | gallery.asp 行400-550 | `asp/includes/gallery.asp` | スライドショー用HTML生成 |
| 3-3 | gallery.asp 行580-650 | `asp/includes/gallery.asp` | タイプ別HTML組み立て（NS/SC/SS） |

**タイプ別出力**:
- **標準**: サムネイル一覧テーブル + lightbox連携
- **QS_gallery_SS**: JavaScript fadeshow
- **QS_gallery_SC**: jQuery cycle
- **QS_gallery_NS**: Nivo Slider

### プログラム呼び出し階層図

```
bs_galleryPreview.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bGallery)
    │
    ├─ cls_gallery（インスタンス生成）
    │      ├─ pick()（データ読込）
    │      │      └─ tblGallery SELECT
    │      │
    │      └─ build()（HTML生成）
    │             ├─ FileSystemObject（画像一覧取得）
    │             ├─ SortDictionary2（画像ソート）
    │             └─ タイプ別HTML生成
    │
    └─ treatconstants()（変数展開）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iGalleryID ───▶ cls_gallery.pick() ───▶ プロパティ設定
(クエリ)              │
                     ▼
               tblGallery SELECT
                     │
                     ▼
               gallery.build()
                     │
                     ├─ 画像フォルダ読込
                     ├─ 画像ソート
                     └─ タイプ別HTML生成
                     │
                     ▼
               treatconstants()
                     │
                     ▼
               ギャラリープレビューHTML表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_galleryPreview.asp | `asp/bs_galleryPreview.asp` | ソース | プレビュー画面メイン |
| gallery.asp | `asp/includes/gallery.asp` | ソース | cls_galleryクラス、build()メソッド |
| bs_galleryList.asp | `asp/bs_galleryList.asp` | ソース | 一覧画面（遷移先） |
| bs_galleryEdit.asp | `asp/bs_galleryEdit.asp` | ソース | 編集画面（遷移先） |
| header.asp | `asp/includes/header.asp` | ソース | HTMLヘッダー（Nivo CSS/JS含む） |
