# 画面設計書 34-カタログ一覧

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログ一覧画面（bs_catalogList.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログ一覧画面は、サイト管理者が登録済みのカタログ（商品カタログ、製品一覧等）を一覧表示・管理するための画面である。カタログごとのフィールド定義やファイルタイプ定義も確認・編集できる。

**業務上の目的・背景**：ECサイトや製品紹介サイトにおいて、商品・製品情報を構造化して管理するカタログ機能は重要である。本画面は、複数のカタログを一元管理し、各カタログのフィールド構造（カスタム項目）やファイルタイプ（添付ファイル種別）を定義・管理できるようにする。これにより、柔軟な商品データ管理が可能となる。

**画面へのアクセス方法**：バックサイトにログイン後、メインメニューから「Catalog」ボタンをクリックするか、直接URLでbs_catalogList.aspにアクセスする。secondAdmin権限でカタログ管理権限（bCatalog）が必要。

**主要な操作・処理内容**：
1. 登録済みカタログの一覧表示
2. 各カタログに定義されたフィールド一覧の表示
3. 各カタログに定義されたファイルタイプ一覧の表示
4. カタログフィールドの並び順変更（上へ/下へ）
5. 新規カタログ作成画面への遷移
6. 既存カタログの編集画面への遷移
7. カタログアイテム一覧画面への遷移
8. 新規カタログアイテム作成画面への遷移
9. 新規フィールド・ファイルタイプ追加画面への遷移

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、バックサイトヘッダーメニュー
- 遷移先：カタログ編集画面（bs_catalogEdit.asp）、カタログフィールド編集画面（bs_catalogFieldEdit.asp）、カタログファイルタイプ編集画面（bs_catalogFileTypeEdit.asp）、カタログアイテム編集画面（bs_catalogItemEdit.asp）、カタログアイテム検索画面（bs_catalogItemSearch.asp）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | カタログ一覧 | 主機能 | 登録済みカタログの一覧表示 |
| 46 | カタログ作成・編集 | 遷移先機能 | 新規カタログ作成画面への遷移 |
| 47 | カタログフィールド管理 | 遷移先機能 | カタログフィールド編集画面への遷移 |
| 49 | カタログアイテム検索 | 遷移先機能 | カタログアイテム一覧・検索画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`/asp/bs_catalogList.asp`

クエリパラメータ：
- `iFieldID`（暗号化）：フィールド並び順変更時の対象フィールドID
- `btnaction`：処理種別（MoveUP/MoveDOWN）
- `QS_secCode`：CSRF対策トークン

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iFieldID | 入力（クエリ） | 暗号化数値 | - | 並び順変更対象フィールドID |
| btnaction | 入力（クエリ） | 文字列 | - | MoveUP/MoveDOWN |
| QS_secCode | 入力（クエリ） | 文字列 | - | CSRF対策トークン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| カタログ名 | 文字列 | カタログの名称（編集画面へのリンク） |
| カタログID | 数値 | システム内部のカタログID |
| フィールド一覧 | HTML | カタログに定義されたフィールドの一覧 |
| ファイルタイプ一覧 | HTML | カタログに定義されたファイルタイプの一覧 |
| 新規アイテムリンク | リンク | カタログアイテム作成画面へのリンク |
| 一覧リンク | リンク | カタログアイテム検索画面へのリンク |
| 上へ/下へアイコン | アイコン | フィールド並び順変更アイコン |
| 新規フィールドリンク | リンク | フィールド追加画面へのリンク |
| 新規タイプリンク | リンク | ファイルタイプ追加画面へのリンク |

## イベント仕様

### 1-新規カタログ作成リンククリック

カタログ編集画面（bs_catalogEdit.asp）に遷移し、新規カタログ作成モードで表示する。

### 2-カタログ名リンククリック

選択したカタログの編集画面（bs_catalogEdit.asp?iCatalogID=暗号化ID）に遷移する。

### 3-新規アイテムリンククリック

カタログアイテム編集画面（bs_catalogItemEdit.asp?iCatalogID=暗号化ID）に遷移する。フィールドが1件以上定義されている場合のみ表示される。

### 4-一覧リンククリック

カタログアイテム検索画面（bs_catalogItemSearch.asp?iCatalogID=暗号化ID）に遷移する。フィールドが1件以上定義されている場合のみ表示される。

### 5-フィールド名リンククリック

カタログフィールド編集画面（bs_catalogFieldEdit.asp?iFieldID=暗号化ID）に遷移する。

### 6-上へアイコンクリック

CSRFトークンチェック後、対象フィールドの並び順を1つ上に移動する（catalogField.moveUp()）。

### 7-下へアイコンクリック

CSRFトークンチェック後、対象フィールドの並び順を1つ下に移動する（catalogField.moveDown()）。

### 8-新規フィールドリンククリック

カタログフィールド編集画面（bs_catalogFieldEdit.asp?iCatalogID=暗号化ID）に遷移する。

### 9-ファイルタイプ名リンククリック

カタログファイルタイプ編集画面（bs_catalogFileTypeEdit.asp?iFileTypeID=暗号化ID）に遷移する。

### 10-新規タイプリンククリック

カタログファイルタイプ編集画面（bs_catalogFileTypeEdit.asp?iCatalogID=暗号化ID）に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCatalog | SELECT | 顧客のカタログ一覧を取得 |
| 画面表示 | tblCatalogField | SELECT | カタログのフィールド一覧を取得 |
| 画面表示 | tblCatalogFileType | SELECT | カタログのファイルタイプ一覧を取得 |
| 上へアイコン | tblCatalogField | UPDATE | フィールドの並び順を更新 |
| 下へアイコン | tblCatalogField | UPDATE | フィールドの並び順を更新 |

### テーブル別更新項目詳細

#### tblCatalogField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE (MoveUP) | iRang | iRang-1 | 対象フィールド |
| UPDATE (MoveUP) | iRang | iRang+1 | 入れ替え対象フィールド |
| UPDATE (MoveDOWN) | iRang | iRang+1 | 対象フィールド |
| UPDATE (MoveDOWN) | iRang | iRang-1 | 入れ替え対象フィールド |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| newcatalog | リンクテキスト | 多言語ラベル | 新規作成リンク |
| newitem | リンクテキスト | 多言語ラベル | 新規アイテムリンク |
| list | リンクテキスト | 多言語ラベル | 一覧リンク |
| fields | 見出し | 多言語ラベル | フィールドセクション |
| attachments | 見出し | 多言語ラベル | ファイルタイプセクション |
| newfield | リンクテキスト | 多言語ラベル | 新規フィールドリンク |
| newtype | リンクテキスト | 多言語ラベル | 新規タイプリンク |
| up | ツールチップ | 多言語ラベル | 上へアイコン |
| down | ツールチップ | 多言語ラベル | 下へアイコン |
| nocatalogs | 情報 | 多言語ラベル | カタログが0件の場合 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| カタログが存在しない | 「nocatalogs」メッセージを表示 |

## 備考

- カタログごとにフィールド構造を自由に定義できる（動的スキーマ）
- フィールドタイプ：テキスト、テキストエリア、チェックボックス、セレクトボックス、日付、リッチテキスト、URL、メール等
- ファイルタイプ：カタログアイテムに添付可能なファイル種別を定義
- フィールドが1件以上定義されていないと、カタログアイテムの作成・一覧表示ができない
- 並び順変更はCSRF対策トークンによる保護が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスの定義、fields()とfiletypes()メソッド |
| 1-2 | catalogField.asp | `asp/includes/catalogField.asp` | cls_catalogFieldクラスの定義、moveUp()/moveDown()メソッド |
| 1-3 | catalogFileType.asp | `asp/includes/catalogFileType.asp` | cls_catalogFileTypeクラスの定義 |

**読解のコツ**: catalog.fields("")でフィールド一覧取得、catalog.filetypes()でファイルタイプ一覧取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogList.asp | `asp/bs_catalogList.asp` | メイン処理。セキュリティ、並び順変更、カタログループ |

**主要処理フロー**:
1. **行4**: セキュリティチェック（logon.hasaccess secondAdmin.bCatalog）
2. **行5-13**: フィールド並び順変更処理（MoveUP/MoveDOWN）
3. **行14-15**: customer.catalogsでカタログ一覧取得
4. **行16-22**: for eachループでカタログごとにフィールド・ファイルタイプを表示

#### Step 3: 並び順変更ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogField.asp 行139-157 | `asp/includes/catalogField.asp` | moveUp()/moveDown()メソッドの実装 |

**処理詳細**:
- moveUp(): iRangが1の場合は何もしない、それ以外は自身を-1、上のフィールドを+1
- moveDown(): iRangがフィールド数と同じ場合は何もしない、それ以外は自身を+1、下のフィールドを-1

### プログラム呼び出し階層図

```
bs_catalogList.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalogField（並び順変更）
    │      ├─ pick()（フィールド読込）
    │      ├─ moveUp()
    │      └─ moveDown()
    │
    ├─ customer.catalogs（カタログ一覧取得）
    │      └─ tblCatalog SELECT
    │
    ├─ catalog.fields("")（フィールド一覧取得）
    │      └─ tblCatalogField SELECT
    │
    └─ catalog.fileTypes（ファイルタイプ一覧取得）
           └─ tblCatalogFileType SELECT
```

### データフロー図

```
[入力]               [処理]                    [出力]

iFieldID ───▶ cls_catalogField.pick() ───▶ フィールド特定
btnaction          │
(MoveUP/          ├─ moveUp()
 MoveDOWN)        └─ moveDown()
                       │
                       ▼
                  tblCatalogField UPDATE

なし ─────────▶ customer.catalogs ───▶ カタログ一覧
(通常表示)            │                     │
                     ▼                     ▼
               tblCatalog SELECT    catalog.fields("")
                                          │
                                          ▼
                                    フィールド一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | カタログ一覧画面メイン |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス定義 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | cls_catalogFieldクラス定義 |
| catalogFileType.asp | `asp/includes/catalogFileType.asp` | ソース | cls_catalogFileTypeクラス定義 |
| bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | ソース | カタログ編集画面（遷移先） |
| bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | ソース | フィールド編集画面（遷移先） |
| bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | ソース | ファイルタイプ編集画面（遷移先） |
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | アイテム検索画面（遷移先） |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | アイテム編集画面（遷移先） |
