# 画面設計書 35-カタログ編集

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログ編集画面（bs_catalogEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログ編集画面は、サイト管理者がカタログ（商品カタログ、製品一覧等）を新規作成・編集するための画面である。カタログの基本設定、表示設定、RSS出力テンプレート、アイテム表示テンプレートなどを設定できる。

**業務上の目的・背景**：ECサイトや製品紹介サイトにおいて、商品・製品カタログの表示形式や動作を柔軟に設定できることが重要である。本画面は、カタログの基本情報、ページング、サムネイル自動生成、RSS配信、フォーム連携などの詳細設定を一元的に管理できるようにする。

**画面へのアクセス方法**：
- カタログ一覧画面から「新規カタログ」リンクをクリック（新規作成）
- カタログ一覧画面から既存カタログ名をクリック（編集）
- 直接URL：bs_catalogEdit.asp?iCatalogID=暗号化ID

**主要な操作・処理内容**：
1. カタログ基本情報の入力（名前、アイテム名、オンライン状態等）
2. RSS配信設定
3. サムネイル自動生成設定
4. ページサイズ設定
5. フォーム連携設定
6. ソート順設定
7. RSS出力テンプレートの編集（3種類）
8. アイテム表示テンプレートの編集
9. カタログの保存・削除

**画面遷移**：
- 遷移元：カタログ一覧画面（bs_catalogList.asp）
- 遷移先：カタログ一覧画面（削除後）、同画面リロード（保存後）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。削除ボタンは既存カタログ編集時のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 46 | カタログ作成・編集 | 主機能 | カタログの基本設定 |

## 画面種別

登録 / 編集

## URL/ルーティング

`/asp/bs_catalogEdit.asp`

クエリパラメータ：
- `iCatalogID`（暗号化）：編集対象カタログID（新規作成時は省略）
- `fbMessage`：保存成功時のフィードバックメッセージ

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| sName | 入力 | 文字列 | ○ | 255 | カタログ名 |
| sItemName | 入力 | 文字列 | ○ | 50 | アイテム名称（商品、製品等） |
| bOnline | 入力（チェック） | 真偽値 | - | - | オンライン状態 |
| bPushRSS | 入力（チェック） | 真偽値 | - | - | RSS配信有効 |
| bSearchable | 入力（チェック） | 真偽値 | - | - | 検索対象 |
| bAutoThumb | 入力（チェック） | 真偽値 | - | - | サムネイル自動生成 |
| iMaxThumbSize | 入力（選択） | 数値 | - | - | サムネイル最大サイズ（10-1000px） |
| sResizePicTo | 入力（選択） | 数値 | - | - | フルサイズ画像リサイズ（480-2800px） |
| sFullImage | 入力 | 文字列 | - | 200 | フルイメージラベル |
| bUseShadow | 入力（チェック） | 真偽値 | - | - | 影エフェクト使用 |
| sOrderItemsBy | 入力（選択） | 文字列 | - | - | ソート順 |
| iPageSize | 入力（選択） | 数値 | - | - | ページサイズ（1-100） |
| iFormID | 入力（選択） | 暗号化数値 | - | - | 連携フォームID |
| sFormTitle | 入力 | 文字列 | 条件付き | - | フォームリンクテキスト |
| sFilePath | 入力（選択） | 文字列 | - | - | 添付ファイルパス |
| sItemView | 入力（テキストエリア） | 文字列 | - | - | アイテム表示テンプレート |
| sRSSView1 | 入力（テキストエリア） | 文字列 | - | - | RSS表示テンプレート1 |
| sRSSView2 | 入力（テキストエリア） | 文字列 | - | - | RSS表示テンプレート2 |
| sRSSView3 | 入力（テキストエリア） | 文字列 | - | - | RSS表示テンプレート3 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 新規アイテムリンク | リンク | フィールドが1件以上ある場合に表示 |
| 一覧リンク | リンク | フィールドが1件以上ある場合に表示 |
| 新規フィールドリンク | リンク | カタログIDが存在しフィールドが0件の場合に表示 |
| テンプレート変数一覧 | テキスト | 使用可能な変数（{ITEMENCID}, {ITEMTITLE}等） |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークンチェック（checkCSRF()）
2. フォーム値をcatalog.getRequestValues()で取得
3. catalog.check()でバリデーション
4. catalog.save()でデータベース保存
5. 同画面をリロード（fbMessage=fb_saveOK付き）

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. CSRFトークンチェック
3. catalog.remove()でデータベースから削除（関連アイテム・フィールド・ファイルタイプも削除）
4. カタログ一覧画面へリダイレクト

### 3-サムネイル自動生成チェック変更

チェック状態変更時にフォームを自動送信し、関連設定項目の表示/非表示を切り替える。

### 4-フォーム選択変更

フォーム選択変更時にフォームを自動送信し、フォームリンクテキスト入力欄の表示/非表示を切り替える。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示（編集） | tblCatalog | SELECT | 既存カタログ情報を取得 |
| 画面表示 | tblCatalogField | SELECT | フィールド一覧を取得（表示制御用） |
| 保存（新規） | tblCatalog | INSERT | 新規カタログレコード作成 |
| 保存（更新） | tblCatalog | UPDATE | 既存カタログレコード更新 |
| 削除 | tblCatalog | DELETE | カタログレコード削除 |
| 削除 | tblCatalogItem | DELETE | 関連アイテム削除 |
| 削除 | tblCatalogField | DELETE | 関連フィールド削除 |
| 削除 | tblCatalogFileType | DELETE | 関連ファイルタイプ削除 |
| 削除 | tblPage | UPDATE | 関連ページのiCatalogIDをnullに更新 |

### テーブル別更新項目詳細

#### tblCatalog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | 必須 |
| INSERT/UPDATE | sItemName | フォーム入力値 | 必須 |
| INSERT/UPDATE | bOnline | フォームチェック値 | オンライン状態 |
| INSERT/UPDATE | bPushRSS | フォームチェック値 | RSS配信 |
| INSERT/UPDATE | bSearchable | フォームチェック値 | 検索対象 |
| INSERT/UPDATE | bAutoThumb | フォームチェック値 | サムネイル自動生成 |
| INSERT/UPDATE | iMaxThumbSize | フォーム選択値 | サムネイルサイズ |
| INSERT/UPDATE | sResizePicTo | フォーム選択値 | フルサイズリサイズ |
| INSERT/UPDATE | sFullImage | フォーム入力値 | フルイメージラベル |
| INSERT/UPDATE | bUseShadow | フォームチェック値 | 影エフェクト |
| INSERT/UPDATE | sOrderItemsBy | フォーム選択値 | ソート順 |
| INSERT/UPDATE | iPageSize | フォーム選択値 | ページサイズ |
| INSERT/UPDATE | iFormID | フォーム選択値（復号化） | フォームID |
| INSERT/UPDATE | sFormTitle | フォーム入力値 | フォームリンクテキスト |
| INSERT/UPDATE | sFilePath | フォーム選択値 | 添付ファイルパス |
| INSERT/UPDATE | sItemView | フォーム入力値 | アイテム表示テンプレート |
| INSERT/UPDATE | sRSSView1 | フォーム入力値 | RSSテンプレート1 |
| INSERT/UPDATE | sRSSView2 | フォーム入力値 | RSSテンプレート2 |
| INSERT/UPDATE | sRSSView3 | フォーム入力値 | RSSテンプレート3 |
| INSERT/UPDATE | iCustomerID | セッション値（cId） | 顧客ID |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| INSERT | dCreatedTS | now() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 必須項目が未入力 | バリデーションエラー |
| areyousure | 確認 | 削除確認 | 削除ボタン押下時 |
| general | ラベル | 一般設定セクション | 画面表示 |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| fb_saveOK | 成功 | 保存成功 | 保存完了後 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| 必須項目未入力 | err_mandatoryメッセージ表示、保存処理中断 |
| フォーム選択時にsFormTitle未入力 | err_mandatoryメッセージ表示 |

## 備考

- テンプレート変数として使用可能: {ITEMENCID}, {ITEMTITLE}, {ITEMDATE}, {ITEMPICTURE}, {フィールド名（大文字）}, {ファイルタイプ名（大文字）}
- RSSビューは3種類定義可能、URLパラメータviewtype=1/2/3で切り替え
- カタログ削除時は関連する全データ（アイテム、フィールド、ファイルタイプ、アイテムファイル、フォーム送信データ）も削除される
- 削除後、関連ページのiCatalogIDはnullに更新される
- サムネイル自動生成はQS_ASPXがtrueの場合のみ有効（.NET環境依存）
- 保存後、RSSキャッシュがクリアされる（clearRSSCache()）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスの全プロパティ、Save/Check/getRequestValues/removeメソッド |

**読解のコツ**: remove()メソッド（行201-227）で関連データの削除順序を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | メイン処理フロー、条件分岐による表示制御 |

**主要処理フロー**:
1. **行4-10**: セキュリティチェック、インスタンス生成、postBack判定
2. **行11-20**: btnactionによる処理分岐（save/delete）
3. **行21-28**: 補助オブジェクト生成（fileexplorer, orderByList等）
4. **行28-41**: フォームHTML生成（条件分岐あり）

#### Step 3: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalog.asp 行201-227 | `asp/includes/catalog.asp` | remove()メソッド - 関連データ削除のカスケード処理 |

**削除順序**:
1. 関連アイテムの削除（各アイテムのremove()呼び出し）
2. 関連フィールドの削除
3. 関連ファイルタイプの削除
4. 関連ページのiCatalogIDをnullに更新
5. tblCatalogItemから削除
6. tblCatalogから削除

### プログラム呼び出し階層図

```
bs_catalogEdit.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalog（インスタンス生成）
    │      ├─ pick()（既存データ読込）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()
    │      │      └─ clearRSSCache()（キャッシュクリア）
    │      └─ remove()
    │             ├─ items().remove()（各アイテム削除）
    │             ├─ fields().remove()（各フィールド削除）
    │             └─ filetypes().remove()（各タイプ削除）
    │
    ├─ cls_fileexplorer（フォルダ選択）
    ├─ cls_catalogOrderByList（ソート選択肢）
    │
    └─ bs_backCatalog.asp（戻るリンク）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iCatalogID ───▶ cls_catalog.pick() ───▶ フォーム表示
(クエリ)              │
                     ▼
               tblCatalog SELECT

フォーム値 ───▶ getRequestValues() ───▶ プロパティ設定
                     │
                     ▼
               check()（バリデーション）
                     │
                     ▼
               save() / remove()
                     │
                     ▼
               tblCatalog INSERT/UPDATE/DELETE
               （関連テーブル操作含む）
                     │
                     ▼
               同画面リロード / 一覧へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogEdit.asp | `asp/bs_catalogEdit.asp` | ソース | カタログ編集画面メイン |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス定義 |
| catalogOrderByList.asp | `asp/includes/catalogOrderByList.asp` | ソース | ソート順選択肢 |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | ソース | 戻るリンク |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | 一覧画面（遷移先） |
| bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | ソース | フィールド編集画面（遷移先） |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | アイテム編集画面（遷移先） |
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | アイテム検索画面（遷移先） |
