# 画面設計書 36-カタログフィールド編集

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログフィールド編集画面（bs_catalogFieldEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログフィールド編集画面は、サイト管理者がカタログのフィールド（カスタム項目）を新規作成・編集するための画面である。フィールドのタイプ、必須設定、検索対象設定などを設定できる。

**業務上の目的・背景**：カタログ機能において、商品・製品ごとに異なる属性（価格、サイズ、色など）を柔軟に定義できることが重要である。本画面は、カタログのスキーマ（データ構造）をノーコードで定義できるようにし、様々な商品カテゴリに対応したカタログ構築を可能にする。

**画面へのアクセス方法**：
- カタログ一覧画面から「新規フィールド」リンクをクリック（新規作成）
- カタログ一覧画面から既存フィールド名をクリック（編集）
- 直接URL：bs_catalogFieldEdit.asp?iFieldID=暗号化ID（編集）
- 直接URL：bs_catalogFieldEdit.asp?iCatalogID=暗号化ID（新規作成）

**主要な操作・処理内容**：
1. フィールド基本情報の入力（名前、タイプ）
2. セレクトボックス選択時の選択肢入力
3. 公開フィールド設定
4. 必須フィールド設定
5. 検索対象フィールド設定
6. フィールドの保存・削除

**画面遷移**：
- 遷移元：カタログ一覧画面（bs_catalogList.asp）
- 遷移先：カタログ一覧画面（保存/削除後）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。削除ボタンは既存フィールド編集時かつカタログにフィールドが2件以上ある場合のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | カタログフィールド管理 | 主機能 | カタログ項目のカスタムフィールド定義 |

## 画面種別

登録 / 編集

## URL/ルーティング

`/asp/bs_catalogFieldEdit.asp`

クエリパラメータ：
- `iFieldID`（暗号化）：編集対象フィールドID（編集時）
- `iCatalogID`（暗号化）：所属カタログID（新規作成時）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| sName | 入力 | 文字列 | ○ | フィールド名 |
| sType | 入力（選択） | 文字列 | ○ | フィールドタイプ |
| sValues | 入力（テキストエリア） | 文字列 | 条件付き | 選択肢（セレクトボックス時必須） |
| bPublic | 入力（チェック） | 真偽値 | - | 公開フィールド |
| bMandatory | 入力（チェック） | 真偽値 | - | 必須フィールド |
| bSearchField | 入力（チェック） | 真偽値 | - | 検索対象フィールド |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| カタログ名 | 文字列 | 所属カタログの名称 |
| 選択肢入力欄 | テキストエリア | セレクトボックスタイプ選択時のみ表示 |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークンチェック（checkCSRF()）
2. フォーム値をcatalogField.getRequestValues()で取得
3. catalogField.check()でバリデーション
4. catalogField.save()でデータベース保存
5. カタログ一覧画面へリダイレクト

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. CSRFトークンチェック
3. catalogField.remove()でデータベースから削除
4. カタログ一覧画面へリダイレクト

### 3-フィールドタイプ選択変更

フォームを自動送信し、選択したタイプに応じた設定項目（選択肢入力欄）を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示（編集） | tblCatalogField | SELECT | 既存フィールド情報を取得 |
| 保存（新規） | tblCatalogField | INSERT | 新規フィールドレコード作成 |
| 保存（新規） | tbCatalogItemFields | INSERT | 既存アイテムに新フィールド追加 |
| 保存（更新） | tblCatalogField | UPDATE | 既存フィールドレコード更新 |
| 削除 | tblCatalogField | DELETE | フィールドレコード削除 |
| 削除 | tblCatalogField | UPDATE | 削除フィールドより下の並び順更新 |
| 削除 | tbCatalogItemFields | DELETE | 関連アイテムフィールド値削除 |

### テーブル別更新項目詳細

#### tblCatalogField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | 必須 |
| INSERT/UPDATE | sType | フォーム選択値 | 必須 |
| INSERT/UPDATE | sValues | フォーム入力値 | セレクトボックス時必須 |
| INSERT/UPDATE | bPublic | フォームチェック値 | 公開フィールド |
| INSERT/UPDATE | bMandatory | フォームチェック値 | 必須フィールド |
| INSERT/UPDATE | bSearchField | フォームチェック値 | 検索対象 |
| INSERT/UPDATE | iCatalogID | パラメータ値 | 所属カタログID |
| INSERT | iRang | 現在のフィールド数+1 | 並び順（新規時自動設定） |
| UPDATE (削除時) | iRang | iRang-1 | 削除フィールドより下のフィールド |

#### tbCatalogItemFields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT (新規フィールド時) | iItemID | 既存アイテムID | 各アイテムに追加 |
| INSERT (新規フィールド時) | iFieldID | 新規フィールドID | 新フィールド参照 |
| INSERT (新規フィールド時) | sValue | 空文字列 | 初期値 |
| DELETE (削除時) | - | iFieldId=対象ID | フィールド値削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 必須項目が未入力 | バリデーションエラー |
| areyousure | 確認 | 削除確認 | 削除ボタン押下時 |
| general | ラベル | 一般設定セクション | 画面表示 |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| enterseplist | 説明 | 改行区切りで入力 | 選択肢入力欄 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| 必須項目未入力 | err_mandatoryメッセージ表示、保存処理中断 |
| セレクトボックスで選択肢未入力 | err_mandatoryメッセージ表示 |

## 備考

- フィールドタイプ一覧（sb_*定数）：
  - sb_text: テキスト（1行）
  - sb_textarea: テキストエリア（複数行）
  - sb_checkbox: チェックボックス
  - sb_select: セレクトボックス
  - sb_date: 日付
  - sb_richtext: リッチテキスト（WYSIWYGエディタ）
  - sb_url: URL
  - sb_email: メールアドレス
- 新規フィールド追加時、既存の全アイテムに対して空のフィールド値が自動追加される
- 削除時、関連するアイテムフィールド値も削除される
- 削除時、削除フィールドより下の並び順（iRang）が自動調整される
- チェックボックスタイプの場合、必須設定は非表示（チェック有無で値が決まるため）
- フィールドが1件しかない場合、削除ボタンは非表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogField.asp | `asp/includes/catalogField.asp` | cls_catalogFieldクラスの全プロパティ、Save/Check/getRequestValues/removeメソッド |

**読解のコツ**: Save()メソッド（行56-103）で新規フィールド追加時の既存アイテムへの追加処理を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | メイン処理フロー、タイプ別表示制御 |

**主要処理フロー**:
1. **行4-10**: セキュリティチェック、インスタンス生成、postBack判定
2. **行11-20**: btnactionによる処理分岐（save/delete）
3. **行21-22**: 補助オブジェクト生成（fixedFieldTypeList）
4. **行22**: フォームHTML生成（タイプ別条件分岐）

#### Step 3: 新規フィールド追加時の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogField.asp 行88-102 | `asp/includes/catalogField.asp` | 新規フィールド追加時の既存アイテムへの追加処理 |

**処理詳細**:
1. 現在のフィールド数を取得してiRangを設定
2. 新規フィールドをtblCatalogFieldに保存
3. 既存の全アイテム（tblCatalogItem）に対してtbCatalogItemFieldsに空のレコードを追加

### プログラム呼び出し階層図

```
bs_catalogFieldEdit.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalogField（インスタンス生成）
    │      ├─ pick()（既存データ読込）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()
    │      │      └─ 既存アイテムへのフィールド追加
    │      └─ remove()
    │             ├─ iRang調整
    │             └─ tbCatalogItemFields削除
    │
    ├─ cls_fixedFieldTypeList（タイプ選択肢）
    │
    └─ bs_backCatalog.asp（戻るリンク）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iFieldID ───▶ cls_catalogField.pick() ───▶ フォーム表示
(クエリ)              │
                     ▼
               tblCatalogField SELECT

フォーム値 ───▶ getRequestValues() ───▶ プロパティ設定
                     │
                     ▼
               check()（バリデーション）
                     │
                     ▼
               save()
                     │
                     ├─ tblCatalogField INSERT/UPDATE
                     │
                     └─ (新規時) tbCatalogItemFields INSERT
                            │
                            ▼
                     全既存アイテムにフィールド追加
                            │
                            ▼
                     カタログ一覧へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogFieldEdit.asp | `asp/bs_catalogFieldEdit.asp` | ソース | フィールド編集画面メイン |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | cls_catalogFieldクラス定義 |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | ソース | 戻るリンク |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | 一覧画面（遷移先） |
