# 画面設計書 37-カタログファイルタイプ編集

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログファイルタイプ編集画面（bs_catalogFileTypeEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログファイルタイプ編集画面は、サイト管理者がカタログに添付可能なファイルタイプ（添付ファイル種別）を新規作成・編集するための画面である。

**業務上の目的・背景**：カタログ機能において、商品・製品に関連するファイル（PDFカタログ、仕様書、画像など）を種別ごとに管理できることが重要である。本画面は、カタログアイテムに添付可能なファイル種別を定義し、体系的なファイル管理を可能にする。

**画面へのアクセス方法**：
- カタログ一覧画面から「新規タイプ」リンクをクリック（新規作成）
- カタログ一覧画面から既存ファイルタイプ名をクリック（編集）
- 直接URL：bs_catalogFileTypeEdit.asp?iFileTypeID=暗号化ID（編集）
- 直接URL：bs_catalogFileTypeEdit.asp?iCatalogID=暗号化ID（新規作成）

**主要な操作・処理内容**：
1. ファイルタイプ名の入力
2. ファイルタイプの保存・削除

**画面遷移**：
- 遷移元：カタログ一覧画面（bs_catalogList.asp）
- 遷移先：カタログ一覧画面（保存/削除後）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。削除ボタンは既存ファイルタイプ編集時のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | カタログファイルタイプ管理 | 主機能 | カタログに添付可能なファイルタイプの定義 |

## 画面種別

登録 / 編集

## URL/ルーティング

`/asp/bs_catalogFileTypeEdit.asp`

クエリパラメータ：
- `iFileTypeID`（暗号化）：編集対象ファイルタイプID（編集時）
- `iCatalogID`（暗号化）：所属カタログID（新規作成時）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| sName | 入力 | 文字列 | ○ | ファイルタイプ名 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| カタログ名 | 文字列 | 所属カタログの名称 |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークンチェック（checkCSRF()）
2. フォーム値をcatalogFileType.getRequestValues()で取得
3. catalogFileType.check()でバリデーション
4. catalogFileType.save()でデータベース保存
5. カタログ一覧画面へリダイレクト

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. CSRFトークンチェック
3. catalogFileType.remove()でデータベースから削除
4. カタログ一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示（編集） | tblCatalogFileType | SELECT | 既存ファイルタイプ情報を取得 |
| 保存（新規） | tblCatalogFileType | INSERT | 新規ファイルタイプレコード作成 |
| 保存（更新） | tblCatalogFileType | UPDATE | 既存ファイルタイプレコード更新 |
| 削除 | tblCatalogFileType | DELETE | ファイルタイプレコード削除 |
| 削除 | tblCatalogItemFiles | DELETE | 関連アイテムファイル削除 |

### テーブル別更新項目詳細

#### tblCatalogFileType

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | 必須 |
| INSERT/UPDATE | iCatalogID | パラメータ値 | 所属カタログID |

#### tblCatalogItemFiles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE (削除時) | - | iFileTypeID=対象ID | 関連ファイル削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 必須項目が未入力 | バリデーションエラー |
| areyousure | 確認 | 削除確認 | 削除ボタン押下時 |
| general | ラベル | 一般設定セクション | 画面表示 |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| catalog | ラベル | カタログ | カタログ名表示 |
| name | ラベル | 名前 | フィールドラベル |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| 必須項目未入力 | err_mandatoryメッセージ表示、保存処理中断 |

## 備考

- ファイルタイプはカタログアイテムへのファイル添付時に種別として選択される
- ファイルタイプ削除時、そのタイプに紐づく全アイテムファイルも削除される
- ファイルタイプ名はテンプレート変数として使用可能（{ファイルタイプ名（大文字）}）
- 実際のファイルアップロードはカタログアイテムファイル画面（bs_catalogItemFile.asp）で行う

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogFileType.asp | `asp/includes/catalogFileType.asp` | cls_catalogFileTypeクラスの全プロパティ、Save/Check/getRequestValues/removeメソッド |

**読解のコツ**: シンプルなクラス構造（約80行）。sNameのみが実質的な設定項目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | メイン処理フロー。非常にシンプルな構造 |

**主要処理フロー**:
1. **行4**: セキュリティチェック、インスタンス生成
2. **行6-14**: btnactionによる処理分岐（save/delete）
3. **行15**: フォームHTML生成

#### Step 3: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogFileType.asp 行59-67 | `asp/includes/catalogFileType.asp` | remove()メソッド - 関連ファイルの削除 |

**処理詳細**:
1. tblCatalogItemFilesから対象ファイルタイプのファイルを削除
2. tblCatalogFileTypeからファイルタイプレコードを削除

### プログラム呼び出し階層図

```
bs_catalogFileTypeEdit.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalogFileType（インスタンス生成）
    │      ├─ pick()（既存データ読込）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()
    │      └─ remove()
    │             └─ tblCatalogItemFiles削除
    │
    └─ bs_backCatalog.asp（戻るリンク）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iFileTypeID ───▶ cls_catalogFileType.pick() ───▶ フォーム表示
(クエリ)              │
                     ▼
               tblCatalogFileType SELECT

sName ─────────▶ getRequestValues() ───▶ プロパティ設定
(フォーム)            │
                     ▼
               check()（バリデーション）
                     │
                     ▼
               save() / remove()
                     │
                     ▼
               tblCatalogFileType INSERT/UPDATE/DELETE
               tblCatalogItemFiles DELETE（削除時）
                     │
                     ▼
               カタログ一覧へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogFileTypeEdit.asp | `asp/bs_catalogFileTypeEdit.asp` | ソース | ファイルタイプ編集画面メイン |
| catalogFileType.asp | `asp/includes/catalogFileType.asp` | ソース | cls_catalogFileTypeクラス定義 |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | ソース | 戻るリンク |
| bs_catalogList.asp | `asp/bs_catalogList.asp` | ソース | 一覧画面（遷移先） |
| bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | ソース | アイテムファイル画面（関連） |
