# 画面設計書 38-カタログアイテム編集

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログアイテム編集画面（bs_catalogItemEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログアイテム編集画面は、サイト管理者がカタログ内の個別アイテム（商品、製品等）を新規作成・編集するための画面である。カタログで定義されたフィールドに従って動的に入力フォームが生成される。

**業務上の目的・背景**：ECサイトや製品紹介サイトにおいて、商品・製品情報を効率的に登録・編集できることが重要である。本画面は、カタログで定義したスキーマ（フィールド構造）に基づく動的フォームを提供し、様々なカタログ形式に対応したアイテム管理を可能にする。

**画面へのアクセス方法**：
- カタログ一覧画面から「新規アイテム」リンクをクリック（新規作成）
- カタログアイテム検索画面からアイテムをクリック（編集）
- 直接URL：bs_catalogItemEdit.asp?iItemID=暗号化ID（編集）
- 直接URL：bs_catalogItemEdit.asp?iCatalogID=暗号化ID（新規作成）

**主要な操作・処理内容**：
1. アイテム基本情報の入力（タイトル、日付、オンライン期間）
2. カタログ定義フィールドに基づく動的フォーム入力
3. フォーム連携設定（フォーム使用有無）
4. アイテム画像のアップロード・削除
5. 添付ファイルの管理
6. アイテムの保存・削除・プレビュー

**画面遷移**：
- 遷移元：カタログ一覧画面（bs_catalogList.asp）、カタログアイテム検索画面（bs_catalogItemSearch.asp）
- 遷移先：カタログアイテム検索画面（保存/削除後）、カタログアイテム画像画面（bs_catalogItemPic.asp）、カタログアイテムファイル画面（bs_catalogItemFile.asp）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。削除・プレビュー・画像アップロードボタンは既存アイテム編集時のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | カタログアイテム管理 | 主機能 | カタログ内の個別アイテム追加・編集 |
| 51 | カタログアイテム画像アップロード | 補助機能 | アイテム画像のアップロード |
| 52 | カタログアイテムファイルアップロード | 補助機能 | アイテムファイルの添付 |

## 画面種別

登録 / 編集

## URL/ルーティング

`/asp/bs_catalogItemEdit.asp`

クエリパラメータ：
- `iItemID`（暗号化）：編集対象アイテムID（編集時）
- `iCatalogID`（暗号化）：所属カタログID（新規作成時）
- `iFileID`（暗号化）：削除対象ファイルID（ファイル削除時）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| sTitle | 入力 | 文字列 | ○ | 250 | アイテムタイトル |
| dDate | 入力（日付ピッカー） | 日付 | - | - | アイテム日付 |
| dOnlineFrom | 入力（日付ピッカー） | 日付 | - | - | オンライン開始日 |
| dOnlineUntill | 入力（日付ピッカー） | 日付 | - | - | オンライン終了日 |
| bForm | 入力（チェック） | 真偽値 | - | - | フォーム使用有無 |
| 動的フィールド | 入力 | 各種 | 各設定による | - | カタログ定義フィールド |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| カタログ名 | 文字列 | 所属カタログの名称 |
| アイテム名ラベル | 文字列 | カタログで定義されたsItemName |
| 作成日時 | 日時 | アイテム作成日時（既存アイテムのみ） |
| 更新日時 | 日時 | アイテム更新日時（既存アイテムのみ） |
| 画像 | 画像 | アップロード済み画像（存在時） |
| 添付ファイル一覧 | HTML | アップロード済みファイル一覧 |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークンチェック（checkCSRF()）
2. フォーム値をcatalogItem.getRequestValues()で取得
3. catalogItem.check()でバリデーション
4. catalogItem.save()でデータベース保存
5. カタログアイテム検索画面へリダイレクト（アンカー付き）

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. CSRFトークンチェック
3. catalogItem.remove()でデータベースから削除（関連ファイル、フォーム送信データも削除）
4. カタログアイテム検索画面へリダイレクト

### 3-プレビューボタン押下

別ウィンドウでアイテムプレビュー画面を表示（default.asp?pageAction=showitem&iItemID=暗号化ID）。
カタログにsItemViewが設定されている場合のみ表示。

### 4-画像アップロードボタン押下

1. フォーム値保存
2. カタログアイテム画像画面（bs_catalogItemPic.asp?iItemID=暗号化ID）へリダイレクト

### 5-画像削除ボタン押下

1. 確認ダイアログ表示
2. catalogItem.removePic()で画像削除
3. アイテム保存

### 6-添付ファイルアップロードボタン押下

1. フォーム値保存
2. カタログアイテムファイル画面（bs_catalogItemFile.asp?iItemID=暗号化ID）へリダイレクト

### 7-添付ファイル削除アイコンクリック

確認後、catalogItem.removeFile()で対象ファイルを削除。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示（編集） | tblCatalogItem | SELECT | 既存アイテム情報を取得 |
| 画面表示（編集） | tbCatalogItemFields | SELECT | フィールド値を取得 |
| 画面表示（編集） | tblCatalogItemFiles | SELECT | 添付ファイル一覧を取得 |
| 保存（新規） | tblCatalogItem | INSERT | 新規アイテムレコード作成 |
| 保存（更新） | tblCatalogItem | UPDATE | 既存アイテムレコード更新 |
| 保存 | tbCatalogItemFields | DELETE+INSERT | フィールド値更新（全削除後再挿入） |
| 削除 | tblCatalogItem | DELETE | アイテムレコード削除 |
| 削除 | tbCatalogItemFields | DELETE | フィールド値削除 |
| 削除 | tblCatalogItemFiles | DELETE | 添付ファイル削除 |
| 削除 | tblFormSubmission | DELETE | フォーム送信データ削除 |
| 画像削除 | - | ファイル削除 | 画像ファイルを物理削除 |

### テーブル別更新項目詳細

#### tblCatalogItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | フォーム入力値（最大255文字） | 必須 |
| INSERT/UPDATE | dDate | 日付ピッカー値 | アイテム日付 |
| INSERT/UPDATE | dOnlineFrom | 日付ピッカー値 | オンライン開始 |
| INSERT/UPDATE | dOnlineUntill | 日付ピッカー値 | オンライン終了 |
| INSERT/UPDATE | bForm | フォームチェック値 | フォーム使用 |
| INSERT/UPDATE | sPicExt | 画像ファイル名 | 画像アップロード時 |
| INSERT/UPDATE | iCatalogID | パラメータ値 | 所属カタログID |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| INSERT | dCreatedTS | now() | 作成日時 |

#### tbCatalogItemFields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iItemID=対象ID | 保存前に全削除 |
| INSERT | iItemID | アイテムID | 各フィールドに1レコード |
| INSERT | iFieldID | フィールドID | フィールド参照 |
| INSERT | sValue | フォーム入力値 | フィールド値 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 必須項目が未入力 | バリデーションエラー |
| areyousure | 確認 | 削除確認 | 削除ボタン押下時 |
| general | ラベル | 一般設定セクション | 画面表示 |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| attachments | ラベル | 添付ファイル | ファイル一覧セクション |
| createdon | ラベル | 作成日時 | 日時表示 |
| updatedon | ラベル | 更新日時 | 日時表示 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| 必須項目未入力 | err_mandatoryメッセージ表示、保存処理中断 |
| 必須フィールド未入力 | err_mandatoryメッセージ表示 |

## 備考

- 動的フィールドはカタログで定義されたフィールドタイプに応じて入力コントロールが変化
  - sb_text: テキスト入力
  - sb_textarea: テキストエリア
  - sb_checkbox: チェックボックス
  - sb_select: セレクトボックス
  - sb_date: 日付ピッカー
  - sb_richtext: WYSIWYGエディタ（FCKInstance）
  - sb_url: URL入力
  - sb_email: メール入力
- フィールド値は保存時に全削除後再挿入される（UPDATE方式ではない）
- アイテム削除時は関連する全データ（フィールド値、添付ファイル、フォーム送信データ、画像ファイル）も削除される
- 画像ファイルは物理削除される（removePic()）
- 保存後、RSSキャッシュがクリアされる（catalog.clearRSSCache()）
- オンライン期間（dOnlineFrom〜dOnlineUntill）でアイテムの公開期間を制御可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラスの全プロパティ、fieldsディクショナリ、Save/Check/getRequestValues/remove/removeFile/removePicメソッド |

**読解のコツ**: fieldsはディクショナリでiFieldIDをキー、sValueを値として保持。保存時にtbCatalogItemFieldsへ展開。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | メイン処理フロー、動的フォーム生成、各アクション処理 |

**主要処理フロー**:
1. **行4-10**: セキュリティチェック、インスタンス生成、postBack判定
2. **行11-14**: ファイル削除処理（iFileIDパラメータ時）
3. **行15-43**: btnactionによる処理分岐（save/delete/uploadattachment/uploadpic/deletepic）
4. **行44-53**: カタログフィールド・ファイル取得
5. **行51-70**: フォームHTML生成（動的フィールドループ）

#### Step 3: 動的フォーム生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_catalogItemEdit.asp 行52-53 | `asp/bs_catalogItemEdit.asp` | フィールドタイプ別の入力コントロール生成（select case） |

**フィールドタイプ別処理**:
- sb_text/sb_url/sb_email: input type="text"
- sb_textarea: textarea
- sb_checkbox: input type="checkbox"
- sb_select: select with catalogFields(catalogField).showSelected()
- sb_date: input + JQDatePicker()
- sb_richtext: createFCKInstance()

### プログラム呼び出し階層図

```
bs_catalogItemEdit.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalogItem（インスタンス生成）
    │      ├─ pick()（既存データ読込）
    │      │      ├─ tblCatalogItem SELECT
    │      │      └─ tbCatalogItemFields SELECT
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()
    │      │      ├─ tblCatalogItem INSERT/UPDATE
    │      │      ├─ tbCatalogItemFields DELETE+INSERT
    │      │      └─ catalog.clearRSSCache()
    │      ├─ remove()
    │      │      ├─ removePic()
    │      │      ├─ files().remove()
    │      │      ├─ submissions().remove()
    │      │      └─ tblCatalogItem/tbCatalogItemFields DELETE
    │      ├─ removeFile()
    │      └─ removePic()
    │
    ├─ catalogItem.catalog.fields("")（フィールド定義取得）
    └─ catalogItem.files（添付ファイル取得）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iItemID ───▶ cls_catalogItem.pick() ───▶ フォーム表示
(クエリ)              │
                     ▼
               tblCatalogItem SELECT
               tbCatalogItemFields SELECT

フォーム値 ───▶ getRequestValues() ───▶ プロパティ/fields設定
                     │
                     ▼
               check()（バリデーション）
                     │
                     ▼
               save()
                     │
                     ├─ tblCatalogItem INSERT/UPDATE
                     │
                     └─ tbCatalogItemFields DELETE+INSERT
                            │
                            ▼
                     アイテム検索画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | アイテム編集画面メイン |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | cls_catalogItemクラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス（親参照） |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | フィールド定義参照 |
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | 検索画面（遷移先） |
| bs_catalogItemPic.asp | `asp/bs_catalogItemPic.asp` | ソース | 画像画面（遷移先） |
| bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | ソース | ファイル画面（遷移先） |
