# 画面設計書 39-カタログアイテム検索

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログアイテム検索画面（bs_catalogItemSearch.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログアイテム検索画面は、サイト管理者がカタログ内のアイテム（商品、製品等）を検索・一覧表示し、管理するための画面である。カタログで定義された検索対象フィールドに基づいて動的に検索フォームが生成される。

**業務上の目的・背景**：ECサイトや製品紹介サイトにおいて、大量の商品・製品データから目的のアイテムを素早く見つけ出すことが重要である。本画面は、カタログで定義したフィールドによる柔軟な検索機能を提供し、効率的なアイテム管理を可能にする。また、検索結果のExcel出力機能により、データの外部活用も支援する。

**画面へのアクセス方法**：
- カタログ一覧画面から「一覧」リンクをクリック
- 直接URL：bs_catalogItemSearch.asp?iCatalogID=暗号化ID

**主要な操作・処理内容**：
1. カタログの選択
2. タイトルによる検索
3. カタログ定義フィールドによる動的検索
4. 日付範囲検索
5. 検索結果の一覧表示（オンライン状態付き）
6. アイテムの編集画面への遷移
7. アイテムのコピー（複製）
8. 検索結果のExcel出力
9. 新規アイテム作成画面への遷移

**画面遷移**：
- 遷移元：カタログ一覧画面（bs_catalogList.asp）
- 遷移先：カタログアイテム編集画面（bs_catalogItemEdit.asp）

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。新規アイテムリンクはフィールドが1件以上定義されている場合のみ表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | カタログアイテム検索 | 主機能 | カタログ内アイテムの検索・絞り込み |

## 画面種別

検索 / 一覧

## URL/ルーティング

`/asp/bs_catalogItemSearch.asp`

クエリパラメータ：
- `iCatalogID`（暗号化）：対象カタログID

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| iCatalogID | 入力（選択） | 暗号化数値 | - | 検索対象カタログ |
| sTitle | 入力 | 文字列 | - | タイトル検索キーワード |
| 動的検索フィールド | 入力 | 各種 | - | カタログ定義の検索フィールド |
| fromXXX | 入力（日付） | 日付 | - | 日付範囲（開始） |
| untillXXX | 入力（日付） | 日付 | - | 日付範囲（終了） |
| btnaction | 入力（ボタン） | 文字列 | - | 検索/Excel |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 検索結果一覧 | HTML | itemSearch.resultTableで生成される検索結果テーブル |
| オンライン状態 | アイコン/文字 | V（オンライン）/ X（オフライン） |
| 凡例 | HTML | オンライン/オフライン状態の説明 |

## イベント仕様

### 1-カタログ選択変更

カタログ選択を変更すると、フォームが自動送信され、選択したカタログの検索フィールドが動的に表示される。

### 2-検索ボタン押下

入力された条件でアイテムを検索し、結果を一覧表示する。検索結果はitemSearch.resultTableプロパティでHTML生成される。

### 3-Excelボタン押下

入力された条件での検索結果をExcel形式でダウンロードする。

### 4-アイテム行クリック

カタログアイテム編集画面（bs_catalogItemEdit.asp?iItemID=暗号化ID）へ遷移する。

### 5-コピーアイコンクリック

選択したアイテムを複製する。複製後は同画面にリダイレクトされ、新アイテムの位置にスクロールする。

### 6-新規アイテムリンククリック

カタログアイテム編集画面（bs_catalogItemEdit.asp?iCatalogID=暗号化ID）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCatalog | SELECT | カタログ一覧を取得 |
| 画面表示 | tblCatalogField | SELECT | 検索フィールド一覧を取得 |
| 検索 | tblCatalogItem | SELECT | アイテム検索 |
| 検索 | tbCatalogItemFields | SELECT | フィールド値による絞り込み |
| コピー | tblCatalogItem | INSERT | アイテム複製 |
| コピー | tbCatalogItemFields | INSERT | フィールド値複製 |
| コピー | tblCatalogItemFiles | INSERT | ファイル複製 |

### テーブル別更新項目詳細

#### tblCatalogItem（コピー時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sTitle | 「コピー元タイトル のコピー」 | 新タイトル |
| INSERT | その他項目 | コピー元の値 | 全項目複製 |
| INSERT | dCreatedTS | now() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| search | ボタンテキスト | 検索 | 検索ボタン |
| excel | ボタンテキスト | Excel | Excel出力ボタン |
| select | プレースホルダー | 選択... | カタログ選択初期表示 |
| newitem | リンクテキスト | 新規アイテム | 新規作成リンク |
| for | 接続詞 | for | リンクテキスト内 |
| online | ラベル | オンライン | 凡例 |
| offline | ラベル | オフライン | 凡例 |
| between | ラベル | 〜の間 | 日付範囲 |
| and | ラベル | と | 日付範囲 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| カタログ未選択 | 検索フォームは表示されず、カタログ選択のみ表示 |
| 検索結果0件 | 空のテーブルまたは該当なしメッセージ表示 |

## 備考

- 検索フィールドはカタログ定義でbSearchField=trueのフィールドのみ表示
- 日付型フィールドは範囲検索（from〜untill）が可能
- 検索結果のオンライン状態は、dOnlineFromとdOnlineUntillによる期間判定で決定
- コピー機能はcatalogItem.copy()メソッドで実装、画像ファイルも複製される
- Excel出力はitemSearch.resultTableの別処理で生成（btnaction=l("excel")時）
- 検索結果テーブルにはアンカーが設定され、保存後のリダイレクト時に該当アイテム位置にスクロール

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラス、copy()メソッド（行385-406） |

**読解のコツ**: copy()メソッドで画像ファイルのコピー処理も含まれることを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | メイン処理フロー、動的検索フォーム生成、検索結果表示 |

**主要処理フロー**:
1. **行4-9**: セキュリティチェック、itemSearchインスタンス生成
2. **行6-9**: 検索フィールド・入力フィールド取得
3. **行17-21**: コピー処理（catalogItem.copy()）
4. **行21-25**: 動的検索フォーム生成（フィールドタイプ別）
5. **行28-29**: 検索結果表示（itemSearch.resultTable）

#### Step 3: 検索クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | (itemSearch関連ファイル) | `asp/includes/` | cls_itemSearchクラスの実装、resultTableプロパティ |

**処理詳細**:
- getRequestValues(): 検索条件取得
- resultTable: 検索結果HTML生成

### プログラム呼び出し階層図

```
bs_catalogItemSearch.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_itemSearch（インスタンス生成）
    │      ├─ catalog.fields("search")（検索フィールド取得）
    │      ├─ getRequestValues()（検索条件取得）
    │      └─ resultTable（検索結果HTML）
    │             └─ tblCatalogItem/tbCatalogItemFields SELECT
    │
    ├─ cls_catalogItem（コピー時）
    │      └─ copy()
    │             ├─ tblCatalogItem INSERT
    │             ├─ tbCatalogItemFields INSERT
    │             ├─ tblCatalogItemFiles INSERT
    │             └─ 画像ファイルコピー
    │
    └─ customer.showSelectedCatalog（カタログ選択肢）
```

### データフロー図

```
[入力]               [処理]                    [出力]

iCatalogID ───▶ catalog.fields("search") ───▶ 検索フォーム表示
(選択)                │
                     ▼
               フィールド定義取得

検索条件 ───────▶ itemSearch.getRequestValues() ───▶ 条件設定
                     │
                     ▼
               itemSearch.resultTable
                     │
                     ▼
               tblCatalogItem SELECT
               tbCatalogItemFields SELECT
                     │
                     ▼
               検索結果HTML表示

btnaction=excel ─▶ Excel出力処理 ───▶ Excelファイルダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | アイテム検索画面メイン |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | cls_catalogItemクラス（コピー処理） |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス（フィールド取得） |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | ソース | 戻るリンク |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | アイテム編集画面（遷移先） |
