# 画面設計書 4-管理者ログオフ画面

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者（Admin）からのログオフ処理を行う画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、システム管理者（Admin）権限でのセッションを終了してログオフするための処理画面である。Admin用のセッションを破棄し、管理者ダッシュボードへの不正アクセスを防止する。

**業務上の目的・背景**：Admin権限は全顧客サイトの管理やIIS設定変更など高度な操作が可能なため、作業終了後の適切なログオフが重要である。セキュリティの観点から、Admin認証セッションを確実に終了させる必要がある。

**画面へのアクセス方法**：管理者ダッシュボードのヘッダーメニューまたはナビゲーションからログオフリンクをクリックする。直接 `/asp/ad_logoff.asp` にアクセスすることも可能。

**主要な操作・処理内容**：
1. logon.logoff関数が自動実行される
2. Admin認証に関連するSession変数・Cookieがクリアされる
3. 「ログオフしました」メッセージと再ログインリンクが表示される

**画面遷移**：
- 遷移元：管理者ダッシュボードおよび管理者画面各所のログオフリンク
- 遷移先：ad_login.asp（管理者ログイン画面）

**権限による表示制御**：Admin認証済みユーザーのみがアクセス可能（ad_security.aspによる認証チェック）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 管理者ログアウト | 主機能 | 管理者画面からのセッション終了・ログアウト処理 |

## 画面種別

処理画面（ログオフ処理後のメッセージ表示）

## URL/ルーティング

- `/asp/ad_logoff.asp`

## 入出力項目

本画面には入力項目はない。

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ログオフ完了メッセージ | 中央 | 多言語対応メッセージ「youareloggedoff」 |
| 再ログインリンク | 中央 | Admin認証画面へのリンク「loginagain」 |

## イベント仕様

### 1-ログオフ処理（自動実行）

**処理フロー**：
1. ad_security.aspにより認証チェック（Admin認証済みか確認）
2. logon.logoff関数を呼び出してセッションをクリア
3. ログオフ完了メッセージを表示
4. Admin認証画面（ad_login.asp）への再ログインリンクを表示

### 2-再ログインリンクのクリック

**処理フロー**：
1. ad_login.aspへ遷移
2. Admin認証画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログオフ処理 | なし | - | データベース更新なし |

### テーブル別更新項目詳細

本画面ではデータベースへの更新は行わない。

**Application変数の更新**：
- `adminLoginCount{UserIP}`: 0にリセット

**Session変数の更新**：
- `{cId}isAUTHENTICATEDasADMIN`: falseに設定
- `{cId}isAUTHENTICATEDasUSER`: falseに設定
- `{cId}isAUTHENTICATEDSecondAdmin`: falseに設定

**Cookie更新**：
- `sEmail`: 空文字列に設定
- `sPw`: 空文字列に設定

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| youareloggedoff | 情報 | ログオフ完了メッセージ | ログオフ処理完了後 |
| loginagain | リンク | 再ログインリンクテキスト | 常時表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態でのアクセス | ad_security.aspによりnoaccess.htmへリダイレクト |

## 備考

- バックサイトログオフ（bs_logoff.asp）と異なり、即座にログオフ完了メッセージを表示する（リダイレクトなし）
- logon.logoff関数は、Admin認証だけでなく、関連するセッション・Cookieもクリアする
- Admin認証の試行回数カウンターもリセットされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログオフで破棄されるセッション・Cookie・Application変数を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logoff関数でクリアされる変数一覧 |

**読解のコツ**: Admin用のlogoff関数はバックサイト用のlogoffBOとは異なる。クリアされる変数の違いを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_logoff.asp | `asp/ad_logoff.asp` | Admin用ログオフ画面のメインファイル |

**主要処理フロー**:
1. **行4**: bUseArtLoginTemplate設定
2. **行4**: ad_security.aspのインクルード（認証チェック）
3. **行4**: logon.logoff関数の呼び出し
4. **行4**: ログオフ完了メッセージ表示
5. **行4**: 再ログインリンク表示

#### Step 3: ログオフ関数を理解する

logoff関数の内部処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logoff関数（行175-182） |

**主要処理フロー**:
- **行176**: Cookie「sEmail」をクリア
- **行177**: Cookie「sPw」をクリア
- **行178**: adminLoginCount試行回数をリセット
- **行179-181**: 各認証フラグをfalseに設定

### プログラム呼び出し階層図

```
ad_logoff.asp (エントリーポイント)
    │
    ├─ ad_security.asp (Admin認証チェック)
    │      └─ 未認証時：noaccess.htmへリダイレクト
    │
    ├─ logon.logoff() (ログオフ処理)
    │      ├─ Cookieクリア
    │      ├─ Application変数リセット
    │      └─ Session変数クリア
    │
    └─ メッセージ表示・リンク表示
```

### データフロー図

```
[処理]                              [影響範囲]

logoff() ─────────────────▶ Cookieクリア
       │                         ├─ sEmail = ""
       │                         └─ sPw = ""
       │
       ├─────────────────▶ Application変数
       │                         └─ adminLoginCount = 0
       │
       └─────────────────▶ Session変数
                                 ├─ isAUTHENTICATEDasADMIN = false
                                 ├─ isAUTHENTICATEDasUSER = false
                                 └─ isAUTHENTICATEDSecondAdmin = false
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_logoff.asp | `asp/ad_logoff.asp` | ソース | Admin用ログオフ画面メイン |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理・クラスロード |
| ad_security.asp | `asp/ad_security.asp` | インクルード | Admin認証チェック |
| logonEdit.asp | `asp/includes/logonEdit.asp` | インクルード | logoff関数定義 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダーHTML |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッターHTML |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
