# 画面設計書 40-カタログアイテムファイル

## 概要

本ドキュメントは、QuickerSiteのバックサイト（管理画面）におけるカタログアイテムファイル画面（bs_catalogItemFile.asp）の設計仕様を定義する。

### 本画面の処理概要

カタログアイテムファイル画面は、サイト管理者がカタログアイテムに添付ファイル（PDF、ドキュメント等）をアップロードするための画面である。

**業務上の目的・背景**：商品・製品カタログにおいて、仕様書、マニュアル、カタログPDFなどの関連ファイルを添付できることは重要な機能である。本画面は、カタログで定義されたファイルタイプに基づいてファイルを分類・管理し、アイテムへのファイル添付を可能にする。

**画面へのアクセス方法**：
- カタログアイテム編集画面から「添付ファイルアップロード」ボタンをクリック
- 直接URL：bs_catalogItemFile.asp?iItemID=暗号化ID

**主要な操作・処理内容**：
1. アップロードするファイルの選択
2. ファイルタイプの選択
3. ファイルのアップロード
4. アイテム編集画面への戻り

**画面遷移**：
- 遷移元：カタログアイテム編集画面（bs_catalogItemEdit.asp）
- 遷移先：カタログアイテムファイルアップロード処理（bs_catalogItemFileUpload.asp）、カタログアイテム編集画面

**権限による表示制御**：secondAdmin.bCatalogがtrueの場合のみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | カタログアイテムファイルアップロード | 主機能 | カタログアイテムへのファイル添付管理 |

## 画面種別

アップロード

## URL/ルーティング

`/asp/bs_catalogItemFile.asp`

クエリパラメータ：
- `iItemID`（暗号化）：対象アイテムID（必須）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| uploadFile | 入力（ファイル） | ファイル | ○ | アップロードするファイル（5MB以下） |
| iFileTypeId | 入力（選択） | 暗号化数値 | ○ | ファイルタイプ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アイテム名 | 文字列 | 対象アイテムのタイトル（catalogItem.sTitle） |
| ファイルタイプ選択 | セレクトボックス | カタログで定義されたファイルタイプ一覧 |
| 戻るリンク | リンク | アイテム編集画面へのリンク |

## イベント仕様

### 1-アップロードボタン押下

1. フォームがbs_catalogItemFileUpload.aspにPOST送信される
2. ファイルがサーバーにアップロードされる
3. tblCatalogItemFilesにレコードが作成される
4. アイテム編集画面にリダイレクト

### 2-戻るリンククリック

カタログアイテム編集画面（bs_catalogItemEdit.asp?iItemID=暗号化ID）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCatalogItem | SELECT | アイテム情報を取得 |
| 画面表示 | tblCatalogFileType | SELECT | ファイルタイプ一覧を取得 |
| アップロード | tblCatalogItemFiles | INSERT | ファイルレコード作成（別処理） |

### テーブル別更新項目詳細

#### tblCatalogItemFiles（アップロード処理で更新）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iItemID | 対象アイテムID | アイテム参照 |
| INSERT | iFileTypeID | 選択されたファイルタイプID | タイプ参照 |
| INSERT | sFileName | アップロードファイル名 | 保存ファイル名 |
| INSERT | sOriginalFileName | 元ファイル名 | ユーザー指定ファイル名 |
| INSERT | dCreatedTS | now() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| attachment | ラベル | 添付ファイル | セクション見出し |
| file | ラベル | ファイル | ファイル入力ラベル |
| type | ラベル | タイプ | タイプ選択ラベル |
| upload | ボタンテキスト | アップロード | アップロードボタン |
| mandatory | ラベル | 必須マーク説明 | 画面表示 |
| back | リンクテキスト | 戻る | 戻るリンク |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | logon.hasaccessでチェック、ログイン画面へリダイレクト |
| ファイルサイズ超過 | アップロード処理でエラー（5MB制限） |
| ファイル未選択 | アップロード処理でエラー |
| ファイルタイプ未選択 | アップロード処理でエラー |

## 備考

- ファイルサイズ制限は5MB
- アップロード処理はbs_catalogItemFileUpload.aspで実行される
- フォームはENCTYPE="multipart/form-data"で送信される
- ファイルはカタログのsFilePathで指定されたフォルダに保存される
- ファイルタイプはカタログで事前に定義されている必要がある
- アップロード後のファイルはアイテム編集画面の添付ファイル一覧に表示される
- ファイル削除はアイテム編集画面から行う

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | cls_catalogItemFileクラスの定義（存在する場合） |
| 1-2 | catalogItem.asp | `asp/includes/catalogItem.asp` | files()メソッド（行202-216）でファイル一覧取得 |

**読解のコツ**: catalogItem.catalog.fileTypesでファイルタイプ一覧を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | 非常にシンプルな画面（7行程度）、フォーム生成のみ |

**主要処理フロー**:
1. **行4**: セキュリティチェック、catalogItemインスタンス生成
2. **行6**: fileTypesでファイルタイプ一覧取得
3. **行7**: フォームHTML生成（enctype=multipart/form-data）

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_catalogItemFileUpload.asp | `asp/bs_catalogItemFileUpload.asp` | 実際のアップロード処理 |

**処理詳細**:
1. マルチパートフォームデータの解析
2. ファイルの保存
3. tblCatalogItemFilesへのレコード挿入
4. アイテム編集画面へリダイレクト

### プログラム呼び出し階層図

```
bs_catalogItemFile.asp
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bCatalog)
    │
    ├─ cls_catalogItem（インスタンス生成）
    │      └─ pick()（アイテム読込）
    │
    ├─ catalogItem.catalog.fileTypes（ファイルタイプ取得）
    │
    └─ フォームHTML生成
           │
           ▼
       [POST送信]
           │
           ▼
       bs_catalogItemFileUpload.asp
              │
              ├─ ファイルアップロード処理
              ├─ tblCatalogItemFiles INSERT
              └─ bs_catalogItemEdit.aspへリダイレクト
```

### データフロー図

```
[入力]               [処理]                    [出力]

iItemID ───▶ cls_catalogItem.pick() ───▶ アイテム情報表示
(クエリ)              │
                     ▼
               catalogItem.catalog.fileTypes
                     │
                     ▼
               ファイルタイプ選択肢表示

uploadFile ─▶ [フォーム送信] ─▶ bs_catalogItemFileUpload.asp
iFileTypeId          │
                     ▼
               ファイル保存処理
               tblCatalogItemFiles INSERT
                     │
                     ▼
               アイテム編集画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemFile.asp | `asp/bs_catalogItemFile.asp` | ソース | ファイルアップロード画面メイン |
| bs_catalogItemFileUpload.asp | `asp/bs_catalogItemFileUpload.asp` | ソース | アップロード処理 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | cls_catalogItemクラス |
| catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | ソース | cls_catalogItemFileクラス |
| catalog.asp | `asp/includes/catalog.asp` | ソース | fileTypesメソッド |
| bs_catalogItemEdit.asp | `asp/bs_catalogItemEdit.asp` | ソース | 編集画面（遷移元・先） |
