# 画面設計書 41-カタログアイテム画像

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「カタログアイテム画像」画面の設計書です。

### 本画面の処理概要

カタログアイテムに紐づく画像をアップロード・管理するための画面です。カタログ機能を利用してECサイトや商品カタログを構築する際に、各アイテム（商品）の画像を設定するために使用します。

**業務上の目的・背景**：カタログアイテムには視覚的な情報として画像が不可欠です。本画面は、カタログアイテムごとに画像を設定することで、フロントエンドで商品やサービスを視覚的に訴求できるようにします。画像は自動的にサムネイル生成やリサイズ処理が行われ、表示パフォーマンスを最適化します。カタログ設定でサムネイル自動生成が有効な場合は、指定サイズに縮小されたサムネイル画像も自動生成されます。

**画面へのアクセス方法**：バックサイトホーム画面からカタログ一覧（bs_catalogList.asp）へ遷移し、対象カタログを選択後、カタログアイテム一覧からアイテムを選択して「カタログアイテム編集」画面（bs_catalogItemEdit.asp）にアクセスします。そこから「画像」リンクをクリックすることで本画面に遷移します。URLパラメータとしてiItemIDが必要です。

**主要な操作・処理内容**：
1. 画像ファイルの選択：ローカルPCから画像ファイル（jpg/gif/png/bmp/tif形式）を選択
2. 画像のアップロード：選択した画像をサーバーへアップロード（5MB以下の制限あり）
3. カタログアイテム編集画面への戻り：アップロード完了後または中断時に編集画面へ戻る

**画面遷移**：
- 遷移元：カタログアイテム編集画面（bs_catalogItemEdit.asp）
- 遷移先：画像アップロード処理（bs_catalogItemPicUpload.asp）、カタログアイテム編集画面（bs_catalogItemEdit.asp）

**権限による表示制御**：セカンド管理者の場合、secondAdmin.bCatalog権限がtrueである必要があります。権限がない場合はアクセスが拒否されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | カタログアイテム画像アップロード | 主機能 | カタログアイテムへの画像管理 |

## 画面種別

登録・編集（画像アップロード）

## URL/ルーティング

```
/asp/bs_catalogItemPic.asp?iItemID={暗号化されたアイテムID}
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| アイテムID | iItemID | hidden | - | 入力 | 暗号化されたカタログアイテムID |
| セキュリティコード | QS_secCodeHidden | hidden | - | 入力 | CSRF対策用トークン |
| 画像ファイル | uploadFile | file | 必須 | 入力 | アップロードする画像ファイル（5MB以下、jpg/gif/png/bmp/tif形式） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| アイテム名ラベル | テーブル左列 | カタログのsItemname設定値 |
| アイテム名 | テーブル右列 | 対象カタログアイテムのタイトル（sTitle） |
| 画像ラベル | テーブル左列 | 「picture:」のラベル表示 |
| ファイル選択欄 | テーブル右列 | ファイル選択input要素とサイズ制限・許可形式の説明 |
| 必須項目説明 | テーブル下部 | 「(*) mandatory」の表示 |
| アップロードボタン | テーブル下部 | 「upload」ボタン |
| 戻るリンク | 画面下部 | カタログアイテム編集画面への戻りリンク |

## イベント仕様

### 1-アップロードボタン押下

「upload」ボタン押下時、フォームがbs_catalogItemPicUpload.aspにPOST送信されます。

**処理フロー**：
1. フォームデータ（multipart/form-data形式）がbs_catalogItemPicUpload.aspに送信される
2. アップロード処理側でCSRFトークンの検証が行われる
3. ファイルタイプの検証（jpg/gif/png/bmp/tifのみ許可）
4. ファイルサイズの検証（5MB以下）
5. 検証成功時：ファイル名を暗号化ID + パスワード + 拡張子にリネームして保存
6. catalogItem.sPicExtに拡張子情報を保存
7. カタログアイテム編集画面にリダイレクト

### 2-戻るリンク押下

「back」リンク押下時、カタログアイテム編集画面（bs_catalogItemEdit.asp）に遷移します。アイテムIDはURLパラメータとして引き継がれます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画像アップロード | tblCatalogItem | UPDATE | sPicExtカラムの更新 |

### テーブル別更新項目詳細

#### tblCatalogItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPicExt | 暗号化ID + パスワード + 拡張子形式のファイル名 | カタログにファイルパス設定がある場合は元ファイル名を使用 |
| UPDATE | dUpdatedTS | 現在日時 | save()メソッド内で自動更新 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| err_fileType | エラー | 許可されていないファイル形式 | 不正なファイルタイプエラー |
| err_fileSize | エラー | ファイルサイズが5MB超過 | ファイルサイズ超過エラー |
| err_newFile | エラー | ファイルが選択されていない | ファイル未選択エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bCatalog権限チェックに失敗した場合、エラー表示またはリダイレクト |
| アイテムIDが不正 | decrypt処理でエラーが発生した場合、画面表示時にエラー |
| CSRF検証失敗 | アップロード処理時にCSRFトークン検証に失敗した場合、処理中断 |

## 備考

- 画像ファイルは、Application("QS_CMS_userfiles")で指定されたディレクトリ配下に保存される
- カタログ設定でsFilePathが指定されている場合は、そのサブディレクトリに保存される
- 既存の画像がある場合は上書きされる
- サムネイル生成はカタログのbAutoThumb設定に依存する
- 許可されるファイル形式は allowedFileTypesforThumbing Dictionary で管理されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログアイテムに関するデータ構造とクラス定義を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラスの定義。sPicExtプロパティ、picURL関数、showPic関数、removePic関数を確認 |
| 1-2 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスの定義。correFP、bAutoThumb、iMaxThumbSizeプロパティを確認 |

**読解のコツ**: ASP/VBScriptのクラス構文では、Public/Private修飾子でプロパティやメソッドのスコープが決まります。Class_Initializeがコンストラクタに相当します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemPic.asp | `asp/bs_catalogItemPic.asp` | 画面表示のメインファイル。インクルード順序とセキュリティチェックの流れを確認 |

**主要処理フロー**:
1. **1行目**: begin.aspインクルードで初期化処理
2. **4行目**: bs_security.aspインクルードとアクセス権限チェック（logon.hasaccess secondAdmin.bCatalog）
3. **4行目**: cls_catalogItemインスタンス生成でRequest("iItemID")からアイテム情報取得
4. **5行目**: フォームとテーブル構造でUI出力

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_catalogItemPicUpload.asp | `asp/bs_catalogItemPicUpload.asp` | 画像アップロード処理。FreeASPUploadクラスの使用方法とファイル検証ロジックを確認 |

**主要処理フロー**:
- **4-8行目**: アップロードディレクトリ設定とFreeASPUploadインスタンス生成
- **9行目**: CSRF検証（checkCSRF_Upload）
- **10-12行目**: catalogItemインスタンス生成と対象アイテム取得
- **15-41行目**: ファイル検証とリネーム・保存処理
- **45-48行目**: 成功/失敗に応じたリダイレクト処理

### プログラム呼び出し階層図

```
bs_catalogItemPic.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │      └─ database.asp, session管理等
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess()
    │
    ├─ includes/header.asp（ヘッダー）
    │
    ├─ cls_catalogItem（クラス）
    │      ├─ Class_Initialize()
    │      │      └─ pick(decrypt(request("iItemID")))
    │      └─ catalog（プロパティ）
    │             └─ cls_catalog.pick()
    │
    └─ includes/footer.asp（フッター）

bs_catalogItemPicUpload.asp（アップロード処理）
    │
    ├─ FreeASPUpload.Save()
    │
    ├─ checkCSRF_Upload()
    │
    ├─ cls_catalogItem.pick()
    │
    ├─ ファイル検証処理
    │      ├─ allowedFileTypesforThumbing.exists()
    │      └─ サイズチェック（5MB制限）
    │
    └─ catalogItem.save()
           └─ tblCatalogItem UPDATE
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画像ファイル ───────▶ FreeASPUpload.Save() ───────▶ userfilesディレクトリ
（5MB以下）              │                               │
                         ├─ ファイル検証                  │
                         │    ├─ 拡張子チェック           │
                         │    └─ サイズチェック           │
                         │                               │
                         ├─ ファイルリネーム              │
                         │    └─ encrypt(iId)_password.ext │
                         │                               │
                         └─ catalogItem.save() ─────────▶ tblCatalogItem.sPicExt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemPic.asp | `asp/bs_catalogItemPic.asp` | ソース | 画像アップロード画面 |
| bs_catalogItemPicUpload.asp | `asp/bs_catalogItemPicUpload.asp` | ソース | 画像アップロード処理 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| freeaspupload.asp | `asp/includes/freeaspupload.asp` | ソース | ファイルアップロードライブラリ |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
