# 画面設計書 42-ニュースレター一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「ニュースレター一覧」画面の設計書です。

### 本画面の処理概要

ニュースレター管理機能のホーム画面として、登録済みのニュースレターテンプレート一覧を表示し、各種ニュースレター関連機能へのナビゲーションを提供します。新規ニュースレター作成、配信メール作成、購読者管理、メーリングリスト（カテゴリ）管理など、ニュースレター機能全体の起点となる画面です。

**業務上の目的・背景**：ニュースレターはWebサイト運営において顧客エンゲージメントを高める重要なマーケティングツールです。本画面は、ニュースレターの作成・管理・配信という一連のワークフローを効率的に行うためのダッシュボード的役割を果たします。サイト管理者は本画面から購読者の管理、配信履歴の確認、新規配信の作成など、メールマーケティングに必要な全ての操作にアクセスできます。

**画面へのアクセス方法**：バックサイトホーム画面のナビゲーションメニューから「Newsletter」ボタンをクリックしてアクセスします。secondAdmin.bNewsletter権限を持つユーザーのみがアクセス可能です。URLは直接bs_newsletterList.aspにアクセスすることも可能です。

**主要な操作・処理内容**：
1. ニュースレターテンプレート一覧の閲覧：登録済みニュースレターの名前とIDを確認
2. 新規ニュースレター作成：「New Newsletter」ボタンから新規テンプレート作成画面へ遷移
3. 新規配信作成：「New Mailing」ボタンから配信メール作成画面へ遷移
4. 配信履歴確認：「Mailing History」ボタンから過去の配信履歴画面へ遷移
5. 購読者管理：「Subscribers」ボタンから購読者一覧画面へ遷移
6. メーリングリスト管理：「Email lists」ボタンからカテゴリ一覧画面へ遷移
7. ニュースレター複製：各ニュースレター横のコピーアイコンで複製処理を実行

**画面遷移**：
- 遷移元：バックサイトホーム画面（bs_default.asp）
- 遷移先：ニュースレター編集（bs_newsletterEdit.asp）、配信編集（bs_newsletterMailingEdit.asp）、配信履歴（bs_newsletterMailingHistory.asp）、購読者一覧（bs_newsletterSubscribers.asp）、カテゴリ一覧（bs_newsletterCategoryList.asp）

**権限による表示制御**：
- secondAdmin.bNewsletter権限がない場合はアクセス不可
- customer.bCanImportSubscribers設定により「New Mailing」「Mailing History」「Subscribers」ボタンの表示/非表示が制御される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | ニュースレター一覧 | 主機能 | 登録済みニュースレターの一覧表示 |
| 68 | ニュースレター作成・編集 | 遷移先機能 | 新規ニュースレター作成画面への遷移 |
| 71 | メーリング作成・送信 | 遷移先機能 | 配信メール作成画面への遷移 |
| 69 | 購読者管理 | 遷移先機能 | 購読者一覧画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

```
/asp/bs_newsletterList.asp
/asp/bs_newsletterList.asp?iNewsletterID={暗号化されたID}&{QS_secCodeURL}  （複製実行時）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| ニュースレターID | iNewsletterID | GET | - | 入力 | 複製対象のニュースレターID（暗号化済み） |
| セキュリティコード | QS_secCodeURL | GET | - | 入力 | CSRF対策用URLパラメータ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| New Newsletterボタン | 上部ボタンエリア | 新規ニュースレター作成画面へのリンク |
| New Mailingボタン | 上部ボタンエリア | 新規配信作成画面へのリンク（bCanImportSubscribersがtrueの場合のみ） |
| Mailing Historyボタン | 上部ボタンエリア | 配信履歴画面へのリンク（bCanImportSubscribersがtrueの場合のみ） |
| Subscribersボタン | 上部ボタンエリア | 購読者一覧画面へのリンク（bCanImportSubscribersがtrueの場合のみ） |
| Email listsボタン | 上部ボタンエリア | カテゴリ一覧画面へのリンク |
| ニュースレター名 | 一覧テーブル | 各ニュースレターの名前（編集画面へのリンク） |
| コピーアイコン | 一覧テーブル | ニュースレター複製機能のアイコン |
| iID | 一覧テーブル | ニュースレターの内部ID（参照用） |
| "No Newsletters available" | テーブル代替 | ニュースレターが0件の場合のメッセージ |

## イベント仕様

### 1-New Newsletterボタン押下

新規ニュースレター作成のため、bs_newsletterEdit.aspにパラメータなしで遷移します。

### 2-New Mailingボタン押下

新規配信メール作成のため、bs_newsletterMailingEdit.aspにパラメータなしで遷移します。

### 3-Mailing Historyボタン押下

配信履歴確認のため、bs_newsletterMailingHistory.aspに遷移します。

### 4-Subscribersボタン押下

購読者一覧表示のため、bs_newsletterSubscribers.aspに遷移します。

### 5-Email listsボタン押下

メーリングリスト（カテゴリ）一覧表示のため、bs_newsletterCategoryList.aspに遷移します。

### 6-ニュースレター名リンク押下

選択したニュースレターの編集画面（bs_newsletterEdit.asp）に遷移します。iNewsletterIDパラメータに暗号化されたIDが付与されます。

### 7-コピーアイコン押下

**処理フロー**：
1. JavaScript confirmダイアログで確認（"areyousuretocopy"メッセージ）
2. 確認後、bs_newsletterList.aspに対してiNewsletterIDとQS_secCodeURLパラメータ付きでリクエスト
3. サーバー側でcls_Newsletterインスタンスを生成し、copy()メソッドを実行
4. 複製完了後、新しいニュースレターの編集画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コピーアイコン押下 | tblNewsletter | INSERT | ニュースレターの複製 |
| 一覧表示 | tblNewsletter | SELECT | ニュースレター一覧取得 |

### テーブル別更新項目詳細

#### tblNewsletter（複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iId | 自動採番 | 新規ID |
| INSERT | sName | コピー元のsName | そのまま複製 |
| INSERT | sValue | コピー元のsValue | ニュースレター本文 |
| INSERT | sSubject | コピー元のsSubject | 件名 |
| INSERT | sFromEmail | コピー元のsFromEmail | 送信元メール |
| INSERT | sFromName | コピー元のsFromName | 送信元名 |
| INSERT | sUnsubscribeText | コピー元の値 | 購読解除テキスト |
| INSERT | sBodyBGColor | コピー元の値 | 背景色 |
| INSERT | sStyleLink | コピー元の値 | リンクスタイル |
| INSERT | bOnline | コピー元の値 | オンライン状態 |
| INSERT | iCustomerID | cId | 現在の顧客ID |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| areyousuretocopy | 確認 | コピーアイコン押下時 | 複製確認ダイアログ |
| (テキスト) | 情報 | ニュースレター0件時 | "No Newsletters available" |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bNewsletter権限チェックに失敗した場合、エラー表示 |
| 複製時のiNewsletterIDが不正 | decrypt処理失敗時、複製処理はスキップされ一覧表示のみ |

## 備考

- ニュースレター一覧はcustomer.Newslettersプロパティから取得される（Dictionary形式）
- bCanImportSubscribers設定は顧客のライセンスレベルに依存
- 複製機能はcls_Newsletterクラスのcopy()メソッドで実装されており、iIdをnullに設定してsave()を実行することで新規レコードとして保存

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ニュースレターに関するデータ構造とクラス定義を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletter.asp | `asp/includes/newsletter.asp` | cls_newsletterクラスの定義。プロパティ（sName, sValue, sSubject等）とcopy()メソッドを確認 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | customerオブジェクトのNewslettersプロパティ、bCanImportSubscribers設定を確認 |

**読解のコツ**: ASP/VBScriptでは、Dictionaryオブジェクトがハッシュマップとして使用されます。for each構文でキーをイテレートし、dictionary(key)でアクセスします。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterList.asp | `asp/bs_newsletterList.asp` | 画面表示のメインファイル。権限チェック、複製処理、一覧表示の流れを確認 |

**主要処理フロー**:
1. **1行目**: begin.aspインクルードで初期化
2. **4行目**: bs_security.aspインクルードとアクセス権限チェック（logon.hasaccess secondAdmin.bNewsletter）
3. **5-7行目**: copyNewsletter処理 - URLパラメータにiNewsletterIDがある場合、複製を実行
4. **8-10行目**: NewsletterCategoriesとNewslettersをcustomerオブジェクトから取得
5. **11-14行目**: ナビゲーションボタンの出力（bCanImportSubscribersによる条件分岐）
6. **13-14行目**: Newsletters.count > 0の場合、for eachループで一覧テーブルを生成

#### Step 3: 複製処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | newsletter.asp | `asp/includes/newsletter.asp` | copy()メソッド（132-137行目）でiIdをnullにしてsave()を呼ぶ実装を確認 |

**主要処理フロー**:
- **133行目**: isNumeriek(iId)でID存在確認
- **134行目**: iId = null で新規レコード扱いに変更
- **135行目**: save()でINSERT実行

### プログラム呼び出し階層図

```
bs_newsletterList.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │      └─ database.asp, session管理等
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bNewsletter)
    │
    ├─ includes/header.asp（ヘッダー）
    │
    ├─ cls_Newsletter（複製処理）
    │      ├─ Class_Initialize()
    │      │      └─ pick(decrypt(request("iNewsletterID")))
    │      └─ copy()
    │             └─ save() → tblNewsletter INSERT
    │
    ├─ customer.NewsletterCategories（Dictionary）
    │
    ├─ customer.Newsletters（Dictionary）
    │      └─ for each ループで一覧表示
    │
    └─ includes/footer.asp（フッター）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ
iNewsletterID ─────────▶ copyNewsletter.copy() ─────────▶ 新規Newsletter作成
（複製時）                   │                                │
                            └─▶ Response.Redirect ──────────▶ 編集画面へ

customer.Newsletters ──────▶ for each ループ ──────────────▶ 一覧テーブル
（Dictionary）                                                 │
                                                               ├─ sName（リンク）
                                                               ├─ コピーアイコン
                                                               └─ iID
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterList.asp | `asp/bs_newsletterList.asp` | ソース | ニュースレター一覧画面 |
| bs_newsletterEdit.asp | `asp/bs_newsletterEdit.asp` | ソース | ニュースレター編集画面 |
| bs_newsletterMailingEdit.asp | `asp/bs_newsletterMailingEdit.asp` | ソース | 配信編集画面 |
| bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | ソース | 配信履歴画面 |
| bs_newsletterSubscribers.asp | `asp/bs_newsletterSubscribers.asp` | ソース | 購読者一覧画面 |
| bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | ソース | カテゴリ一覧画面 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | ニュースレタークラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス定義（Newslettersプロパティ含む） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
