# 画面設計書 43-ニュースレター編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「ニュースレター編集」画面の設計書です。

### 本画面の処理概要

ニュースレターテンプレートの作成・編集を行う画面です。メール配信時に使用するHTMLメールの本文、件名、送信元情報、購読解除リンクのテキスト・スタイルなど、ニュースレターの全ての設定を管理します。WYSIWYGエディタを搭載しており、HTMLの知識がなくても視覚的にニュースレターをデザインできます。

**業務上の目的・背景**：ニュースレターはメールマーケティングの中心的なコンテンツです。本画面では、ブランドイメージに合わせたデザインのメールテンプレートを作成し、繰り返し使用できるようにします。テンプレートには動的変数（[NL_NAME]、[NL_EMAIL]、[NL_UNSUBSCRIBELINK]）を埋め込むことができ、配信時に購読者ごとにパーソナライズされたメールを生成します。作成したテンプレートはデフォルトテンプレートとして保存でき、新規作成時の雛形として再利用できます。

**画面へのアクセス方法**：ニュースレター一覧画面（bs_newsletterList.asp）から「New Newsletter」ボタンをクリックして新規作成、または既存ニュースレター名をクリックして編集画面にアクセスします。iNewsletterIDパラメータがない場合は新規作成モード、ある場合は編集モードとなります。

**主要な操作・処理内容**：
1. ニュースレター名の入力：識別用の名前を設定
2. 送信元情報の設定：From Email、From Nameを設定
3. 件名の設定：メールの件名を設定（動的変数使用可能）
4. 本文の編集：WYSIWYGエディタでHTML本文を作成
5. 背景色の設定：メール本文の背景色を指定
6. 購読解除リンクの設定：テキストとCSSスタイルを設定
7. プレビュー送信：指定したメールアドレスにテスト送信
8. デフォルトテンプレート保存：現在の設定を新規作成時のデフォルトとして保存
9. 削除：既存ニュースレターの削除

**画面遷移**：
- 遷移元：ニュースレター一覧画面（bs_newsletterList.asp）
- 遷移先：ニュースレター一覧画面（bs_newsletterList.asp）（保存後・削除後・戻る時）

**権限による表示制御**：secondAdmin.bNewsletter権限がない場合はアクセス不可。既存ニュースレター編集時のみ「プレビュー送信」「削除」機能が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 68 | ニュースレター作成・編集 | 主機能 | ニュースレターの作成・コンテンツ編集 |

## 画面種別

登録・編集

## URL/ルーティング

```
/asp/bs_newsletterEdit.asp  （新規作成）
/asp/bs_newsletterEdit.asp?iNewsletterID={暗号化されたID}  （編集）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| ニュースレターID | iNewsletterID | hidden | - | 入力 | 暗号化されたニュースレターID |
| ポストバックフラグ | postBack | hidden | - | 入力 | フォーム送信フラグ |
| セキュリティコード | QS_secCodeHidden | hidden | - | 入力 | CSRF対策用トークン |
| 名前 | sName | text | 必須 | 入力 | ニュースレターの識別名（最大150文字） |
| 送信元メール | sFromEmail | text | 必須 | 入力 | From Emailアドレス（最大50文字） |
| 送信元名 | sFromName | text | 必須 | 入力 | From Name（最大50文字） |
| 件名 | sSubject | text | 必須 | 入力 | メール件名（最大150文字） |
| 本文 | sValue | textarea | - | 入力 | HTML本文（WYSIWYGエディタ） |
| 背景色 | sBodyBGColor | text | 必須 | 入力 | 本文背景色（カラーコード） |
| 購読解除テキスト | sUnsubscribeText | text | 必須 | 入力 | 購読解除リンクのテキスト（最大50文字） |
| 購読解除リンクスタイル | sStyleLink | text | - | 入力 | CSSスタイル（最大250文字） |
| プレビュー送信先名 | previewName | text | - | 入力 | プレビュー送信先の名前 |
| プレビュー送信先メール | previewEmail | text | - | 入力 | プレビュー送信先のメールアドレス |
| デフォルト保存フラグ | bSaveAsTemplate | checkbox | - | 入力 | デフォルトテンプレートとして保存 |
| アクションボタン | btnaction | submit | - | 入力 | save/send/delete |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| 戻るリンク | 上部・下部 | ニュースレター一覧への戻りリンク |
| General見出し | フォーム内 | 「General:」セクションヘッダー |
| プレビュー送信エリア | フォーム内 | 既存ニュースレターのみ表示、送信成功時は「Preview was sent!」メッセージ |
| 必須項目説明 | フォーム下部 | 「(*) mandatory」の表示 |
| 保存ボタン | フォーム下部 | 「save」ボタン |
| 削除ボタン | フォーム下部 | 「delete」ボタン（既存のみ） |
| デフォルト保存チェックボックス | フォーム下部 | 「Save as default new newsletter」 |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. フォームデータがPOSTされる
2. postBack=trueでgetRequestValues()が呼ばれ、フォーム値を取得
3. checkCSRF()でCSRF検証
4. Newsletter.save()でバリデーションとデータベース保存
5. bSaveAsTemplateがtrueの場合、customer.sNLTemplateに設定を保存してcustomer.save()
6. 成功時、"fb_saveOK"メッセージを表示

### 2-プレビュー送信ボタン押下

**処理フロー**：
1. フォームデータがPOSTされる（btnaction="send"）
2. getRequestValues()でフォーム値を取得
3. Newsletter.save()で一旦保存
4. previewNameとpreviewEmailを取得
5. Newsletter.send(previewName, previewEmail, "")でプレビューメール送信
6. 画面に「Preview was sent!」メッセージを表示

### 3-削除ボタン押下

**処理フロー**：
1. JavaScript confirmで削除確認
2. 確認後、btnaction="delete"でPOST
3. Newsletter.remove()でデータベースからレコード削除
4. ニュースレター一覧画面にリダイレクト

### 4-戻るリンク押下

ニュースレター一覧画面（bs_newsletterList.asp）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（新規） | tblNewsletter | INSERT | 新規ニュースレター作成 |
| 保存ボタン押下（既存） | tblNewsletter | UPDATE | ニュースレター更新 |
| 保存ボタン押下（デフォルト保存時） | tblCustomer | UPDATE | sNLTemplateカラム更新 |
| 削除ボタン押下 | tblNewsletter | DELETE | ニュースレター削除 |

### テーブル別更新項目詳細

#### tblNewsletter

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値（最大150文字） | ニュースレター名 |
| INSERT/UPDATE | bOnline | フォーム入力値 | オンライン状態 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | sValue | フォーム入力値 | HTML本文 |
| INSERT/UPDATE | sSubject | フォーム入力値（最大150文字） | 件名 |
| INSERT/UPDATE | sFromName | フォーム入力値（最大50文字） | 送信元名 |
| INSERT/UPDATE | sFromEmail | フォーム入力値（最大50文字） | 送信元メール |
| INSERT/UPDATE | sUnsubscribeText | フォーム入力値（最大50文字） | 購読解除テキスト |
| INSERT/UPDATE | sBodyBGColor | フォーム入力値（最大50文字） | 背景色 |
| INSERT/UPDATE | sStyleLink | フォーム入力値（最大255文字） | リンクスタイル |

#### tblCustomer（デフォルト保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sNLTemplate | 各項目を「\|\|\|###qsdelimiter###\|\|\|」で連結した文字列 | デフォルトテンプレート |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存完了メッセージ |
| err_mandatory | エラー | 必須項目未入力時 | 必須項目エラー |
| err_email | エラー | メールアドレス形式不正時 | メール形式エラー |
| areyousure | 確認 | 削除ボタン押下時 | 削除確認ダイアログ |
| (テキスト) | 成功 | プレビュー送信成功時 | "Preview was sent!" |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bNewsletter権限チェックに失敗した場合、エラー表示 |
| 必須項目未入力 | check()でfalseを返し、err_mandatoryエラーメッセージ表示 |
| メールアドレス形式不正 | checkEmailSyntax()失敗時、err_emailエラーメッセージ表示 |
| CSRF検証失敗 | checkCSRF()で処理中断 |

## 備考

- 本文はWYSIWYGエディタ（FCKEditor）で編集可能
- デフォルトテンプレートはcustomer.sNLTemplateに「|||###qsdelimiter###|||」区切りで保存
- プレビュー送信先のデフォルトはcustomer.webmasterとcustomer.webmasterEmail
- 本文内で使用可能な変数：[NL_NAME]（購読者名）、[NL_EMAIL]（購読者メール）、[NL_UNSUBSCRIBELINK]（購読解除リンク）
- JQColorPickerでカラーピッカーUI提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletter.asp | `asp/includes/newsletter.asp` | cls_newsletterクラス。プロパティ定義（3行目）、Class_Initialize（5-35行目）、getRequestValues（43-57行目）、Check（78-92行目）、Save（93-124行目）、send（139-170行目）を確認 |

**読解のコツ**: Class_Initializeでは、customer.sNLTemplateが存在する場合にデフォルト値を分割して各プロパティにセットしています。"|||###qsdelimiter###|||"が区切り文字です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterEdit.asp | `asp/bs_newsletterEdit.asp` | 画面表示のメインファイル。処理分岐（8-25行目）とフォーム生成を確認 |

**主要処理フロー**:
1. **4行目**: 権限チェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5行目**: cls_Newsletterインスタンス生成（request("iNewsletterID")からpick）
3. **7行目**: postBack取得
4. **8-11行目**: 削除処理判定とremove()実行
5. **13-25行目**: 保存/プレビュー送信処理
6. **29-30行目**: フォーム生成とWYSIWYGエディタ配置

#### Step 3: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | newsletter.asp | `asp/includes/newsletter.asp` | send()メソッド（139-170行目）。動的変数置換とcls_mail_messageによるメール送信処理を確認 |

**主要処理フロー**:
- **161-165行目**: [NL_NAME]、[NL_EMAIL]の置換
- **166行目**: [NL_UNSUBSCRIBELINK]の生成と置換
- **167-169行目**: cls_mail_messageでメール送信

### プログラム呼び出し階層図

```
bs_newsletterEdit.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bNewsletter)
    │
    ├─ cls_Newsletter
    │      ├─ Class_Initialize()
    │      │      └─ pick(decrypt(request("iNewsletterID")))
    │      │
    │      ├─ getRequestValues()
    │      │      └─ bSaveAsTemplate時 → customer.save()
    │      │
    │      ├─ save()
    │      │      ├─ check()
    │      │      │      └─ checkEmailSyntax(sFromEmail)
    │      │      └─ tblNewsletter INSERT/UPDATE
    │      │
    │      ├─ send(previewName, previewEmail, "")
    │      │      ├─ treatConstants(copyV)
    │      │      ├─ 動的変数置換
    │      │      └─ cls_mail_message.send()
    │      │
    │      └─ remove()
    │             └─ tblNewsletter DELETE
    │
    ├─ createFCKInstance()（WYSIWYGエディタ）
    │
    ├─ JQColorPicker()（カラーピッカー）
    │
    └─ includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                           [出力]

フォーム入力
├─ sName ─────────────────▶ getRequestValues() ────────────▶ tblNewsletter
├─ sFromEmail                     │
├─ sFromName                      ├─ check()
├─ sSubject                       │    └─ バリデーション
├─ sValue                         │
├─ sBodyBGColor                   └─ save()
├─ sUnsubscribeText                    └─ INSERT/UPDATE
└─ sStyleLink

bSaveAsTemplate ───────────▶ customer.sNLTemplate ─────────▶ tblCustomer
                                 └─ デリミタ連結

previewName/Email ─────────▶ Newsletter.send() ────────────▶ メール送信
                                 ├─ 変数置換
                                 └─ cls_mail_message
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterEdit.asp | `asp/bs_newsletterEdit.asp` | ソース | ニュースレター編集画面 |
| bs_newsletterList.asp | `asp/bs_newsletterList.asp` | ソース | ニュースレター一覧画面 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | ニュースレタークラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（sNLTemplate保存） |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコードJS |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
