# 画面設計書 47-カテゴリ一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「カテゴリ一覧」画面（ニュースレターカテゴリ一覧/Email lists）の設計書です。

### 本画面の処理概要

ニュースレターのメーリングリスト（カテゴリ）を一覧表示・管理するための画面です。各カテゴリは購読者グループを表し、ニュースレター配信時に送信先グループとして使用されます。本画面では新規カテゴリの作成、既存カテゴリの編集、購読者数の確認、フロントエンド用の購読フォームタグのコピーが可能です。

**業務上の目的・背景**：ニュースレターマーケティングでは、購読者を目的別・興味別にグループ分けすることが重要です。例えば「製品アップデート」「セール情報」「ブログ更新通知」など、異なるコンテンツを異なる購読者層に配信できます。本画面は、そうしたメーリングリストの管理を行うハブとなります。各カテゴリには独自の購読フォーム、ウェルカムメッセージ、購読解除ページを設定できます。

**画面へのアクセス方法**：ニュースレター一覧画面（bs_newsletterList.asp）の「Email lists」ボタン、または購読者一覧画面からアクセスします。URLパラメータは不要です。

**主要な操作・処理内容**：
1. カテゴリ一覧の閲覧：登録済みカテゴリ名と購読者数を表示
2. 新規カテゴリ作成：「Create new Email list」ボタンから作成画面へ遷移
3. カテゴリ編集：カテゴリ名クリックで編集画面へ遷移
4. 購読者一覧へ遷移：購読者数リンクで該当カテゴリの購読者一覧を表示
5. テンプレートタグのコピー：[QS_NLCAT_ID]形式のタグをコピー

**画面遷移**：
- 遷移元：ニュースレター一覧画面（bs_newsletterList.asp）、購読者一覧画面（bs_newsletterSubscribers.asp）
- 遷移先：カテゴリ編集画面（bs_newsletterCategoryEdit.asp）、購読者一覧画面（bs_newsletterSubscribers.asp）、ニュースレター一覧画面（bs_newsletterList.asp）

**権限による表示制御**：secondAdmin.bNewsletter権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | メールリスト管理 | 主機能 | 購読者グループ分けカテゴリの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
/asp/bs_newsletterCategoryList.asp
```

## 入出力項目

なし（一覧表示のみ）

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| Create new Email listボタン | 上部 | 新規カテゴリ作成画面へのリンク |
| Newsletter homeボタン | 上部 | ニュースレター一覧画面へのリンク |
| カテゴリ名 | 一覧テーブル | 各カテゴリの名前（編集画面へのリンク） |
| 購読者数リンク | 一覧テーブル | 「X subscribers」形式で購読者数を表示（購読者一覧へのリンク） |
| テンプレートタグ | 一覧テーブル | [QS_NLCAT_{ID}]形式のタグ入力欄（クリックで選択可能） |
| "No lists yet..." | テーブル代替 | カテゴリが0件の場合のメッセージ |

## イベント仕様

### 1-Create new Email listボタン押下

カテゴリ編集画面（bs_newsletterCategoryEdit.asp）にパラメータなしで遷移します。新規作成モードになります。

### 2-Newsletter homeボタン押下

ニュースレター一覧画面（bs_newsletterList.asp）に遷移します。

### 3-カテゴリ名リンク押下

選択したカテゴリの編集画面（bs_newsletterCategoryEdit.asp）に遷移します。iNewsletterCategoryIDパラメータに暗号化されたIDが付与されます。

### 4-購読者数リンク押下

選択したカテゴリの購読者一覧画面（bs_newsletterSubscribers.asp）に遷移します。iCategoryIDパラメータに暗号化されたIDが付与されます。

### 5-テンプレートタグ入力欄クリック

JavaScript onclick="this.select()"により、入力欄の内容が全選択され、コピーしやすくなります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblNewsletterCategory | SELECT | customer.NewsletterCategoriesから取得 |
| 購読者数表示 | tblNewsletterCategorySubscriber | SELECT | nmbrSubscribersプロパティで集計 |

### テーブル別更新項目詳細

本画面ではデータベース更新は発生しません（参照のみ）。

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| (テキスト) | 情報 | カテゴリ0件時 | "No lists yet..." |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bNewsletter権限チェックに失敗した場合、エラー表示 |

## 備考

- カテゴリ一覧はcustomer.NewsletterCategoriesプロパティから取得（Dictionary形式）
- 購読者数はcls_newsletterCategoryクラスのnmbrSubscribersプロパティで取得
- nmbrSubscribersはbActive=trueの購読者のみをカウント
- テンプレートタグ[QS_NLCAT_{ID}]はフロントエンドのページにニュースレター購読フォームを埋め込むために使用
- フォームのHTMLはカテゴリ編集画面で設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | cls_newsletterCategoryクラス。sName、nmbrSubscribersプロパティを確認 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | NewsletterCategoriesプロパティの実装を確認 |

**読解のコツ**: nmbrSubscribers（100-105行目）はSELECT count(*)でbActive=trueのみをカウントしています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | 画面表示のメインファイル。シンプルなfor eachループで一覧生成 |

**主要処理フロー**:
1. **4行目**: 権限チェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5行目**: customer.NewsletterCategoriesを取得
3. **5行目**: ナビゲーションボタン出力
4. **5-6行目**: NewsletterCategories.count > 0の条件分岐
5. **6行目**: for each NewsletterKey in NewsletterCategoriesでループ
   - カテゴリ名（編集リンク）
   - 購読者数（購読者一覧リンク）
   - テンプレートタグ入力欄

### プログラム呼び出し階層図

```
bs_newsletterCategoryList.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bNewsletter)
    │
    ├─ customer.NewsletterCategories（Dictionary）
    │      └─ cls_newsletterCategory インスタンス群
    │             ├─ sName
    │             └─ nmbrSubscribers
    │                    └─ SELECT count(*) FROM tblNewsletterCategorySubscriber
    │
    └─ includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                           [出力]

（なし）                    customer.NewsletterCategories ──▶ 一覧テーブル
                                 │                                │
                                 └─ for each                      ├─ カテゴリ名（リンク）
                                        │                         ├─ 購読者数（リンク）
                                        └─ cls_newsletterCategory  └─ [QS_NLCAT_{ID}]タグ
                                               │
                                               └─ nmbrSubscribers
                                                      └─ SELECT count(*)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | ソース | カテゴリ一覧画面 |
| bs_newsletterCategoryEdit.asp | `asp/bs_newsletterCategoryEdit.asp` | ソース | カテゴリ編集画面 |
| bs_newsletterSubscribers.asp | `asp/bs_newsletterSubscribers.asp` | ソース | 購読者一覧画面 |
| bs_newsletterList.asp | `asp/bs_newsletterList.asp` | ソース | ニュースレター一覧画面 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | カテゴリクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（NewsletterCategories） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
