# 画面設計書 48-カテゴリ編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「カテゴリ編集」画面（ニュースレターカテゴリ編集）の設計書です。

### 本画面の処理概要

ニュースレターのメーリングリスト（カテゴリ）の詳細設定を行う画面です。カテゴリ名、購読フォームのHTML、ウェルカムメッセージ、購読解除後のフィードバックページ、エラーメッセージ、新規登録通知メールの設定が可能です。フロントエンドに表示される購読フォームと、購読・購読解除時のユーザー体験を完全にカスタマイズできます。

**業務上の目的・背景**：ニュースレター購読のユーザー体験はブランドイメージに直結します。本画面では、サイトのデザインに合わせた購読フォーム、パーソナライズされたウェルカムメッセージ、丁寧な購読解除フィードバックページを設定することで、プロフェッショナルなメールマーケティングを実現します。また、新規購読者の通知メールを設定することで、マーケティングチームがリアルタイムで購読状況を把握できます。

**画面へのアクセス方法**：カテゴリ一覧画面（bs_newsletterCategoryList.asp）から「Create new Email list」ボタンまたは既存カテゴリ名をクリックしてアクセスします。iNewsletterCategoryIDパラメータがない場合は新規作成モード、ある場合は編集モードとなります。

**主要な操作・処理内容**：
1. カテゴリ名の設定：メーリングリストの識別名
2. 購読フォームの設定：フロントエンドに埋め込むHTMLフォーム
3. 必須項目設定：名前とメールの両方を必須にするかどうか
4. エラーメッセージの設定：入力エラー時に表示するメッセージ
5. 通知メール設定：新規購読時に管理者へ通知するメールアドレス
6. ウェルカムメッセージの設定：購読完了時に表示するメッセージ
7. 購読解除フィードバックの設定：購読解除時に表示するページタイトルと内容
8. 削除：既存カテゴリの削除（関連する購読者も全削除）

**画面遷移**：
- 遷移元：カテゴリ一覧画面（bs_newsletterCategoryList.asp）
- 遷移先：カテゴリ一覧画面（bs_newsletterCategoryList.asp）（保存後・削除後・戻る時）

**権限による表示制御**：secondAdmin.bNewsletter権限がない場合はアクセス不可。既存カテゴリ編集時のみ「削除」ボタンが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | メールリスト管理 | 主機能 | 購読者カテゴリの詳細設定 |

## 画面種別

登録・編集

## URL/ルーティング

```
/asp/bs_newsletterCategoryEdit.asp  （新規作成）
/asp/bs_newsletterCategoryEdit.asp?iNewsletterCategoryID={暗号化されたID}  （編集）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| カテゴリID | iNewsletterCategoryID | hidden | - | 入力 | 暗号化されたカテゴリID |
| ポストバックフラグ | postBack | hidden | - | 入力 | フォーム送信フラグ |
| セキュリティコード | QS_secCodeHidden | hidden | - | 入力 | CSRF対策用トークン |
| カテゴリ名 | sName | text | 必須 | 入力 | メーリングリストの名前（最大50文字） |
| 購読フォーム | sSignupForm | textarea | 必須 | 入力 | フロントエンド用HTMLフォーム |
| 名前・メール両方必須 | bRequireBoth | checkbox | - | 入力 | チェック時は名前とメールの両方を必須 |
| エラーメッセージ | sErrorMessage | text | 必須 | 入力 | 入力エラー時のメッセージ（最大255文字） |
| 通知メール | sNotifEmail | text | - | 入力 | 新規購読通知先メールアドレス（最大50文字） |
| ウェルカムメッセージ | sWelcomeMessage | textarea | 必須 | 入力 | 購読完了時のメッセージ（WYSIWYG） |
| 購読解除ページタイトル | sUnsubscribeFBTitle | text | 必須 | 入力 | 購読解除ページのタイトル（最大50文字） |
| 購読解除フィードバック | sUnsubscribeFB | textarea | 必須 | 入力 | 購読解除時のメッセージ（WYSIWYG） |
| アクションボタン | btnaction | submit | - | 入力 | save/delete |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| 戻るリンク | 上部・下部 | カテゴリ一覧への戻りリンク |
| List name入力欄 | フォーム | カテゴリ名入力（40文字幅） |
| Signup formテキストエリア | フォーム | HTMLフォーム入力（90列×20行） |
| Require both name and emailチェックボックス | フォーム | 必須項目設定 |
| Error message入力欄 | フォーム | エラーメッセージ入力（90文字幅） |
| Email notification入力欄 | フォーム | 通知先メールアドレス入力 |
| Welcome messageエディタ | フォーム | WYSIWYGエディタ |
| Unsubscribe-feedback page-title入力欄 | フォーム | 購読解除ページタイトル入力 |
| Unsubscribe-feedbackエディタ | フォーム | WYSIWYGエディタ |
| 必須項目説明 | フォーム下部 | 「(*) mandatory」の表示 |
| 保存ボタン | フォーム下部 | 「save」ボタン |
| 削除ボタン | フォーム下部 | 「delete」ボタン（既存のみ） |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. フォームデータがPOSTされる
2. postBack=trueでgetRequestValues()が呼ばれ、フォーム値を取得
3. checkCSRF()でCSRF検証
4. newsletterCategory.save()でバリデーションとデータベース保存
5. check()でsName、sUnsubscribeFB、sUnsubscribeFBTitleの必須チェック
6. 成功時、"fb_saveOK"メッセージを表示

### 2-削除ボタン押下

**処理フロー**：
1. JavaScript confirmで削除確認
2. 確認後、btnaction="delete"でPOST
3. newsletterCategory.remove()で実行
   - tblNewsletterCategorySubscriberから購読者を全削除
   - tblNewsletterCategoryからカテゴリを削除
4. カテゴリ一覧画面にリダイレクト

### 3-戻るリンク押下

カテゴリ一覧画面（bs_newsletterCategoryList.asp）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（新規） | tblNewsletterCategory | INSERT | 新規カテゴリ作成 |
| 保存ボタン押下（既存） | tblNewsletterCategory | UPDATE | カテゴリ更新 |
| 削除ボタン押下 | tblNewsletterCategorySubscriber | DELETE | 購読者全削除 |
| 削除ボタン押下 | tblNewsletterCategory | DELETE | カテゴリ削除 |

### テーブル別更新項目詳細

#### tblNewsletterCategory

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値（最大50文字） | カテゴリ名 |
| INSERT/UPDATE | sSignupForm | フォーム入力値 | 購読フォームHTML |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | sUnsubscribeFB | フォーム入力値 | 購読解除メッセージ |
| INSERT/UPDATE | sUnsubscribeFBTitle | フォーム入力値（最大50文字） | 購読解除タイトル |
| INSERT/UPDATE | sWelcomeMessage | フォーム入力値 | ウェルカムメッセージ |
| INSERT/UPDATE | bRequireBoth | フォーム入力値 | 両方必須フラグ |
| INSERT/UPDATE | sErrorMessage | フォーム入力値（最大255文字） | エラーメッセージ |
| INSERT/UPDATE | sNotifEmail | フォーム入力値（最大50文字） | 通知先メール |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存完了メッセージ |
| err_mandatory | エラー | 必須項目未入力時 | 必須項目エラー |
| areyousure | 確認 | 削除ボタン押下時 | 削除確認ダイアログ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bNewsletter権限チェックに失敗した場合、エラー表示 |
| 必須項目未入力 | check()でfalseを返し、err_mandatoryエラーメッセージ表示 |
| CSRF検証失敗 | checkCSRF()で処理中断 |

## 備考

- 購読フォームには以下のプレースホルダーが使用可能:
  - {ID}: カテゴリID
  - {N}: 名前入力フィールド名
  - {E}: メール入力フィールド名
  - {NL_HIDDENFIELD_DO_NOT_TOUCH}: CSRFトークン用hiddenフィールド
  - {NL_NAME}: 既存の名前値
  - {NL_EMAIL}: 既存のメール値
  - {AJAX}: Ajaxフォーム送信用JavaScript
- ウェルカムメッセージと購読解除フィードバックには[NL_NAME]、[NL_EMAIL]変数が使用可能
- デフォルトの購読フォームテンプレートはClass_Initializeで設定
- WYSIWYGエディタはcreateFCKInstance関数で生成（siteBuilderRichTextモード）
- 削除時は関連する購読者も全て削除されるため、確認ダイアログで注意喚起

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | cls_newsletterCategoryクラス。プロパティ定義（3行目）、Class_Initialize（5-15行目）でデフォルト値設定、getRequestValues（16-25行目）、Check（45-59行目）、Save（60-90行目）、remove（91-99行目）、build（106-127行目）を確認 |

**読解のコツ**: Class_Initializeでsignupformのデフォルトテンプレートが設定されています。{ID}、{N}、{E}などのプレースホルダーの意味を理解することが重要です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterCategoryEdit.asp | `asp/bs_newsletterCategoryEdit.asp` | 画面表示のメインファイル。保存・削除の分岐処理を確認 |

**主要処理フロー**:
1. **4行目**: 権限チェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5行目**: cls_newsletterCategoryインスタンス生成（request("iNewsletterCategoryID")からpick）
3. **7行目**: postBack取得
4. **8-11行目**: 削除処理判定とremove()実行
5. **12-17行目**: 保存処理
   - getRequestValues()
   - checkCSRF()
   - save() + message.Add("fb_saveOK")
6. **18-19行目**: フォーム生成とWYSIWYGエディタ配置

#### Step 3: フロントエンド動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | build()メソッド（106-127行目）でフロントエンドフォーム生成、registerNameAndEmail()（128-184行目）で購読処理を確認 |

**主要処理フロー**:
- **106-127行目**: build()でプレースホルダー置換
- **128-184行目**: registerNameAndEmail()でフォーム送信処理

### プログラム呼び出し階層図

```
bs_newsletterCategoryEdit.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bNewsletter)
    │
    ├─ cls_newsletterCategory
    │      ├─ Class_Initialize()
    │      │      └─ デフォルトフォームテンプレート設定
    │      │      └─ pick(decrypt(request("iNewsletterCategoryID")))
    │      │
    │      ├─ getRequestValues()
    │      │
    │      ├─ save()
    │      │      ├─ check()（必須チェック）
    │      │      └─ tblNewsletterCategory INSERT/UPDATE
    │      │
    │      └─ remove()
    │             ├─ tblNewsletterCategorySubscriber DELETE
    │             └─ tblNewsletterCategory DELETE
    │
    ├─ createFCKInstance()（WYSIWYGエディタ）
    │      └─ sWelcomeMessage, sUnsubscribeFB用
    │
    └─ includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                           [出力]

フォーム入力
├─ sName ─────────────────▶ getRequestValues() ────────────▶ cls_newsletterCategory
├─ sSignupForm                    │
├─ bRequireBoth                   ├─ check()
├─ sErrorMessage                  │    └─ 必須チェック
├─ sNotifEmail                    │
├─ sWelcomeMessage                └─ save()
├─ sUnsubscribeFBTitle                 └─ INSERT/UPDATE
└─ sUnsubscribeFB

btnaction="delete" ───────▶ remove() ───────────────────────▶ tblNewsletterCategorySubscriber DELETE
                                 │                                tblNewsletterCategory DELETE
                                 └─ Response.Redirect
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterCategoryEdit.asp | `asp/bs_newsletterCategoryEdit.asp` | ソース | カテゴリ編集画面 |
| bs_newsletterCategoryList.asp | `asp/bs_newsletterCategoryList.asp` | ソース | カテゴリ一覧画面 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | カテゴリクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
