# 画面設計書 49-配信編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「配信編集」画面の設計書です。

### 本画面の処理概要

ニュースレターの配信（メーリング）設定を行う画面です。既存のニュースレターテンプレートを選択し、送信先のメーリングリスト（カテゴリ）を指定して、配信の準備を行います。配信前にプレビューメールを送信して内容を確認でき、配信履歴（レポート）を保存するかどうかも設定できます。

**業務上の目的・背景**：ニュースレター配信は慎重に行う必要があります。本画面では、送信前にテンプレートと送信先を確認し、プレビュー送信で実際のメール内容を検証してから本番配信に進むというワークフローを提供します。配信履歴を保存することで、後から開封率などのレポートを確認できます。

**画面へのアクセス方法**：ニュースレター一覧画面（bs_newsletterList.asp）の「New Mailing」ボタンをクリックしてアクセスします。既存の配信設定を編集する場合は、配信履歴画面からiNewsletterMailingIDパラメータ付きでアクセスします。

**主要な操作・処理内容**：
1. ニュースレター選択：配信するニュースレターテンプレートを選択
2. メーリングリスト選択：送信先カテゴリを選択（ラジオボタン）
3. 配信履歴保存設定：チェックするとレポート用にログを保存
4. プレビュー送信：指定したメールアドレスにテスト送信
5. 続行：配信送信画面（bs_newsletterMailingSend.asp）へ遷移
6. 削除：既存の配信設定を削除

**画面遷移**：
- 遷移元：ニュースレター一覧画面（bs_newsletterList.asp）、配信履歴画面（bs_newsletterMailingHistory.asp）
- 遷移先：配信送信画面（bs_newsletterMailingSend.asp）、ニュースレター一覧画面（bs_newsletterList.asp）

**権限による表示制御**：secondAdmin.bNewsletter権限がない場合はアクセス不可。既存の配信設定編集時のみ「削除」ボタンが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | メーリング作成・送信 | 主機能 | 配信メールの作成・編集 |

## 画面種別

登録・編集

## URL/ルーティング

```
/asp/bs_newsletterMailingEdit.asp  （新規作成）
/asp/bs_newsletterMailingEdit.asp?iNewsletterMailingID={暗号化されたID}  （編集）
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|--------|--------|-----|------|-----------|------|
| 配信ID | iNewsletterMailingID | hidden | - | 入力 | 暗号化された配信ID |
| ポストバックフラグ | postBack | hidden | - | 入力 | フォーム送信フラグ |
| セキュリティコード | QS_secCodeHidden | hidden | - | 入力 | CSRF対策用トークン |
| ニュースレター | iNewsletterID | select | 必須 | 入力 | 配信するニュースレターのID |
| メーリングリスト | sCategory | radio | 必須 | 入力 | 送信先カテゴリID |
| 配信履歴保存 | bLog | checkbox | - | 入力 | チェック時はレポート用ログを保存 |
| プレビュー送信先名 | previewName | text | - | 入力 | プレビュー送信先の名前 |
| プレビュー送信先メール | previewEmail | text | - | 入力 | プレビュー送信先のメールアドレス |
| アクションボタン | btnaction | submit | - | 入力 | send/continue/delete |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|---------|------|
| 戻るリンク | 上部・下部 | ニュースレター一覧への戻りリンク |
| General見出し | フォーム内 | 「General:」セクションヘッダー |
| ニュースレター選択 | フォーム | ドロップダウンリスト |
| メーリングリスト選択 | フォーム | ラジオボタン（カテゴリ名と購読者数を表示） |
| 配信履歴保存チェック | フォーム | 「Store mailing for future reporting?」 |
| プレビュー送信エリア | フォーム | 名前・メール入力欄と送信ボタン、送信成功メッセージ |
| 必須項目説明 | フォーム下部 | 「(*) mandatory」の表示 |
| 続行ボタン | フォーム下部 | 「continue」ボタン |
| 削除ボタン | フォーム下部 | 「delete」ボタン（既存のみ） |

## イベント仕様

### 1-続行ボタン押下

**処理フロー**：
1. フォームデータがPOSTされる（btnaction="continue"）
2. postBack=trueでgetRequestValues()が呼ばれ、フォーム値を取得
3. checkCSRF()でCSRF検証
4. newsletterMailing.save()でバリデーションとデータベース保存
5. check()でiNewsletterIDとsCategoryの必須チェック
6. 成功時、配信送信画面にリダイレクト

### 2-プレビュー送信ボタン押下

**処理フロー**：
1. フォームデータがPOSTされる（btnaction="send"）
2. getRequestValues()でフォーム値を取得
3. newsletterMailing.save()で一旦保存
4. previewNameとpreviewEmailを取得
5. newsletterMailing.Newsletter.send(previewName, previewEmail, "")でプレビューメール送信
6. 画面に「Preview was sent!」メッセージを表示

### 3-削除ボタン押下

**処理フロー**：
1. JavaScript confirmで削除確認
2. 確認後、btnaction="delete"でPOST
3. newsletterMailing.remove()で実行
   - tblNewsletterLogから配信ログを削除
   - tblNewsletterMailingから配信設定を削除
4. ニュースレター一覧画面にリダイレクト

### 4-戻るリンク押下

ニュースレター一覧画面（bs_newsletterList.asp）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 続行ボタン押下（新規） | tblNewsletterMailing | INSERT | 新規配信設定作成 |
| 続行ボタン押下（既存） | tblNewsletterMailing | UPDATE | 配信設定更新 |
| 削除ボタン押下 | tblNewsletterLog | DELETE | 配信ログ削除 |
| 削除ボタン押下 | tblNewsletterMailing | DELETE | 配信設定削除 |

### テーブル別更新項目詳細

#### tblNewsletterMailing

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | iNewsletterID | フォーム入力値 | 選択されたニュースレターID |
| INSERT/UPDATE | sCategory | フォーム入力値 | 選択されたカテゴリID |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | bLog | フォーム入力値 | 配信履歴保存フラグ |
| INSERT/UPDATE | dSentDate | NULL（送信時に更新） | 送信日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| err_mandatory | エラー | 必須項目未選択時 | 必須項目エラー |
| areyousure | 確認 | 削除ボタン押下時 | 削除確認ダイアログ |
| (テキスト) | 成功 | プレビュー送信成功時 | "Preview was sent!" |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| アクセス権限なし | secondAdmin.bNewsletter権限チェックに失敗した場合、エラー表示 |
| 必須項目未選択 | check()でfalseを返し、err_mandatoryエラーメッセージ表示 |
| CSRF検証失敗 | checkCSRF()で処理中断 |

## 備考

- カテゴリが1つしかない場合は自動的にチェックされる
- 各カテゴリにはアクティブな購読者数が表示される（nmbrSubscribersプロパティ）
- プレビュー送信先のデフォルトはcustomer.webmasterとcustomer.webmasterEmail
- 「続行」を押すと配信送信画面に遷移し、そこで実際の送信を実行
- bLogをtrueにすると、配信後に開封追跡が可能（画像ビーコン方式）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | cls_newsletterMailingクラス。プロパティ（iId, iNewsletterID, sCategory, bLog, dSentDate）、Newsletter()プロパティ、check()、save()、remove()を確認 |
| 1-2 | newsletter.asp | `asp/includes/newsletter.asp` | cls_newsletterクラスのsend()メソッドを確認（プレビュー送信用） |

**読解のコツ**: newsletterMailingはニュースレター（テンプレート）とカテゴリ（送信先）を紐付ける中間エンティティです。Newsletter()プロパティでcls_newsletterインスタンスを取得できます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterMailingEdit.asp | `asp/bs_newsletterMailingEdit.asp` | 画面表示のメインファイル。保存・プレビュー送信・削除の分岐処理を確認 |

**主要処理フロー**:
1. **4行目**: 権限チェック（logon.hasaccess secondAdmin.bNewsletter）
2. **5行目**: cls_newsletterMailingインスタンス生成（request("iNewsletterMailingID")からpick）
3. **6-9行目**: 削除処理判定とremove()実行
4. **10-24行目**: 保存・プレビュー処理
   - getRequestValues()
   - checkCSRF()
   - save()
   - btnaction="send"時はnewsletterMailing.Newsletter.send()
   - それ以外は配信送信画面にリダイレクト
5. **28-44行目**: フォーム生成（ニュースレター選択、カテゴリラジオボタン）

### プログラム呼び出し階層図

```
bs_newsletterMailingEdit.asp（画面表示）
    │
    ├─ begin.asp（初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bNewsletter)
    │
    ├─ cls_newsletterMailing
    │      ├─ Class_Initialize()
    │      │      └─ pick(decrypt(request("iNewsletterMailingID")))
    │      │
    │      ├─ getRequestValues()
    │      │
    │      ├─ save()
    │      │      ├─ check()
    │      │      └─ tblNewsletterMailing INSERT/UPDATE
    │      │
    │      ├─ Newsletter（プロパティ）
    │      │      └─ cls_newsletter.pick(iNewsletterID)
    │      │             └─ send(previewName, previewEmail, "")
    │      │
    │      └─ remove()
    │             ├─ tblNewsletterLog DELETE
    │             └─ tblNewsletterMailing DELETE
    │
    ├─ customer.showSelectedNewsletter()
    │      └─ ニュースレター選択肢生成
    │
    ├─ customer.NewsletterCategories
    │      └─ カテゴリラジオボタン生成
    │
    └─ includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                           [出力]

フォーム入力
├─ iNewsletterID ─────────▶ getRequestValues() ────────────▶ cls_newsletterMailing
├─ sCategory                      │
└─ bLog                           ├─ check()
                                  │    └─ 必須チェック
                                  │
                                  └─ save()
                                         └─ INSERT/UPDATE

btnaction="continue" ─────▶ Response.Redirect ──────────────▶ bs_newsletterMailingSend.asp
                                 └─ iNewsletterMailingID付与

btnaction="send" ─────────▶ newsletterMailing.Newsletter.send() ▶ プレビューメール送信
previewName/Email                  └─ cls_newsletter.send()

btnaction="delete" ───────▶ remove() ───────────────────────▶ tblNewsletterLog DELETE
                                 │                                tblNewsletterMailing DELETE
                                 └─ Response.Redirect
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterMailingEdit.asp | `asp/bs_newsletterMailingEdit.asp` | ソース | 配信編集画面 |
| bs_newsletterMailingSend.asp | `asp/bs_newsletterMailingSend.asp` | ソース | 配信送信画面 |
| bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | ソース | 配信履歴画面 |
| bs_newsletterList.asp | `asp/bs_newsletterList.asp` | ソース | ニュースレター一覧画面 |
| newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | ソース | 配信クラス定義 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | ニュースレタークラス定義 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | カテゴリクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・認可処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
