# 画面設計書 5-バックサイトホーム

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）のトップページについて、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、バックサイトにログイン後に最初に表示されるダッシュボード兼ページ管理画面である。サイトのページ階層構造をツリー形式で表示し、ページの作成・編集・削除・移動・コピーなどの操作へのナビゲーションを提供する。

**業務上の目的・背景**：CMSの中心的な機能であるページ管理を直感的に行えるようにすることが目的である。サイト管理者はこの画面を起点として、コンテンツの追加・編集・構造変更などの日常的な管理作業を行う。また、フォーム管理、テンプレート管理、統計情報などの各機能へのハブとしても機能する。

**画面へのアクセス方法**：バックサイトログイン成功後に自動遷移、または `/asp/bs_default.asp` へ直接アクセス。

**主要な操作・処理内容**：
1. ページ一覧のツリー表示を確認する
2. ページタイトルをクリックして編集画面へ遷移する
3. 新規ページ作成ボタンをクリックしてページタイプを選択する
4. 各種アイコン（移動、コピー、パスワード設定等）をクリックして操作を実行する
5. 定数一覧、ASP/VBScripts、検索、検証などの機能へ遷移する
6. フリーページ（メニューに属さない独立ページ）を管理する

**画面遷移**：
- 遷移元：bs_login.asp（ログイン成功時）、各編集画面からの戻り
- 遷移先：bs_setupPage.asp（新規ページ作成）、bs_editItem.asp（コンテンツ編集）、bs_listPage.asp（リストページ）、bs_editContainer.asp（コンテナ編集）、bs_constantlist.asp（定数一覧）、bs_search.asp（検索）、bs_validatepages.asp（検証）など

**権限による表示制御**：
- secondAdmin.bPagesAdd：新規ページ作成ボタンの表示/非表示
- secondAdmin.bHomeConstants：定数一覧リンクの表示/非表示
- secondAdmin.bHomeVBScript：ASP/VBScriptsリンクの表示/非表示（bApplication=trueの場合のみ）
- secondAdmin.bPagesPW：パスワード設定アイコンの表示/非表示
- secondAdmin.bPagesMove：移動アイコンの表示/非表示
- secondAdmin.bApplicationpath：アプリケーションアイコンの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ページ一覧 | 主機能 | ページ階層構造の表示・管理のメイン画面 |
| 97 | バックオフィス検索 | 補助機能 | 管理画面内でのページ・コンテンツ検索へのリンク |
| 9 | ページ作成・編集 | 遷移先機能 | 新規ページ作成画面への遷移 |
| 94 | 定数一覧 | 遷移先機能 | サイト定数一覧画面への遷移 |

## 画面種別

ダッシュボード / 一覧画面

## URL/ルーティング

- `/asp/bs_default.asp`

## 入出力項目

本画面は表示専用であり、直接的な入力項目はない（各操作はリンクまたはアイコンのクリックで実行）。

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| BOヘッダー | 上部 | バックサイト共通ヘッダー（btn_Home表示） |
| ページ一覧リンク | ナビゲーション | 現在の画面へのリンク |
| 新規ページリンク | ナビゲーション | bs_setupPage.aspへのリンク（権限制限あり） |
| 定数リンク | ナビゲーション | bs_constantlist.aspへのリンク（権限制限あり） |
| ASP/VBScriptsリンク | ナビゲーション | bs_scriptlist.aspへのリンク（権限制限あり） |
| 検索リンク | ナビゲーション | bs_search.aspへのリンク（セカンド管理者除く） |
| 検証リンク | ナビゲーション | bs_validatepages.aspへのリンク（検証待ちページあり時） |
| ページツリー | メインエリア | 階層構造でページを表示（bs_menu.aspで生成） |
| フリーページ一覧 | 下部 | メニュー外の独立ページ一覧 |

## イベント仕様

### 1-新規ページ作成リンクのクリック

**処理フロー**：
1. bs_setupPage.aspへ遷移
2. ページタイプ選択画面が表示される

### 2-ページタイトルのクリック

**処理フロー**：
1. ページタイプに応じた編集画面へ遷移
   - コンテンツ付きアイテム：bs_editItem.asp
   - リストページ：bs_listPage.asp
   - コンテナ：bs_editContainer.asp
   - 外部URL：bs_editExternalURL.asp

### 3-コピーアイコンのクリック

**処理フロー**：
1. JavaScript confirm()で確認ダイアログ表示
2. 確認後、bs_default.asp?btnaction=Copy&iId={暗号化ID}へ遷移
3. bs_process.aspでページ複製処理
4. bs_default.aspにリダイレクトしてツリー更新

### 4-移動アイコンのクリック

**処理フロー**：
1. bs_selectPage.aspへ遷移（移動先選択画面）
2. 移動先を選択後、処理実行

### 5-パスワード設定アイコンのクリック

**処理フロー**：
1. bs_applyPw.aspへ遷移
2. ページパスワード設定画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コピー操作 | tblPage | INSERT | ページをコピーして新規レコード作成 |
| 上へ移動 | tblPage | UPDATE | iRangの値を更新 |
| 下へ移動 | tblPage | UPDATE | iRangの値を更新 |

### テーブル別更新項目詳細

#### tblPage（コピー時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全カラム | コピー元ページの値 | iId以外 |
| INSERT | iId | 新規採番 | 自動採番 |
| INSERT | sCode | 空文字列 | ユニーク性確保 |
| INSERT | sUserFriendlyURL | 空文字列 | ユニーク性確保 |
| INSERT | sTitle | 元タイトル + " (copy)" | コピー識別用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| areyousuretocopy | 確認 | コピー確認メッセージ | コピーアイコンクリック時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | bs_security.aspによりログイン画面へリダイレクト |
| デフォルトパスワード使用 | bs_initialsetup.aspへ強制リダイレクト |

## 備考

- ページツリーはbs_menu.aspで生成され、Application変数にキャッシュされる
- セカンド管理者でログインした場合は、各種機能の表示が権限に応じて制限される
- 検証待ちページがある場合のみ「Validations」リンクが表示される
- copyItem()関数はJavaScriptで定義され、確認ダイアログを表示する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページ管理に関わるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのプロパティ、階層構造 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | 権限フラグの定義 |
| 1-3 | menu.asp | `asp/includes/menu.asp` | cls_menuクラスのツリー生成ロジック |

**読解のコツ**: tblPageテーブルのiParentID、iRang、bLossePagina等のカラムがページ階層構造を表現している。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_default.asp | `asp/bs_default.asp` | バックサイトホームのメインファイル |

**主要処理フロー**:
1. **行4**: bs_security.aspによる認証チェック
2. **行4**: bs_process.aspのインクルード（各種処理定義）
3. **行4**: getBOHeader関数でヘッダー生成
4. **行4**: getArtLink関数で各リンク生成
5. **行4**: bs_menu.aspでページツリー生成

#### Step 3: メニュー生成を理解する

ページツリーの生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_menu.asp | `asp/bs_menu.asp` | ページツリーHTML生成 |
| 3-2 | menu.asp | `asp/includes/menu.asp` | getBOMenu関数、lossePaginas関数 |

**主要処理フロー**:
- **行4-7**: Application変数からキャッシュ取得または新規生成
- **行8-24**: フリーページ（lossePaginas）の表示

#### Step 4: 処理ロジックを理解する

各種操作（コピー、移動等）の処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_process.asp | `asp/bs_process.asp` | Copy、MoveUp、MoveDownなどのcase文 |

### プログラム呼び出し階層図

```
bs_default.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証チェック)
    │      └─ secondAdmin設定の読み込み
    │
    ├─ bs_process.asp (処理定義)
    │      ├─ Copy処理
    │      ├─ MoveUp処理
    │      └─ MoveDown処理
    │
    ├─ getBOHeader() (ヘッダー生成)
    │
    ├─ getArtLink() (リンク生成)
    │      └─ 権限に応じた表示制御
    │
    └─ bs_menu.asp (ページツリー)
           ├─ menu.getBOMenu() (キャッシュまたは生成)
           └─ menu.lossePaginas() (フリーページ)
```

### データフロー図

```
[データソース]              [処理]                    [出力]

tblPage ─────────────▶ menu.getBOMenu() ─────▶ ページツリーHTML
    │                                               │
    ├─ iParentID                                    ▼
    ├─ iRang                                 Application変数
    └─ bLossePagina                         (キャッシュ)

secondAdmin ──────────▶ 権限チェック ────────▶ リンク表示制御
    ├─ bPagesAdd
    ├─ bHomeConstants
    └─ bPagesMove
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_default.asp | `asp/bs_default.asp` | ソース | バックサイトホームメイン |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 各種処理定義 |
| bs_menu.asp | `asp/bs_menu.asp` | インクルード | ページツリー生成 |
| menu.asp | `asp/includes/menu.asp` | インクルード | cls_menuクラス |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | インクルード | 権限管理クラス |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
