# 画面設計書 51-配信履歴

## 概要

本ドキュメントは、QuickerSiteのニュースレター管理機能における配信履歴画面（bs_newsletterMailingHistory.asp）の設計書である。

### 本画面の処理概要

この画面では、ニュースレターの過去の配信履歴を一覧表示し、各配信の詳細な統計情報（配信数、開封数、未開封数）を確認することができる。

**業務上の目的・背景**：ニュースレターマーケティングにおいて、配信の効果測定は非常に重要である。本画面は、各配信の開封率を把握し、購読者のエンゲージメントを分析するために必要である。マーケティング担当者は、この情報を基にニュースレターの内容改善や配信タイミングの最適化を行うことができる。

**画面へのアクセス方法**：バックサイトにログイン後、「Newsletter」メニューから「配信履歴」を選択するか、ニュースレター一覧画面から配信履歴リンクをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 配信履歴の一覧表示（配信日、ニュースレター名、メールリスト、配信数、開封数、未開封数）
2. 各統計項目（総数、開封、未開封）をクリックして対象の購読者一覧を表示
3. 配信履歴の削除（確認ダイアログ付き）

**画面遷移**：ニュースレター一覧画面（bs_NewsletterList.asp）から遷移してくる。画面下部の「back」リンクからニュースレター一覧画面に戻ることができる。

**権限による表示制御**：secondAdmin.bNewsletter権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 72 | メーリング履歴 | 主機能 | 過去の配信履歴の確認 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_newsletterMailingHistory.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| delete | String | 入力 | - | 削除フラグ（"1"で削除実行） |
| iNewsletterMailingID | String | 入力 | - | 削除対象のメーリングID（暗号化） |
| showRead | String | 入力 | - | 詳細表示対象のメーリングID（暗号化） |
| t | String | 入力 | - | 表示タイプ（0:全件、1:開封、2:未開封） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Date sent | 配信日時 | tblNewsletterMailing.dSentDate |
| Newsletter | ニュースレター名 | tblNewsletter.sName（関連） |
| Email list | 配信先カテゴリ名 | tblNewsletterCategory.sName（関連） |
| Total | 総配信数 | tblNewsletterLog（カウント） |
| Read | 開封数（開封率%） | tblNewsletterLog（bRead=true） |
| Not read | 未開封数（未開封率%） | tblNewsletterLog（bRead=false） |
| 削除リンク | 削除ボタン | - |

## イベント仕様

### 1-配信数・開封数・未開封数リンククリック

「?」リンクをクリックすると、該当するメーリングの購読者一覧がインライン表示される。showReadパラメータとt（タイプ）パラメータを使用して対象を指定する。

### 2-削除リンククリック

削除リンクをクリックすると、JavaScript確認ダイアログが表示される。確認後、delete=1とiNewsletterMailingIDパラメータを付与してページをリロードし、対象のメーリング履歴を削除する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblNewsletterMailing | SELECT | 配信履歴一覧取得 |
| 画面表示 | tblNewsletterLog | SELECT | 配信統計取得 |
| 詳細表示 | tblNewsletterCategorySubscriber | SELECT | 購読者一覧取得 |
| 削除 | tblNewsletterLog | DELETE | 配信ログ削除 |
| 削除 | tblNewsletterMailing | DELETE | メーリング履歴削除 |

### テーブル別更新項目詳細

#### tblNewsletterLog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iMailingID=対象ID | メーリング削除時に関連ログも削除 |

#### tblNewsletterMailing

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iCustomerID=cId and iId=対象ID | メーリング履歴削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | 確認 | Are you sure to PERMANENTLY remove this mailing? | 削除リンククリック時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 配信履歴が存在しない | "No mailings.."メッセージを表示 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- 配信ログは開封トラッキングに使用され、メール内の追跡用画像の読み込みにより開封を検知する
- 配信履歴は配信日の降順で表示される
- 削除操作は取り消し不可能なため、確認ダイアログで警告している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ニュースレターメーリングに関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | cls_newsletterMailingクラスの構造、プロパティ（iId, iNewsletterID, dSentDate, sCategory）を理解 |
| 1-2 | newsletter.asp | `asp/includes/newsletter.asp` | ニュースレター本体の構造を理解 |
| 1-3 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | カテゴリ（メールリスト）の構造を理解 |

**読解のコツ**: ASP/VBScriptのクラス定義は`Class cls_XXX`で始まり、`End Class`で終わる。Public変数がプロパティとなる。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | メイン画面ファイル、セキュリティチェックと一覧表示ロジック |

**主要処理フロー**:
1. **行4**: セキュリティチェック（logon.hasaccess secondAdmin.bNewsletter）
2. **行6-9**: 削除パラメータがあれば削除処理実行
3. **行10**: 配信履歴一覧をSQLで取得
4. **行12-21**: ループで各履歴を表示、統計情報を計算・表示

#### Step 3: クラスメソッドを理解する

統計取得と詳細表示のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | nmbrReceiversプロパティ（行85-101）で統計カウント、showReadサブ（行102-122）で購読者一覧表示 |

**主要処理フロー**:
- **行85-101**: nmbrReceiversプロパティでt（0:全件、1:開封、2:未開封）に応じたカウント取得
- **行102-122**: showReadサブで該当する購読者のメールアドレス一覧を表示

### プログラム呼び出し階層図

```
bs_newsletterMailingHistory.asp
    │
    ├─ begin.asp（初期化）
    │      └─ newsletterMailing.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_newsletterMailing
    │      ├─ pick()（データ取得）
    │      ├─ remove()（削除処理）
    │      ├─ nmbrReceivers（統計取得）
    │      ├─ showRead()（詳細表示）
    │      ├─ newsletter（ニュースレター取得）
    │      └─ category（カテゴリ取得）
    │
    └─ bs_endBack.asp / footer.asp（終了処理）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

QueryString              bs_newsletterMailingHistory.asp   HTML一覧
  ├─ delete                    │                              │
  ├─ iNewsletterMailingID      ├─ 削除処理                    ├─ 配信日
  ├─ showRead                  │    └─ tblNewsletterLog      ├─ ニュースレター名
  └─ t                         │    └─ tblNewsletterMailing  ├─ カテゴリ名
                               │                              ├─ 総数
tblNewsletterMailing ────▶ cls_newsletterMailing.pick() ──▶ ├─ 開封数（%）
tblNewsletterLog ────────▶ nmbrReceivers ─────────────────▶ ├─ 未開封数（%）
tblNewsletterCategorySubscriber ─▶ showRead() ─────────────▶ └─ 購読者詳細
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_newsletterMailingHistory.asp | `asp/bs_newsletterMailingHistory.asp` | ソース | メイン画面 |
| newsletterMailing.asp | `asp/includes/newsletterMailing.asp` | ソース | メーリングクラス定義 |
| newsletter.asp | `asp/includes/newsletter.asp` | ソース | ニュースレタークラス定義 |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | カテゴリクラス定義 |
| bs_NewsletterList.asp | `asp/bs_NewsletterList.asp` | ソース | 遷移元・戻り先画面 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証チェック |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | ヘッダー表示 |
