# 画面設計書 52-連絡先ホーム

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における連絡先ホーム画面（bs_contactHome.asp）の設計書である。

### 本画面の処理概要

この画面では、会員（コンタクト）情報の検索・一覧表示を行い、連絡先管理の中心的な画面として機能する。カスタムフィールドによる柔軟な検索機能と、検索結果に対する一括メール送信機能を提供する。

**業務上の目的・背景**：会員制サイトやイントラネット機能を持つウェブサイトにおいて、会員情報の管理は重要な業務である。本画面は、管理者が会員を効率的に検索・管理し、必要に応じて一括でコミュニケーションを取るための基盤を提供する。会員のステータス管理（silent/profile/read/write/readwrite）により、きめ細かなアクセス権限管理が可能となる。

**画面へのアクセス方法**：バックサイトにログイン後、「Intranet」メニューから「Contacts」を選択してアクセスする。

**主要な操作・処理内容**：
1. カスタムフィールドを使用した会員検索（テキスト、日付範囲、チェックボックス、セレクトボックス）
2. メールアドレス・ニックネームによる検索
3. 会員ロール（ステータス）によるフィルタリング
4. 検索結果の一覧表示とExcel出力
5. 選択した会員への一括メール送信
6. 会員の新規追加、編集、パーミッション管理

**画面遷移**：連絡先編集画面（bs_contactEdit.asp）、連絡先フィールド一覧（bs_contactFields.asp）、チケット管理（bs_tickets.asp）、一括操作画面（bs_contactSelectionActions.asp）へ遷移できる。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能。一括メール送信リンクはsecondAdmin.bIntranetMail権限も必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 83 | コンタクト一覧 | 主機能 | 会員（コンタクト）の検索・一覧表示 |
| 84 | コンタクト作成・編集 | 遷移先機能 | 会員情報編集画面への遷移 |

## 画面種別

検索・一覧

## URL/ルーティング

`asp/bs_contactHome.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| カスタムフィールド | 可変 | 入力 | - | 顧客定義のフィールドによる検索条件 |
| fromXXX | Date | 入力 | - | 日付フィールドの開始日 |
| untillXXX | Date | 入力 | - | 日付フィールドの終了日 |
| sEmail | String | 入力 | - | メールアドレス検索条件 |
| sNickname | String | 入力 | - | ニックネーム検索条件 |
| iStatus | Number | 入力 | - | 会員ロール（ステータス） |
| pageSize | Number | 入力 | - | 表示件数（100-500、または全件） |
| btnaction | String | 入力 | - | アクション種別（search/excel） |
| postback | Boolean | 入力 | - | ポストバックフラグ |
| iCPP | Number | 入力 | - | ポップアップ表示用連絡先ID |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| カスタムフィールド値 | 顧客定義フィールドの値 | tblContactValues |
| アバター | 会員アバター画像 | tblContact.sAvatar |
| iId | 連絡先ID | tblContact.iId |
| ニックネーム | 会員ニックネーム | tblContact.sNickname |
| Email | メールアドレス | tblContact.sEmail |
| last login | 最終ログイン日時 | tblContact.dLastLoginTS |
| ステータス | 会員ロール（色分け表示） | tblContact.iStatus |

## イベント仕様

### 1-検索ボタン押下

検索フォームの入力値を使用して会員を検索し、結果を一覧表示する。カスタムフィールド、メールアドレス、ニックネーム、ステータスの各条件でAND検索を行う。

### 2-Excelボタン押下

検索結果をExcelファイルとして出力する。cls_excelfileクラスを使用してファイルを生成し、ダウンロードリンクを表示する。

### 3-リセットボタン押下

検索条件をクリアしてページをリロードする（JavaScriptでbs_contacthome.aspにリダイレクト）。

### 4-選択メール送信リンククリック

チェックボックスで選択された連絡先に対して一括メール送信画面（bs_contactSelectionActions.asp）へ遷移する。確認ダイアログを表示してから遷移する。

### 5-連絡先追加リンククリック

連絡先編集画面（bs_contactEdit.asp）をポップアップで開く（bPopupFullWidthReloadクラス使用）。

### 6-編集アイコンクリック

選択した連絡先の編集画面をポップアップで開く。

### 7-パーミッションアイコンクリック

選択した連絡先のページパーミッション管理画面（bs_contactPage.asp）をポップアップで開く。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索 | tblContact | SELECT | 連絡先基本情報取得 |
| 検索 | tblContactValues | SELECT | カスタムフィールド値取得 |
| 検索 | tblContactField | SELECT | フィールド定義取得 |

### テーブル別更新項目詳細

本画面では参照のみで更新処理はない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| areyousure | 確認 | 本当によろしいですか？ | 一括メール送信リンククリック時 |
| warningcontacts | 警告 | 連絡先に関する警告 | 一括メール送信時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| フィールド定義なし | フィールド定義画面へのリンクを表示 |
| 検索結果0件 | 件数0を表示（テーブルは非表示） |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- 会員ステータスは5段階（cs_silent=10, cs_profile=20, cs_read=30, cs_write=40, cs_readwrite=50）で管理される
- 各ステータスは一覧表示時に色分けで視覚的に区別される
- 大量の連絡先がある場合（manyContacts設定）、ページサイズ選択が表示される
- アバター機能が有効な場合、Gravatarまたはアップロード画像が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

連絡先管理に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、プロパティ（iId, sEmail, sNickname, iStatus等） |
| 1-2 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラス、フィールド定義の構造 |
| 1-3 | contactSearch.asp | `asp/includes/contactSearch.asp` | cls_contactSearchクラス、検索ロジック |

**読解のコツ**: contactSearchクラスのgetRows関数とresultTable関数が検索と表示の中心となる。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactHome.asp | `asp/bs_contactHome.asp` | メイン画面、検索フォームと結果表示 |

**主要処理フロー**:
1. **行4**: セキュリティチェックとヘッダー表示
2. **行5-8**: カスタムフィールド取得（customer.contactFields）
3. **行9-16**: contactSearchオブジェクト初期化と検索条件取得
4. **行23-26**: 検索フォーム生成（各フィールドタイプに応じた入力要素）
5. **行27**: 検索モードに応じた結果表示（resultTable）

#### Step 3: 検索ロジックを理解する

検索処理の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contactSearch.asp | `asp/includes/contactSearch.asp` | getRows関数（行54-139）で複雑なSQLクエリを構築 |

**主要処理フロー**:
- **行65-68**: 基本SQL構築（JOIN構文）
- **行72-79**: 各検索条件でWHERE句を追加
- **行82-95**: カスタムフィールド検索条件
- **行96-119**: 日付範囲検索条件
- **行140-226**: resultTable関数で検索結果をHTML化

### プログラム呼び出し階層図

```
bs_contactHome.asp
    │
    ├─ begin.asp（初期化）
    │      ├─ contact.asp（クラス定義）
    │      ├─ contactField.asp（クラス定義）
    │      └─ contactSearch.asp（クラス定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ customer.contactFields()（フィールド定義取得）
    │
    ├─ cls_contactSearch
    │      ├─ getRequestValues()（検索条件取得）
    │      ├─ getRows()（データ取得）
    │      └─ resultTable()（HTML生成）
    │
    ├─ cls_excelfile（Excel出力時）
    │      └─ export()
    │
    └─ colorbox（ポップアップ表示用JS）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

検索フォーム              bs_contactHome.asp            HTML
  ├─ カスタムフィールド           │                       │
  ├─ sEmail                      │                       ├─ 検索フォーム
  ├─ sNickname                   │                       ├─ 結果テーブル
  └─ iStatus                     ▼                       │    ├─ フィールド値
                           cls_contactSearch             │    ├─ アバター
tblContactField ─────▶ customer.contactFields() ──▶    │    ├─ ステータス色
tblContact ───────────▶ getRows() ─────────────────▶   │    └─ 操作アイコン
tblContactValues ─────▶ resultTable() ─────────────▶   ├─ Excel DLリンク
                                                        └─ ステータス凡例
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | メイン画面 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先クラス定義 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | フィールドクラス定義 |
| contactSearch.asp | `asp/includes/contactSearch.asp` | ソース | 検索クラス定義 |
| contactStatusList.asp | `asp/includes/contactStatusList.asp` | ソース | ステータスリスト |
| bs_contactEdit.asp | `asp/bs_contactEdit.asp` | ソース | 連絡先編集画面 |
| bs_contactFields.asp | `asp/bs_contactFields.asp` | ソース | フィールド一覧画面 |
| bs_tickets.asp | `asp/bs_tickets.asp` | ソース | チケット管理画面 |
| bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | ソース | 一括操作画面 |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | Excel出力機能 |
