# 画面設計書 53-連絡先編集

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における連絡先編集画面（bs_contactEdit.asp）の設計書である。

### 本画面の処理概要

この画面では、会員（コンタクト）情報の新規作成・編集・削除を行う。ログイン情報（メール、パスワード、ニックネーム）と顧客定義のカスタムフィールドの両方を管理できる。

**業務上の目的・背景**：会員制サイトの運営において、個々の会員情報を正確に管理することは重要である。本画面は、管理者が会員のログイン情報を設定し、会員の属性情報（カスタムフィールド）を入力・編集するための画面である。パスワードリセット機能により、会員がパスワードを忘れた場合の対応も可能である。

**画面へのアクセス方法**：連絡先ホーム画面（bs_contactHome.asp）から「連絡先追加」リンクまたは既存連絡先の編集アイコンをクリックしてポップアップで開く。

**主要な操作・処理内容**：
1. 会員基本情報（メール、パスワード、ニックネーム）の入力・編集
2. プライベートメッセージ受信許可の設定
3. 会員ロール（ステータス）の設定
4. カスタムフィールド値の入力・編集
5. 新規会員の保存
6. 既存会員の更新
7. 既存会員の削除
8. パスワードリセット（メール送信付き）

**画面遷移**：連絡先ホーム画面からポップアップで表示される。保存・削除後はポップアップを閉じて親画面をリロードする。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 84 | コンタクト作成・編集 | 主機能 | 会員情報の登録・編集 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_contactEdit.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iContactID | String | 入力 | - | 連絡先ID（暗号化、新規時は空） |
| sEmail | String | 入力 | 必須 | メールアドレス |
| sPw | String | 入力 | 必須 | パスワード |
| sNickname | String | 入力 | 必須 | ニックネーム |
| bGetEmailsFromSite | Boolean | 入力 | - | プライベートメッセージ受信許可 |
| iStatus | Number | 入力 | - | 会員ロール（ステータス） |
| カスタムフィールド | 可変 | 入力 | フィールド定義による | 顧客定義フィールド |
| postback | Boolean | 入力 | - | ポストバックフラグ |
| btnaction | String | 入力 | - | アクション種別（save/delete/savAndResetPw） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| メールアドレス | ログイン用メール | tblContact.sEmail |
| 元メールアドレス | 変更前メール（参考表示） | tblContact.sOrigEmail |
| パスワード | ログインパスワード | tblContact.sPw |
| ニックネーム | 表示名 | tblContact.sNickname |
| プライベートメッセージ許可 | メール受信設定 | tblContact.bGetEmailsFromSite |
| 会員ロール | ステータス選択 | tblContact.iStatus |
| カスタムフィールド | 動的生成フィールド | tblContactValues |
| 作成日時 | 登録日時 | tblContact.dCreatedTS |
| 更新日時 | 最終更新日時 | tblContact.dUpdatedTS |
| 最終ログイン | 最終ログイン日時 | tblContact.dLastLoginTS |

## イベント仕様

### 1-保存ボタン押下

入力値のバリデーションを行い、問題なければデータベースに保存する。バリデーション項目：
- メールアドレス：必須、形式チェック、重複チェック
- パスワード：必須
- ニックネーム：必須、重複チェック
- 必須カスタムフィールド：必須チェック

保存成功時は「fb_saveOK」メッセージを表示。ステータスがcs_silent以外に変更された場合、顧客設定のメッセージを自動送信する。

### 2-削除ボタン押下

確認ダイアログを表示後、連絡先を削除する。関連データ（tblContactValues、投稿、購読情報等）も合わせて削除される。削除後はポップアップを閉じる。

### 3-パスワードリセットボタン押下（保存後リセット）

確認ダイアログを表示後、入力値を保存してからパスワードをリセットする。新しいパスワードはランダム生成され、会員のメールアドレスに送信される。

### 4-ランダムパスワード生成リンククリック

GeneratePassWord関数で生成したランダムパスワードをパスワード入力欄に設定する（JavaScriptで実行）。

### 5-会員ロール変更

セレクトボックスの変更時にフォームを自動サブミットし、ステータス変更に応じた画面表示を更新する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblContact | INSERT | 連絡先基本情報登録 |
| 新規保存 | tblContactValues | INSERT | カスタムフィールド値登録 |
| 更新保存 | tblContact | UPDATE | 連絡先基本情報更新 |
| 更新保存 | tblContactValues | DELETE/INSERT | カスタムフィールド値更新 |
| 削除 | tblContact | DELETE | 連絡先削除 |
| 削除 | tblContactValues | DELETE | カスタムフィールド値削除 |
| 削除 | tblThemeSubscription | DELETE | テーマ購読削除 |
| 削除 | tblThemeTopicSubscription | DELETE | トピック購読削除 |
| 削除 | tblContactPage | DELETE | ページ権限削除 |
| 削除 | tblContactRegistration | DELETE | 登録チケット削除 |
| PWリセット | tblContact | UPDATE | パスワード更新 |

### テーブル別更新項目詳細

#### tblContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sEmail | 入力値（小文字変換） | 一意制約 |
| INSERT/UPDATE | sNickName | 入力値 | 一意制約 |
| INSERT/UPDATE | sPw | 入力値またはランダム生成 | |
| INSERT/UPDATE | iStatus | 選択値 | デフォルトは顧客設定 |
| INSERT/UPDATE | bGetEmailsFromSite | 入力値 | |
| INSERT/UPDATE | dUpdatedTS | now() | |
| INSERT | dCreatedTS | now() | 新規時のみ |
| UPDATE(reset) | sPw | GeneratePassWord() | PWリセット時 |

#### tblContactValues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iContactID=対象ID | 更新前に全削除 |
| INSERT | iContactID | 連絡先ID | |
| INSERT | iFieldID | フィールドID | |
| INSERT | sValue | 入力値 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| fb_saveOK | 成功 | 保存しました | 保存成功時 |
| fb_passwordreset | 成功 | パスワードをリセットしました | PWリセット成功時 |
| err_mandatory | エラー | 必須項目を入力してください | 必須チェック失敗時 |
| err_email | エラー | メールアドレスの形式が不正です | メール形式エラー時 |
| err_doubleemail | エラー | このメールアドレスは既に登録されています | メール重複時 |
| err_doublenickname | エラー | このニックネームは既に登録されています | ニックネーム重複時 |
| areyousure | 確認 | 本当によろしいですか？ | 削除・PWリセット時 |
| abouttosentpw | 確認 | パスワードを送信しようとしています | PWリセット時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| メール重複 | エラーメッセージを表示し、保存を中止 |
| ニックネーム重複 | エラーメッセージを表示し、保存を中止 |
| 必須項目未入力 | エラーメッセージを表示し、保存を中止 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- パスワードはプレーンテキストで保存される（セキュリティ上の注意点）
- 日付フィールドはjQuery DatePickerを使用
- リッチテキストフィールドはFCKEditorを使用
- 重複メールアドレスの連絡先は自動削除される（行201-208）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

連絡先エンティティの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、save関数（行153-225）、delete関数（行247-271） |
| 1-2 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラス、フィールドタイプ |

**読解のコツ**: contact.aspのsave関数では、重複チェック、フィールド値保存、ステータス変更時のメール送信が行われる。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactEdit.asp | `asp/bs_contactEdit.asp` | メイン画面、アクション分岐（行19-40） |

**主要処理フロー**:
1. **行4-5**: セキュリティチェック、contactオブジェクト生成
2. **行6-9**: セッションリダイレクト処理
3. **行13-18**: ポストバック時の入力値取得
4. **行19-40**: btnactionに応じた処理分岐（save/delete/savAndResetPw）
5. **行42-47**: フォーム表示、カスタムフィールド動的生成

#### Step 3: バリデーションと保存を理解する

データの検証と保存処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contact.asp | `asp/includes/contact.asp` | Check関数（行80-128）でバリデーション、Save関数（行153-225）で保存 |

**主要処理フロー**:
- **行80-128**: Check関数 - 必須チェック、メール形式、重複チェック
- **行153-210**: Save関数 - INSERT/UPDATE、フィールド値保存
- **行211-224**: ステータス変更時のメール自動送信
- **行288-306**: resetPWサブ - パスワードリセットとメール送信

### プログラム呼び出し階層図

```
bs_contactEdit.asp
    │
    ├─ begin.asp（初期化）
    │      └─ contact.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_contact
    │      ├─ pick()（データ取得）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      │      └─ cls_mail_message.send()（ステータス変更メール）
    │      ├─ delete()（削除処理）
    │      └─ resetPW()（パスワードリセット）
    │             └─ cls_mail_message.send()（PWメール送信）
    │
    ├─ customer.contactFields()（フィールド定義取得）
    │
    └─ cPopup.close()（削除後のポップアップ閉じる）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

フォーム入力              bs_contactEdit.asp            画面更新
  ├─ sEmail                     │                       │
  ├─ sPw                        ├─ check() ──────────▶ エラーメッセージ
  ├─ sNickname                  │     │
  ├─ iStatus                    │     ▼
  └─ カスタムフィールド          ├─ save() ──────────▶ tblContact
                                │     │                tblContactValues
                                │     ▼
                                ├─ ステータス変更
                                │     └─ メール送信
                                │
                                ├─ delete() ─────────▶ 関連テーブル削除
                                │
                                └─ resetPW() ────────▶ tblContact.sPw
                                      └─ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactEdit.asp | `asp/bs_contactEdit.asp` | ソース | メイン画面 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先クラス定義 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | フィールドクラス定義 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信機能 |
| customerIntranetMessage.asp | `asp/includes/customerIntranetMessage.asp` | ソース | ステータス変更メッセージ |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | 親画面（遷移元） |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | リッチテキストエディタ |
