# 画面設計書 54-連絡先フィールド一覧

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における連絡先フィールド一覧画面（bs_contactFields.asp）の設計書である。

### 本画面の処理概要

この画面では、会員情報に追加するカスタムフィールドの一覧表示と管理を行う。フィールドの並び順変更機能を提供し、会員情報入力フォームの項目構成を柔軟にカスタマイズできる。

**業務上の目的・背景**：会員制サイトでは、業種や用途によって必要な会員情報が異なる。本画面は、管理者がサイト固有の会員属性（住所、電話番号、会社名など）を自由に定義できるようにするための管理画面である。これにより、標準のログイン情報に加えて、業務に必要な情報を収集・管理できるようになる。

**画面へのアクセス方法**：連絡先ホーム画面（bs_contactHome.asp）から「specifyfields」リンクをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 定義済みカスタムフィールドの一覧表示
2. フィールド名、タイプ、必須/検索/プロファイル表示フラグの確認
3. フィールドの並び順変更（上へ/下へ移動）
4. 新規フィールド作成画面への遷移
5. 既存フィールド編集画面への遷移

**画面遷移**：連絡先ホーム画面から遷移する。フィールド名リンクまたは「newfield」リンクから連絡先フィールド編集画面（bs_contactFieldEdit.asp）へ遷移する。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | コンタクトフィールド管理 | 主機能 | 会員情報カスタムフィールドの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_contactFields.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iFieldID | String | 入力 | - | フィールドID（暗号化、並び順変更時） |
| btnaction | String | 入力 | - | アクション種別（MoveUP/MoveDOWN） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Name | フィールド名（編集リンク付き） | tblContactField.sFieldname |
| Type | フィールドタイプ | tblContactField.sType |
| Mandatory | 必須フラグ（Yes/No） | tblContactField.bMandatory |
| Searchfield | 検索対象フラグ（Yes/No） | tblContactField.bSearchField |
| Publicprofile | プロファイル表示フラグ（Yes/No） | tblContactField.bProfile |
| iId | フィールドID | tblContactField.iId |
| Sortorder | 並び順 | tblContactField.iRang |
| 上へ/下へアイコン | 並び順変更ボタン | - |

## イベント仕様

### 1-フィールド名リンククリック

選択したフィールドの編集画面（bs_contactFieldEdit.asp）へ遷移する。iFieldIDパラメータを暗号化して渡す。

### 2-新規フィールドリンククリック

新規フィールド作成画面（bs_contactFieldEdit.asp）へiFieldIDパラメータなしで遷移する。

### 3-上へ移動アイコンクリック

選択したフィールドの並び順を1つ上げる。最上位（iRang=1）の場合は処理をスキップする。

### 4-下へ移動アイコンクリック

選択したフィールドの並び順を1つ下げる。最下位の場合は処理をスキップする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblContactField | SELECT | フィールド一覧取得 |
| 上へ移動 | tblContactField | UPDATE | 対象フィールドのiRang-1、入替対象のiRang+1 |
| 下へ移動 | tblContactField | UPDATE | 対象フィールドのiRang+1、入替対象のiRang-1 |

### テーブル別更新項目詳細

#### tblContactField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE(MoveUP) | iRang | iRang-1 | 対象フィールド |
| UPDATE(MoveUP) | iRang | iRang+1 | 入替対象（iRang=対象-1） |
| UPDATE(MoveDOWN) | iRang | iRang+1 | 対象フィールド |
| UPDATE(MoveDOWN) | iRang | iRang-1 | 入替対象（iRang=対象+1） |

## メッセージ仕様

本画面では特にメッセージ表示はない。

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| フィールド定義なし | 一覧テーブルを非表示（「newfield」リンクのみ表示） |
| 最上位で上へ移動 | 処理をスキップ（何も起こらない） |
| 最下位で下へ移動 | 処理をスキップ（何も起こらない） |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- テーブルはsortableクラスが適用されており、JavaScriptによる並べ替え表示が可能
- フィールドタイプはfixedFieldTypeListクラスで表示名に変換される
- isMandatory、isSearchField、isProfileFieldプロパティでYes/No表示を制御
- 並び順変更時はCSRFチェックが実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

連絡先フィールド定義の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラス、プロパティ（iId, sFieldName, sType, iRang等） |

**読解のコツ**: sTypeフィールドでフィールドタイプ（text/textarea/checkbox/select/date/richtext/comment）を管理している。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactFields.asp | `asp/bs_contactFields.asp` | メイン画面、アクション分岐（行6-13） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、ヘッダー表示
2. **行5-6**: contactFieldオブジェクト生成、btnaction取得
3. **行7-13**: MoveUP/MoveDOWN処理
4. **行14-16**: フィールド一覧取得（customer.contactFields）
5. **行17**: 一覧テーブル表示

#### Step 3: 並び順変更ロジックを理解する

フィールドの並び順変更処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contactField.asp | `asp/includes/contactField.asp` | moveUp関数（行137-146）、moveDown関数（行147-156） |

**主要処理フロー**:
- **行137-146**: moveUp - 最上位チェック後、自身のiRang-1、入替対象のiRang+1
- **行147-156**: moveDown - 最下位チェック後、自身のiRang+1、入替対象のiRang-1

### プログラム呼び出し階層図

```
bs_contactFields.asp
    │
    ├─ begin.asp（初期化）
    │      └─ contactField.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_contactField
    │      ├─ pick()（データ取得）
    │      ├─ moveUp()（上へ移動）
    │      └─ moveDown()（下へ移動）
    │
    ├─ cls_contactFieldTypeList
    │      └─ showSelected()（タイプ表示名変換）
    │
    └─ customer.contactFields()（フィールド一覧取得）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

QueryString               bs_contactFields.asp          HTML一覧
  ├─ iFieldID                   │                       │
  └─ btnaction                  │                       ├─ フィールド名
                                ▼                       ├─ タイプ
tblContactField ────▶ customer.contactFields() ────▶   ├─ 必須フラグ
                                │                       ├─ 検索フラグ
                                ├─ MoveUP ─────────▶    ├─ プロファイルフラグ
                                │    └─ UPDATE iRang   ├─ iId
                                │                       ├─ 並び順
                                └─ MoveDOWN ───────▶    └─ 操作アイコン
                                     └─ UPDATE iRang
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactFields.asp | `asp/bs_contactFields.asp` | ソース | メイン画面 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | フィールドクラス定義 |
| contactFieldTypeList.asp | `asp/includes/contactFieldTypeList.asp` | ソース | フィールドタイプリスト |
| bs_contactFieldEdit.asp | `asp/bs_contactFieldEdit.asp` | ソース | フィールド編集画面 |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | 遷移元画面 |
| bs_backContact.asp | `asp/bs_backContact.asp` | テンプレート | 戻るリンク表示 |
| showicons.asp | `asp/includes/showicons.asp` | ソース | アイコン表示関数 |
