# 画面設計書 55-連絡先フィールド編集

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における連絡先フィールド編集画面（bs_contactFieldEdit.asp）の設計書である。

### 本画面の処理概要

この画面では、会員情報に追加するカスタムフィールドの新規作成・編集・削除を行う。フィールドの名前、タイプ、必須設定、検索対象設定、プロファイル表示設定を管理できる。

**業務上の目的・背景**：会員制サイトのカスタマイズにおいて、標準のログイン情報以外に収集したい情報は多岐にわたる。本画面では、テキスト入力、セレクトボックス、チェックボックス、日付、リッチテキストなど様々な入力タイプのフィールドを定義できる。これにより、業種・用途に合わせた会員情報収集が可能となる。

**画面へのアクセス方法**：連絡先フィールド一覧画面（bs_contactFields.asp）から「newfield」リンクまたは既存フィールド名をクリックしてアクセスする。

**主要な操作・処理内容**：
1. フィールド名の入力
2. フィールドタイプの選択（text/textarea/checkbox/select/date/richtext/comment等）
3. セレクトタイプの場合、選択肢リストの入力
4. コメントタイプの場合、表示コメント内容の入力
5. 必須フラグの設定
6. 検索対象フラグの設定
7. プロファイル表示フラグの設定
8. フィールドの保存
9. 既存フィールドの削除

**画面遷移**：連絡先フィールド一覧画面から遷移する。保存・削除後は連絡先フィールド一覧画面にリダイレクトする。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | コンタクトフィールド管理 | 主機能 | 会員情報フィールドの詳細設定 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_contactFieldEdit.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iFieldID | String | 入力 | - | フィールドID（暗号化、新規時は空） |
| sFieldName | String | 入力 | 必須 | フィールド名 |
| sType | String | 入力 | 必須 | フィールドタイプ |
| sValues | String | 入力 | 条件付必須 | 選択肢リスト（selectタイプ時）/コメント内容（commentタイプ時） |
| bMandatory | Boolean | 入力 | - | 必須フラグ |
| bSearchField | Boolean | 入力 | - | 検索対象フラグ |
| bProfile | Boolean | 入力 | - | プロファイル表示フラグ |
| postBack | Boolean | 入力 | - | ポストバックフラグ |
| btnaction | String | 入力 | - | アクション種別（save/delete） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Name | フィールド名入力欄 | tblContactField.sFieldname |
| 補足説明 | "emaildefaultfield"説明文 | 固定テキスト |
| Type | フィールドタイプ選択 | tblContactField.sType |
| Values | 選択肢リスト（selectタイプ時） | tblContactField.sValues |
| Comment | コメント内容（commentタイプ時） | tblContactField.sValues |
| Mandatory | 必須フラグチェックボックス | tblContactField.bMandatory |
| Searchfield | 検索対象フラグチェックボックス | tblContactField.bSearchField |
| Publicprofile | プロファイル表示フラグチェックボックス | tblContactField.bProfile |

## イベント仕様

### 1-保存ボタン押下

入力値のバリデーションを行い、問題なければデータベースに保存する。バリデーション項目：
- フィールド名：必須
- フィールドタイプ：必須
- 選択肢リスト：selectタイプ時に必須
- 必須フラグとプロファイル表示の整合性：必須フィールドはプロファイル表示必須

新規フィールドの場合、既存の全連絡先に対して空のフィールド値レコードを作成する。

### 2-削除ボタン押下

確認ダイアログを表示後、フィールドを削除する。関連する全連絡先のフィールド値（tblContactValues）も削除される。他フィールドの並び順も調整される。

### 3-タイプ変更

セレクトボックスの変更時にフォームを自動サブミットし、タイプに応じた入力項目（選択肢リスト/コメント内容）を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblContactField | INSERT | フィールド定義登録 |
| 新規保存 | tblContactValues | INSERT | 全連絡先に空の値レコード作成 |
| 更新保存 | tblContactField | UPDATE | フィールド定義更新 |
| 削除 | tblContactField | DELETE | フィールド定義削除 |
| 削除 | tblContactField | UPDATE | 他フィールドの並び順調整 |
| 削除 | tblContactValues | DELETE | 関連フィールド値削除 |

### テーブル別更新項目詳細

#### tblContactField

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | sFieldName | 入力値 | |
| INSERT/UPDATE | sType | 選択値 | |
| INSERT/UPDATE | sValues | 入力値 | select/comment時 |
| INSERT/UPDATE | bMandatory | 入力値 | |
| INSERT/UPDATE | bSearchField | 入力値 | |
| INSERT/UPDATE | bProfile | 入力値 | |
| INSERT | iRang | count(*)+1 | 新規時は末尾に追加 |
| UPDATE(delete) | iRang | iRang-1 | 削除フィールドより後の並び順を詰める |

#### tblContactValues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iContactID | 各連絡先ID | 新規フィールド作成時 |
| INSERT | iFieldID | 新規フィールドID | |
| INSERT | sValue | "" | 空文字 |
| DELETE | - | iFieldId=対象ID | フィールド削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| err_mandatory | エラー | 必須項目を入力してください | 必須チェック失敗時 |
| err_mandatoryprofile | エラー | 必須フィールドはプロファイル表示が必要です | 必須＆非プロファイル時 |
| areyousure | 確認 | 本当によろしいですか？ | 削除時 |
| deletefieldfb | 確認 | フィールドを削除しますか？ | 削除時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| フィールド名未入力 | エラーメッセージを表示し、保存を中止 |
| タイプ未選択 | エラーメッセージを表示し、保存を中止 |
| selectタイプで選択肢未入力 | エラーメッセージを表示し、保存を中止 |
| 必須フラグON＆プロファイル表示OFF | エラーメッセージを表示し、保存を中止 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- selectタイプの選択肢は改行区切りで入力する
- commentタイプはフォームに表示される説明文として使用され、入力項目ではない
- checkbox/commentタイプは必須フラグの設定が不可
- commentタイプは検索対象フラグの設定が不可
- 新規フィールド作成時、既存の全連絡先に空のレコードが自動作成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

連絡先フィールド定義の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラス、save関数（行59-106）、remove関数（行157-167） |

**読解のコツ**: save関数内で新規作成時に全連絡先への空レコード作成が行われている（行91-105）。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactFieldEdit.asp | `asp/bs_contactFieldEdit.asp` | メイン画面、アクション分岐（行11-22） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、ヘッダー表示
2. **行5-6**: contactFieldオブジェクト生成
3. **行7-10**: ポストバック時の入力値取得
4. **行11-22**: btnactionに応じた処理分岐（save/delete）
5. **行23-25**: タイプに応じた入力項目表示制御

#### Step 3: バリデーションと保存を理解する

データの検証と保存処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contactField.asp | `asp/includes/contactField.asp` | Check関数（行40-58）でバリデーション |

**主要処理フロー**:
- **行40-58**: Check関数 - タイプ、フィールド名、選択肢の必須チェック、必須とプロファイルの整合性チェック
- **行59-106**: Save関数 - INSERT/UPDATE、新規時の全連絡先へのレコード作成
- **行157-167**: remove関数 - 並び順調整、フィールド値削除、フィールド定義削除

### プログラム呼び出し階層図

```
bs_contactFieldEdit.asp
    │
    ├─ begin.asp（初期化）
    │      └─ contactField.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_contactField
    │      ├─ pick()（データ取得）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      │      └─ 全連絡先への空レコード作成
    │      └─ remove()（削除処理）
    │
    ├─ cls_contactFieldTypeList
    │      └─ showSelected()（タイプ選択肢表示）
    │
    └─ createFCKInstance()（commentタイプ時リッチテキスト）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

フォーム入力              bs_contactFieldEdit.asp       リダイレクト
  ├─ sFieldName                 │                       │
  ├─ sType                      ├─ check() ──────────▶ エラーメッセージ
  ├─ sValues                    │     │
  ├─ bMandatory                 │     ▼
  ├─ bSearchField               ├─ save() ──────────▶ tblContactField
  └─ bProfile                   │     │
                                │     └─ 新規時
                                │          └─ tblContactValues（全連絡先分）
                                │
                                └─ remove() ─────────▶ tblContactField
                                      └─ tblContactValues
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactFieldEdit.asp | `asp/bs_contactFieldEdit.asp` | ソース | メイン画面 |
| contactField.asp | `asp/includes/contactField.asp` | ソース | フィールドクラス定義 |
| contactFieldTypeList.asp | `asp/includes/contactFieldTypeList.asp` | ソース | フィールドタイプリスト |
| bs_contactFields.asp | `asp/bs_contactFields.asp` | ソース | 遷移元・遷移先画面 |
| bs_backContactField.asp | `asp/bs_backContactField.asp` | テンプレート | 戻るリンク表示 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | リッチテキストエディタ |
